/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.classic.SQLContext$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveClientImpl;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.hive.client.IsolatedClientLoader;
import org.apache.spark.sql.hive.client.IsolatedClientLoader$;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class HiveUtils$
implements Logging {
    public static final HiveUtils$ MODULE$ = new HiveUtils$();
    private static final Regex PATTERN_FOR_KEY_EQ_VAL;
    private static final String builtinHiveVersion;
    private static final ConfigEntry<String> BUILTIN_HIVE_VERSION;
    private static final ConfigEntry<String> HIVE_METASTORE_VERSION;
    private static final ConfigEntry<String> HIVE_METASTORE_JARS;
    private static final ConfigEntry<Seq<String>> HIVE_METASTORE_JARS_PATH;
    private static final ConfigEntry<Object> CONVERT_METASTORE_PARQUET;
    private static final ConfigEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    private static final ConfigEntry<Object> CONVERT_METASTORE_ORC;
    private static final ConfigEntry<Object> CONVERT_INSERTING_PARTITIONED_TABLE;
    private static final ConfigEntry<Object> CONVERT_INSERTING_UNPARTITIONED_TABLE;
    private static final ConfigEntry<Object> CONVERT_METASTORE_CTAS;
    private static final ConfigEntry<Object> CONVERT_METASTORE_INSERT_DIR;
    private static final ConfigEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES;
    private static final ConfigEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES;
    private static final ConfigEntry<Object> HIVE_THRIFT_SERVER_ASYNC;
    private static final ConfigEntry<Object> USE_DELEGATE_FOR_SYMLINK_TEXT_INPUT_FORMAT;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        PATTERN_FOR_KEY_EQ_VAL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(.+)=(.+)"));
        builtinHiveVersion = HiveVersionInfo.getVersion();
        BUILTIN_HIVE_VERSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.version").doc("The compiled, a.k.a, builtin Hive version of the Spark distribution bundled with. Note that, this a read-only conf and only used to report the built-in hive version. If you want a different metastore client for Spark to call, please refer to spark.sql.hive.metastore.version.").version("1.1.1").stringConf().checkValue((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$BUILTIN_HIVE_VERSION$1(x$1)), "The builtin Hive version is read-only, please use spark.sql.hive.metastore.version").createWithDefault((Object)MODULE$.builtinHiveVersion());
        HIVE_METASTORE_VERSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.version").doc("Version of the Hive metastore. Available options are <code>2.0.0</code> through <code>2.3.10</code>, <code>3.0.0</code> through <code>3.1.3</code> and <code>4.0.0</code> through <code>4.0.1</code>.").version("1.4.0").stringConf().checkValue((Function1 & Serializable)hiveVersionStr -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.MODULE$.isCompatibleHiveVersion(hiveVersionStr)), "Unsupported Hive Metastore version").createWithDefault((Object)MODULE$.builtinHiveVersion());
        HIVE_METASTORE_JARS = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.jars").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      | Location of the jars that should be used to instantiate the HiveMetastoreClient.\n      | This property can be one of four options:\n      | 1. \"builtin\"\n      |   Use Hive " + MODULE$.builtinHiveVersion() + ", which is bundled with the Spark assembly when\n      |   <code>-Phive</code> is enabled. When this option is chosen,\n      |   <code>spark.sql.hive.metastore.version</code> must be either\n      |   <code>" + MODULE$.builtinHiveVersion() + "</code> or not defined.\n      | 2. \"maven\"\n      |   Use Hive jars of specified version downloaded from Maven repositories.\n      | 3. \"path\"\n      |   Use Hive jars configured by `spark.sql.hive.metastore.jars.path`\n      |   in comma separated format. Support both local or remote paths.The provided jars\n      |   should be the same version as `" + MODULE$.HIVE_METASTORE_VERSION().key() + "`.\n      | 4. A classpath in the standard format for both Hive and Hadoop. The provided jars\n      |   should be the same version as `" + MODULE$.HIVE_METASTORE_VERSION().key() + "`.\n      "))).version("1.4.0").stringConf().createWithDefault((Object)"builtin");
        HIVE_METASTORE_JARS_PATH = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.jars.path").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      | Comma-separated paths of the jars that used to instantiate the HiveMetastoreClient.\n      | This configuration is useful only when `" + MODULE$.HIVE_METASTORE_JARS().key() + "` is set as `path`.\n      | The paths can be any of the following format:\n      | 1. file://path/to/jar/foo.jar\n      | 2. hdfs://nameservice/path/to/jar/foo.jar\n      | 3. /path/to/jar/ (path without URI scheme follow conf `fs.defaultFS`'s URI schema)\n      | 4. [http/https/ftp]://path/to/jar/foo.jar\n      | Note that 1, 2, and 3 support wildcard. For example:\n      | 1. file://path/to/jar/*,file://path2/to/jar/*/*.jar\n      | 2. hdfs://nameservice/path/to/jar/*,hdfs://nameservice2/path/to/jar/*/*.jar\n      "))).version("3.1.0").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
        CONVERT_METASTORE_PARQUET = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreParquet").doc("When set to true, the built-in Parquet reader and writer are used to process parquet tables created by using the HiveQL syntax, instead of Hive serde.").version("1.1.1").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreParquet.mergeSchema").doc("When true, also tries to merge possibly different but compatible Parquet schemas in different Parquet data files. This configuration is only effective when \"spark.sql.hive.convertMetastoreParquet\" is true.").version("1.3.1").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CONVERT_METASTORE_ORC = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreOrc").doc("When set to true, the built-in ORC reader and writer are used to process ORC tables created by using the HiveQL syntax, instead of Hive serde.").version("2.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CONVERT_INSERTING_PARTITIONED_TABLE = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertInsertingPartitionedTable").doc("When set to true, and `spark.sql.hive.convertMetastoreParquet` or `spark.sql.hive.convertMetastoreOrc` is true, the built-in ORC/Parquet writer is usedto process inserting into partitioned ORC/Parquet tables created by using the HiveSQL syntax.").version("3.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CONVERT_INSERTING_UNPARTITIONED_TABLE = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertInsertingUnpartitionedTable").doc("When set to true, and `spark.sql.hive.convertMetastoreParquet` or `spark.sql.hive.convertMetastoreOrc` is true, the built-in ORC/Parquet writer is usedto process inserting into unpartitioned ORC/Parquet tables created by using the HiveSQL syntax.").version("4.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CONVERT_METASTORE_CTAS = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreCtas").doc("When set to true,  Spark will try to use built-in data source writer instead of Hive serde in CTAS. This flag is effective only if `spark.sql.hive.convertMetastoreParquet` or `spark.sql.hive.convertMetastoreOrc` is enabled respectively for Parquet and ORC formats").version("3.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CONVERT_METASTORE_INSERT_DIR = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreInsertDir").doc("When set to true,  Spark will try to use built-in data source writer instead of Hive serde in INSERT OVERWRITE DIRECTORY. This flag is effective only if `spark.sql.hive.convertMetastoreParquet` or `spark.sql.hive.convertMetastoreOrc` is enabled respectively for Parquet and ORC formats").version("3.3.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        HIVE_METASTORE_SHARED_PREFIXES = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.sharedPrefixes").doc("A comma separated list of class prefixes that should be loaded using the classloader that is shared between Spark SQL and a specific version of Hive. An example of classes that should be shared is JDBC drivers that are needed to talk to the metastore. Other classes that need to be shared are those that interact with classes that are already shared. For example, custom appenders that are used by log4j.").version("1.4.0").stringConf().toSequence().createWithDefault(MODULE$.jdbcPrefixes());
        HIVE_METASTORE_BARRIER_PREFIXES = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.barrierPrefixes").doc("A comma separated list of class prefixes that should explicitly be reloaded for each version of Hive that Spark SQL is communicating with. For example, Hive UDFs that are declared in a prefix that typically would be shared (i.e. <code>org.apache.spark.*</code>).").version("1.4.0").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
        HIVE_THRIFT_SERVER_ASYNC = SQLConf$.MODULE$.buildConf("spark.sql.hive.thriftServer.async").doc("When set to true, Hive Thrift server executes SQL queries in an asynchronous way.").version("1.5.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        USE_DELEGATE_FOR_SYMLINK_TEXT_INPUT_FORMAT = SQLConf$.MODULE$.buildConf("spark.sql.hive.useDelegateForSymlinkTextInputFormat").internal().doc("When true, SymlinkTextInputFormat is replaced with a similar delegate class during table scan in order to fix the issue of empty splits").version("3.4.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Regex PATTERN_FOR_KEY_EQ_VAL() {
        return PATTERN_FOR_KEY_EQ_VAL;
    }

    public String builtinHiveVersion() {
        return builtinHiveVersion;
    }

    public ConfigEntry<String> BUILTIN_HIVE_VERSION() {
        return BUILTIN_HIVE_VERSION;
    }

    private boolean isCompatibleHiveVersion(String hiveVersionStr) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> IsolatedClientLoader$.MODULE$.hiveVersion(hiveVersionStr)).isSuccess();
    }

    public ConfigEntry<String> HIVE_METASTORE_VERSION() {
        return HIVE_METASTORE_VERSION;
    }

    public ConfigEntry<String> HIVE_METASTORE_JARS() {
        return HIVE_METASTORE_JARS;
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_JARS_PATH() {
        return HIVE_METASTORE_JARS_PATH;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_PARQUET() {
        return CONVERT_METASTORE_PARQUET;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING() {
        return CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_ORC() {
        return CONVERT_METASTORE_ORC;
    }

    public ConfigEntry<Object> CONVERT_INSERTING_PARTITIONED_TABLE() {
        return CONVERT_INSERTING_PARTITIONED_TABLE;
    }

    public ConfigEntry<Object> CONVERT_INSERTING_UNPARTITIONED_TABLE() {
        return CONVERT_INSERTING_UNPARTITIONED_TABLE;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_CTAS() {
        return CONVERT_METASTORE_CTAS;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_INSERT_DIR() {
        return CONVERT_METASTORE_INSERT_DIR;
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES() {
        return HIVE_METASTORE_SHARED_PREFIXES;
    }

    private Seq<String> jdbcPrefixes() {
        return new .colon.colon((Object)"com.mysql.jdbc", (List)new .colon.colon((Object)"org.postgresql", (List)new .colon.colon((Object)"com.microsoft.sqlserver", (List)new .colon.colon((Object)"oracle.jdbc", (List)Nil$.MODULE$))));
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES() {
        return HIVE_METASTORE_BARRIER_PREFIXES;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_ASYNC() {
        return HIVE_THRIFT_SERVER_ASYNC;
    }

    public ConfigEntry<Object> USE_DELEGATE_FOR_SYMLINK_TEXT_INPUT_FORMAT() {
        return USE_DELEGATE_FOR_SYMLINK_TEXT_INPUT_FORMAT;
    }

    private String hiveMetastoreVersion(SQLConf conf) {
        return (String)conf.getConf(this.HIVE_METASTORE_VERSION());
    }

    private String hiveMetastoreJars(SQLConf conf) {
        return (String)conf.getConf(this.HIVE_METASTORE_JARS());
    }

    private Seq<String> hiveMetastoreJarsPath(SQLConf conf) {
        return (Seq)conf.getConf(this.HIVE_METASTORE_JARS_PATH());
    }

    private Seq<String> hiveMetastoreSharedPrefixes(SQLConf conf) {
        return (Seq)((IterableOps)conf.getConf(this.HIVE_METASTORE_SHARED_PREFIXES())).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$hiveMetastoreSharedPrefixes$1(x$2)));
    }

    private Seq<String> hiveMetastoreBarrierPrefixes(SQLConf conf) {
        return (Seq)((IterableOps)conf.getConf(this.HIVE_METASTORE_BARRIER_PREFIXES())).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$hiveMetastoreBarrierPrefixes$1(x$3)));
    }

    public boolean isCliSessionState() {
        boolean found = false;
        for (Class temp = (state = SessionState.get()) != null ? state.getClass() : null; temp != null && !found; temp = temp.getSuperclass()) {
            String string = temp.getName();
            String string2 = "org.apache.hadoop.hive.cli.CliSessionState";
            found = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return found;
    }

    public HiveClientImpl newClientForExecution(SparkConf conf, Configuration hadoopConf) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing execution hive, version "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HIVE_METASTORE_VERSION$.MODULE$, (Object)MODULE$.builtinHiveVersion())})))));
        package.HiveVersion x$1 = IsolatedClientLoader$.MODULE$.hiveVersion(this.builtinHiveVersion());
        SparkConf x$2 = conf;
        Seq x$3 = (Seq)package$.MODULE$.Seq().empty();
        Configuration x$4 = hadoopConf;
        scala.collection.immutable.Map<String, String> x$5 = this.newTemporaryConfiguration(true);
        boolean x$6 = false;
        ClassLoader x$7 = Utils$.MODULE$.getContextOrSparkClassLoader();
        Option<Object> x$8 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
        Seq<String> x$9 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$9();
        Seq<String> x$10 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$10();
        IsolatedClientLoader loader = new IsolatedClientLoader(x$1, x$2, x$4, (Seq<URL>)x$3, x$5, false, x$8, x$7, x$9, x$10);
        return (HiveClientImpl)loader.createClient();
    }

    public HiveClient newClientForMetadata(SparkConf conf, Configuration hadoopConf, scala.collection.immutable.Map<String, String> configurations) {
        IsolatedClientLoader isolatedClientLoader;
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLContext$.MODULE$.getSQLProperties(conf));
        String hiveMetastoreVersion = this.hiveMetastoreVersion(sqlConf);
        String hiveMetastoreJars = this.hiveMetastoreJars(sqlConf);
        Seq<String> hiveMetastoreSharedPrefixes = this.hiveMetastoreSharedPrefixes(sqlConf);
        Seq<String> hiveMetastoreBarrierPrefixes = this.hiveMetastoreBarrierPrefixes(sqlConf);
        package.HiveVersion metaVersion = IsolatedClientLoader$.MODULE$.hiveVersion(hiveMetastoreVersion);
        String string = hiveMetastoreJars;
        String string2 = "builtin";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = this.builtinHiveVersion();
            String string4 = hiveMetastoreVersion;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw new IllegalArgumentException("Builtin jars can only be used when hive execution version == hive metastore version. Execution: " + this.builtinHiveVersion() + " != Metastore: " + hiveMetastoreVersion + ". Specify a valid path to the correct hive jars using " + this.HIVE_METASTORE_JARS().key() + " or change " + this.HIVE_METASTORE_VERSION().key() + " to " + this.builtinHiveVersion() + ".");
            }
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing HiveMetastoreConnection version "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " using Spark classes."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HIVE_METASTORE_VERSION$.MODULE$, (Object)hiveMetastoreVersion)})))));
            package.HiveVersion x$1 = metaVersion;
            SparkConf x$2 = conf;
            Configuration x$3 = hadoopConf;
            scala.collection.immutable.Map<String, String> x$4 = configurations;
            boolean x$5 = false;
            Some x$6 = new Some((Object)BoxesRunTime.boxToBoolean((!this.isCliSessionState() ? 1 : 0) != 0));
            Seq<String> x$7 = hiveMetastoreBarrierPrefixes;
            Seq<String> x$8 = hiveMetastoreSharedPrefixes;
            Seq<URL> x$9 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$4();
            ClassLoader x$10 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
            isolatedClientLoader = new IsolatedClientLoader(x$1, x$2, x$3, x$9, x$4, false, (Option<Object>)x$6, x$10, x$8, x$7);
        } else {
            String string5 = hiveMetastoreJars;
            String string6 = "maven";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing HiveMetastoreConnection version "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " using maven."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HIVE_METASTORE_VERSION$.MODULE$, (Object)hiveMetastoreVersion)})))));
                String x$11 = hiveMetastoreVersion;
                String x$12 = VersionInfo.getVersion();
                SparkConf x$13 = conf;
                Configuration x$14 = hadoopConf;
                scala.collection.immutable.Map<String, String> x$15 = configurations;
                Seq<String> x$16 = hiveMetastoreBarrierPrefixes;
                Seq<String> x$17 = hiveMetastoreSharedPrefixes;
                Option<String> x$18 = IsolatedClientLoader$.MODULE$.forVersion$default$6();
                isolatedClientLoader = IsolatedClientLoader$.MODULE$.forVersion(x$11, x$12, x$13, x$14, x$15, x$18, x$17, x$16);
            } else {
                String string7 = hiveMetastoreJars;
                String string8 = "path";
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    Seq jars = (Seq)this.hiveMetastoreJarsPath(sqlConf).flatMap((Function1 & Serializable)x0$1 -> {
                        String string = x0$1;
                        switch (string == null ? 0 : string.hashCode()) {
                            default: 
                        }
                        if (string.contains("\\") && Utils$.MODULE$.isWindows()) {
                            return this.addLocalHiveJars$1(new File(string));
                        }
                        .colon.colon x$19 = new .colon.colon((Object)string, (List)Nil$.MODULE$);
                        Configuration x$20 = hadoopConf;
                        boolean x$21 = true;
                        boolean x$22 = false;
                        boolean x$23 = true;
                        Integer x$24 = DataSource$.MODULE$.checkAndGlobPathIfNecessary$default$5();
                        return (Seq)DataSource$.MODULE$.checkAndGlobPathIfNecessary((Seq)x$19, x$20, true, false, x$24, true).map((Function1 & Serializable)x$6 -> x$6.toUri().toURL());
                    });
                    this.logInitWithPath$1(jars, hiveMetastoreVersion);
                    package.HiveVersion x$25 = metaVersion;
                    SparkConf x$26 = conf;
                    Configuration x$27 = hadoopConf;
                    Seq x$28 = jars;
                    scala.collection.immutable.Map<String, String> x$29 = configurations;
                    boolean x$30 = true;
                    Seq<String> x$31 = hiveMetastoreBarrierPrefixes;
                    Seq<String> x$32 = hiveMetastoreSharedPrefixes;
                    Option<Object> x$33 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
                    ClassLoader x$34 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
                    isolatedClientLoader = new IsolatedClientLoader(x$25, x$26, x$27, (Seq<URL>)x$28, x$29, true, x$33, x$34, x$32, x$31);
                } else {
                    URL[] jars = (URL[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])hiveMetastoreJars.split(File.pathSeparator)), (Function1 & Serializable)path -> this.addLocalHiveJars$1(new File((String)path)), ClassTag$.MODULE$.apply(URL.class));
                    this.logInitWithPath$1(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])jars)), hiveMetastoreVersion);
                    package.HiveVersion x$35 = metaVersion;
                    SparkConf x$36 = conf;
                    Configuration x$37 = hadoopConf;
                    ArraySeq x$38 = ArrayImplicits$.MODULE$.SparkArrayOps((Object)jars).toImmutableArraySeq();
                    scala.collection.immutable.Map<String, String> x$39 = configurations;
                    boolean x$40 = true;
                    Seq<String> x$41 = hiveMetastoreBarrierPrefixes;
                    Seq<String> x$42 = hiveMetastoreSharedPrefixes;
                    Option<Object> x$43 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
                    ClassLoader x$44 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
                    isolatedClientLoader = new IsolatedClientLoader(x$35, x$36, x$37, (Seq<URL>)x$38, x$39, true, x$43, x$44, x$42, x$41);
                }
            }
        }
        IsolatedClientLoader isolatedLoader = isolatedClientLoader;
        return isolatedLoader.createClient();
    }

    public scala.collection.immutable.Map<String, String> newClientForMetadata$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public scala.collection.immutable.Map<String, String> newTemporaryConfiguration(boolean useInMemoryDerby) {
        String withInMemoryMode = useInMemoryDerby ? "memory:" : "";
        File tempDir = Utils$.MODULE$.createTempDir();
        File localMetastore = new File(tempDir, "metastore");
        HashMap propMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])HiveConf.ConfVars.values()), (Function1 & Serializable)confvar -> {
            if (confvar.varname.contains("datanucleus") || confvar.varname.contains("jdo") || confvar.varname.contains("hive.metastore.rawstore.impl")) {
                return propMap.put((Object)confvar.varname, (Object)confvar.getDefaultExpr());
            }
            return BoxedUnit.UNIT;
        });
        propMap.put((Object)StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), (Object)localMetastore.toURI().toString());
        propMap.put((Object)"javax.jdo.option.ConnectionURL", (Object)("jdbc:derby:" + withInMemoryMode + ";databaseName=" + localMetastore.getAbsolutePath() + ";create=true"));
        propMap.put((Object)"datanucleus.rdbms.datastoreAdapterClassName", (Object)"org.datanucleus.store.rdbms.adapter.DerbyAdapter");
        propMap.put((Object)"hive.metastore.schema.verification", (Object)"false");
        propMap.put((Object)"datanucleus.schema.autoCreateAll", (Object)"true");
        propMap.put((Object)"hive.metastore.uris", (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_PRE_EVENT_LISTENERS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_EVENT_LISTENERS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_END_FUNCTION_LISTENERS.varname, (Object)"");
        SparkHadoopUtil$.MODULE$.get().appendSparkHadoopConfigs(scala.sys.package$.MODULE$.props().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), propMap);
        SparkHadoopUtil$.MODULE$.get().appendSparkHiveConfigs(scala.sys.package$.MODULE$.props().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), propMap);
        return propMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public CatalogTable inferSchema(CatalogTable table) {
        if (DDLUtils$.MODULE$.isDatasourceTable(table) || table.dataSchema().nonEmpty()) {
            return table;
        }
        Table hiveTable = HiveClientImpl$.MODULE$.toHiveTable(table, HiveClientImpl$.MODULE$.toHiveTable$default$2());
        Buffer partCols = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(hiveTable.getPartCols()).asScala().map((Function1 & Serializable)hc -> HiveClientImpl$.MODULE$.fromHiveColumn((FieldSchema)hc));
        Buffer dataCols = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(hiveTable.getCols()).asScala().map((Function1 & Serializable)hc -> HiveClientImpl$.MODULE$.fromHiveColumn((FieldSchema)hc));
        StructType x$1 = new StructType((StructField[])((IterableOnceOps)dataCols.$plus$plus((IterableOnce)partCols)).toArray(ClassTag$.MODULE$.apply(StructField.class)));
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        Option x$5 = table.copy$default$5();
        Seq x$6 = table.copy$default$6();
        Option x$7 = table.copy$default$7();
        String x$8 = table.copy$default$8();
        long x$9 = table.copy$default$9();
        long x$10 = table.copy$default$10();
        String x$11 = table.copy$default$11();
        scala.collection.immutable.Map x$12 = table.copy$default$12();
        Option x$13 = table.copy$default$13();
        Option x$14 = table.copy$default$14();
        Option x$15 = table.copy$default$15();
        Option x$16 = table.copy$default$16();
        Seq x$17 = table.copy$default$17();
        boolean x$18 = table.copy$default$18();
        boolean x$19 = table.copy$default$19();
        scala.collection.immutable.Map x$20 = table.copy$default$20();
        Option x$21 = table.copy$default$21();
        return table.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
    }

    public String[] partitionNameToValues(String name) {
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])name.split("/")), (Function1 & Serializable)x0$1 -> {
            Option option;
            String string = x0$1;
            if (string != null && !(option = MODULE$.PATTERN_FOR_KEY_EQ_VAL().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                String v = (String)((LinearSeqOps)option.get()).apply(1);
                return FileUtils.unescapePathName((String)v);
            }
            throw new MatchError((Object)string);
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public boolean causedByThrift(Throwable e) {
        for (Throwable target = e; target != null; target = target.getCause()) {
            String msg = target.getMessage();
            if (msg == null || !msg.matches("(?s).*(TApplication|TProtocol|TTransport)Exception.*")) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$BUILTIN_HIVE_VERSION$1(String x$1) {
        String string = x$1;
        String string2 = MODULE$.builtinHiveVersion();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hiveMetastoreSharedPrefixes$1(String x$2) {
        String string = x$2;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hiveMetastoreBarrierPrefixes$1(String x$3) {
        String string = x$3;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$newClientForMetadata$2(File x$4) {
        return x$4.getName().toLowerCase(Locale.ROOT).endsWith(".jar");
    }

    private final Seq addLocalHiveJars$1(File file) {
        String string = file.getName();
        String string2 = "*";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            File[] files = file.getParentFile().listFiles();
            if (files == null) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Hive jar path '", "' does not exist."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)file.getPath())}))));
                return Nil$.MODULE$;
            }
            return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$newClientForMetadata$2(x$4)))), (Function1 & Serializable)x$5 -> x$5.toURI().toURL(), ClassTag$.MODULE$.apply(URL.class))).toImmutableArraySeq();
        }
        URL uRL = file.toURI().toURL();
        return Nil$.MODULE$.$colon$colon((Object)uRL);
    }

    private final void logInitWithPath$1(Seq jars, String hiveMetastoreVersion$1) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing HiveMetastoreConnection version "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " using paths: "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HIVE_METASTORE_VERSION$.MODULE$, (Object)hiveMetastoreVersion$1)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)jars.mkString(", "))})))));
    }

    private HiveUtils$() {
    }
}

