/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.ReadOnlySparkConf;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.deploy.SparkSubmitTestUtils;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.launcher.JavaModuleOptions;
import org.apache.spark.sql.hive.HiveExternalCatalogVersionsSuite$;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.PROCESS_TABLES$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.tags.ExtendedHiveTest;
import org.apache.spark.tags.SlowHiveTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Signaler;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@SlowHiveTest
@ExtendedHiveTest
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001\u0002\u000e\u001c\u0001\u0019BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013Ec\u0007\u0003\u0004@\u0001\u0001\u0006Ia\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"91\n\u0001b\u0001\n\u0013\t\u0005B\u0002'\u0001A\u0003%!\tC\u0004N\u0001\t\u0007I\u0011B!\t\r9\u0003\u0001\u0015!\u0003C\u0011\u001dy\u0005A1A\u0005\nACaa\u0016\u0001!\u0002\u0013\t\u0006b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007O\u0002\u0001\u000b\u0011\u0002.\t\u000b!\u0004A\u0011I5\t\u000b9\u0004A\u0011B8\t\u000bQ\u0004A\u0011B;\t\u000ba\u0004A\u0011B=\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!1\u0011q\u0001\u0001\u0005B%<q!a\b\u001c\u0011\u0003\t\tC\u0002\u0004\u001b7!\u0005\u00111\u0005\u0005\u0007cU!\t!!\r\t\u0013\u0005MRC1A\u0005\n\u0005U\u0002\u0002CA!+\u0001\u0006I!a\u000e\t\u0013\u0005\rS#!A\u0005\n\u0005\u0015#\u0001\t%jm\u0016,\u0005\u0010^3s]\u0006d7)\u0019;bY><g+\u001a:tS>t7oU;ji\u0016T!\u0001H\u000f\u0002\t!Lg/\u001a\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0004\u0001\u001dZ\u0003C\u0001\u0015*\u001b\u0005y\u0012B\u0001\u0016 \u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011AfL\u0007\u0002[)\u0011afH\u0001\u0007I\u0016\u0004Hn\\=\n\u0005Aj#\u0001F*qCJ\\7+\u001e2nSR$Vm\u001d;Vi&d7/\u0001\u0004=S:LGO\u0010\u000b\u0002gA\u0011A\u0007A\u0007\u00027\u0005IB-\u001a4bk2$8\u000b]1sWN+(-\\5u)&lWm\\;u+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011!\u0018.\\3\u000b\u0005q\u001a\u0013!C:dC2\fG/Z:u\u0013\tq\u0014H\u0001\u0003Ta\u0006t\u0017A\u00073fM\u0006,H\u000e^*qCJ\\7+\u001e2nSR$\u0016.\\3pkR\u0004\u0013!D<be\u0016Du.^:f!\u0006$\b.F\u0001C!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0002j_*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u00111\u0015\u000e\\3\u0002\u001d]\f'/\u001a%pkN,\u0007+\u0019;iA\u0005QA/\u001c9ECR\fG)\u001b:\u0002\u0017Ql\u0007\u000fR1uC\u0012K'\u000fI\u0001\u0010gB\f'o\u001b+fgRLgn\u001a#je\u0006\u00012\u000f]1sWR+7\u000f^5oO\u0012K'\u000fI\u0001\nk:,8/\u001a3KCJ,\u0012!\u0015\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u001a\u000b1A\\3u\u0013\t16KA\u0002V%2\u000b!\"\u001e8vg\u0016$'*\u0019:!\u0003-A\u0017N^3WKJ\u001c\u0018n\u001c8\u0016\u0003i\u0003\"a\u00173\u000f\u0005q\u0013\u0007CA/a\u001b\u0005q&BA0&\u0003\u0019a$o\\8u})\t\u0011-A\u0003tG\u0006d\u0017-\u0003\u0002dA\u00061\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u0019\u0007-\u0001\u0007iSZ,g+\u001a:tS>t\u0007%\u0001\u0005bMR,'/\u00117m)\u0005Q\u0007CA6m\u001b\u0005\u0001\u0017BA7a\u0005\u0011)f.\u001b;\u0002!Q\u0014\u0018\u0010R8x]2|\u0017\rZ*qCJ\\Gc\u00016qe\")\u0011o\u0004a\u00015\u00069a/\u001a:tS>t\u0007\"B:\u0010\u0001\u0004Q\u0016\u0001\u00029bi\"\f!bZ3o\t\u0006$\u0018\rR5s)\tQf\u000fC\u0003x!\u0001\u0007!,\u0001\u0003oC6,\u0017AD4fi\u001aKG.\u001a$s_6,&\u000f\u001c\u000b\u0005Ujdh\u0010C\u0003|#\u0001\u0007!,A\u0005ve2\u001cFO]5oO\")Q0\u0005a\u00015\u0006IA/\u0019:hKR$\u0015N\u001d\u0005\u0006\u007fF\u0001\rAW\u0001\tM&dWM\\1nK\u0006\u0001r-\u001a;TiJLgn\u001a$s_6,&\u000f\u001c\u000b\u00045\u0006\u0015\u0001\"B>\u0013\u0001\u0004Q\u0016!\u00032fM>\u0014X-\u00117mQ\r\u0001\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0010\u0002\tQ\fwm]\u0005\u0005\u0003+\tyA\u0001\u0007TY><\b*\u001b<f)\u0016\u001cH\u000fK\u0002\u0001\u00033\u0001B!!\u0004\u0002\u001c%!\u0011QDA\b\u0005A)\u0005\u0010^3oI\u0016$\u0007*\u001b<f)\u0016\u001cH/\u0001\u0011ISZ,W\t\u001f;fe:\fGnQ1uC2|wMV3sg&|gn]*vSR,\u0007C\u0001\u001b\u0016'\u0015)\u0012QEA\u0016!\rY\u0017qE\u0005\u0004\u0003S\u0001'AB!osJ+g\rE\u0002D\u0003[I1!a\fE\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\t\t#\u0001\u0013T!\u0006\u00136j\u0018+F'R{6)Q\"I\u000b~#\u0015JU0T3N#V)T0Q%>\u0003VI\u0015+Z+\t\t9\u0004\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\tiDR\u0001\u0005Y\u0006tw-C\u0002f\u0003w\tQe\u0015)B%.{F+R*U?\u000e\u000b5\tS#`\t&\u0013vlU-T)\u0016ku\f\u0015*P!\u0016\u0013F+\u0017\u0011\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u001d\u0003\u0003BA\u001d\u0003\u0013JA!a\u0013\u0002<\t1qJ\u00196fGR\u0004")
public class HiveExternalCatalogVersionsSuite
extends SparkFunSuite
implements SparkSubmitTestUtils {
    private final Span defaultSparkSubmitTimeout;
    private final File wareHousePath;
    private final File tmpDataDir;
    private final File sparkTestingDir;
    private final URL unusedJar;
    private final String hiveVersion;
    private Signaler defaultSignaler;

    public int runSparkSubmit(scala.collection.immutable.Seq<String> args, Option<String> sparkHomeOpt, Span timeout, boolean isSparkTesting, boolean expectFailure) {
        return SparkSubmitTestUtils.runSparkSubmit$((SparkSubmitTestUtils)this, args, sparkHomeOpt, (Span)timeout, (boolean)isSparkTesting, (boolean)expectFailure);
    }

    public Option<String> runSparkSubmit$default$2() {
        return SparkSubmitTestUtils.runSparkSubmit$default$2$((SparkSubmitTestUtils)this);
    }

    public Span runSparkSubmit$default$3() {
        return SparkSubmitTestUtils.runSparkSubmit$default$3$((SparkSubmitTestUtils)this);
    }

    public boolean runSparkSubmit$default$4() {
        return SparkSubmitTestUtils.runSparkSubmit$default$4$((SparkSubmitTestUtils)this);
    }

    public boolean runSparkSubmit$default$5() {
        return SparkSubmitTestUtils.runSparkSubmit$default$5$((SparkSubmitTestUtils)this);
    }

    public Signaler defaultSignaler() {
        return this.defaultSignaler;
    }

    public void org$apache$spark$deploy$SparkSubmitTestUtils$_setter_$defaultSparkSubmitTimeout_$eq(Span x$1) {
    }

    public void org$apache$spark$deploy$SparkSubmitTestUtils$_setter_$defaultSignaler_$eq(Signaler x$1) {
        this.defaultSignaler = x$1;
    }

    public Span defaultSparkSubmitTimeout() {
        return this.defaultSparkSubmitTimeout;
    }

    private File wareHousePath() {
        return this.wareHousePath;
    }

    private File tmpDataDir() {
        return this.tmpDataDir;
    }

    private File sparkTestingDir() {
        return this.sparkTestingDir;
    }

    private URL unusedJar() {
        return this.unusedJar;
    }

    public String hiveVersion() {
        return this.hiveVersion;
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.wareHousePath());
            Utils$.MODULE$.deleteRecursively(this.tmpDataDir());
            if (Option$.MODULE$.apply((Object)System.getProperty(HiveExternalCatalogVersionsSuite$.MODULE$.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$SPARK_TEST_CACHE_DIR_SYSTEM_PROPERTY())).isEmpty()) {
                Utils$.MODULE$.deleteRecursively(this.sparkTestingDir());
            }
        }
        finally {
            super.afterAll();
        }
    }

    private void tryDownloadSpark(String version, String path) {
        Object object = new Object();
        try {
            IndexedSeq mirrors = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).flatMap((Function1 & Serializable)x$2 -> HiveExternalCatalogVersionsSuite.$anonfun$tryDownloadSpark$1(this, BoxesRunTime.unboxToInt((Object)x$2)));
            IndexedSeq sites = (IndexedSeq)((SeqOps)((SeqOps)mirrors.distinct()).$colon$plus((Object)"https://archive.apache.org/dist")).$colon$plus((Object)PROCESS_TABLES$.MODULE$.releaseMirror());
            this.logInfo((Function0 & Serializable)() -> "Trying to download Spark " + version + " from " + sites);
            sites.foreach((Function1 & Serializable)site -> {
                Object object;
                String string;
                String string2 = version;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    default: 
                }
                if (string2.startsWith("3.")) {
                    string = "-scala2.13";
                } else if (string2.startsWith("4.")) {
                    string = "";
                } else {
                    throw this.fail("Spark version " + version + " is unexpected", new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
                }
                String scalaVersion = string;
                String filename = "spark-" + version + "-bin-hadoop3" + scalaVersion + ".tgz";
                String url = site + "/spark/spark-" + version + "/" + filename;
                this.logInfo((Function0 & Serializable)() -> "Downloading Spark " + version + " from " + url);
                try {
                    this.getFileFromUrl(url, path, filename);
                    String downloaded = new File(this.sparkTestingDir(), filename).getCanonicalPath();
                    String targetDir = new File(this.sparkTestingDir(), "spark-" + version).getCanonicalPath();
                    scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"mkdir", (List)new .colon.colon((Object)targetDir, (List)Nil$.MODULE$))).$bang();
                    int exitCode = scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"tar", (List)new .colon.colon((Object)"-xzf", (List)new .colon.colon((Object)downloaded, (List)new .colon.colon((Object)"-C", (List)new .colon.colon((Object)targetDir, (List)new .colon.colon((Object)"--strip-components=1", (List)new .colon.colon((Object)"--no-same-owner", (List)Nil$.MODULE$)))))))).$bang();
                    scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"rm", (List)new .colon.colon((Object)downloaded, (List)Nil$.MODULE$))).$bang();
                    File sparkSubmit = new File(this.sparkTestingDir(), "spark-" + version + "/bin/spark-submit");
                    if (exitCode == 0 && sparkSubmit.exists()) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    object = BoxesRunTime.boxToInteger((int)scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"rm", (List)new .colon.colon((Object)"-rf", (List)new .colon.colon((Object)targetDir, (List)Nil$.MODULE$)))).$bang());
                }
                catch (Exception ex) {
                    this.logWarning((Function0 & Serializable)() -> "Failed to download Spark " + version + " from " + url + ": " + ex.getMessage());
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            throw this.fail("Unable to download Spark " + version, new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            ex.value$mcV$sp();
            return;
        }
    }

    private String genDataDir(String name) {
        return new File(this.tmpDataDir(), name).getCanonicalPath();
    }

    private void getFileFromUrl(String urlString, String targetDir, String filename) {
        SparkConf conf = new SparkConf();
        conf.set("spark.files.overwrite", "true");
        Configuration hadoopConf = new Configuration();
        File outDir = new File(targetDir);
        Object object = !outDir.exists() ? BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.createDirectory(outDir)) : BoxedUnit.UNIT;
        Utils$.MODULE$.doFetchFile(urlString, outDir, filename, (ReadOnlySparkConf)conf, hadoopConf);
    }

    private String getStringFromUrl(String urlString) {
        File contentFile = File.createTempFile("string-", ".txt");
        contentFile.deleteOnExit();
        this.getFileFromUrl(urlString, contentFile.getParent(), contentFile.getName());
        Path contentPath = Paths.get(contentFile.toURI());
        return new String(Files.readAllBytes(contentPath), StandardCharsets.UTF_8);
    }

    public void beforeAll() {
        super.beforeAll();
        File tempPyFile = File.createTempFile("test", ".py");
        Files.write(tempPyFile.toPath(), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |from pyspark.sql import SparkSession\n        |import os\n        |\n        |spark = SparkSession.builder.enableHiveSupport().getOrCreate()\n        |version_index = spark.conf.get(\"spark.sql.test.version.index\", None)\n        |\n        |spark.sql(\"create table data_source_tbl_{} using json as select 1 i\".format(version_index))\n        |\n        |spark.sql(\"create table hive_compatible_data_source_tbl_{} using parquet as select 1 i\".format(version_index))\n        |\n        |json_file = \"" + this.genDataDir("json_") + "\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.json(json_file)\n        |spark.sql(\"create table external_data_source_tbl_{}(i int) using json options (path '{}')\".format(version_index, json_file))\n        |\n        |parquet_file = \"" + this.genDataDir("parquet_") + "\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.parquet(parquet_file)\n        |spark.sql(\"create table hive_compatible_external_data_source_tbl_{}(i int) using parquet options (path '{}')\".format(version_index, parquet_file))\n        |\n        |json_file2 = \"" + this.genDataDir("json2_") + "\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.json(json_file2)\n        |spark.sql(\"create table external_table_without_schema_{} using json options (path '{}')\".format(version_index, json_file2))\n        |\n        |parquet_file2 = \"" + this.genDataDir("parquet2_") + "\" + str(version_index)\n        |spark.range(1, 3).selectExpr(\"1 as i\", \"cast(id as int) as p\", \"1 as j\").write.parquet(os.path.join(parquet_file2, \"p=1\"))\n        |spark.sql(\"create table tbl_with_col_overlap_{} using parquet options(path '{}')\".format(version_index, parquet_file2))\n        |\n        |spark.sql(\"create view v_{} as select 1 i\".format(version_index))\n      ")).getBytes("utf8"), new OpenOption[0]);
        if (PROCESS_TABLES$.MODULE$.testingVersions().isEmpty()) {
            if (PROCESS_TABLES$.MODULE$.isPythonVersionAvailable()) {
                if (Utils$.MODULE$.isJavaVersionAtMost17()) {
                    this.logError((Function0 & Serializable)() -> "Fail to get the latest Spark versions to test.");
                } else {
                    this.logInfo((Function0 & Serializable)() -> "Skip tests because old Spark versions don't support Java 21.");
                }
            } else {
                this.logError((Function0 & Serializable)() -> "Python version <  " + TestUtils$.MODULE$.minimumPythonSupportedVersion() + ", the running environment is unavailable.");
            }
        }
        ((IterableOnceOps)PROCESS_TABLES$.MODULE$.testingVersions().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)HiveExternalCatalogVersionsSuite.$anonfun$beforeAll$4(this, tempPyFile, x0$1)));
        tempPyFile.delete();
    }

    public static final /* synthetic */ Option $anonfun$tryDownloadSpark$1(HiveExternalCatalogVersionsSuite $this, int x$2) {
        Some some;
        try {
            some = new Some((Object)$this.getStringFromUrl("https://www.apache.org/dyn/closer.lua?preferred=true"));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    public static final /* synthetic */ int $anonfun$beforeAll$4(HiveExternalCatalogVersionsSuite $this, File tempPyFile$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            scala.collection.immutable.Seq args;
            String version = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            File sparkHome = new File($this.sparkTestingDir(), "spark-" + version);
            if (!sparkHome.exists()) {
                $this.tryDownloadSpark(version, $this.sparkTestingDir().getCanonicalPath());
            }
            String hiveMetastoreVersion = (String)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\d+\\.\\d+")).findFirstIn((CharSequence)$this.hiveVersion()).get();
            scala.collection.immutable.Seq x$1 = args = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--name", "prepare testing tables", "--master", "local[2]", "--conf", UI$.MODULE$.UI_ENABLED().key() + "=false", "--conf", org.apache.spark.internal.config.package$.MODULE$.MASTER_REST_SERVER_ENABLED().key() + "=false", "--conf", HiveUtils$.MODULE$.HIVE_METASTORE_VERSION().key() + "=" + hiveMetastoreVersion, "--conf", HiveUtils$.MODULE$.HIVE_METASTORE_JARS().key() + "=maven", "--conf", StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key() + "=" + $this.wareHousePath().getCanonicalPath(), "--conf", "spark.sql.test.version.index=" + index, "--driver-java-options", "-Dderby.system.home=" + $this.wareHousePath().getCanonicalPath() + " " + JavaModuleOptions.defaultModuleOptions(), tempPyFile$1.getCanonicalPath()}));
            Some x$2 = new Some((Object)sparkHome.getCanonicalPath());
            boolean x$3 = false;
            Span x$4 = $this.runSparkSubmit$default$3();
            boolean x$5 = $this.runSparkSubmit$default$5();
            return $this.runSparkSubmit((scala.collection.immutable.Seq<String>)x$1, (Option<String>)x$2, x$4, false, x$5);
        }
        throw new MatchError((Object)tuple2);
    }

    public HiveExternalCatalogVersionsSuite() {
        SparkSubmitTestUtils.$init$((SparkSubmitTestUtils)this);
        this.defaultSparkSubmitTimeout = SpanSugar$.MODULE$.convertIntToGrainOfTime(5).minutes();
        String x$12 = "warehouse";
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        this.wareHousePath = Utils$.MODULE$.createTempDir(x$2, "warehouse");
        String x$3 = "test-data";
        String x$4 = Utils$.MODULE$.createTempDir$default$1();
        this.tmpDataDir = Utils$.MODULE$.createTempDir(x$4, "test-data");
        this.sparkTestingDir = (File)Option$.MODULE$.apply((Object)System.getProperty(HiveExternalCatalogVersionsSuite$.MODULE$.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$SPARK_TEST_CACHE_DIR_SYSTEM_PROPERTY())).map((Function1 & Serializable)x$1 -> new File((String)x$1)).getOrElse((Function0 & Serializable)() -> {
            String x$5 = "test-spark";
            String x$6 = Utils$.MODULE$.createTempDir$default$1();
            return Utils$.MODULE$.createTempDir(x$6, "test-spark");
        });
        this.unusedJar = TestUtils$.MODULE$.createJarWithClasses((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), TestUtils$.MODULE$.createJarWithClasses$default$2(), TestUtils$.MODULE$.createJarWithClasses$default$3(), TestUtils$.MODULE$.createJarWithClasses$default$4());
        this.hiveVersion = HiveUtils$.MODULE$.builtinHiveVersion();
        this.test("backward compatibility", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(PROCESS_TABLES$.MODULE$.isPythonVersionAvailable(), "PROCESS_TABLES.isPythonVersionAvailable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            scala.collection.immutable.Seq args = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--class", StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(PROCESS_TABLES$.MODULE$.getClass().getName()), "$"), "--name", "HiveExternalCatalog backward compatibility test", "--master", "local[2]", "--conf", UI$.MODULE$.UI_ENABLED().key() + "=false", "--conf", org.apache.spark.internal.config.package$.MODULE$.MASTER_REST_SERVER_ENABLED().key() + "=false", "--conf", HiveUtils$.MODULE$.HIVE_METASTORE_VERSION().key() + "=" + this.hiveVersion(), "--conf", HiveUtils$.MODULE$.HIVE_METASTORE_JARS().key() + "=maven", "--conf", StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key() + "=" + this.wareHousePath().getCanonicalPath(), "--driver-java-options", "-Dderby.system.home=" + this.wareHousePath().getCanonicalPath(), this.unusedJar().toString()}));
            if (PROCESS_TABLES$.MODULE$.testingVersions().nonEmpty()) {
                return BoxesRunTime.boxToInteger((int)this.runSparkSubmit((scala.collection.immutable.Seq<String>)args, this.runSparkSubmit$default$2(), this.runSparkSubmit$default$3(), this.runSparkSubmit$default$4(), this.runSparkSubmit$default$5()));
            }
            return BoxedUnit.UNIT;
        }, new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        Statics.releaseFence();
    }
}

