/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.FileBasedDataSourceTest;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTest;
import org.apache.spark.sql.hive.HiveParquetSourceSuite$;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.ParquetPartitioningTest;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005%2Aa\u0001\u0003\u0001\u001f!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E\t1\u0002*\u001b<f!\u0006\u0014\u0018/^3u'>,(oY3Tk&$XM\u0003\u0002\u0006\r\u0005!\u0001.\u001b<f\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0006\t\u0003#Ii\u0011\u0001B\u0005\u0003'\u0011\u0011q\u0003U1scV,G\u000fU1si&$\u0018n\u001c8j]\u001e$Vm\u001d;\u0011\u0005UaR\"\u0001\f\u000b\u0005]A\u0012a\u00029beF,X\r\u001e\u0006\u00033i\t1\u0002Z1uCN|WO]2fg*\u00111DB\u0001\nKb,7-\u001e;j_:L!!\b\f\u0003\u0017A\u000b'/];fiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\u0005\u0001\u0002\u0013\t,gm\u001c:f\u00032dG#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\tUs\u0017\u000e\u001e")
public class HiveParquetSourceSuite
extends ParquetPartitioningTest
implements ParquetTest {
    private String dataSourceName;
    private String vectorizedReaderEnabledKey;
    private String vectorizedReaderNestedEnabledKey;

    public void readParquetFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        ParquetTest.readParquetFile$((ParquetTest)this, (String)path, (boolean)testVectorized, f);
    }

    public boolean readParquetFile$default$2() {
        return ParquetTest.readParquetFile$default$2$((ParquetTest)this);
    }

    public <T extends Product> void withParquetFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        ParquetTest.withParquetFile$((ParquetTest)this, data, f, evidence$1, evidence$2);
    }

    public <T extends Product> void withParquetDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        ParquetTest.withParquetDataFrame$((ParquetTest)this, data, (boolean)testVectorized, f, evidence$3, evidence$4);
    }

    public <T extends Product> boolean withParquetDataFrame$default$2() {
        return ParquetTest.withParquetDataFrame$default$2$((ParquetTest)this);
    }

    public <T extends Product> void withParquetTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        ParquetTest.withParquetTable$((ParquetTest)this, data, (String)tableName, (boolean)testVectorized, f, evidence$5, evidence$6);
    }

    public <T extends Product> boolean withParquetTable$default$3() {
        return ParquetTest.withParquetTable$default$3$((ParquetTest)this);
    }

    public <T extends Product> void makeParquetFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        ParquetTest.makeParquetFile$((ParquetTest)this, data, (File)path, evidence$7, evidence$8);
    }

    public <T extends Product> void makeParquetFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        ParquetTest.makeParquetFile$((ParquetTest)this, df, (File)path, evidence$9, evidence$10);
    }

    public File makePartitionDir(File basePath, String defaultPartitionName, Seq<Tuple2<String, Object>> partitionCols) {
        return ParquetTest.makePartitionDir$((ParquetTest)this, (File)basePath, (String)defaultPartitionName, partitionCols);
    }

    public void writeMetadata(StructType schema, Path path, Configuration configuration) {
        ParquetTest.writeMetadata$((ParquetTest)this, (StructType)schema, (Path)path, (Configuration)configuration);
    }

    public void writeMetadata(MessageType parquetSchema, Path path, Configuration configuration, Map<String, String> extraMetadata) {
        ParquetTest.writeMetadata$((ParquetTest)this, (MessageType)parquetSchema, (Path)path, (Configuration)configuration, extraMetadata);
    }

    public Map<String, String> writeMetadata$default$4() {
        return ParquetTest.writeMetadata$default$4$((ParquetTest)this);
    }

    public Seq<Footer> readAllFootersWithoutSummaryFiles(Path path, Configuration configuration) {
        return ParquetTest.readAllFootersWithoutSummaryFiles$((ParquetTest)this, (Path)path, (Configuration)configuration);
    }

    public ParquetMetadata readFooter(Path path, Configuration configuration) {
        return ParquetTest.readFooter$((ParquetTest)this, (Path)path, (Configuration)configuration);
    }

    public void testStandardAndLegacyModes(String testName, Function0<BoxedUnit> f) {
        ParquetTest.testStandardAndLegacyModes$((ParquetTest)this, (String)testName, f);
    }

    public Dataset<Row> readResourceParquetFile(String name) {
        return ParquetTest.readResourceParquetFile$((ParquetTest)this, (String)name);
    }

    public String getResourceParquetFilePath(String name) {
        return ParquetTest.getResourceParquetFilePath$((ParquetTest)this, (String)name);
    }

    public <T> StructType schemaFor(TypeTags.TypeTag<T> evidence$11) {
        return ParquetTest.schemaFor$((ParquetTest)this, evidence$11);
    }

    public void withAllParquetReaders(Function0<BoxedUnit> code) {
        ParquetTest.withAllParquetReaders$((ParquetTest)this, code);
    }

    public void withAllParquetWriters(Function0<BoxedUnit> code) {
        ParquetTest.withAllParquetWriters$((ParquetTest)this, code);
    }

    public Map<String, String> getMetaData(File dir) {
        return ParquetTest.getMetaData$((ParquetTest)this, (File)dir);
    }

    public void readFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        FileBasedDataSourceTest.readFile$((FileBasedDataSourceTest)this, (String)path, (boolean)testVectorized, f);
    }

    public boolean readFile$default$2() {
        return FileBasedDataSourceTest.readFile$default$2$((FileBasedDataSourceTest)this);
    }

    public <T extends Product> void withDataSourceFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        FileBasedDataSourceTest.withDataSourceFile$((FileBasedDataSourceTest)this, data, f, evidence$1, evidence$2);
    }

    public <T extends Product> void withDataSourceDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        FileBasedDataSourceTest.withDataSourceDataFrame$((FileBasedDataSourceTest)this, data, (boolean)testVectorized, f, evidence$3, evidence$4);
    }

    public <T extends Product> boolean withDataSourceDataFrame$default$2() {
        return FileBasedDataSourceTest.withDataSourceDataFrame$default$2$((FileBasedDataSourceTest)this);
    }

    public <T extends Product> void withDataSourceTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        FileBasedDataSourceTest.withDataSourceTable$((FileBasedDataSourceTest)this, data, (String)tableName, (boolean)testVectorized, f, evidence$5, evidence$6);
    }

    public <T extends Product> boolean withDataSourceTable$default$3() {
        return FileBasedDataSourceTest.withDataSourceTable$default$3$((FileBasedDataSourceTest)this);
    }

    public <T extends Product> void makeDataSourceFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        FileBasedDataSourceTest.makeDataSourceFile$((FileBasedDataSourceTest)this, data, (File)path, evidence$7, evidence$8);
    }

    public <T extends Product> void makeDataSourceFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        FileBasedDataSourceTest.makeDataSourceFile$((FileBasedDataSourceTest)this, df, (File)path, evidence$9, evidence$10);
    }

    public Seq<Tuple3<Dataset<Row>, String, Function1<Object, Object>>> withNestedDataFrame(Dataset<Row> inputDF) {
        return FileBasedDataSourceTest.withNestedDataFrame$((FileBasedDataSourceTest)this, inputDF);
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public String vectorizedReaderEnabledKey() {
        return this.vectorizedReaderEnabledKey;
    }

    public String vectorizedReaderNestedEnabledKey() {
        return this.vectorizedReaderNestedEnabledKey;
    }

    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$dataSourceName_$eq(String x$1) {
        this.dataSourceName = x$1;
    }

    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$vectorizedReaderEnabledKey_$eq(String x$1) {
        this.vectorizedReaderEnabledKey = x$1;
    }

    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$vectorizedReaderNestedEnabledKey_$eq(String x$1) {
        this.vectorizedReaderNestedEnabledKey = x$1;
    }

    @Override
    public void beforeAll() {
        super.beforeAll();
        this.dropTables((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned_parquet", "partitioned_parquet_with_key", "partitioned_parquet_with_complextypes", "partitioned_parquet_with_key_and_complextypes", "normal_parquet"}));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW partitioned_parquet\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '" + this.partitionedTableDir().toURI() + "'\n        |)\n      ")));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW partitioned_parquet_with_key\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '" + this.partitionedTableDirWithKey().toURI() + "'\n        |)\n      ")));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW normal_parquet\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '" + new File(this.partitionedTableDir(), "p=1").toURI() + "'\n        |)\n      ")));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW partitioned_parquet_with_key_and_complextypes\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '" + this.partitionedTableDirWithKeyAndComplexTypes().toURI() + "'\n        |)\n      ")));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW partitioned_parquet_with_complextypes\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '" + this.partitionedTableDirWithComplexTypes().toURI() + "'\n        |)\n      ")));
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$3(int x$1) {
        return new Tuple1.mcI.sp(x$1);
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$6(int x$2) {
        return new Tuple1.mcI.sp(x$2);
    }

    private static final String checkErrorMsg$1(String path) {
        return "Path: " + path + " is a directory, which is not supported by the record reader when `mapreduce.input.fileinputformat.input.dir.recursive` is false.";
    }

    public HiveParquetSourceSuite() {
        FileBasedDataSourceTest.$init$((FileBasedDataSourceTest)this);
        ParquetTest.$init$((ParquetTest)this);
        this.test("SPARK-6016 make sure to use the latest footers", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "spark_6016_fix";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator10$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator10$1(HiveParquetSourceSuite $outer) {
                    }
                }
                org.apache.spark.sql.classic.Dataset df1 = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$1 -> HiveParquetSourceSuite.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x$1))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).coalesce(2);
                df1.write().mode(SaveMode.Overwrite).format("parquet").saveAsTable(tableName);
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("select * from " + tableName)), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))}))));
                JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator20$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator20$1(HiveParquetSourceSuite $outer) {
                    }
                }
                org.apache.spark.sql.classic.Dataset df2 = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$2 -> HiveParquetSourceSuite.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)x$2))), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).coalesce(4);
                df2.write().mode(SaveMode.Overwrite).format("parquet").saveAsTable(tableName);
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("select * from " + tableName)), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))}))));
            });
        }, new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("SPARK-8811: compatibility with array of struct in Hive", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)dir -> {
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"array_of_struct"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                .colon.colon conf = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()), (Object)"false"), (List)Nil$.MODULE$)));
                $this.withSQLConf((Seq<Tuple2<String, String>>)conf, (JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE array_of_struct\n               |STORED AS PARQUET LOCATION '" + dir.toURI() + "'\n               |AS SELECT\n               |  '1st' AS a,\n               |  '2nd' AS b,\n               |  ARRAY(NAMED_STRUCT('a', 'val_a', 'b', 'val_b')) AS c\n             ")));
                    $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().parquet(dir.getCanonicalPath()), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1st", "2nd", new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"val_a", "val_b"})), (List)Nil$.MODULE$)})));
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("Verify the PARQUET conversion parameter: CONVERT_METASTORE_PARQUET", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"single"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator30$1(HiveParquetSourceSuite $outer) {
                }
            }
            org.apache.spark.sql.classic.Dataset singleRowDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"foo"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}));
            singleRowDF.createOrReplaceTempView("single");
            new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)parquetConversion -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)parquetConversion)}), (JFunction0.mcV.sp & Serializable)() -> {
                    String tableName = "test_parquet_ctas";
                    $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE " + tableName + " STORED AS PARQUET\n                 |AS SELECT tmp.key, tmp.value FROM single tmp\n               ")));
                        org.apache.spark.sql.classic.Dataset df = $this.spark().sql("SELECT * FROM " + tableName + " WHERE key=0");
                        $this.checkAnswer((Function0 & Serializable)() -> df, (Dataset)singleRowDF$1);
                        QueryExecution queryExecution = df.queryExecution();
                        String string = parquetConversion;
                        String string2 = "true";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            queryExecution.analyzed().collectFirst((PartialFunction)new Serializable(null){
                                private static final long serialVersionUID = 0L;

                                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    A1 A1 = x1;
                                    if (A1 instanceof LogicalRelation) {
                                        return (B1)BoxedUnit.UNIT;
                                    }
                                    return (B1)function1.apply(x1);
                                }

                                public final boolean isDefinedAt(LogicalPlan x1) {
                                    LogicalPlan logicalPlan = x1;
                                    return logicalPlan instanceof LogicalRelation;
                                }
                            }).getOrElse((Function0 & Serializable)() -> $this.fail("Expecting the query plan to convert parquet to data sources, but got:\n" + queryExecution, new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165)));
                            return;
                        }
                        queryExecution.analyzed().collectFirst((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                A1 A1 = x2;
                                if (A1 instanceof HiveTableRelation) {
                                    return (B1)BoxedUnit.UNIT;
                                }
                                return (B1)function1.apply(x2);
                            }

                            public final boolean isDefinedAt(LogicalPlan x2) {
                                LogicalPlan logicalPlan = x2;
                                return logicalPlan instanceof HiveTableRelation;
                            }
                        }).getOrElse((Function0 & Serializable)() -> $this.fail("Expecting no conversion from parquet to data sources, but got:\n" + queryExecution, new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172)));
                    });
                });
                return BoxedUnit.UNIT;
            });
        }), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("values in arrays and maps stored in parquet are always nullable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple2 tuple2 = new Tuple2(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator31$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator31$1(HiveParquetSourceSuite $outer) {
                }
            }
            org.apache.spark.sql.classic.Dataset df = this.spark().createDataFrame((Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator31$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"m", "a"}));
            MapType mapType1 = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
            ArrayType arrayType1 = new ArrayType((DataType)IntegerType$.MODULE$, false);
            StructField structField = new StructField("m", (DataType)mapType1, true, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("a", (DataType)arrayType1, true, StructField$.MODULE$.apply$default$4());
            StructType expectedSchema1 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = expectedSchema1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alwaysNullable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                df.write().format("parquet").saveAsTable("alwaysNullable");
                MapType mapType2 = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true);
                ArrayType arrayType2 = new ArrayType((DataType)IntegerType$.MODULE$, true);
                StructField structField = new StructField("m", (DataType)mapType2, true, StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("a", (DataType)arrayType2, true, StructField$.MODULE$.apply$default$4());
                StructType expectedSchema2 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.spark().table("alwaysNullable").schema());
                StructType $org_scalatest_assert_macro_right = expectedSchema2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT m, a FROM alwaysNullable"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)3))})), package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))})));
            });
        }, new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("SPARK-25993 CREATE EXTERNAL TABLE with subdirectories", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)parquetConversion -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)parquetConversion)}), (JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)path -> {
                $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"parq_tbl1", "parq_tbl2", "parq_tbl3", "tbl1", "tbl2", "tbl3", "tbl4", "tbl5", "tbl6"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    String parquetTblStatement1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE parq_tbl1(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + path.getCanonicalPath() + "/l1/'"));
                    $this.sql().apply((Object)parquetTblStatement1);
                    String parquetTblInsertL1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO TABLE parq_tbl1 VALUES (1, 1, 'parq1'), (2, 2, 'parq2')"));
                    $this.sql().apply((Object)parquetTblInsertL1);
                    String parquetTblStatement2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE parq_tbl2(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + path.getCanonicalPath() + "/l1/l2/'"));
                    $this.sql().apply((Object)parquetTblStatement2);
                    String parquetTblInsertL2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO TABLE parq_tbl2 VALUES (3, 3, 'parq3'), (4, 4, 'parq4')"));
                    $this.sql().apply((Object)parquetTblInsertL2);
                    String parquetTblStatement3 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE parq_tbl3(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + path.getCanonicalPath() + "/l1/l2/l3/'"));
                    $this.sql().apply((Object)parquetTblStatement3);
                    String parquetTblInsertL3 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO TABLE parq_tbl3 VALUES (5, 5, 'parq5'), (6, 6, 'parq6')"));
                    $this.sql().apply((Object)parquetTblInsertL3);
                    String topDirStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE tbl1(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + path.getCanonicalPath() + "'"));
                    $this.sql().apply((Object)topDirStatement);
                    String string = parquetConversion$2;
                    String string2 = "true";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tbl1"), (Seq)Nil$.MODULE$);
                        v1 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl1")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(path + "/l1");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        v1 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
                    }
                    String l1DirStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE tbl2(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + path.getCanonicalPath() + "/l1/'"));
                    $this.sql().apply((Object)l1DirStatement);
                    String string3 = parquetConversion$2;
                    String string4 = "true";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tbl2"), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), "parq" + BoxesRunTime.unboxToInt((Object)i)}))));
                        v3 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl2")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(path + "/l1/l2");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        v3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
                    }
                    String l2DirStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE tbl3(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + path.getCanonicalPath() + "/l1/l2/'"));
                    $this.sql().apply((Object)l2DirStatement);
                    String string5 = parquetConversion$2;
                    String string6 = "true";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tbl3"), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 4).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), "parq" + BoxesRunTime.unboxToInt((Object)i)}))));
                        v5 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl3")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(path + "/l1/l2/l3");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        v5 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
                    }
                    String wildcardTopDirStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE tbl4(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + new File(path + "/*").toURI() + "'"));
                    $this.sql().apply((Object)wildcardTopDirStatement);
                    String string7 = parquetConversion$2;
                    String string8 = "true";
                    if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                        $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tbl4"), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), "parq" + BoxesRunTime.unboxToInt((Object)i)}))));
                        v7 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl4")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(path + "/l1/l2");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        v7 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
                    }
                    String wildcardL1DirStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE tbl5(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + new File(path + "/l1/*").toURI() + "'"));
                    $this.sql().apply((Object)wildcardL1DirStatement);
                    String string9 = parquetConversion$2;
                    String string10 = "true";
                    if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                        $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tbl5"), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), "parq" + BoxesRunTime.unboxToInt((Object)i)}))));
                        v9 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl5")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(path + "/l1/l2/l3");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        v9 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
                    }
                    String wildcardL2DirStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE EXTERNAL TABLE tbl6(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '" + new File(path + "/l1/l2/*").toURI() + "'"));
                    $this.sql().apply((Object)wildcardL2DirStatement);
                    $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tbl6"), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 6).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), "parq" + BoxesRunTime.unboxToInt((Object)i)}))));
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("SPARK-36941: Save/load ANSI intervals to Hive Parquet table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "tbl_ansi_intervals";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Tuple2 tuple2 = new Tuple2((Object)Period.ofMonths(10), (Object)Duration.ofDays(1L));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Period ym = (Period)tuple2._1();
                Duration dt = (Duration)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)ym, (Object)dt);
                Period ym2 = (Period)tuple22._1();
                Duration dt2 = (Duration)tuple22._2();
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator41$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.time.Period").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.time.Duration").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator41$1(HiveParquetSourceSuite $outer) {
                    }
                }
                org.apache.spark.sql.classic.Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)ym2, (Object)dt2), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator41$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ym", "dt"}));
                df.write().mode(SaveMode.Overwrite).format("parquet").saveAsTable(tableName);
                this.withAllParquetReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("select * from " + tableName)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ym2, dt2}))));
            });
        }, new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        this.test("Create view with dashes in column type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE VIEW t AS SELECT STRUCT('a' AS `$a`, 1 AS b) q");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)1)}))})));
        }), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        this.test("Alter view with nested struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE OR REPLACE VIEW t AS SELECT struct(id AS `$col2`, struct(id AS `$col`) AS s1) AS s2 FROM RANGE(5)");
            this.sql().apply((Object)"ALTER VIEW t SET TBLPROPERTIES ('x' = 'y')");
            this.sql().apply((Object)"ALTER VIEW t RENAME TO t2");
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"show TBLPROPERTIES t2 (x)"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"x", "y"})));
        }), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        Statics.releaseFence();
    }
}

