/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompatibilityTest;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005M3AAB\u0004\u0001%!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003BB\u0019\u0001A\u0003%\u0011\u0006C\u00033\u0001\u0011E3\u0007C\u0003G\u0001\u0011%qIA\u000fQCJ\fX/\u001a;ISZ,7i\\7qCRL'-\u001b7jif\u001cV/\u001b;f\u0015\tA\u0011\"\u0001\u0003iSZ,'B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011c\u0001\u0001\u0014;A\u0011AcG\u0007\u0002+)\u0011acF\u0001\ba\u0006\u0014\u0018/^3u\u0015\tA\u0012$A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u000e\n\u0003%)\u00070Z2vi&|g.\u0003\u0002\u001d+\tA\u0002+\u0019:rk\u0016$8i\\7qCRL'-\u001b7jif$Vm\u001d;\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001:\u0011\u0001\u0002;fgRL!AI\u0010\u0003#Q+7\u000f\u001e%jm\u0016\u001c\u0016N\\4mKR|g.\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u000f\u0005Q1\u000f^1hS:<G)\u001b:\u0016\u0003%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\t1\fgn\u001a\u0006\u0002]\u0005!!.\u0019<b\u0013\t\u00014F\u0001\u0004TiJLgnZ\u0001\fgR\fw-\u001b8h\t&\u0014\b%\u0001\tm_\u001e\u0004\u0016M]9vKR\u001c6\r[3nCR\u0011AG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0005+:LG\u000fC\u0003<\t\u0001\u0007A(\u0001\u0003qCRD\u0007CA\u001fE\u001d\tq$\t\u0005\u0002@m5\t\u0001I\u0003\u0002B#\u00051AH]8pizJ!a\u0011\u001c\u0002\rA\u0013X\rZ3g\u0013\t\u0001TI\u0003\u0002Dm\u0005aB/Z:u!\u0006\u0014\u0018/^3u\u0011&4XmQ8na\u0006$\u0018NY5mSRLHc\u0001\u001bI\u001d\")\u0011*\u0002a\u0001\u0015\u0006\u0019!o\\<\u0011\u0005-cU\"A\u0005\n\u00055K!a\u0001*po\")q*\u0002a\u0001!\u0006I\u0001.\u001b<f)f\u0004Xm\u001d\t\u0004kEc\u0014B\u0001*7\u0005)a$/\u001a9fCR,GM\u0010")
public class ParquetHiveCompatibilitySuite
extends ParquetCompatibilityTest
implements TestHiveSingleton {
    private final String stagingDir;
    private boolean enableAutoThreadAudit;
    private SparkSession spark;
    private TestHiveContext hiveContext;
    private HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public void afterEach() {
        TestHiveSingleton.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private String stagingDir() {
        return this.stagingDir;
    }

    public void logParquetSchema(String path2) {
        MessageType schema = this.readParquetSchema(path2, (Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ParquetHiveCompatibilitySuite.$anonfun$logParquetSchema$1(this, path)));
        this.logInfo((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Schema of the Parquet file written by parquet-avro:\n         |" + schema + "\n       ")));
    }

    private void testParquetHiveCompatibility(Row row, Seq<String> hiveTypes) {
        this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"parquet_compat"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)dir -> {
            ParquetHiveCompatibilitySuite.$anonfun$testParquetHiveCompatibility$2(this, row, hiveTypes, dir);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$logParquetSchema$1(ParquetHiveCompatibilitySuite $this, Path path) {
        return !path.getName().startsWith("_") && !path.getName().startsWith($this.stagingDir());
    }

    public static final /* synthetic */ void $anonfun$testParquetHiveCompatibility$2(ParquetHiveCompatibilitySuite $this, Row row$1, Seq hiveTypes$1, File dir) {
        String path = dir.toURI().toString();
        Row row = row$1;
        Row row2 = Row$.MODULE$.apply((Seq)package$.MODULE$.Seq().fill(row$1.length(), (Function0 & Serializable)() -> null));
        List rows = Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row);
        $this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"data"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq fields = (Seq)((IterableOps)hiveTypes$1.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String typ = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return "  col_" + index + " " + typ;
                }
                throw new MatchError((Object)tuple2);
            });
            String ddl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE parquet_compat(\n                 |" + fields.mkString(",\n") + "\n                 |)\n                 |STORED AS PARQUET\n                 |LOCATION '" + path + "'\n               "));
            $this.logInfo((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Creating testing Parquet table with the following DDL:\n                 |" + ddl + "\n               ")));
            $this.spark().sql(ddl);
            StructType schema = $this.spark().table("parquet_compat").schema();
            RDD qual$1 = $this.spark().sparkContext().parallelize((Seq)rows, $this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
            boolean x$1 = true;
            boolean x$2 = qual$1.coalesce$default$2();
            Option x$3 = qual$1.coalesce$default$3();
            boolean x$4 = true;
            boolean x$5 = x$2;
            Option x$6 = x$3;
            Ordering x$7 = qual$1.coalesce$default$4(1, x$5, x$6);
            RDD rowRDD = qual$1.coalesce(1, x$5, x$6, x$7);
            $this.spark().createDataFrame(rowRDD, schema).createOrReplaceTempView("data");
            $this.spark().sql("INSERT INTO TABLE parquet_compat SELECT * FROM data");
        }));
        $this.logParquetSchema(path);
        $this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().parquet(path), (Seq)rows));
    }

    public ParquetHiveCompatibilitySuite() {
        TestHiveSingleton.$init$(this);
        this.stagingDir = ".hive-staging";
        this.test("simple primitives", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testParquetHiveCompatibility(Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToShort((short)((short)2)), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToFloat((float)5.1f), BoxesRunTime.boxToDouble((double)6.1), "foo"})), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"BOOLEAN", "TINYINT", "SMALLINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "STRING"})), new Position("ParquetHiveCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("SPARK-10177 timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testParquetHiveCompatibility(Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Timestamp.valueOf("2015-08-24 00:31:00")})), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP"})), new Position("ParquetHiveCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("array", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testParquetHiveCompatibility(Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon(null, (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon(null, (List)Nil$.MODULE$)))), new .colon.colon((Object)"foo", (List)new .colon.colon(null, (List)new .colon.colon((Object)"bar", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), new .colon.colon((Object)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon(null, (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon(null, (List)Nil$.MODULE$)), (List)Nil$.MODULE$))})), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ARRAY<INT>", "ARRAY<STRING>", "ARRAY<ARRAY<INT>>"})), new Position("ParquetHiveCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("map", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testParquetHiveCompatibility(Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(2)), null)}))})), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAP<INT, STRING>"})), new Position("ParquetHiveCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.ignore("map entries with null keys", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testParquetHiveCompatibility(Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(null), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(null), null)}))})), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAP<INT, STRING>"})), new Position("ParquetHiveCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("struct", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testParquetHiveCompatibility(Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon(null, (List)Nil$.MODULE$)))}))})), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"STRUCT<f0: INT, f1: ARRAY<STRING>>"})), new Position("ParquetHiveCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("SPARK-16344: array of struct with a single field named 'array_element'", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testParquetHiveCompatibility(Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)})), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ARRAY<STRUCT<array_element: INT>>"})), new Position("ParquetHiveCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        Statics.releaseFence();
    }
}

