/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.StatisticsCollectionTestBase;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat$;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.hive.HiveSessionCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.StatisticsSuite$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product14;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.MapOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashMap;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\u0006\f\u0001YAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\n\u0019Bq!\u0011\u0001\u0012\u0002\u0013%!\tC\u0004N\u0001E\u0005I\u0011\u0002\"\t\u000b9\u0003A\u0011B(\t\u000b\r\u0004A\u0011\u00023\t\u000b!\u0004A\u0011B5\t\u000b=\u0004A\u0011\u00029\t\u000bU\u0004A\u0011\u0002<\u0003\u001fM#\u0018\r^5ti&\u001c7oU;ji\u0016T!\u0001D\u0007\u0002\t!Lg/\u001a\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]Y\u0002C\u0001\r\u001a\u001b\u0005i\u0011B\u0001\u000e\u000e\u0005q\u0019F/\u0019;jgRL7m]\"pY2,7\r^5p]R+7\u000f\u001e\"bg\u0016\u0004\"\u0001H\u0010\u000e\u0003uQ!AH\u0006\u0002\tQ,7\u000f^\u0005\u0003Au\u0011\u0011\u0003V3ti\"Kg/Z*j]\u001edW\r^8o\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t1\"A\rde\u0016\fG/\u001a(p]B\u000b'\u000f^5uS>tW\r\u001a+bE2,G\u0003B\u0014.u}\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012A!\u00168ji\")aF\u0001a\u0001_\u00059A/\u00192OC6,\u0007C\u0001\u00198\u001d\t\tT\u0007\u0005\u00023S5\t1G\u0003\u00025+\u00051AH]8pizJ!AN\u0015\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003m%Bqa\u000f\u0002\u0011\u0002\u0003\u0007A(A\bb]\u0006d\u0017P_3e\u0005f\u001c\u0006/\u0019:l!\tAS(\u0003\u0002?S\t9!i\\8mK\u0006t\u0007b\u0002!\u0003!\u0003\u0005\r\u0001P\u0001\u000fC:\fG.\u001f>fI\nK\b*\u001b<f\u0003\r\u001a'/Z1uK:{g\u000eU1si&$\u0018n\u001c8fIR\u000b'\r\\3%I\u00164\u0017-\u001e7uII*\u0012a\u0011\u0016\u0003y\u0011[\u0013!\u0012\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005)K\u0013AC1o]>$\u0018\r^5p]&\u0011Aj\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aI2sK\u0006$XMT8o!\u0006\u0014H/\u001b;j_:,G\rV1cY\u0016$C-\u001a4bk2$HeM\u0001\u0017Kb$(/Y2u'R\fGo\u001d)s_B4\u0016\r\\;fgR\u0019\u0001\u000bX1\u0011\u0007!\n6+\u0003\u0002SS\t1q\n\u001d;j_:\u0004\"\u0001V-\u000f\u0005U;fB\u0001\u001aW\u0013\u0005Q\u0013B\u0001-*\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\r\tKw-\u00138u\u0015\tA\u0016\u0006C\u0003^\u000b\u0001\u0007a,\u0001\u0006eKN\u001cw*\u001e;qkR\u00042\u0001V00\u0013\t\u00017LA\u0002TKFDQAY\u0003A\u0002=\nq\u0001\u001d:pa.+\u00170\u0001\ruKN$\u0018\t\u001c;feR\u000b'\r\\3Qe>\u0004XM\u001d;jKN$2aJ3g\u0011\u0015qc\u00011\u00010\u0011\u00159g\u00011\u00010\u0003E\tG\u000e^3s)\u0006\u0014G.\u001a)s_B\u001cU\u000eZ\u0001\u0013O\u0016$8\u000b^1ugB\u0013x\u000e]3si&,7\u000f\u0006\u0002k[B!\u0001g[\u00180\u0013\ta\u0017HA\u0002NCBDQA\\\u0004A\u0002=\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0002-Q,7\u000f^+qI\u0006$\u0018N\\4UC\ndWm\u0015;biN$2aJ9t\u0011\u0015\u0011\b\u00021\u00010\u0003A!\u0018M\u00197f\t\u0016\u001c8M]5qi&|g\u000eC\u0003u\u0011\u0001\u0007q&\u0001\bde\u0016\fG/\u001a+bE2,7)\u001c3\u00023\u001d,Go\u0015;biN\u0014UMZ8sK\u00063G/\u001a:Va\u0012\fG/\u001a\u000b\u0004o\u0006\u0015\u0001\u0003\u0002\u0015yujL!!_\u0015\u0003\rQ+\b\u000f\\33!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\bG\u0006$\u0018\r\\8h\u0015\tyX\"\u0001\u0005dCR\fG._:u\u0013\r\t\u0019\u0001 \u0002\u0012\u0007\u0006$\u0018\r\\8h'R\fG/[:uS\u000e\u001c\bBBA\u0004\u0013\u0001\u0007A(\u0001\tjg\u0006s\u0017\r\\={K\u000e{G.^7og\u0002")
public class StatisticsSuite
extends StatisticsCollectionTestBase
implements TestHiveSingleton {
    private boolean enableAutoThreadAudit;
    private org.apache.spark.sql.classic.SparkSession spark;
    private TestHiveContext hiveContext;
    private HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public void afterEach() {
        TestHiveSingleton.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public org.apache.spark.sql.classic.SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(org.apache.spark.sql.classic.SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private void createNonPartitionedTable(String tabName, boolean analyzedBySpark, boolean analyzedByHive) {
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |CREATE TABLE " + tabName + " (key STRING, value STRING)\n         |STORED AS TEXTFILE\n         |TBLPROPERTIES ('prop1' = 'val1', 'prop2' = 'val2')\n       ")));
        this.sql().apply((Object)("INSERT INTO TABLE " + tabName + " SELECT * FROM src"));
        Object object = analyzedBySpark ? this.sql().apply((Object)("ANALYZE TABLE " + tabName + " COMPUTE STATISTICS")) : BoxedUnit.UNIT;
        Object object2 = analyzedByHive ? this.hiveClient().runSqlHive("ANALYZE TABLE " + tabName + " COMPUTE STATISTICS") : BoxedUnit.UNIT;
        Seq describeResult1 = this.hiveClient().runSqlHive("DESCRIBE FORMATTED " + tabName);
        Map tableMetadata = this.getCatalogTable(tabName).properties();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new .colon.colon((Object)"COLUMN_STATS_ACCURATE", (List)new .colon.colon((Object)"numFiles", (List)new .colon.colon((Object)"numPartitions", (List)new .colon.colon((Object)"numRows", (List)new .colon.colon((Object)"rawDataSize", (List)new .colon.colon((Object)"totalSize", (List)Nil$.MODULE$)))))).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StatisticsSuite.$anonfun$createNonPartitionedTable$1(tableMetadata, x$1))), "scala.`package`.Seq.apply[String](\"COLUMN_STATS_ACCURATE\", \"numFiles\", \"numPartitions\", \"numRows\", \"rawDataSize\", \"totalSize\").forall(((x$1: String) => tableMetadata.contains(x$1).unary_!))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
        if (analyzedByHive) {
            Seq $org_scalatest_assert_macro_left = StringUtils$.MODULE$.filterPattern(describeResult1, "*numRows\\s+500*");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 886));
            return;
        }
        Seq $org_scalatest_assert_macro_left = StringUtils$.MODULE$.filterPattern(describeResult1, "*numRows\\s+500*");
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 888));
    }

    private boolean createNonPartitionedTable$default$2() {
        return true;
    }

    private boolean createNonPartitionedTable$default$3() {
        return true;
    }

    private Option<BigInt> extractStatsPropValues(Seq<String> descOutput, String propKey) {
        Option option;
        Seq str = (Seq)((IterableOps)descOutput.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(HiveExternalCatalog$.MODULE$.STATISTICS_PREFIX())))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains(propKey)));
        if (str.isEmpty()) {
            return None$.MODULE$;
        }
        Seq $org_scalatest_assert_macro_left = str;
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"found more than one matches", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
        Regex pattern = new Regex(propKey + "\\s+(-?\\d+)", (Seq)Nil$.MODULE$);
        String string = ((String)str.head()).trim();
        if (string == null || (option = pattern.unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)string);
        }
        String value = (String)((LinearSeqOps)option.get()).apply(0);
        String value2 = value;
        return Option$.MODULE$.apply((Object)scala.package$.MODULE$.BigInt().apply(value2));
    }

    private void testAlterTableProperties(String tabName, String alterTablePropCmd) {
        scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)analyzedBySpark -> {
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Bool bool;
                Bool bool2;
                Bool bool3;
                String x$1 = tabName$2;
                boolean x$2 = true;
                boolean x$3 = analyzedBySpark;
                $this.createNonPartitionedTable(x$1, x$3, true);
                $this.checkTableStats(tabName$2, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
                $this.sql().apply((Object)alterTablePropCmd$1);
                Seq describeResult = $this.hiveClient().runSqlHive("DESCRIBE FORMATTED " + tabName$2);
                Option<BigInt> totalSize = $this.extractStatsPropValues((Seq<String>)describeResult, "totalSize");
                Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(totalSize.isDefined(), "totalSize.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left.value()) {
                    BigInt $org_scalatest_assert_macro_left2 = (BigInt)totalSize.get();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right = bool3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"totalSize is lost", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 959));
                Option<BigInt> numRows = $this.extractStatsPropValues((Seq<String>)describeResult, "numRows");
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.simpleMacroBool(numRows.isDefined(), "numRows.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    BigInt $org_scalatest_assert_macro_left4 = (BigInt)numRows.get();
                    int $org_scalatest_assert_macro_right2 = 500;
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 962));
                Option<BigInt> rawDataSize = $this.extractStatsPropValues((Seq<String>)describeResult, "rawDataSize");
                Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.simpleMacroBool(rawDataSize.isDefined(), "rawDataSize.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left5.value()) {
                    BigInt $org_scalatest_assert_macro_left6 = (BigInt)rawDataSize.get();
                    int $org_scalatest_assert_macro_right4 = 5312;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left6, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4)), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right5 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964));
                $this.checkTableStats(tabName$2, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
            });
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, String> getStatsProperties(String tableName) {
        CatalogTable hTable = this.hiveClient().getTable(this.spark().sessionState().catalog().getCurrentDatabase(), tableName);
        return (Map)hTable.properties().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StatisticsSuite.$anonfun$getStatsProperties$1(x0$1)));
    }

    private void testUpdatingTableStats(String tableDescription, String createTableCmd) {
        this.test("test table-level statistics for " + tableDescription, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String parquetTable = "parquetTable";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTable}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)createTableCmd);
                CatalogTable catalogTable = this.getCatalogTable(parquetTable);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isDatasourceTable(catalogTable), "org.apache.spark.sql.execution.command.DDLUtils.isDatasourceTable(catalogTable)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1319));
                this.sql().apply((Object)("INSERT INTO TABLE " + parquetTable + " SELECT * FROM src WHERE key < 10"));
                this.checkTableStats(parquetTable, false, (Option)None$.MODULE$);
                this.sql().apply((Object)("ANALYZE TABLE " + parquetTable + " COMPUTE STATISTICS noscan"));
                Option fetchedStats1 = this.checkTableStats(parquetTable, true, (Option)None$.MODULE$);
                this.sql().apply((Object)("INSERT INTO TABLE " + parquetTable + " SELECT * FROM src WHERE key < 10"));
                this.sql().apply((Object)("ANALYZE TABLE " + parquetTable + " COMPUTE STATISTICS noscan"));
                Option fetchedStats2 = this.checkTableStats(parquetTable, true, (Option)None$.MODULE$);
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats2.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = ((CatalogStatistics)fetchedStats1.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1334));
                this.sql().apply((Object)("ANALYZE TABLE " + parquetTable + " COMPUTE STATISTICS"));
                Option fetchedStats3 = this.checkTableStats(parquetTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetchedStats3.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)fetchedStats2.get()).sizeInBytes();
                BigInt bigInt = $org_scalatest_assert_macro_left2;
                BigInt bigInt2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1340));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1314));
    }

    private Tuple2<CatalogStatistics, CatalogStatistics> getStatsBeforeAfterUpdate(boolean isAnalyzeColumns) {
        String tableName = "tbl";
        ObjectRef statsBeforeUpdate = ObjectRef.create(null);
        ObjectRef statsAfterUpdate = ObjectRef.create(null);
        this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TableIdentifier tableIndent = TableIdentifier$.MODULE$.apply(tableName, (Option)new Some((Object)"default"));
            HiveSessionCatalog catalog = (HiveSessionCatalog)this.spark().sessionState().catalog();
            this.sql().apply((Object)("CREATE TABLE " + tableName + " (key int) USING PARQUET"));
            this.sql().apply((Object)("INSERT INTO " + tableName + " SELECT 1"));
            Object object = isAnalyzeColumns ? this.sql().apply((Object)("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS FOR COLUMNS key")) : this.sql().apply((Object)("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS"));
            this.spark().table(tableIndent);
            statsBeforeUpdate$1.elem = (CatalogStatistics)((CatalogTable)((LogicalRelation)catalog.metastoreCatalog().getCachedDataSourceTable(tableIndent)).catalogTable().get()).stats().get();
            this.sql().apply((Object)("INSERT INTO " + tableName + " SELECT 2"));
            Object object2 = isAnalyzeColumns ? this.sql().apply((Object)("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS FOR COLUMNS key")) : this.sql().apply((Object)("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS"));
            this.spark().table(tableIndent);
            statsAfterUpdate$1.elem = (CatalogStatistics)((CatalogTable)((LogicalRelation)catalog.metastoreCatalog().getCachedDataSourceTable(tableIndent)).catalogTable().get()).stats().get();
        });
        return new Tuple2((Object)((CatalogStatistics)statsBeforeUpdate.elem), (Object)((CatalogStatistics)statsAfterUpdate.elem));
    }

    public static final /* synthetic */ void $anonfun$new$9(StatisticsSuite $this, File tempDir) {
        File file1 = new File(tempDir + "/data1");
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(file1), (Function1 & Serializable)writer -> {
            writer.write("1,2");
            return BoxedUnit.UNIT;
        });
        File file2 = new File(tempDir + "/data2");
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(file2), (Function1 & Serializable)writer -> {
            writer.write("1,2");
            return BoxedUnit.UNIT;
        });
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE EXTERNAL TABLE csv_table(page_id INT, impressions INT)\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n               |WITH SERDEPROPERTIES (\n               |\"separatorChar\" = \",\",\n               |\"quoteChar\"     = \"\\\"\",\n               |\"escapeChar\"    = \"\\\\\")\n               |LOCATION '" + tempDir.toURI() + "'")));
        HiveTableRelation relation = (HiveTableRelation)$this.spark().table("csv_table").queryExecution().analyzed().children().head();
        Map properties = relation.tableMeta().ignoredProperties();
        long $org_scalatest_assert_macro_left = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)properties.apply((Object)"totalSize")));
        int $org_scalatest_assert_macro_right = 6;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        Option $org_scalatest_assert_macro_left2 = properties.get((Object)"rawDataSize");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        BigInt sizeInBytes = relation.stats().sizeInBytes();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(sizeInBytes);
        BigInt $org_scalatest_assert_macro_right2 = scala.package$.MODULE$.BigInt().apply(file1.length() + file2.length());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }

    private final BigInt queryTotalSize$1(String tableName) {
        return this.spark().table(tableName).queryExecution().analyzed().stats().sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$new$34(StatisticsSuite $this, String tableName$2, File path) {
        $this.sql().apply((Object)("CREATE TABLE " + tableName$2 + " (key STRING, value STRING) USING hive PARTITIONED BY (ds STRING)"));
        .colon.colon partitionDates = new .colon.colon((Object)"2010-01-01", (List)new .colon.colon((Object)"2010-01-02", (List)new .colon.colon((Object)"2010-01-03", (List)Nil$.MODULE$)));
        partitionDates.foreach((Function1 & Serializable)ds -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("INSERT INTO TABLE " + tableName$2 + " PARTITION (ds='" + ds + "') SELECT * FROM src")));
        $this.sql().apply((Object)("ALTER TABLE " + tableName$2 + " SET LOCATION '" + path.toURI() + "'"));
        $this.sql().apply((Object)("ANALYZE TABLE " + tableName$2 + " COMPUTE STATISTICS noscan"));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getTableStats(tableName$2).sizeInBytes());
        BigInt $org_scalatest_assert_macro_right = scala.package$.MODULE$.BigInt().apply(17436);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
    }

    public static final /* synthetic */ void $anonfun$new$38(StatisticsSuite $this, String sourceTableName$1, String tableName$3, File path) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE TABLE " + sourceTableName$1 + " (key STRING, value STRING)\n               |USING hive\n               |PARTITIONED BY (ds STRING)\n               |LOCATION '" + path.toURI() + "'\n             ")));
        .colon.colon partitionDates = new .colon.colon((Object)"2010-01-01", (List)new .colon.colon((Object)"2010-01-02", (List)new .colon.colon((Object)"2010-01-03", (List)Nil$.MODULE$)));
        partitionDates.foreach((Function1 & Serializable)ds -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |INSERT INTO TABLE " + sourceTableName$1 + " PARTITION (ds='" + ds + "')\n                   |SELECT * FROM src\n                 "))));
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE TABLE " + tableName$3 + " (key STRING, value STRING)\n               |USING hive\n               |PARTITIONED BY (ds STRING)\n               |LOCATION '" + path.toURI() + "'\n             ")));
        String ds2 = (String)partitionDates.head();
        $this.sql().apply((Object)("ALTER TABLE " + tableName$3 + " ADD PARTITION (ds='" + ds2 + "')"));
        $this.sql().apply((Object)("ANALYZE TABLE " + sourceTableName$1 + " COMPUTE STATISTICS noscan"));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getTableStats(sourceTableName$1).sizeInBytes());
        BigInt $org_scalatest_assert_macro_right = scala.package$.MODULE$.BigInt().apply(17436);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        $this.sql().apply((Object)("ANALYZE TABLE " + tableName$3 + " COMPUTE STATISTICS noscan"));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getTableStats(tableName$3).sizeInBytes());
        BigInt $org_scalatest_assert_macro_right2 = scala.package$.MODULE$.BigInt().apply(5812);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
    }

    private final Option queryStats$1(String ds, String tableName$4) {
        CatalogTablePartition partition = this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName$4), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)ds)})));
        return partition.stats();
    }

    public static final /* synthetic */ void $anonfun$new$45(StatisticsSuite $this, String tableName$4, File path$1, String ds) {
        $this.sql().apply((Object)("ALTER TABLE " + tableName$4 + " ADD PARTITION (ds='" + ds + "') LOCATION '" + path$1 + "/ds=" + ds + "'"));
        ((org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM src")).write().mode(SaveMode.Overwrite).format("parquet").save(path$1 + "/ds=" + ds);
    }

    public static final /* synthetic */ void $anonfun$new$44(StatisticsSuite $this, String tableName$4, List partitionDates$1, boolean partitionStatsEnabled$1, int expectedRowCount$1, File path) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE " + tableName$4 + " (key INT, value STRING)\n                 |USING parquet\n                 |PARTITIONED BY (ds STRING)\n                 |LOCATION '" + path.toURI() + "'\n               ")));
        partitionDates$1.foreach((Function1 & Serializable)ds -> {
            StatisticsSuite.$anonfun$new$45($this, tableName$4, path, ds);
            return BoxedUnit.UNIT;
        });
        Option $org_scalatest_assert_macro_left = $this.getCatalogTable(tableName$4).stats();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        partitionDates$1.foreach((Function1 & Serializable)ds -> {
            Option $org_scalatest_assert_macro_left = $this.queryStats$1((String)ds, tableName$4);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        });
        $this.sql().apply((Object)("ANALYZE TABLE " + tableName$4 + " COMPUTE STATISTICS NOSCAN"));
        BigInt $org_scalatest_assert_macro_left2 = $this.getTableStats(tableName$4).sizeInBytes();
        BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        Option $org_scalatest_assert_macro_left3 = $this.getTableStats(tableName$4).rowCount();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        partitionDates$1.foreach((Function1 & Serializable)ds -> {
            Option partStats = $this.queryStats$1((String)ds, tableName$4);
            if (partitionStatsEnabled$1) {
                Option $org_scalatest_assert_macro_left = partStats;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)partStats.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
                Option $org_scalatest_assert_macro_left3 = ((CatalogStatistics)partStats.get()).rowCount();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
            }
            Option $org_scalatest_assert_macro_left = partStats;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        });
        $this.sql().apply((Object)("ANALYZE TABLE " + tableName$4 + " COMPUTE STATISTICS"));
        BigInt $org_scalatest_assert_macro_left4 = $this.getTableStats(tableName$4).sizeInBytes();
        BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.int2bigInt(0);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        BigInt $org_scalatest_assert_macro_left5 = (BigInt)$this.getTableStats(tableName$4).rowCount().get();
        int $org_scalatest_assert_macro_right3 = 3 * expectedRowCount$1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        partitionDates$1.foreach((Function1 & Serializable)ds -> {
            Option partStats = $this.queryStats$1((String)ds, tableName$4);
            if (partitionStatsEnabled$1) {
                Option $org_scalatest_assert_macro_left = partStats;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)partStats.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
                BigInt $org_scalatest_assert_macro_left3 = (BigInt)((CatalogStatistics)partStats.get()).rowCount().get();
                int $org_scalatest_assert_macro_right2 = expectedRowCount$1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
            }
            Option $org_scalatest_assert_macro_left = partStats;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        });
    }

    private final CatalogStatistics queryStats$2(String ds, String tableName$5) {
        CatalogTablePartition partition = this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName$5), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)ds)})));
        return (CatalogStatistics)partition.stats().get();
    }

    private final void createPartition$1(String ds, String query, String tableName$5) {
        this.sql().apply((Object)("INSERT INTO TABLE " + tableName$5 + " PARTITION (ds='" + ds + "') " + query));
    }

    private final Option queryStats$3(String ds, String hr, String tableName$6) {
        TableIdentifier tableId = TableIdentifier$.MODULE$.apply(tableName$6);
        CatalogTablePartition partition = this.spark().sessionState().catalog().getPartition(tableId, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)ds), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)hr)})));
        return partition.stats();
    }

    private final void assertPartitionStats$1(String ds, String hr, Option rowCount, BigInt sizeInBytes, String tableName$6) {
        CatalogStatistics stats = (CatalogStatistics)this.queryStats$3(ds, hr, tableName$6).get();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(stats.rowCount());
        Option $org_scalatest_assert_macro_right = rowCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(stats.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right2 = sizeInBytes;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
    }

    private final void createPartition$2(String ds, int hr, String query, String tableName$6) {
        this.sql().apply((Object)("INSERT INTO TABLE " + tableName$6 + " PARTITION (ds='" + ds + "', hr=" + hr + ") " + query));
    }

    private final void assertPartitionStats$2(String ds, String hr, Option rowCount, BigInt sizeInBytes, String tableName$7) {
        CatalogStatistics stats = (CatalogStatistics)this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName$7), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)ds), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)hr)}))).stats().get();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(stats.rowCount());
        Option $org_scalatest_assert_macro_right = rowCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(stats.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right2 = sizeInBytes;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
    }

    private final void createPartition$3(String ds, int hr, String query, String tableName$7) {
        this.sql().apply((Object)("INSERT INTO TABLE " + tableName$7 + " PARTITION (ds='" + ds + "', hr=" + hr + ") " + query));
    }

    private final void assertAnalysisException$1(String partitionSpec, String tableName$10) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ANALYZE TABLE " + tableName$10 + " " + partitionSpec + " COMPUTE STATISTICS")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630))).getMessage();
        String $org_scalatest_assert_macro_right = "The list of partition columns with values in partition specification for table '" + tableName$10.toLowerCase(Locale.ROOT) + "' in database 'default' is not a prefix of the list of partition columns defined in the table schema";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
    }

    private final void assertAnalysisException$2(String analyzeCommand, String errorMessage) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)analyzeCommand), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686))).getMessage();
        String $org_scalatest_assert_macro_right = errorMessage;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
    }

    public static final /* synthetic */ boolean $anonfun$createNonPartitionedTable$1(Map tableMetadata$1, String x$1) {
        return !tableMetadata$1.contains((Object)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getStatsProperties$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith(HiveExternalCatalog$.MODULE$.STATISTICS_PREFIX());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$100(StatisticsSuite $this, String table$7, boolean autoUpdate$2, File loadPath) {
        File file = new File(loadPath + "/data");
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(file), (Function1 & Serializable)writer -> {
            writer.write("2,xyz");
            return BoxedUnit.UNIT;
        });
        $this.sql().apply((Object)("LOAD DATA INPATH '" + loadPath.toURI().toString() + "' INTO TABLE " + table$7));
        if (autoUpdate$2) {
            Option fetched2 = $this.checkTableStats(table$7, true, (Option)None$.MODULE$);
            BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched2.get()).sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1038));
            Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched2.get()).colStats();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1039));
            Map<String, String> statsProp = $this.getStatsProperties(table$7);
            long $org_scalatest_assert_macro_left3 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)statsProp.apply((Object)HiveExternalCatalog$.MODULE$.STATISTICS_TOTAL_SIZE())));
            BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)$org_scalatest_assert_macro_right2, BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), (Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1041));
            return;
        }
        Map<String, String> $org_scalatest_assert_macro_left = $this.getStatsProperties(table$7);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1043));
    }

    public static final /* synthetic */ void $anonfun$new$107(StatisticsSuite $this, String table$8, String ds) {
        new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)hr -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("INSERT OVERWRITE TABLE " + table$8 + " PARTITION (ds='" + ds + "',hr='" + hr + "') SELECT 1, 'a'")));
    }

    public static final /* synthetic */ void $anonfun$new$109(StatisticsSuite $this, String table$8, boolean autoUpdate$3, Option fetched1$1, Seq x0$1) {
        SeqOps seqOps;
        Seq seq = x0$1;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            File dir1 = (File)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            File dir2 = (File)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            File partDir1 = new File(new File(dir1, "ds=2008-04-09"), "hr=11");
            File file1 = new File(partDir1, "data");
            Utils$.MODULE$.createDirectory(file1.getParentFile());
            Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(file1), (Function1 & Serializable)writer -> {
                writer.write("1,a");
                return BoxedUnit.UNIT;
            });
            File partDir2 = new File(new File(dir2, "ds=2008-04-09"), "hr=12");
            File file2 = new File(partDir2, "data");
            Utils$.MODULE$.createDirectory(file2.getParentFile());
            Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(file2), (Function1 & Serializable)writer -> {
                writer.write("1,a");
                return BoxedUnit.UNIT;
            });
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |ALTER TABLE " + table$8 + " ADD\n                 |PARTITION (ds='2008-04-09', hr='11') LOCATION '" + partDir1.toURI().toString() + "'\n                 |PARTITION (ds='2008-04-09', hr='12') LOCATION '" + partDir2.toURI().toString() + "'\n            ")));
            if (autoUpdate$3) {
                Option fetched2 = $this.checkTableStats(table$8, true, (Option)None$.MODULE$);
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = ((CatalogStatistics)fetched1$1.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1092));
                Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched2.get()).colStats();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1093));
                Map<String, String> statsProp = $this.getStatsProperties(table$8);
                long $org_scalatest_assert_macro_left3 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)statsProp.apply((Object)HiveExternalCatalog$.MODULE$.STATISTICS_TOTAL_SIZE())));
                BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)$org_scalatest_assert_macro_right2, BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), (Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1095));
                CatalogStatistics partStats1 = $this.getPartitionStats(table$8, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-08"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")})));
                BigInt $org_scalatest_assert_macro_left4 = partStats1.sizeInBytes();
                BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.int2bigInt(0);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1099));
                CatalogStatistics partStats2 = $this.getPartitionStats(table$8, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-08"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"12")})));
                BigInt $org_scalatest_assert_macro_left5 = partStats2.sizeInBytes();
                BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.int2bigInt(0);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, ">", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$greater((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1101));
                CatalogStatistics partStats3 = $this.getPartitionStats(table$8, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")})));
                BigInt $org_scalatest_assert_macro_left6 = partStats3.sizeInBytes();
                BigInt $org_scalatest_assert_macro_right5 = BigInt$.MODULE$.int2bigInt(0);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, ">", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$greater((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1103));
                CatalogStatistics partStats4 = $this.getPartitionStats(table$8, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"12")})));
                BigInt $org_scalatest_assert_macro_left7 = partStats4.sizeInBytes();
                BigInt $org_scalatest_assert_macro_right6 = BigInt$.MODULE$.int2bigInt(0);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, ">", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$greater((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1105));
            } else {
                Map<String, String> $org_scalatest_assert_macro_left = $this.getStatsProperties(table$8);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1107));
            }
            $this.sql().apply((Object)("ANALYZE TABLE " + table$8 + " COMPUTE STATISTICS FOR COLUMNS i, j"));
            Option fetched3 = $this.checkTableStats(table$8, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
            BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched3.get()).sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1114));
            Map $org_scalatest_assert_macro_left8 = ((CatalogStatistics)fetched3.get()).colStats();
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1115));
            $this.sql().apply((Object)("ALTER TABLE " + table$8 + " DROP PARTITION (ds='2008-04-08'), PARTITION (hr='12')"));
            Set $org_scalatest_assert_macro_left9 = ((IterableOnceOps)$this.spark().sessionState().catalog().listPartitions(TableIdentifier$.MODULE$.apply(table$8), $this.spark().sessionState().catalog().listPartitions$default$2()).map((Function1 & Serializable)x$4 -> x$4.spec())).toSet();
            Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")}))}));
            Set set = $org_scalatest_assert_macro_left9;
            Set set2 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right8, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1119));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(partDir1.exists(), "partDir1.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1121));
            if (autoUpdate$3) {
                Option fetched4 = $this.checkTableStats(table$8, true, (Option)None$.MODULE$);
                BigInt $org_scalatest_assert_macro_left10 = ((CatalogStatistics)fetched4.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right9 = ((CatalogStatistics)fetched1$1.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "<", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.$less((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1125));
                Map $org_scalatest_assert_macro_left11 = ((CatalogStatistics)fetched4.get()).colStats();
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1126));
                Map<String, String> statsProp = $this.getStatsProperties(table$8);
                long $org_scalatest_assert_macro_left12 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)statsProp.apply((Object)HiveExternalCatalog$.MODULE$.STATISTICS_TOTAL_SIZE())));
                BigInt $org_scalatest_assert_macro_right10 = ((CatalogStatistics)fetched4.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), "==", (Object)$org_scalatest_assert_macro_right10, BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), (Object)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1128));
                CatalogStatistics partStats3 = $this.getPartitionStats(table$8, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")})));
                BigInt $org_scalatest_assert_macro_left13 = partStats3.sizeInBytes();
                BigInt $org_scalatest_assert_macro_right11 = BigInt$.MODULE$.int2bigInt(0);
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, ">", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left13.$greater((Object)$org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1132));
                return;
            }
            Map<String, String> $org_scalatest_assert_macro_left14 = $this.getStatsProperties(table$8);
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left14, "isEmpty", $org_scalatest_assert_macro_left14.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1134));
            return;
        }
        throw new MatchError((Object)seq);
    }

    public static final /* synthetic */ void $anonfun$new$117(StatisticsSuite $this, String managedTable$1, String ds) {
        new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)hr -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |INSERT OVERWRITE TABLE " + managedTable$1 + "\n             |partition (ds='" + ds + "',hr='" + hr + "')\n             |SELECT 1, 'a'\n           "))));
    }

    public static final /* synthetic */ void $anonfun$new$121(StatisticsSuite $this, String format) {
        scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)isConverted -> {
            $this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)isConverted)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)isConverted))))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{format}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + format$1 + " (key STRING, value STRING) STORED AS " + format$1));
                $this.sql().apply((Object)("INSERT INTO TABLE " + format$1 + " SELECT * FROM src"));
                $this.checkTableStats(format$1, !isConverted, (Option)None$.MODULE$);
                $this.sql().apply((Object)("ANALYZE TABLE " + format$1 + " COMPUTE STATISTICS"));
                $this.checkTableStats(format$1, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$126(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith("spark.sql.statistics.colStats");
        }
        throw new MatchError((Object)tuple2);
    }

    private final void checkColStatsProps$1(Map expected, String tableName$13) {
        Map props;
        this.sql().apply((Object)("ANALYZE TABLE " + tableName$13 + " COMPUTE STATISTICS FOR COLUMNS " + this.stats().keys().mkString(", ")));
        CatalogTable table = this.hiveClient().getTable("default", tableName$13);
        Map $org_scalatest_assert_macro_left = props = (Map)table.properties().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StatisticsSuite.$anonfun$new$126(x0$1)));
        Map $org_scalatest_assert_macro_right = expected;
        Map map = $org_scalatest_assert_macro_left;
        Map map2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1226));
    }

    public static final /* synthetic */ Object $anonfun$new$132(HistogramBin[] bins$1, int i) {
        HistogramBin b = bins$1[i];
        double $org_scalatest_assert_macro_left = b.lo();
        double $org_scalatest_assert_macro_right = b.hi();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1273));
        if (i > 0) {
            HistogramBin pre = bins$1[i - 1];
            double $org_scalatest_assert_macro_left2 = pre.hi();
            double $org_scalatest_assert_macro_right2 = b.lo();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1276));
        }
        return BoxedUnit.UNIT;
    }

    private static final void checkBinsOrder$1(HistogramBin[] bins) {
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])bins)).foreach((Function1 & Serializable)i -> StatisticsSuite.$anonfun$new$132(bins, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$133(long startTimestamp$1, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)DateTimeUtils$.MODULE$.toJavaTimestamp(startTimestamp$1 + (long)i));
    }

    public static final /* synthetic */ boolean $anonfun$new$136(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith("spark.sql.statistics.colStats.cint.histogram");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$137(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith("spark.sql.statistics.colStats.ctimestamp.histogram");
        }
        throw new MatchError((Object)tuple2);
    }

    private final void mkTest$1(Function0 before, Function0 after, String query, Seq expectedAnswer, ClassTag ct) {
        Bool bool;
        Bool bool2;
        before.apply$mcV$sp();
        ObjectRef df = ObjectRef.create((Object)((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)query)));
        Seq sizes = ((org.apache.spark.sql.classic.Dataset)df.elem).queryExecution().analyzed().collect((PartialFunction)new Serializable(null, ct){
            private static final long serialVersionUID = 0L;
            private final ClassTag ct$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (this.ct$1.runtimeClass().isAssignableFrom(A1.getClass())) {
                    return (B1)A1.stats().sizeInBytes();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return this.ct$1.runtimeClass().isAssignableFrom(logicalPlan.getClass());
            }
            {
                this.ct$1 = ct$1;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left2.value()) {
            BigInt $org_scalatest_assert_macro_left3 = (BigInt)sizes.apply(0);
            BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
            bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "<=", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$less$eq((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        } else {
            bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right3 = bool2;
        Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left4.value()) {
            BigInt $org_scalatest_assert_macro_left5 = (BigInt)sizes.apply(1);
            BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "<=", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$less$eq((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        } else {
            bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right5 = bool;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"query should contain two relations, each of which has size smaller than autoConvertSize", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1422));
        ObjectRef bhj = ObjectRef.create((Object)((org.apache.spark.sql.classic.Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof BroadcastHashJoinExec) {
                    BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                    return (B1)broadcastHashJoinExec;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan = x2;
                return sparkPlan instanceof BroadcastHashJoinExec;
            }
        }));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Seq)bhj.elem).size()));
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)("actual query plans do not contain broadcast join: " + ((org.apache.spark.sql.classic.Dataset)df.elem).queryExecution()), Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1429));
        this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)df$4.elem, expectedAnswer);
        this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"-1")}), (Function0 & Serializable)() -> {
            df$4.elem = (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)query);
            bhj$1.elem = ((org.apache.spark.sql.classic.Dataset)df$4.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof BroadcastHashJoinExec) {
                        BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                        return (B1)broadcastHashJoinExec;
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(SparkPlan x3) {
                    SparkPlan sparkPlan = x3;
                    return sparkPlan instanceof BroadcastHashJoinExec;
                }
            });
            Seq $org_scalatest_assert_macro_left = (Seq)bhj$1.elem;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"BroadcastHashJoin still planned even though it is switched off", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1437));
            Seq shj = ((org.apache.spark.sql.classic.Dataset)df$4.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    if (A1 instanceof SortMergeJoinExec) {
                        SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)A1;
                        return (B1)sortMergeJoinExec;
                    }
                    return (B1)function1.apply(x4);
                }

                public final boolean isDefinedAt(SparkPlan x4) {
                    SparkPlan sparkPlan = x4;
                    return sparkPlan instanceof SortMergeJoinExec;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shj.size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"SortMergeJoin should be planned when BroadcastHashJoin is turned off", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1440));
        });
        after.apply$mcV$sp();
    }

    public static final /* synthetic */ void $anonfun$new$156(StatisticsSuite $this, String tableName$17, boolean isConverted) {
        scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)updateEnabled -> {
            $this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)updateEnabled))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)Boolean.toString(isConverted))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName$17}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + tableName$17 + " STORED AS parquet AS SELECT 'a', 'b'"));
                CatalogTable catalogTable = $this.getCatalogTable(tableName$17);
                if (!isConverted$2 || updateEnabled) {
                    Option $org_scalatest_assert_macro_left = catalogTable.stats();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1529));
                    return;
                }
                Option $org_scalatest_assert_macro_left = catalogTable.stats();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1531));
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$169(StatisticsSuite $this, File dir) {
        File tableDir = new File(dir, "table");
        File partitionDir = new File(dir, "partition");
        $this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark_28876"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE spark_28876(id bigint)\n                 |PARTITIONED BY (ds STRING)\n                 |STORED AS PARQUET\n                 |LOCATION '" + tableDir.toURI() + "'\n             ")));
            $this.spark().range(5L).write().mode(SaveMode.Overwrite).parquet(partitionDir.getCanonicalPath());
            $this.sql().apply((Object)("ALTER TABLE spark_28876 ADD PARTITION (ds='p1') LOCATION '" + partitionDir + "'"));
            Option $org_scalatest_assert_macro_left = $this.getCatalogTable("spark_28876").stats();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1590));
            BigInt sizeInBytes = ((HiveTableRelation)$this.spark().table("spark_28876").queryExecution().analyzed().children().head()).stats().sizeInBytes();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(sizeInBytes);
            long $org_scalatest_assert_macro_right = $this.conf().defaultSizeInBytes();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1593));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)$this.spark().table("spark_28876").count()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1594));
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$180(StatisticsSuite $this, String table$9, int i) {
        CatalogStatistics partStats = $this.getPartitionStats(table$9, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sp"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dp"), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)))})));
        BigInt $org_scalatest_assert_macro_left = partStats.sizeInBytes();
        BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1658));
    }

    public static final /* synthetic */ void $anonfun$new$184(StatisticsSuite $this, String table$10, Seq x0$4) {
        SeqOps seqOps;
        Seq seq = x0$4;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            File dir1 = (File)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            File dir2 = (File)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            File partDir1 = new File(new File(dir1, "ds=2008-04-09"), "hr=11");
            File file1 = new File(partDir1, "data");
            Utils$.MODULE$.createDirectory(file1.getParentFile());
            Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(file1), (Function1 & Serializable)writer -> {
                writer.write("1,a");
                return BoxedUnit.UNIT;
            });
            File partDir2 = new File(new File(dir2, "ds=2008-04-09"), "hr=12");
            File file2 = new File(partDir2, "data");
            Utils$.MODULE$.createDirectory(file2.getParentFile());
            Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(file2), (Function1 & Serializable)writer -> {
                writer.write("1,a");
                return BoxedUnit.UNIT;
            });
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |LOAD DATA INPATH '" + file1.toURI().toString() + "' INTO TABLE " + table$10 + "\n            |PARTITION (ds='2008-04-09', hr='11')\n            ")));
            $this.sql().apply((Object)("ALTER TABLE " + table$10 + " ADD PARTITION (ds='2008-04-09', hr='12')"));
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |ALTER TABLE " + table$10 + " PARTITION (ds='2008-04-09', hr='12')\n            |SET LOCATION '" + partDir2.toURI().toString() + "'\n            |")));
            CatalogStatistics partStats1 = $this.getPartitionStats(table$10, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")})));
            BigInt $org_scalatest_assert_macro_left = partStats1.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1697));
            CatalogStatistics partStats2 = $this.getPartitionStats(table$10, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"12")})));
            BigInt $org_scalatest_assert_macro_left2 = partStats2.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1699));
            $this.sql().apply((Object)("TRUNCATE TABLE " + table$10 + " PARTITION (ds='2008-04-09', hr='11')"));
            CatalogStatistics partStats3 = $this.getPartitionStats(table$10, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")})));
            BigInt $org_scalatest_assert_macro_left3 = partStats3.sizeInBytes();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1704));
            CatalogStatistics partStats4 = $this.getPartitionStats(table$10, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"12")})));
            BigInt $org_scalatest_assert_macro_left4 = partStats4.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1706));
            $this.sql().apply((Object)("TRUNCATE TABLE " + table$10));
            CatalogStatistics partStats5 = $this.getPartitionStats(table$10, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"12")})));
            BigInt $org_scalatest_assert_macro_left5 = partStats5.sizeInBytes();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1709));
            return;
        }
        throw new MatchError((Object)seq);
    }

    public StatisticsSuite() {
        TestHiveSingleton.$init$(this);
        this.test("size estimation for relations is based on row size * number of rows", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String dsTbl = "rel_est_ds_table";
            String hiveTbl = "rel_est_hive_table";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dsTbl, hiveTbl}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().range(1000L).write().format("parquet").saveAsTable(dsTbl);
                this.spark().range(1000L).write().format("hive").saveAsTable(hiveTbl);
                new .colon.colon((Object)dsTbl, (List)new .colon.colon((Object)hiveTbl, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)tbl -> {
                    this.sql().apply((Object)("ANALYZE TABLE " + tbl + " COMPUTE STATISTICS"));
                    CatalogStatistics catalogStats = this.getTableStats((String)tbl);
                    this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"false")}), (Function0 & Serializable)() -> {
                        Statistics relationStats = this.spark().table(tbl).queryExecution().optimizedPlan().stats();
                        BigInt $org_scalatest_assert_macro_left = relationStats.sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right = catalogStats.sizeInBytes();
                        BigInt bigInt = $org_scalatest_assert_macro_left;
                        BigInt bigInt2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
                        Option $org_scalatest_assert_macro_left2 = relationStats.rowCount();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
                    });
                    this.spark().sessionState().catalog().refreshTable(TableIdentifier$.MODULE$.apply(tbl));
                    return (Assertion)this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true")}), (Function0 & Serializable)() -> {
                        Statistics relationStats = this.spark().table(tbl).queryExecution().optimizedPlan().stats();
                        BigInt $org_scalatest_assert_macro_left = catalogStats.sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right = relationStats.sizeInBytes();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "<", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$less((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
                        Option $org_scalatest_assert_macro_left2 = catalogStats.rowCount();
                        Option $org_scalatest_assert_macro_right2 = relationStats.rowCount();
                        Option option = $org_scalatest_assert_macro_left2;
                        Option option2 = $org_scalatest_assert_macro_right2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
                    });
                });
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("Hive serde tables should fallback to HDFS for size estimation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"csv_table"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)tempDir -> {
            StatisticsSuite.$anonfun$new$9(this, tempDir);
            return BoxedUnit.UNIT;
        }))), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("Hive serde table with incorrect statistics", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)tempDir -> {
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.spark().range(5L).write().mode(SaveMode.Overwrite).parquet(tempDir.getCanonicalPath());
                long dataSize = $this.getDataSize(tempDir);
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE EXTERNAL TABLE t1(id BIGINT)\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n             |LOCATION '" + tempDir.getCanonicalPath() + "'\n             |TBLPROPERTIES (\n             |'rawDataSize'='-1', 'numFiles'='0', 'totalSize'='0',\n             |'COLUMN_STATS_ACCURATE'='false', 'numRows'='-1'\n             |)")));
                $this.spark().sql("REFRESH TABLE t1");
                LogicalPlan relation1 = (LogicalPlan)$this.spark().table("t1").queryExecution().analyzed().children().head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(relation1.stats().sizeInBytes());
                long $org_scalatest_assert_macro_right = dataSize;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                $this.spark().sql("REFRESH TABLE t1");
                $this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key()), (Object)"true")}), (Function0 & Serializable)() -> {
                    LogicalPlan relation2 = (LogicalPlan)$this.spark().table("t1").queryExecution().analyzed().children().head();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(relation2.stats().sizeInBytes());
                    long $org_scalatest_assert_macro_right = dataSize;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("analyze Hive serde tables", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String nonPartTable = "non_part_table";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{nonPartTable}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + nonPartTable + " (key STRING, value STRING) USING hive"));
                this.sql().apply((Object)("INSERT INTO TABLE " + nonPartTable + " SELECT * FROM src"));
                this.sql().apply((Object)("INSERT INTO TABLE " + nonPartTable + " SELECT * FROM src"));
                this.sql().apply((Object)("ANALYZE TABLE " + nonPartTable + " COMPUTE STATISTICS noscan"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.queryTotalSize$1(nonPartTable));
                BigInt $org_scalatest_assert_macro_right = scala.package$.MODULE$.BigInt().apply(11624);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            });
            String partTable = "part_table";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{partTable}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + partTable + " (key STRING, value STRING) USING hive PARTITIONED BY (ds STRING)"));
                this.sql().apply((Object)("INSERT INTO TABLE " + partTable + " PARTITION (ds='2010-01-01') SELECT * FROM src"));
                this.sql().apply((Object)("INSERT INTO TABLE " + partTable + " PARTITION (ds='2010-01-02') SELECT * FROM src"));
                this.sql().apply((Object)("INSERT INTO TABLE " + partTable + " PARTITION (ds='2010-01-03') SELECT * FROM src"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.queryTotalSize$1(partTable));
                long $org_scalatest_assert_macro_right = this.spark().sessionState().conf().defaultSizeInBytes();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                this.sql().apply((Object)("ANALYZE TABLE " + partTable + " COMPUTE STATISTICS noscan"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.queryTotalSize$1(partTable));
                BigInt $org_scalatest_assert_macro_right2 = scala.package$.MODULE$.BigInt().apply(17436);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            });
            this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tempTable"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                ((Dataset)this.sql().apply((Object)"SELECT * FROM src")).createOrReplaceTempView("tempTable");
                this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"ANALYZE TABLE tempTable COMPUTE STATISTICS"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("SPARK-24626 parallel file listing in Stats computation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARALLEL_FILE_LISTING_IN_STATS_COMPUTATION().key()), (Object)"True")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String checkSizeTable = "checkSizeTable";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{checkSizeTable}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + checkSizeTable + " (key STRING, value STRING) USING hive PARTITIONED BY (ds STRING)"));
                this.sql().apply((Object)("INSERT INTO TABLE " + checkSizeTable + " PARTITION (ds='2010-01-01') SELECT * FROM src"));
                this.sql().apply((Object)("INSERT INTO TABLE " + checkSizeTable + " PARTITION (ds='2010-01-02') SELECT * FROM src"));
                this.sql().apply((Object)("INSERT INTO TABLE " + checkSizeTable + " PARTITION (ds='2010-01-03') SELECT * FROM src"));
                CatalogTable tableMeta = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(checkSizeTable));
                HiveCatalogMetrics$.MODULE$.reset();
                long $org_scalatest_assert_macro_left = HiveCatalogMetrics$.MODULE$.METRIC_PARALLEL_LISTING_JOB_COUNT().getCount();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
                Tuple2 tuple2 = CommandUtils$.MODULE$.calculateTotalSize(this.spark(), tableMeta, CommandUtils$.MODULE$.calculateTotalSize$default$3());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BigInt size = (BigInt)tuple2._1();
                BigInt size2 = size;
                long $org_scalatest_assert_macro_left2 = HiveCatalogMetrics$.MODULE$.METRIC_PARALLEL_LISTING_JOB_COUNT().getCount();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(size2);
                BigInt $org_scalatest_assert_macro_right3 = scala.package$.MODULE$.BigInt().apply(17436);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            });
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("analyze non hive compatible datasource tables", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "parquet_tab";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE " + table + " (a int, b int)\n          |USING parquet\n          |OPTIONS (skipHiveMetadata true)\n        ")));
                StructType rawSchema = this.hiveClient().getTable("default", table).schema();
                Metadata metadata = new MetadataBuilder().putString("comment", "from deserializer").build();
                StructType expectedRawSchema = new StructType().add("col", "array<string>", true, metadata);
                StructType $org_scalatest_assert_macro_left = rawSchema;
                StructType $org_scalatest_assert_macro_right = expectedRawSchema;
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
                StructType actualSchema = this.spark().sharedState().externalCatalog().getTable("default", table).schema();
                StructType expectedActualSchema = new StructType().add("a", "int").add("b", "int");
                StructType $org_scalatest_assert_macro_left2 = actualSchema;
                StructType $org_scalatest_assert_macro_right2 = expectedActualSchema;
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
                this.sql().apply((Object)("INSERT INTO " + table + " VALUES (1, 1)"));
                this.sql().apply((Object)("INSERT INTO " + table + " VALUES (2, 1)"));
                this.sql().apply((Object)("ANALYZE TABLE " + table + " COMPUTE STATISTICS FOR COLUMNS a, b"));
                Option fetchedStats0 = this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                Map $org_scalatest_assert_macro_left3 = ((CatalogStatistics)fetchedStats0.get()).colStats();
                Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)"1"), (Option)new Some((Object)"2"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                Map map = $org_scalatest_assert_macro_left3;
                Map map2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("Analyze hive serde tables when schema is not same as schema in table properties", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "hive_serde";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + table + " (C1 INT, C2 STRING, C3 DOUBLE)"));
                StructType rawSchema = this.hiveClient().getTable("default", table).schema();
                StructType expectedRawSchema = new StructType().add("c1", "int").add("c2", "string").add("c3", "double");
                StructType $org_scalatest_assert_macro_left = rawSchema;
                StructType $org_scalatest_assert_macro_right = expectedRawSchema;
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
                StructType actualSchema = this.spark().sharedState().externalCatalog().getTable("default", table).schema();
                StructType expectedActualSchema = new StructType().add("C1", "int").add("C2", "string").add("C3", "double");
                StructType $org_scalatest_assert_macro_left2 = actualSchema;
                StructType $org_scalatest_assert_macro_right2 = expectedActualSchema;
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
                this.sql().apply((Object)("INSERT INTO TABLE " + table + " SELECT 1, 'a', 10.0"));
                this.sql().apply((Object)("ANALYZE TABLE " + table + " COMPUTE STATISTICS FOR COLUMNS C1"));
                CatalogStatistics fetchedStats1 = (CatalogStatistics)this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))).get();
                Map $org_scalatest_assert_macro_left3 = fetchedStats1.colStats();
                Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                Map map = $org_scalatest_assert_macro_left3;
                Map map2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        this.test("SPARK-22745 - read Hive's statistics for partition", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "hive_stats_part_table";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value STRING) USING hive PARTITIONED BY (ds STRING)"));
                this.sql().apply((Object)("INSERT INTO TABLE " + tableName + " PARTITION (ds='2017-01-01') SELECT * FROM src"));
                CatalogTablePartition partition = this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2017-01-01")})));
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)partition.stats().get()).sizeInBytes();
                int $org_scalatest_assert_macro_right = 5812;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
                Option $org_scalatest_assert_macro_left2 = ((CatalogStatistics)partition.stats().get()).rowCount();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
                this.hiveClient().runSqlHive("ANALYZE TABLE " + tableName + " PARTITION (ds='2017-01-01') COMPUTE STATISTICS");
                partition = this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2017-01-01")})));
                BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)partition.stats().get()).sizeInBytes();
                int $org_scalatest_assert_macro_right2 = 5812;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
                Option $org_scalatest_assert_macro_left4 = ((CatalogStatistics)partition.stats().get()).rowCount();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToInteger((int)500));
                Option option = $org_scalatest_assert_macro_left4;
                Some some = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("SPARK-21079 - analyze table with location different than that of individual partitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)path -> {
                StatisticsSuite.$anonfun$new$34(this, tableName, path);
                return BoxedUnit.UNIT;
            }));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("SPARK-21079 - analyze partitioned table with only a subset of partitions visible", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sourceTableName = "analyzeTable_part";
            String tableName = "analyzeTable_part_vis";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceTableName, tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)path -> {
                StatisticsSuite.$anonfun$new$38(this, sourceTableName, tableName, path);
                return BoxedUnit.UNIT;
            }));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("SPARK-45731: update partition stats with ANALYZE TABLE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            .colon.colon partitionDates = new .colon.colon((Object)"2010-01-01", (List)new .colon.colon((Object)"2010-01-02", (List)new .colon.colon((Object)"2010-01-03", (List)Nil$.MODULE$)));
            int expectedRowCount = 500;
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach(arg_0 -> StatisticsSuite.$anonfun$new$41$adapted(this, tableName, (List)partitionDates, expectedRowCount, arg_0));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.test("analyze single partition", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value STRING) USING hive PARTITIONED BY (ds STRING)"));
                this.createPartition$1("2010-01-01", "SELECT '1', 'A' from src", tableName);
                this.createPartition$1("2010-01-02", "SELECT '1', 'A' from src UNION ALL SELECT '1', 'A' from src", tableName);
                this.createPartition$1("2010-01-03", "SELECT '1', 'A' from src", tableName);
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds='2010-01-01') COMPUTE STATISTICS NOSCAN"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds='2010-01-02') COMPUTE STATISTICS NOSCAN"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.queryStats$2("2010-01-01", tableName).rowCount());
                None$ $org_scalatest_assert_macro_right = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.queryStats$2("2010-01-01", tableName).sizeInBytes());
                int $org_scalatest_assert_macro_right2 = 2000;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.queryStats$2("2010-01-02", tableName).rowCount());
                None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.queryStats$2("2010-01-02", tableName).sizeInBytes());
                int $org_scalatest_assert_macro_right4 = 4000;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds='2010-01-01') COMPUTE STATISTICS"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds='2010-01-02') COMPUTE STATISTICS"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(this.queryStats$2("2010-01-01", tableName).rowCount().get());
                int $org_scalatest_assert_macro_right5 = 500;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(this.queryStats$2("2010-01-01", tableName).sizeInBytes());
                int $org_scalatest_assert_macro_right6 = 2000;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.queryStats$2("2010-01-02", tableName).rowCount().get());
                int $org_scalatest_assert_macro_right7 = 1000;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(this.queryStats$2("2010-01-02", tableName).sizeInBytes());
                int $org_scalatest_assert_macro_right8 = 4000;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        this.test("analyze a set of partitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value STRING) USING hive PARTITIONED BY (ds STRING, hr INT)"));
                this.createPartition$2("2010-01-01", 10, "SELECT '1', 'A' from src", tableName);
                this.createPartition$2("2010-01-01", 11, "SELECT '1', 'A' from src", tableName);
                this.createPartition$2("2010-01-02", 10, "SELECT '1', 'A' from src", tableName);
                this.createPartition$2("2010-01-02", 11, "SELECT '1', 'A' from src UNION ALL SELECT '1', 'A' from src", tableName);
                this.assertPartitionStats$1("2010-01-01", "10", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-01", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "10", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(4000), tableName);
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds='2010-01-01') COMPUTE STATISTICS"));
                this.assertPartitionStats$1("2010-01-01", "10", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-01", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "10", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(4000), tableName);
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds='2010-01-02') COMPUTE STATISTICS"));
                this.assertPartitionStats$1("2010-01-01", "10", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-01", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "10", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1000)), BigInt$.MODULE$.int2bigInt(4000), tableName);
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
        this.test("analyze all partitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value STRING) USING hive PARTITIONED BY (ds STRING, hr INT)"));
                this.createPartition$3("2010-01-01", 10, "SELECT '1', 'A' from src", tableName);
                this.createPartition$3("2010-01-01", 11, "SELECT '1', 'A' from src", tableName);
                this.createPartition$3("2010-01-02", 10, "SELECT '1', 'A' from src", tableName);
                this.createPartition$3("2010-01-02", 11, "SELECT '1', 'A' from src UNION ALL SELECT '1', 'A' from src", tableName);
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds, hr) COMPUTE STATISTICS NOSCAN"));
                this.assertPartitionStats$2("2010-01-01", "10", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-01", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-01", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-02", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(4000), tableName);
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds, hr) COMPUTE STATISTICS"));
                this.assertPartitionStats$2("2010-01-01", "10", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-01", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-01", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-02", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1000)), BigInt$.MODULE$.int2bigInt(4000), tableName);
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        this.test("analyze partitions for an empty table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value STRING) PARTITIONED BY (ds STRING)"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds) COMPUTE STATISTICS NOSCAN"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds) COMPUTE STATISTICS"));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
        this.test("analyze partitions case sensitivity", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value STRING) PARTITIONED BY (ds STRING)"));
                this.sql().apply((Object)("INSERT INTO TABLE " + tableName + " PARTITION (ds='2010-01-01') SELECT * FROM src"));
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"false")}), (Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (DS='2010-01-01') COMPUTE STATISTICS")));
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException x$1 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (DS='2010-01-01') COMPUTE STATISTICS")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
                    String x$2 = "PARTITIONS_NOT_FOUND";
                    Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)"`DS`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + tableName + "`"))}));
                    Option x$4 = this.checkError$default$3();
                    boolean x$5 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$1, "PARTITIONS_NOT_FOUND", x$4, x$3, x$5, x$6);
                });
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
        this.test("analyze partial partition specifications", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + tableName + " (key STRING, value STRING)\n           |PARTITIONED BY (a STRING, b INT, c STRING)\n         ")));
                this.sql().apply((Object)("INSERT INTO TABLE " + tableName + " PARTITION (a='a1', b=10, c='c1') SELECT * FROM src"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (a='a1') COMPUTE STATISTICS"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (a='a1', b=10) COMPUTE STATISTICS"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (A='a1', b=10) COMPUTE STATISTICS"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (b=10, a='a1') COMPUTE STATISTICS"));
                this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (b=10, A='a1') COMPUTE STATISTICS"));
                this.assertAnalysisException$1("PARTITION (b=10)", tableName);
                this.assertAnalysisException$1("PARTITION (a, b=10)", tableName);
                this.assertAnalysisException$1("PARTITION (b=10, c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (a, b=10, c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (a, b, c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (a='a1', c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (a='a1', b, c='c1')", tableName);
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
        this.test("analyze not found column", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value STRING) PARTITIONED BY (ds STRING)"));
                AnalysisException x$7 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS FOR COLUMNS fakeColumn")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
                String x$8 = "COLUMN_NOT_FOUND";
                Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`fakeColumn`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"caseSensitiveConfig"), (Object)"\"spark.sql.caseSensitive\"")}));
                Option x$10 = this.checkError$default$3();
                boolean x$11 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$7, "COLUMN_NOT_FOUND", x$10, x$9, x$11, x$12);
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
        this.test("analyze non-existent partition", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value STRING) PARTITIONED BY (ds STRING)"));
                this.sql().apply((Object)("INSERT INTO TABLE " + tableName + " PARTITION (ds='2010-01-01') SELECT * FROM src"));
                AnalysisException x$13 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (hour=20) COMPUTE STATISTICS")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
                String x$14 = "PARTITIONS_NOT_FOUND";
                Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)"`hour`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + tableName.toLowerCase(Locale.ROOT) + "`"))}));
                Option x$16 = this.checkError$default$3();
                boolean x$17 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$13, "PARTITIONS_NOT_FOUND", x$16, x$15, x$17, x$18);
                AnalysisException x$19 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (hour) COMPUTE STATISTICS")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
                String x$20 = "PARTITIONS_NOT_FOUND";
                Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)"`hour`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + tableName.toLowerCase(Locale.ROOT) + "`"))}));
                Option x$22 = this.checkError$default$3();
                boolean x$23 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$19, "PARTITIONS_NOT_FOUND", x$22, x$21, x$23, x$24);
                this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ANALYZE TABLE " + tableName + " PARTITION (ds='2011-02-30') COMPUTE STATISTICS")), ClassTag$.MODULE$.apply(NoSuchPartitionException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 720));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
        this.test("test table-level statistics for hive tables created in HiveExternalCatalog", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String textTable = "textTable";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{textTable}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + textTable + " (key STRING, value STRING) STORED AS TEXTFILE"));
                this.checkTableStats(textTable, false, (Option)None$.MODULE$);
                this.sql().apply((Object)("INSERT INTO TABLE " + textTable + " SELECT * FROM src"));
                this.checkTableStats(textTable, true, (Option)None$.MODULE$);
                this.sql().apply((Object)("ANALYZE TABLE " + textTable + " COMPUTE STATISTICS noscan"));
                Option fetchedStats1 = this.checkTableStats(textTable, true, (Option)None$.MODULE$);
                this.sql().apply((Object)("ANALYZE TABLE " + textTable + " COMPUTE STATISTICS"));
                Option fetchedStats2 = this.checkTableStats(textTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats1.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = ((CatalogStatistics)fetchedStats2.get()).sizeInBytes();
                BigInt bigInt = $org_scalatest_assert_macro_left;
                BigInt bigInt2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
        this.test("keep existing row count in stats with noscan if table is not changed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String textTable = "textTable";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{textTable}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + textTable + " (key STRING, value STRING)"));
                this.sql().apply((Object)("INSERT INTO TABLE " + textTable + " SELECT * FROM src"));
                this.sql().apply((Object)("ANALYZE TABLE " + textTable + " COMPUTE STATISTICS"));
                Option fetchedStats1 = this.checkTableStats(textTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
                this.sql().apply((Object)("ANALYZE TABLE " + textTable + " COMPUTE STATISTICS noscan"));
                Option fetchedStats2 = this.checkTableStats(textTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
                Option $org_scalatest_assert_macro_left = fetchedStats1;
                Option $org_scalatest_assert_macro_right = fetchedStats2;
                Option option = $org_scalatest_assert_macro_left;
                Option option2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
        this.test("keep existing column stats if table is not changed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "update_col_stats_table";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + table + " (c1 INT, c2 STRING, c3 DOUBLE)"));
                this.sql().apply((Object)("ANALYZE TABLE " + table + " COMPUTE STATISTICS FOR COLUMNS c1"));
                Option fetchedStats0 = this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                Map $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats0.get()).colStats();
                Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                Map map = $org_scalatest_assert_macro_left;
                Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
                this.sql().apply((Object)("INSERT INTO TABLE " + table + " SELECT 1, 'a', 10.0"));
                this.sql().apply((Object)("ANALYZE TABLE " + table + " COMPUTE STATISTICS FOR COLUMNS c1"));
                CatalogStatistics fetchedStats1 = (CatalogStatistics)this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))).get();
                Map $org_scalatest_assert_macro_left2 = fetchedStats1.colStats();
                Map $org_scalatest_assert_macro_right2 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                Map map3 = $org_scalatest_assert_macro_left2;
                Map map4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 787));
                this.sql().apply((Object)("ANALYZE TABLE " + table + " COMPUTE STATISTICS FOR COLUMNS c2"));
                CatalogStatistics fetchedStats2 = (CatalogStatistics)this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))).get();
                Map $org_scalatest_assert_macro_left3 = fetchedStats2.colStats();
                Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                Map map5 = $org_scalatest_assert_macro_left3;
                Map map6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
                this.sql().apply((Object)("INSERT INTO TABLE " + table + " SELECT 2, 'b', 20.0"));
                this.sql().apply((Object)("ANALYZE TABLE " + table + " COMPUTE STATISTICS FOR COLUMNS c1, c3"));
                CatalogStatistics fetchedStats3 = (CatalogStatistics)this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2))).get();
                Map $org_scalatest_assert_macro_left4 = fetchedStats3.colStats();
                Map $org_scalatest_assert_macro_right4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)"1"), (Option)new Some((Object)"2"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c3"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)"10.0"), (Option)new Some((Object)"20.0"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                Map map7 = $org_scalatest_assert_macro_left4;
                Map map8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
        this.test("collecting statistics for all columns", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "update_col_stats_table";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + table + " (c1 INT, c2 STRING, c3 DOUBLE)"));
                this.sql().apply((Object)("ANALYZE TABLE " + table + " COMPUTE STATISTICS FOR ALL COLUMNS"));
                Option fetchedStats0 = this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                Map $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats0.get()).colStats();
                Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c3"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)20L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)20L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                Map map = $org_scalatest_assert_macro_left;
                Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 822));
                this.sql().apply((Object)("INSERT INTO TABLE " + table + " SELECT 1, 'a', 10.0"));
                this.sql().apply((Object)("INSERT INTO TABLE " + table + " SELECT 1, 'b', null"));
                this.sql().apply((Object)("ANALYZE TABLE " + table + " COMPUTE STATISTICS FOR ALL COLUMNS"));
                Option fetchedStats1 = this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetchedStats1.get()).colStats();
                Map $org_scalatest_assert_macro_right2 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c3"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"10.0"), (Option)new Some((Object)"10.0"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                Map map3 = $org_scalatest_assert_macro_left2;
                Map map4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
        this.test("analyze column command parameters validation", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IllegalArgumentException e1 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> new AnalyzeColumnCommand(TableIdentifier$.MODULE$.apply("test"), Option$.MODULE$.apply((Object)new .colon.colon((Object)"c1", (List)Nil$.MODULE$)), true).run((SparkSession)this.spark()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "Parameter `columnNames` or `allColumns` are mutually exclusive";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
            IllegalArgumentException e2 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> new AnalyzeColumnCommand(TableIdentifier$.MODULE$.apply("test"), (Option)None$.MODULE$, false).run((SparkSession)this.spark()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Parameter `columnNames` or `allColumns` are mutually exclusive";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 856));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
        this.test("get statistics when not analyzed in Hive or Spark", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Bool bool;
                String x$25 = tabName;
                boolean x$26 = false;
                boolean x$27 = false;
                this.createNonPartitionedTable(x$25, false, false);
                this.checkTableStats(tabName, true, (Option)None$.MODULE$);
                Seq describeResult = this.hiveClient().runSqlHive("DESCRIBE FORMATTED " + tabName);
                Option<BigInt> rawDataSize = this.extractStatsPropValues((Seq<String>)describeResult, "rawDataSize");
                Option<BigInt> numRows = this.extractStatsPropValues((Seq<String>)describeResult, "numRows");
                Option<BigInt> totalSize = this.extractStatsPropValues((Seq<String>)describeResult, "totalSize");
                Option<BigInt> $org_scalatest_assert_macro_left = rawDataSize;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"rawDataSize should not be shown without table analysis", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 921));
                Option<BigInt> $org_scalatest_assert_macro_left2 = numRows;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"numRows should not be shown without table analysis", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 922));
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.simpleMacroBool(totalSize.isDefined(), "totalSize.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    BigInt $org_scalatest_assert_macro_left4 = (BigInt)totalSize.get();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"totalSize is lost", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
        this.test("alter table should not have the side effect to store statistics in Spark side", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "alter_table_side_effect";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                BigInt hiveSize2;
                this.sql().apply((Object)("CREATE TABLE " + table + " (i string, j string) USING hive"));
                this.sql().apply((Object)("INSERT INTO TABLE " + table + " SELECT 'a', 'b'"));
                CatalogTable catalogTable1 = this.getCatalogTable(table);
                BigInt hiveSize1 = scala.package$.MODULE$.BigInt().apply((String)catalogTable1.ignoredProperties().apply((Object)"totalSize"));
                this.sql().apply((Object)("ALTER TABLE " + table + " SET TBLPROPERTIES ('prop1' = 'a')"));
                this.sql().apply((Object)("INSERT INTO TABLE " + table + " SELECT 'c', 'd'"));
                CatalogTable catalogTable2 = this.getCatalogTable(table);
                BigInt $org_scalatest_assert_macro_left = hiveSize2 = scala.package$.MODULE$.BigInt().apply((String)catalogTable2.ignoredProperties().apply((Object)"totalSize"));
                BigInt $org_scalatest_assert_macro_right = hiveSize1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 941));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)catalogTable2.stats().get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right2 = hiveSize2;
                BigInt bigInt = $org_scalatest_assert_macro_left2;
                BigInt bigInt2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 927));
        this.test("alter table SET TBLPROPERTIES after analyze table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAlterTableProperties("set_prop_table", "ALTER TABLE set_prop_table SET TBLPROPERTIES ('foo' = 'a')"), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 970));
        this.test("alter table UNSET TBLPROPERTIES after analyze table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAlterTableProperties("unset_prop_table", "ALTER TABLE unset_prop_table UNSET TBLPROPERTIES ('prop1')"), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
        this.test("change stats after insert command for hive table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "change_stats_insert_hive_table";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)("CREATE TABLE " + table$6 + " (i int, j string)"));
                    $this.sql().apply((Object)("ANALYZE TABLE " + table$6 + " COMPUTE STATISTICS FOR COLUMNS i, j"));
                    Option fetched1 = $this.checkTableStats(table$6, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 998));
                    Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 999));
                    $this.sql().apply((Object)("INSERT INTO TABLE " + table$6 + " SELECT 1, 'abc'"));
                    if (autoUpdate) {
                        Option fetched2 = $this.checkTableStats(table$6, true, (Option)None$.MODULE$);
                        BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.int2bigInt(0);
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1005));
                        Map $org_scalatest_assert_macro_left4 = ((CatalogStatistics)fetched2.get()).colStats();
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1006));
                        Map<String, String> statsProp = $this.getStatsProperties(table$6);
                        long $org_scalatest_assert_macro_left5 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)statsProp.apply((Object)HiveExternalCatalog$.MODULE$.STATISTICS_TOTAL_SIZE())));
                        BigInt $org_scalatest_assert_macro_right4 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)$org_scalatest_assert_macro_right4, BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), (Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1008));
                        return;
                    }
                    Map<String, String> $org_scalatest_assert_macro_left6 = $this.getStatsProperties(table$6);
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 989));
        this.test("change stats after load data command", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "change_stats_load_table";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)("CREATE TABLE " + table$7 + " (i INT, j STRING) STORED AS PARQUET"));
                    $this.sql().apply((Object)("ANALYZE TABLE " + table$7 + " COMPUTE STATISTICS FOR COLUMNS i, j"));
                    Option fetched1 = $this.checkTableStats(table$7, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1026));
                    Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1027));
                    $this.withTempDir((Function1 & Serializable)loadPath -> {
                        StatisticsSuite.$anonfun$new$100($this, table$7, autoUpdate, loadPath);
                        return BoxedUnit.UNIT;
                    });
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1017));
        this.test("change stats after add/drop partition command", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "change_stats_part_table";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)("CREATE TABLE " + table$8 + " (i INT, j STRING) USING hive PARTITIONED BY (ds STRING, hr STRING)"));
                    new .colon.colon((Object)"2008-04-08", (List)Nil$.MODULE$).foreach((Function1 & Serializable)ds -> {
                        StatisticsSuite.$anonfun$new$107($this, table$8, ds);
                        return BoxedUnit.UNIT;
                    });
                    $this.sql().apply((Object)("ANALYZE TABLE " + table$8 + " COMPUTE STATISTICS FOR COLUMNS i, j"));
                    Option fetched1 = $this.checkTableStats(table$8, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1065));
                    Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
                    $this.withTempPaths(2, (Function1 & Serializable)x0$1 -> {
                        StatisticsSuite.$anonfun$new$109($this, table$8, autoUpdate, fetched1, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1051));
        this.test("add/drop partitions - managed table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            String managedTable = "partitionedTable";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{managedTable}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + managedTable + " (key INT, value STRING)\n           |USING hive\n           |PARTITIONED BY (ds STRING, hr STRING)\n         ")));
                new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ds -> {
                    StatisticsSuite.$anonfun$new$117(this, managedTable, ds);
                    return BoxedUnit.UNIT;
                });
                this.checkTableStats(managedTable, false, (Option)None$.MODULE$);
                this.sql().apply((Object)("ANALYZE TABLE " + managedTable + " COMPUTE STATISTICS"));
                Option stats1 = this.checkTableStats(managedTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |ALTER TABLE " + managedTable + " DROP PARTITION (ds='2008-04-08'),\n           |PARTITION (hr='12')\n        ")));
                Set $org_scalatest_assert_macro_left = ((IterableOnceOps)catalog.listPartitions(TableIdentifier$.MODULE$.apply(managedTable), catalog.listPartitions$default$2()).map((Function1 & Serializable)x$5 -> x$5.spec())).toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")}))}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1175));
                this.sql().apply((Object)("ANALYZE TABLE " + managedTable + " COMPUTE STATISTICS"));
                Option stats2 = this.checkTableStats(managedTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)stats1.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)stats2.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1182));
                this.sql().apply((Object)("ALTER TABLE " + managedTable + " ADD PARTITION (ds='2008-04-08', hr='12')"));
                this.sql().apply((Object)("ANALYZE TABLE " + managedTable + " COMPUTE STATISTICS"));
                Option stats4 = this.checkTableStats(managedTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)stats1.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right3 = ((CatalogStatistics)stats4.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1189));
                BigInt $org_scalatest_assert_macro_left4 = ((CatalogStatistics)stats4.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right4 = ((CatalogStatistics)stats2.get()).sizeInBytes();
                BigInt bigInt = $org_scalatest_assert_macro_left4;
                BigInt bigInt2 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1190));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1142));
        this.test("test statistics of LogicalRelation converted from Hive serde tables", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"orc", (List)new .colon.colon((Object)"parquet", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)format -> {
            StatisticsSuite.$anonfun$new$121(this, format);
            return BoxedUnit.UNIT;
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1194));
        this.test("verify serialized column stats after analyzing columns", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "column_stats_test_ser";
            LinkedHashMap $org_scalatest_assert_macro_left = this.stats();
            int $org_scalatest_assert_macro_right = ((Product14)this.data().head()).productArity() - 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1218));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_StatisticsSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple14"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Boolean").asType().toTypeConstructor(), $m.staticClass("java.lang.Byte").asType().toTypeConstructor(), $m.staticClass("java.lang.Short").asType().toTypeConstructor(), $m.staticClass("java.lang.Integer").asType().toTypeConstructor(), $m.staticClass("java.lang.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("java.lang.Float").asType().toTypeConstructor(), $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), $m.staticClass("java.sql.Date").asType().toTypeConstructor(), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), $m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))})));
                }

                public Org_apache_spark_sql_hive_StatisticsSuite$$typecreator10$1(StatisticsSuite $outer) {
                }
            }
            org.apache.spark.sql.classic.Dataset df = this.testImplicits().localSeqToDatasetHolder(this.data(), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_StatisticsSuite$$typecreator10$1(null)))).toDF((Seq)this.stats().keys().toSeq().$colon$plus((Object)"carray"));
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                df.write().saveAsTable(tableName);
                this.checkColStatsProps$1(this.expectedSerializedColStats(), tableName);
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"2")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkColStatsProps$1((Map)this.expectedSerializedColStats().$plus$plus((IterableOnce)this.expectedSerializedHistograms()), tableName));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1213));
        this.test("verify column stats can be deserialized from tblproperties", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "column_stats_test_de";
            LinkedHashMap $org_scalatest_assert_macro_left = this.stats();
            int $org_scalatest_assert_macro_right = ((Product14)this.data().head()).productArity() - 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1248));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_StatisticsSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple14"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Boolean").asType().toTypeConstructor(), $m.staticClass("java.lang.Byte").asType().toTypeConstructor(), $m.staticClass("java.lang.Short").asType().toTypeConstructor(), $m.staticClass("java.lang.Integer").asType().toTypeConstructor(), $m.staticClass("java.lang.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("java.lang.Float").asType().toTypeConstructor(), $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), $m.staticClass("java.sql.Date").asType().toTypeConstructor(), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), $m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))})));
                }

                public Org_apache_spark_sql_hive_StatisticsSuite$$typecreator20$1(StatisticsSuite $outer) {
                }
            }
            org.apache.spark.sql.classic.Dataset df = this.testImplicits().localSeqToDatasetHolder(this.data(), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_StatisticsSuite$$typecreator20$1(null)))).toDF((Seq)this.stats().keys().toSeq().$colon$plus((Object)"carray")).drop("ctimestamp_ntz");
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                df.write().saveAsTable(tableName);
                CatalogTable table = this.getCatalogTable(tableName);
                Map x$28 = (Map)((scala.collection.immutable.MapOps)((MapOps)table.properties().$plus$plus((IterableOnce)this.expectedSerializedColStats())).$plus$plus((IterableOnce)this.expectedSerializedHistograms())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.statistics.totalSize"), (Object)"1"));
                TableIdentifier x$29 = table.copy$default$1();
                CatalogTableType x$30 = table.copy$default$2();
                CatalogStorageFormat x$31 = table.copy$default$3();
                StructType x$32 = table.copy$default$4();
                Option x$33 = table.copy$default$5();
                Seq x$34 = table.copy$default$6();
                Option x$35 = table.copy$default$7();
                String x$36 = table.copy$default$8();
                long x$37 = table.copy$default$9();
                long x$38 = table.copy$default$10();
                String x$39 = table.copy$default$11();
                Option x$40 = table.copy$default$13();
                Option x$41 = table.copy$default$14();
                Option x$42 = table.copy$default$15();
                Option x$43 = table.copy$default$16();
                Seq x$44 = table.copy$default$17();
                boolean x$45 = table.copy$default$18();
                boolean x$46 = table.copy$default$19();
                Map x$47 = table.copy$default$20();
                Option x$48 = table.copy$default$21();
                CatalogTable newTable = table.copy(x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$28, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48);
                this.hiveClient().alterTable(newTable);
                this.validateColStats(tableName, this.statsWithHgms());
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1243));
        this.test("serialization and deserialization of histograms to/from hive metastore", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long startTimestamp = DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf("2016-05-08 00:00:01"));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_StatisticsSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_StatisticsSuite$$typecreator30$1(StatisticsSuite $outer) {
                }
            }
            org.apache.spark.sql.classic.Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5000).map((Function1 & Serializable)i -> StatisticsSuite.$anonfun$new$133(startTimestamp, BoxesRunTime.unboxToInt((Object)i))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_StatisticsSuite$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cint", "ctimestamp"}));
            String tableName = "histogram_serde_test";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                df.write().saveAsTable(tableName);
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Map tsHistogramProps;
                    Map intHistogramProps;
                    this.sql().apply((Object)("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS FOR COLUMNS cint, ctimestamp"));
                    CatalogTable table = this.hiveClient().getTable("default", tableName);
                    Map $org_scalatest_assert_macro_left = intHistogramProps = (Map)table.properties().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StatisticsSuite.$anonfun$new$136(x0$2)));
                    int $org_scalatest_assert_macro_right = 1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1295));
                    Map $org_scalatest_assert_macro_left2 = tsHistogramProps = (Map)table.properties().filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)StatisticsSuite.$anonfun$new$137(x0$3)));
                    int $org_scalatest_assert_macro_right2 = 1;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1299));
                    Map cs = this.getTableStats(tableName).colStats();
                    Histogram intHistogram = (Histogram)((CatalogColumnStat)cs.apply((Object)"cint")).histogram().get();
                    Histogram tsHistogram = (Histogram)((CatalogColumnStat)cs.apply((Object)"ctimestamp")).histogram().get();
                    HistogramBin[] $org_scalatest_assert_macro_left3 = intHistogram.bins();
                    int $org_scalatest_assert_macro_right3 = this.spark().sessionState().conf().histogramNumBins();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1305));
                    StatisticsSuite.checkBinsOrder$1(intHistogram.bins());
                    HistogramBin[] $org_scalatest_assert_macro_left4 = tsHistogram.bins();
                    int $org_scalatest_assert_macro_right4 = this.spark().sessionState().conf().histogramNumBins();
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1307));
                    StatisticsSuite.checkBinsOrder$1(tsHistogram.bins());
                });
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1267));
        this.testUpdatingTableStats("data source table created in HiveExternalCatalog", "CREATE TABLE parquetTable (key STRING, value STRING) USING PARQUET");
        this.testUpdatingTableStats("partitioned data source table", "CREATE TABLE parquetTable (key STRING, value STRING) USING PARQUET PARTITIONED BY (key)");
        this.test("test refreshing table stats of cached data source table by `ANALYZE TABLE` statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Tuple2<CatalogStatistics, CatalogStatistics> tuple2 = this.getStatsBeforeAfterUpdate(false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            CatalogStatistics statsBeforeUpdate = (CatalogStatistics)tuple2._1();
            CatalogStatistics statsAfterUpdate = (CatalogStatistics)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statsBeforeUpdate, (Object)statsAfterUpdate);
            CatalogStatistics statsBeforeUpdate2 = (CatalogStatistics)tuple22._1();
            CatalogStatistics statsAfterUpdate2 = (CatalogStatistics)tuple22._2();
            BigInt $org_scalatest_assert_macro_left = statsBeforeUpdate2.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1390));
            Option $org_scalatest_assert_macro_left2 = statsBeforeUpdate2.rowCount();
            Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option option = $org_scalatest_assert_macro_left2;
            Some some = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1391));
            BigInt $org_scalatest_assert_macro_left3 = statsAfterUpdate2.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right3 = statsBeforeUpdate2.sizeInBytes();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1393));
            Option $org_scalatest_assert_macro_left4 = statsAfterUpdate2.rowCount();
            Some $org_scalatest_assert_macro_right4 = new Some((Object)BoxesRunTime.boxToInteger((int)2));
            Option option2 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1394));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1387));
        this.test("estimates the size of a test Hive serde tables", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            org.apache.spark.sql.classic.Dataset df = (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM src");
            Seq sizes = df.queryExecution().analyzed().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof HiveTableRelation) {
                        HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                        return (B1)hiveTableRelation.stats().sizeInBytes();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    return logicalPlan instanceof HiveTableRelation;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Size wrong for:\n " + df.queryExecution()), Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((BigInt)sizes.apply(0)).equals(scala.package$.MODULE$.BigInt().apply(5812)), "sizes.apply(0).equals(scala.`package`.BigInt.apply(5812))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)("expected exact size 5812 for test table 'src', got: " + sizes.apply(0)), Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1397));
        this.test("auto converts to broadcast hash join, by size estimate of a relation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String metastoreQuery = "SELECT * FROM src a JOIN src b ON a.key = 238 AND a.key = b.key";
            Seq metastoreAnswer = (Seq)scala.package$.MODULE$.Seq().fill(4, (Function0 & Serializable)() -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)238), "val_238", BoxesRunTime.boxToInteger((int)238), "val_238"})));
            this.mkTest$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, metastoreQuery, metastoreAnswer, (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(HiveTableRelation.class)));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1407));
        this.test("auto converts to broadcast left semi join, by size estimate of a relation", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool bool;
            Bool bool2;
            int $org_scalatest_assert_macro_right;
            String leftSemiJoinQuery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT * FROM src a\n        |left semi JOIN src b ON a.key=86 and a.key = b.key"));
            Row answer = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)86), "val_86"}));
            ObjectRef df = ObjectRef.create((Object)((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)leftSemiJoinQuery)));
            Seq sizes = ((org.apache.spark.sql.classic.Dataset)df.elem).queryExecution().analyzed().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof HiveTableRelation) {
                        HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                        return (B1)hiveTableRelation.stats().sizeInBytes();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(LogicalPlan x2) {
                    LogicalPlan logicalPlan = x2;
                    return logicalPlan instanceof HiveTableRelation;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)($org_scalatest_assert_macro_right = 2)), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                BigInt $org_scalatest_assert_macro_left3 = (BigInt)sizes.apply(1);
                BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "<=", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$less$eq((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                BigInt $org_scalatest_assert_macro_left5 = (BigInt)sizes.apply(0);
                BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "<=", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$less$eq((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"query should contain two relations, each of which has size smaller than autoConvertSize", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1470));
            ObjectRef bhj = ObjectRef.create((Object)((org.apache.spark.sql.classic.Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof BroadcastHashJoinExec) {
                        BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                        return (B1)broadcastHashJoinExec;
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(SparkPlan x3) {
                    SparkPlan sparkPlan = x3;
                    return sparkPlan instanceof BroadcastHashJoinExec;
                }
            }));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Seq)bhj.elem).size()));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)("actual query plans do not contain broadcast join: " + ((org.apache.spark.sql.classic.Dataset)df.elem).queryExecution()), Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)df$5.elem, answer);
            return (Assertion)this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"-1")}), (Function0 & Serializable)() -> {
                df$5.elem = (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)leftSemiJoinQuery);
                bhj$2.elem = ((org.apache.spark.sql.classic.Dataset)df$5.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        A1 A1 = x4;
                        if (A1 instanceof BroadcastHashJoinExec) {
                            BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                            return (B1)broadcastHashJoinExec;
                        }
                        return (B1)function1.apply(x4);
                    }

                    public final boolean isDefinedAt(SparkPlan x4) {
                        SparkPlan sparkPlan = x4;
                        return sparkPlan instanceof BroadcastHashJoinExec;
                    }
                });
                Seq $org_scalatest_assert_macro_left = (Seq)bhj$2.elem;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"BroadcastHashJoin still planned even though it is switched off", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1489));
                Seq shj = ((org.apache.spark.sql.classic.Dataset)df$5.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        A1 A1 = x5;
                        if (A1 instanceof SortMergeJoinExec) {
                            SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)A1;
                            return (B1)sortMergeJoinExec;
                        }
                        return (B1)function1.apply(x5);
                    }

                    public final boolean isDefinedAt(SparkPlan x5) {
                        SparkPlan sparkPlan = x5;
                        return sparkPlan instanceof SortMergeJoinExec;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shj.size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"SortMergeJoinExec should be planned when BroadcastHashJoin is turned off", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1494));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1458));
        this.test("Deals with wrong Hive's statistics (zero rowCount)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"maybe_big"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE maybe_big (c1 bigint)TBLPROPERTIES ('numRows'='0', 'rawDataSize'='60000000000', 'totalSize'='8000000000000')");
            CatalogTable catalogTable = this.getCatalogTable("maybe_big");
            Map properties = catalogTable.ignoredProperties();
            long $org_scalatest_assert_macro_left = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)properties.apply((Object)"totalSize")));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1507));
            long $org_scalatest_assert_macro_left2 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)properties.apply((Object)"rawDataSize")));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1508));
            long $org_scalatest_assert_macro_left3 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)properties.apply((Object)"numRows")));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1509));
            CatalogStatistics catalogStats = (CatalogStatistics)catalogTable.stats().get();
            BigInt $org_scalatest_assert_macro_left4 = catalogStats.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1512));
            Option $org_scalatest_assert_macro_left5 = catalogStats.rowCount();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1513));
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1499));
        this.test("CTAS should update statistics if " + SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key() + " is enabled", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "SPARK_23263";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)isConverted -> {
                StatisticsSuite.$anonfun$new$156(this, tableName, BoxesRunTime.unboxToBoolean((Object)isConverted));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1517));
        this.test("SPARK-28518 fix getDataSize refer to ChecksumFileSystem#isChecksumFile", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)tempDir -> {
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.spark().range(5L).write().mode(SaveMode.Overwrite).parquet(tempDir.getCanonicalPath());
                Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(new File(tempDir + "/temp.crc")), (Function1 & Serializable)writer -> {
                    writer.write("1,2");
                    return BoxedUnit.UNIT;
                });
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE EXTERNAL TABLE t1(id BIGINT)\n             |STORED AS parquet\n             |LOCATION '" + tempDir.getCanonicalPath() + "'\n             |TBLPROPERTIES (\n             |'rawDataSize'='-1', 'numFiles'='0', 'totalSize'='0',\n             |'COLUMN_STATS_ACCURATE'='false', 'numRows'='-1'\n             |)")));
                $this.spark().sql("REFRESH TABLE t1");
                LogicalPlan relation1 = (LogicalPlan)$this.spark().table("t1").queryExecution().analyzed().children().head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(relation1.stats().sizeInBytes());
                long $org_scalatest_assert_macro_right = $this.getDataSize(tempDir);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1560));
                $this.spark().sql("REFRESH TABLE t1");
                $this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key()), (Object)"true")}), (Function0 & Serializable)() -> {
                    LogicalPlan relation2 = (LogicalPlan)$this.spark().table("t1").queryExecution().analyzed().children().head();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(relation2.stats().sizeInBytes());
                    long $org_scalatest_assert_macro_right = $this.getDataSize(tempDir);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1565));
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1539));
        this.test("fallBackToHdfs should not support Hive partitioned table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)fallBackToHdfs -> {
            this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fallBackToHdfs)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)dir -> {
                StatisticsSuite.$anonfun$new$169($this, dir);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1571));
        this.test("SPARK-30269 failed to update partition stats if it's equal to table's old stats", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tbl = "SPARK_30269";
            String ext_tbl = "SPARK_30269_external";
            this.withTempDir((Function1 & Serializable)dir -> {
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tbl, ext_tbl}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)("CREATE TABLE " + tbl$2 + " (key INT, value STRING, ds STRING)USING parquet PARTITIONED BY (ds)"));
                    $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               | CREATE TABLE " + ext_tbl$1 + " (key INT, value STRING, ds STRING)\n               | USING PARQUET\n               | PARTITIONED BY (ds)\n               | LOCATION '" + dir.toURI() + "'\n           ")));
                    new .colon.colon((Object)tbl$2, (List)new .colon.colon((Object)ext_tbl$1, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)tblName -> {
                        $this.sql().apply((Object)("INSERT INTO " + tblName + " VALUES (1, 'a', '2019-12-13')"));
                        Option $org_scalatest_assert_macro_left = $this.getCatalogTable((String)tblName).stats();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1619));
                        $this.sql().apply((Object)("ANALYZE TABLE " + tblName + " COMPUTE STATISTICS NOSCAN"));
                        CatalogStatistics tableStats = $this.getTableStats((String)tblName);
                        BigInt expectedSize = tableStats.sizeInBytes();
                        Option $org_scalatest_assert_macro_left2 = tableStats.rowCount();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1625));
                        $this.sql().apply((Object)("ANALYZE TABLE " + tblName + " COMPUTE STATISTICS"));
                        tableStats = $this.getTableStats((String)tblName);
                        BigInt $org_scalatest_assert_macro_left3 = tableStats.sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right = expectedSize;
                        BigInt bigInt = $org_scalatest_assert_macro_left3;
                        BigInt bigInt2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1629));
                        BigInt $org_scalatest_assert_macro_left4 = (BigInt)tableStats.rowCount().get();
                        int $org_scalatest_assert_macro_right2 = 1;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1630));
                        $this.sql().apply((Object)("ANALYZE TABLE " + tblName + " PARTITION (ds='2019-12-13') COMPUTE STATISTICS NOSCAN"));
                        CatalogStatistics partStats = $this.getPartitionStats((String)tblName, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2019-12-13")})));
                        BigInt $org_scalatest_assert_macro_left5 = partStats.sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right3 = expectedSize;
                        BigInt bigInt3 = $org_scalatest_assert_macro_left5;
                        BigInt bigInt4 = $org_scalatest_assert_macro_right3;
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(bigInt3 != null ? !bigInt3.equals(bigInt4) : bigInt4 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1635));
                        Option $org_scalatest_assert_macro_left6 = partStats.rowCount();
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1636));
                        $this.sql().apply((Object)("ANALYZE TABLE " + tblName + " PARTITION (ds='2019-12-13') COMPUTE STATISTICS"));
                        partStats = $this.getPartitionStats((String)tblName, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2019-12-13")})));
                        BigInt $org_scalatest_assert_macro_left7 = partStats.sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right4 = expectedSize;
                        BigInt bigInt5 = $org_scalatest_assert_macro_left7;
                        BigInt bigInt6 = $org_scalatest_assert_macro_right4;
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(bigInt5 != null ? !bigInt5.equals(bigInt6) : bigInt6 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1640));
                        BigInt $org_scalatest_assert_macro_left8 = (BigInt)partStats.rowCount().get();
                        int $org_scalatest_assert_macro_right5 = 1;
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left8, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1641));
                    });
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1601));
        this.test("SPARK-38573: partition stats auto update for dynamic partitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "partition_stats_dynamic_partition";
            new .colon.colon((Object)"hive", (List)new .colon.colon((Object)"parquet", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)source -> {
                this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)("CREATE TABLE " + table$9 + " (id INT, sp INT, dp INT) USING " + source + " PARTITIONED BY (sp, dp)"));
                    $this.sql().apply((Object)("INSERT INTO " + table$9 + " PARTITION (sp=0, dp) VALUES (0, 0)"));
                    $this.sql().apply((Object)("INSERT OVERWRITE TABLE " + table$9 + " PARTITION (sp=0, dp) SELECT id, id FROM range(5)"));
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> StatisticsSuite.$anonfun$new$180($this, table$9, BoxesRunTime.unboxToInt((Object)i)));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1648));
        this.test("SPARK-38573: change partition stats after load/set/truncate data command", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "partition_stats_load_set_truncate";
            this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + table + " (i INT, j STRING) USING hive PARTITIONED BY (ds STRING, hr STRING)"));
                this.withTempPaths(2, (Function1 & Serializable)x0$4 -> {
                    StatisticsSuite.$anonfun$new$184(this, table, x0$4);
                    return BoxedUnit.UNIT;
                });
            }));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1665));
        this.test("Don't support MapType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "analyzeTable_column";
            this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tableName + " (key STRING, value MAP<STRING, STRING>) PARTITIONED BY (ds STRING)"));
                AnalysisException x$49 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS FOR COLUMNS value")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1721));
                String x$50 = "UNSUPPORTED_FEATURE.ANALYZE_UNSUPPORTED_COLUMN_TYPE";
                Map x$51 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnType"), (Object)"\"MAP<STRING, STRING>\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`value`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`analyzetable_column`")}));
                Option x$52 = this.checkError$default$3();
                boolean x$53 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$54 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$49, "UNSUPPORTED_FEATURE.ANALYZE_UNSUPPORTED_COLUMN_TYPE", x$52, x$51, x$53, x$54);
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1715));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$new$41$adapted(StatisticsSuite $this, String tableName$4, List partitionDates$1, int expectedRowCount$1, Object partitionStatsEnabled) {
        $this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.UPDATE_PART_STATS_IN_ANALYZE_TABLE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)partitionStatsEnabled)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName$4}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1 & Serializable)path -> {
            StatisticsSuite.$anonfun$new$44($this, tableName$4, partitionDates$1, partitionStatsEnabled, expectedRowCount$1, path);
            return BoxedUnit.UNIT;
        })));
        return BoxedUnit.UNIT;
    }
}

