/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveVersionSuite;
import org.apache.spark.sql.hive.client.IsolatedClientLoader$;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.hive.test.TestHiveVersion;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001B\u000b\u0017\u0001\rB\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006m\u0001!\ta\u000e\u0005\bu\u0001\u0001\r\u0011\"\u0003<\u0011\u001d\u0011\u0005\u00011A\u0005\n\rCaA\u0013\u0001!B\u0013a\u0004bB&\u0001\u0005\u0004%I\u0001\u0014\u0005\u0007)\u0002\u0001\u000b\u0011B'\t\u000fU\u0003!\u0019!C\u0005-\"1a\f\u0001Q\u0001\n]CQa\u0018\u0001\u0005\u0012\u0001DQ\u0001\u001c\u0001\u0005\u00025D\u0011\"!\u0003\u0001#\u0003%\t!a\u0003\t\u0013\u0005\u0005\u0002!%A\u0005\u0002\u0005\r\u0002\"CA\u0014\u0001\t\u0007I\u0011BA\u0015\u0011!\t9\u0004\u0001Q\u0001\n\u0005-\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005u\u0002\"CA#\u0001\t\u0007I\u0011AA$\u0011!\ty\u0005\u0001Q\u0001\n\u0005%\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0002\u0010\u0011&4Xm\u00117jK:$8+^5uK*\u0011q\u0003G\u0001\u0007G2LWM\u001c;\u000b\u0005eQ\u0012\u0001\u00025jm\u0016T!a\u0007\u000f\u0002\u0007M\fHN\u0003\u0002\u001e=\u0005)1\u000f]1sW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u00152S\"\u0001\f\n\u0005\u001d2\"\u0001\u0005%jm\u00164VM]:j_:\u001cV/\u001b;f\u0003\u001d1XM]:j_:\u0004\"AK\u001a\u000f\u0005-\n\u0004C\u0001\u00170\u001b\u0005i#B\u0001\u0018#\u0003\u0019a$o\\8u})\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u0011t&\u0001\u0004=S:LGO\u0010\u000b\u0003qe\u0002\"!\n\u0001\t\u000b!\u0012\u0001\u0019A\u0015\u0002\u0019Y,'o]5p]N\u0003\u0018M]6\u0016\u0003q\u0002\"!\u0010!\u000e\u0003yR!a\u0010\r\u0002\tQ,7\u000f^\u0005\u0003\u0003z\u0012q\u0002V3ti\"Kg/\u001a,feNLwN\\\u0001\u0011m\u0016\u00148/[8o'B\f'o[0%KF$\"\u0001\u0012%\u0011\u0005\u00153U\"A\u0018\n\u0005\u001d{#\u0001B+oSRDq!\u0013\u0003\u0002\u0002\u0003\u0007A(A\u0002yIE\nQB^3sg&|gn\u00159be.\u0004\u0013\u0001C3naRLH)\u001b:\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\t1\fgn\u001a\u0006\u0002%\u0006!!.\u0019<b\u0013\t!t*A\u0005f[B$\u0018\u0010R5sA\u0005\u0019a/\u001a:\u0016\u0003]\u0003\"\u0001W.\u000f\u0005\u0015J\u0016B\u0001.\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0017!Kg/\u001a,feNLwN\u001c\u0006\u00035Z\tAA^3sA\u0005Iq/\u001b;i)\u0006\u0014G.\u001a\u000b\u0003C\u001e$\"\u0001\u00122\t\r\rTA\u00111\u0001e\u0003\u00051\u0007cA#f\t&\u0011am\f\u0002\ty\tLh.Y7f}!)\u0001N\u0003a\u0001S\u0006QA/\u00192mK:\u000bW.Z:\u0011\u0007\u0015S\u0017&\u0003\u0002l_\tQAH]3qK\u0006$X\r\u001a \u0002\u000bQ\f'\r\\3\u0015\u000b94\bP_@\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018aB2bi\u0006dwn\u001a\u0006\u0003gj\t\u0001bY1uC2L8\u000f^\u0005\u0003kB\u0014AbQ1uC2|w\rV1cY\u0016DQa^\u0006A\u0002%\n\u0001\u0002Z1uC\n\f7/\u001a\u0005\u0006s.\u0001\r!K\u0001\ni\u0006\u0014G.\u001a(b[\u0016Dqa_\u0006\u0011\u0002\u0003\u0007A0A\u0005d_2d\u0017\r^5p]B\u0019Q)`\u0015\n\u0005y|#AB(qi&|g\u000eC\u0005\u0002\u0002-\u0001\n\u00111\u0001\u0002\u0004\u0005IA/\u00192mKRK\b/\u001a\t\u0004_\u0006\u0015\u0011bAA\u0004a\n\u00012)\u0019;bY><G+\u00192mKRK\b/Z\u0001\u0010i\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0002\u0016\u0004y\u0006=1FAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mq&\u0001\u0006b]:|G/\u0019;j_:LA!a\b\u0002\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001fQ\f'\r\\3%I\u00164\u0017-\u001e7uIQ*\"!!\n+\t\u0005\r\u0011qB\u0001\u0011i\u0016l\u0007\u000fR1uC\n\f7/\u001a)bi\",\"!a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\rR\u0003\rqW\r^\u0005\u0005\u0003k\tyCA\u0002V%&\u000b\u0011\u0003^3na\u0012\u000bG/\u00192bg\u0016\u0004\u0016\r\u001e5!\u00035\u0019Ho\u001c:bO\u00164uN]7biV\u0011\u0011Q\b\t\u0004_\u0006}\u0012bAA!a\n!2)\u0019;bY><7\u000b^8sC\u001e,gi\u001c:nCR\fab\u001d;pe\u0006<WMR8s[\u0006$\b%\u0001\nuKN$\b+\u0019:uSRLwN\\\"pk:$XCAA%!\r)\u00151J\u0005\u0004\u0003\u001bz#aA%oi\u0006\u0019B/Z:u!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uA\u0005Aa-\u001e8di&|g\u000e\u0006\u0004\u0002V\u0005m\u0013q\f\t\u0004_\u0006]\u0013bAA-a\ny1)\u0019;bY><g)\u001e8di&|g\u000e\u0003\u0004\u0002^Q\u0001\r!K\u0001\u0005]\u0006lW\r\u0003\u0004\u0002bQ\u0001\r!K\u0001\nG2\f7o\u001d(b[\u0016\u0004")
public class HiveClientSuite
extends HiveVersionSuite {
    private final String version;
    private TestHiveVersion versionSpark;
    private final String emptyDir;
    private final package.HiveVersion ver;
    private final URI tempDatabasePath;
    private final CatalogStorageFormat storageFormat;
    private final int testPartitionCount;

    private TestHiveVersion versionSpark() {
        return this.versionSpark;
    }

    private void versionSpark_$eq(TestHiveVersion x$1) {
        this.versionSpark = x$1;
    }

    private String emptyDir() {
        return this.emptyDir;
    }

    private package.HiveVersion ver() {
        return this.ver;
    }

    public void withTable(scala.collection.immutable.Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable)name -> this.versionSpark().sql("DROP TABLE IF EXISTS " + name));
        }
    }

    public CatalogTable table(String database, String tableName, Option<String> collation, CatalogTableType tableType) {
        TableIdentifier x$1 = TableIdentifier$.MODULE$.apply(tableName, (Option)new Some((Object)database));
        CatalogTableType x$2 = tableType;
        StructType x$3 = new StructType().add("key", "int");
        Option<String> x$4 = collation;
        CatalogStorageFormat x$5 = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        Option x$6 = CatalogTable$.MODULE$.apply$default$5();
        scala.collection.immutable.Seq x$7 = CatalogTable$.MODULE$.apply$default$6();
        Option x$8 = CatalogTable$.MODULE$.apply$default$7();
        String x$9 = CatalogTable$.MODULE$.apply$default$8();
        long x$10 = CatalogTable$.MODULE$.apply$default$9();
        long x$11 = CatalogTable$.MODULE$.apply$default$10();
        String x$12 = CatalogTable$.MODULE$.apply$default$11();
        Map x$13 = CatalogTable$.MODULE$.apply$default$12();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Option x$16 = CatalogTable$.MODULE$.apply$default$15();
        scala.collection.immutable.Seq x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        boolean x$19 = CatalogTable$.MODULE$.apply$default$19();
        Map x$20 = CatalogTable$.MODULE$.apply$default$20();
        Option x$21 = CatalogTable$.MODULE$.apply$default$21();
        return new CatalogTable(x$1, x$2, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$4, x$17, x$18, x$19, x$20, x$21);
    }

    public Option<String> table$default$3() {
        return None$.MODULE$;
    }

    public CatalogTableType table$default$4() {
        return CatalogTableType$.MODULE$.MANAGED();
    }

    private URI tempDatabasePath() {
        return this.tempDatabasePath;
    }

    private CatalogStorageFormat storageFormat() {
        return this.storageFormat;
    }

    public int testPartitionCount() {
        return this.testPartitionCount;
    }

    public CatalogFunction function(String name, String className) {
        return new CatalogFunction(FunctionIdentifier$.MODULE$.apply(name, (Option)new Some((Object)"default")), className, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
    }

    public static final /* synthetic */ void $anonfun$new$6(HiveClientSuite $this, File tmpDir) {
        CatalogDatabase dbWithNullDesc = new CatalogDatabase("dbWithNullDesc", null, tmpDir.toURI(), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        $this.client().createDatabase(dbWithNullDesc, true);
        String $org_scalatest_assert_macro_left = $this.client().getDatabase("dbWithNullDesc").description();
        String $org_scalatest_assert_macro_right = "";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
    }

    public static final /* synthetic */ CatalogTablePartition $anonfun$new$42(HiveClientSuite $this, int key2) {
        return new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)Integer.toString(key2))})), $this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
    }

    public static final /* synthetic */ String $anonfun$new$44(int key2) {
        return "key1=1/key2=" + key2;
    }

    public static final /* synthetic */ void $anonfun$new$57(HiveClientSuite $this, CatalogTable table$1, scala.collection.immutable.Seq partitions$1) {
        $this.client().createPartitions(table$1, partitions$1, false);
    }

    public static final /* synthetic */ Dataset $anonfun$new$95(HiveClientSuite $this, int i) {
        return $this.versionSpark().sql("INSERT OVERWRITE TABLE tab SELECT '" + i + "'");
    }

    private static final List listFiles$1(File path2) {
        File[] dir = path2.listFiles();
        List folders = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])dir), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isDirectory()))).toList();
        List filePaths = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])dir), (Function1 & Serializable)x$11 -> x$11.getName(), ClassTag$.MODULE$.apply(String.class))).toList();
        List list = folders.flatMap((Function1 & Serializable)path -> HiveClientSuite.listFiles$1(path));
        return (List)filePaths.$plus$plus$colon((IterableOnce)list);
    }

    public static final /* synthetic */ void $anonfun$new$100(HiveClientSuite $this, File dir) {
        String path = dir.toURI().toString();
        String tableName = "spark_13709";
        String tempTableName = "spark_13709_temp";
        new File(dir.getAbsolutePath(), tableName).mkdir();
        new File(dir.getAbsolutePath(), tempTableName).mkdir();
        String avroSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |  \"name\": \"test_record\",\n          |  \"type\": \"record\",\n          |  \"fields\": [ {\n          |    \"name\": \"f0\",\n          |    \"type\": \"int\"\n          |  }, {\n          |    \"name\": \"f1\",\n          |    \"type\": {\n          |      \"type\": \"record\",\n          |      \"name\": \"inner\",\n          |      \"fields\": [ {\n          |        \"name\": \"f10\",\n          |        \"type\": \"int\"\n          |      }, {\n          |        \"name\": \"f11\",\n          |        \"type\": \"double\"\n          |      } ]\n          |    }\n          |  } ]\n          |}\n          "));
        $this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName, tempTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE EXTERNAL TABLE " + tableName + "\n             |PARTITIONED BY (ds STRING)\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |LOCATION '" + path + "/" + tableName + "'\n             |TBLPROPERTIES ('avro.schema.literal' = '" + avroSchema + "')\n           ")));
            $this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE EXTERNAL TABLE " + tempTableName + "\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |LOCATION '" + path + "/" + tempTableName + "'\n             |TBLPROPERTIES ('avro.schema.literal' = '" + avroSchema + "')\n           ")));
            $this.versionSpark().sql("INSERT OVERWRITE TABLE " + tempTableName + " SELECT 1, STRUCT(2, 2.5)");
            $this.versionSpark().sql("ALTER TABLE " + tableName + " ADD PARTITION (ds = 'foo') LOCATION '" + path + "/" + tempTableName + "'");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().sql("SELECT * FROM " + tableName).collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)2.5)})), "foo"}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
        });
    }

    public static final /* synthetic */ void $anonfun$new$110(HiveClientSuite $this, File dir) {
        String avroSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |{\n          |  \"name\": \"test_record\",\n          |  \"type\": \"record\",\n          |  \"fields\": [{\n          |    \"name\": \"f0\",\n          |    \"type\": [\n          |      \"null\",\n          |      {\n          |        \"precision\": 38,\n          |        \"scale\": 2,\n          |        \"type\": \"bytes\",\n          |        \"logicalType\": \"decimal\"\n          |      }\n          |    ]\n          |  }]\n          |}\n          "));
        File schemaFile = new File(dir, "avroDecimal.avsc");
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(schemaFile), (Function1 & Serializable)writer -> {
            writer.write(avroSchema);
            return BoxedUnit.UNIT;
        });
        String schemaPath = schemaFile.toURI().toString();
        URL url = Thread.currentThread().getContextClassLoader().getResource("avroDecimal");
        String srcLocation = new File(url.getFile()).toURI().toString();
        String destTableName = "tab1";
        String srcTableName = "tab2";
        $this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{srcTableName, destTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE EXTERNAL TABLE " + srcTableName + "\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |LOCATION '" + srcLocation + "'\n             |TBLPROPERTIES ('avro.schema.url' = '" + schemaPath + "')\n           ")));
            $this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE " + destTableName + "\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |TBLPROPERTIES ('avro.schema.url' = '" + schemaPath + "')\n           ")));
            $this.versionSpark().sql("INSERT OVERWRITE TABLE " + destTableName + " SELECT * FROM " + srcTableName);
            Row[] result = (Row[])$this.versionSpark().table(srcTableName).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(destTableName).collect());
            Row[] $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 973));
            $this.versionSpark().sql("INSERT INTO TABLE " + destTableName + " SELECT * FROM " + srcTableName);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])$this.versionSpark().table(destTableName).collect())));
            Row[] $org_scalatest_assert_macro_right2 = (Row[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])result), (Object)result, ClassTag$.MODULE$.apply(Row.class));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 976));
        });
    }

    public HiveClientSuite(String version) {
        this.version = version;
        super(version);
        this.versionSpark = null;
        this.emptyDir = Utils$.MODULE$.createTempDir().getCanonicalPath();
        this.ver = IsolatedClientLoader$.MODULE$.hiveVersion(version);
        this.test("create client", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.client_$eq(null);
            System.gc();
            Configuration hadoopConf = new Configuration();
            hadoopConf.set("test", "success");
            this.client_$eq(this.buildClient(hadoopConf));
            if (this.versionSpark() != null) {
                this.versionSpark().reset();
            }
            this.versionSpark_$eq(new TestHiveVersion(this.client()));
            String $org_scalatest_assert_macro_left = ((HiveExternalCatalog)this.versionSpark().sharedState().externalCatalog().unwrapped()).client().version().fullVersion();
            String $org_scalatest_assert_macro_right = $this.version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.tempDatabasePath = Utils$.MODULE$.createTempDir().toURI();
        this.test("createDatabase", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogDatabase defaultDB = new CatalogDatabase("default", "desc", new URI("loc"), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
            this.client().createDatabase(defaultDB, true);
            CatalogDatabase tempDB = new CatalogDatabase("temporary", "test create", this.tempDatabasePath(), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
            this.client().createDatabase(tempDB, true);
            return (DatabaseAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.client().createDatabase(tempDB, false), ClassTag$.MODULE$.apply(DatabaseAlreadyExistsException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("create/get/alter database should pick right user name as owner", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String currentUser = UserGroupInformation.getCurrentUser().getUserName();
            String ownerName = "SPARK_29425";
            String db1 = "SPARK_29425_1";
            String db2 = "SPARK_29425_2";
            Map ownerProps = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)ownerName)}));
            CatalogDatabase dbWithOwner = new CatalogDatabase(db1, "desc", Utils$.MODULE$.createTempDir().toURI(), ownerProps);
            this.client().createDatabase(dbWithOwner, true);
            CatalogDatabase getDbWithOwner = this.client().getDatabase(db1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(getDbWithOwner.properties().apply((Object)"owner"));
            String $org_scalatest_assert_macro_right = ownerName;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            Map x$1 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            String x$2 = getDbWithOwner.copy$default$1();
            String x$3 = getDbWithOwner.copy$default$2();
            URI x$4 = getDbWithOwner.copy$default$3();
            this.client().alterDatabase(getDbWithOwner.copy(x$2, x$3, x$4, x$1));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.client().getDatabase(db1).properties().apply((Object)"owner"));
            String $org_scalatest_assert_macro_right2 = "";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            CatalogDatabase dbWithoutOwner = new CatalogDatabase(db2, "desc", Utils$.MODULE$.createTempDir().toURI(), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
            this.client().createDatabase(dbWithoutOwner, true);
            CatalogDatabase getDbWithoutOwner = this.client().getDatabase(db2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(getDbWithoutOwner.properties().apply((Object)"owner"));
            String $org_scalatest_assert_macro_right3 = currentUser;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            Map x$5 = ownerProps;
            String x$6 = getDbWithoutOwner.copy$default$1();
            String x$7 = getDbWithoutOwner.copy$default$2();
            URI x$8 = getDbWithoutOwner.copy$default$3();
            this.client().alterDatabase(getDbWithoutOwner.copy(x$6, x$7, x$8, x$5));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.client().getDatabase(db2).properties().apply((Object)"owner"));
            String $org_scalatest_assert_macro_right4 = ownerName;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("createDatabase with null description", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)tmpDir -> {
            HiveClientSuite.$anonfun$new$6(this, tmpDir);
            return BoxedUnit.UNIT;
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("setCurrentDatabase", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.client().setCurrentDatabase("default"), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("getDatabase", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.client().getDatabase("default");
            return (NoSuchDatabaseException)this.intercept((Function0 & Serializable)() -> this.client().getDatabase("nonexist"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("databaseExists", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().databaseExists("default"), "HiveClientSuite.this.client.databaseExists(\"default\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().databaseExists("nonexist"), "HiveClientSuite.this.client.databaseExists(\"nonexist\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("listDatabases", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = this.client().listDatabases("defau.*");
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"default", (List)Nil$.MODULE$);
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("alterDatabase", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogDatabase qual$1 = this.client().getDatabase("temporary");
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)"true")}));
            String x$10 = qual$1.copy$default$1();
            String x$11 = qual$1.copy$default$2();
            URI x$12 = qual$1.copy$default$3();
            CatalogDatabase database = qual$1.copy(x$10, x$11, x$12, x$9);
            this.client().alterDatabase(database);
            Map $org_scalatest_assert_macro_left = this.client().getDatabase("temporary").properties();
            String $org_scalatest_assert_macro_right = "flag";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            URI tempDatabasePath2 = Utils$.MODULE$.createTempDir().toURI();
            if (this.ver().compare((package.HiveVersion)package.hive$.v3_0$.MODULE$) >= 0) {
                URI x$13 = tempDatabasePath2;
                String x$14 = database.copy$default$1();
                String x$15 = database.copy$default$2();
                Map x$16 = database.copy$default$4();
                this.client().alterDatabase(database.copy(x$14, x$15, x$13, x$16));
                URI uriInCatalog = this.client().getDatabase("temporary").locationUri();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer("file");
                String $org_scalatest_assert_macro_right2 = uriInCatalog.getScheme();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new Path(tempDatabasePath2.getPath()).toUri().getPath());
                String $org_scalatest_assert_macro_right3 = uriInCatalog.getPath();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Failed to alter database location", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            }
            AnalysisException e = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                URI x$17 = tempDatabasePath2;
                String x$18 = database.copy$default$1();
                String x$19 = database.copy$default$2();
                Map x$20 = database.copy$default$4();
                this.client().alterDatabase(database.copy(x$18, x$19, x$17, x$20));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            String $org_scalatest_assert_macro_left4 = e.getMessage();
            String $org_scalatest_assert_macro_right4 = "does not support altering database location";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("dropDatabase", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            AnalysisException ex;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().databaseExists("temporary"), "HiveClientSuite.this.client.databaseExists(\"temporary\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            this.client().createTable(this.table("temporary", "tbl", this.table$default$3(), this.table$default$4()), false);
            AnalysisException x$21 = ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> {
                this.client().dropDatabase("temporary", false, false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"dropDatabase should throw HiveException", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            String x$22 = "SCHEMA_NOT_EMPTY";
            Map x$23 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`temporary`")}));
            Option x$24 = this.checkError$default$3();
            boolean x$25 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$26 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$21, "SCHEMA_NOT_EMPTY", x$24, x$23, x$25, x$26);
            this.client().dropDatabase("temporary", false, true);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().databaseExists("temporary"), "HiveClientSuite.this.client.databaseExists(\"temporary\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("createTable", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.client().createTable(this.table("default", "src", this.table$default$3(), this.table$default$4()), false);
            this.client().createTable(this.table("default", "temporary", this.table$default$3(), this.table$default$4()), false);
            String x$27 = "default";
            String x$28 = "view1";
            CatalogTableType x$29 = CatalogTableType$.MODULE$.VIEW();
            Option<String> x$30 = this.table$default$3();
            this.client().createTable(this.table("default", "view1", x$30, x$29), false);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        this.test("create/alter table with collations", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.client().createTable(this.table("default", "collation_table", (Option<String>)new Some((Object)"UNICODE"), this.table$default$4()), false);
            CatalogTable readBack = this.client().getTable("default", "collation_table");
            Map $org_scalatest_assert_macro_left = readBack.properties();
            String $org_scalatest_assert_macro_right = "collation";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(readBack.collation());
            Some $org_scalatest_assert_macro_right2 = new Some((Object)"UNICODE");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            Some x$31 = new Some((Object)"UNICODE_CI");
            TableIdentifier x$32 = readBack.copy$default$1();
            CatalogTableType x$33 = readBack.copy$default$2();
            CatalogStorageFormat x$34 = readBack.copy$default$3();
            StructType x$35 = readBack.copy$default$4();
            Option x$36 = readBack.copy$default$5();
            scala.collection.immutable.Seq x$37 = readBack.copy$default$6();
            Option x$38 = readBack.copy$default$7();
            String x$39 = readBack.copy$default$8();
            long x$40 = readBack.copy$default$9();
            long x$41 = readBack.copy$default$10();
            String x$42 = readBack.copy$default$11();
            Map x$43 = readBack.copy$default$12();
            Option x$44 = readBack.copy$default$13();
            Option x$45 = readBack.copy$default$14();
            Option x$46 = readBack.copy$default$15();
            scala.collection.immutable.Seq x$47 = readBack.copy$default$17();
            boolean x$48 = readBack.copy$default$18();
            boolean x$49 = readBack.copy$default$19();
            Map x$50 = readBack.copy$default$20();
            Option x$51 = readBack.copy$default$21();
            this.client().alterTable("default", "collation_table", readBack.copy(x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, (Option)x$31, x$47, x$48, x$49, x$50, x$51));
            CatalogTable alteredTbl = this.client().getTable("default", "collation_table");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(alteredTbl.collation());
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"UNICODE_CI");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            this.client().dropTable("default", "collation_table", true, true);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("loadTable", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.client().loadTable(this.emptyDir(), "src", false, false), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("tableExists", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "src"), "HiveClientSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "nonexistent"), "HiveClientSuite.this.client.tableExists(\"default\", \"nonexistent\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("getTable", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> this.client().getTable("default", "src"), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("getTableOption", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().getTableOption("default", "src").isDefined(), "HiveClientSuite.this.client.getTableOption(\"default\", \"src\").isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        this.test("getTablesByName", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogTable $org_scalatest_assert_macro_left = (CatalogTable)this.client().getTablesByName("default", (scala.collection.immutable.Seq)new .colon.colon((Object)"src", (List)Nil$.MODULE$)).head();
            CatalogTable $org_scalatest_assert_macro_right = (CatalogTable)this.client().getTableOption("default", "src").get();
            CatalogTable catalogTable = $org_scalatest_assert_macro_left;
            CatalogTable catalogTable2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTable != null ? !catalogTable.equals(catalogTable2) : catalogTable2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        this.test("getTablesByName when multiple tables", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = (scala.collection.immutable.Seq)this.client().getTablesByName("default", (scala.collection.immutable.Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)"temporary", (List)Nil$.MODULE$))).map((Function1 & Serializable)x$1 -> x$1.identifier().table());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"src", (List)new .colon.colon((Object)"temporary", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("getTablesByName when some tables do not exist", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = (scala.collection.immutable.Seq)this.client().getTablesByName("default", (scala.collection.immutable.Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)"notexist", (List)Nil$.MODULE$))).map((Function1 & Serializable)x$2 -> x$2.identifier().table());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"src", (List)Nil$.MODULE$);
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("getTablesByName when contains invalid name", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String name = "\u7816";
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = (scala.collection.immutable.Seq)this.client().getTablesByName("default", (scala.collection.immutable.Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)name, (List)Nil$.MODULE$))).map((Function1 & Serializable)x$3 -> x$3.identifier().table());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"src", (List)Nil$.MODULE$);
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("getTablesByName when empty", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = this.client().getTablesByName("default", (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("alterTable(table: CatalogTable)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogTable qual$2 = this.client().getTable("default", "src");
            Map x$52 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changed"), (Object)"")}));
            TableIdentifier x$53 = qual$2.copy$default$1();
            CatalogTableType x$54 = qual$2.copy$default$2();
            CatalogStorageFormat x$55 = qual$2.copy$default$3();
            StructType x$56 = qual$2.copy$default$4();
            Option x$57 = qual$2.copy$default$5();
            scala.collection.immutable.Seq x$58 = qual$2.copy$default$6();
            Option x$59 = qual$2.copy$default$7();
            String x$60 = qual$2.copy$default$8();
            long x$61 = qual$2.copy$default$9();
            long x$62 = qual$2.copy$default$10();
            String x$63 = qual$2.copy$default$11();
            Option x$64 = qual$2.copy$default$13();
            Option x$65 = qual$2.copy$default$14();
            Option x$66 = qual$2.copy$default$15();
            Option x$67 = qual$2.copy$default$16();
            scala.collection.immutable.Seq x$68 = qual$2.copy$default$17();
            boolean x$69 = qual$2.copy$default$18();
            boolean x$70 = qual$2.copy$default$19();
            Map x$71 = qual$2.copy$default$20();
            Option x$72 = qual$2.copy$default$21();
            CatalogTable newTable = qual$2.copy(x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$52, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72);
            this.client().alterTable(newTable);
            Map $org_scalatest_assert_macro_left = this.client().getTable("default", "src").properties();
            String $org_scalatest_assert_macro_right = "changed";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("alterTable - should respect the original catalog table's owner name", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String ownerName = "SPARK-29405";
            CatalogTable originalTable = this.client().getTable("default", "src");
            String x$73 = ownerName;
            TableIdentifier x$74 = originalTable.copy$default$1();
            CatalogTableType x$75 = originalTable.copy$default$2();
            CatalogStorageFormat x$76 = originalTable.copy$default$3();
            StructType x$77 = originalTable.copy$default$4();
            Option x$78 = originalTable.copy$default$5();
            scala.collection.immutable.Seq x$79 = originalTable.copy$default$6();
            Option x$80 = originalTable.copy$default$7();
            long x$81 = originalTable.copy$default$9();
            long x$82 = originalTable.copy$default$10();
            String x$83 = originalTable.copy$default$11();
            Map x$84 = originalTable.copy$default$12();
            Option x$85 = originalTable.copy$default$13();
            Option x$86 = originalTable.copy$default$14();
            Option x$87 = originalTable.copy$default$15();
            Option x$88 = originalTable.copy$default$16();
            scala.collection.immutable.Seq x$89 = originalTable.copy$default$17();
            boolean x$90 = originalTable.copy$default$18();
            boolean x$91 = originalTable.copy$default$19();
            Map x$92 = originalTable.copy$default$20();
            Option x$93 = originalTable.copy$default$21();
            CatalogTable newTable = originalTable.copy(x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$73, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93);
            this.client().alterTable(newTable);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().getTable("default", "src").owner());
            String $org_scalatest_assert_macro_right = ownerName;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            String x$94 = "";
            TableIdentifier x$95 = originalTable.copy$default$1();
            CatalogTableType x$96 = originalTable.copy$default$2();
            CatalogStorageFormat x$97 = originalTable.copy$default$3();
            StructType x$98 = originalTable.copy$default$4();
            Option x$99 = originalTable.copy$default$5();
            scala.collection.immutable.Seq x$100 = originalTable.copy$default$6();
            Option x$101 = originalTable.copy$default$7();
            long x$102 = originalTable.copy$default$9();
            long x$103 = originalTable.copy$default$10();
            String x$104 = originalTable.copy$default$11();
            Map x$105 = originalTable.copy$default$12();
            Option x$106 = originalTable.copy$default$13();
            Option x$107 = originalTable.copy$default$14();
            Option x$108 = originalTable.copy$default$15();
            Option x$109 = originalTable.copy$default$16();
            scala.collection.immutable.Seq x$110 = originalTable.copy$default$17();
            boolean x$111 = originalTable.copy$default$18();
            boolean x$112 = originalTable.copy$default$19();
            Map x$113 = originalTable.copy$default$20();
            Option x$114 = originalTable.copy$default$21();
            CatalogTable newTable2 = originalTable.copy(x$95, x$96, x$97, x$98, x$99, x$100, x$101, "", x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114);
            this.client().alterTable(newTable2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.client().getTable("default", "src").owner());
            String $org_scalatest_assert_macro_right2 = this.client().userName();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("alterTable(dbName: String, tableName: String, table: CatalogTable)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogTable qual$3 = this.client().getTable("default", "src");
            Map x$115 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changedAgain"), (Object)"")}));
            TableIdentifier x$116 = qual$3.copy$default$1();
            CatalogTableType x$117 = qual$3.copy$default$2();
            CatalogStorageFormat x$118 = qual$3.copy$default$3();
            StructType x$119 = qual$3.copy$default$4();
            Option x$120 = qual$3.copy$default$5();
            scala.collection.immutable.Seq x$121 = qual$3.copy$default$6();
            Option x$122 = qual$3.copy$default$7();
            String x$123 = qual$3.copy$default$8();
            long x$124 = qual$3.copy$default$9();
            long x$125 = qual$3.copy$default$10();
            String x$126 = qual$3.copy$default$11();
            Option x$127 = qual$3.copy$default$13();
            Option x$128 = qual$3.copy$default$14();
            Option x$129 = qual$3.copy$default$15();
            Option x$130 = qual$3.copy$default$16();
            scala.collection.immutable.Seq x$131 = qual$3.copy$default$17();
            boolean x$132 = qual$3.copy$default$18();
            boolean x$133 = qual$3.copy$default$19();
            Map x$134 = qual$3.copy$default$20();
            Option x$135 = qual$3.copy$default$21();
            CatalogTable newTable = qual$3.copy(x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$115, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135);
            this.client().alterTable("default", "src", newTable);
            Map $org_scalatest_assert_macro_left = this.client().getTable("default", "src").properties();
            String $org_scalatest_assert_macro_right = "changedAgain";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("alterTable - rename", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogTable qual$4 = this.client().getTable("default", "src");
            TableIdentifier x$136 = TableIdentifier$.MODULE$.apply("tgt", (Option)new Some((Object)"default"));
            CatalogTableType x$137 = qual$4.copy$default$2();
            CatalogStorageFormat x$138 = qual$4.copy$default$3();
            StructType x$139 = qual$4.copy$default$4();
            Option x$140 = qual$4.copy$default$5();
            scala.collection.immutable.Seq x$141 = qual$4.copy$default$6();
            Option x$142 = qual$4.copy$default$7();
            String x$143 = qual$4.copy$default$8();
            long x$144 = qual$4.copy$default$9();
            long x$145 = qual$4.copy$default$10();
            String x$146 = qual$4.copy$default$11();
            Map x$147 = qual$4.copy$default$12();
            Option x$148 = qual$4.copy$default$13();
            Option x$149 = qual$4.copy$default$14();
            Option x$150 = qual$4.copy$default$15();
            Option x$151 = qual$4.copy$default$16();
            scala.collection.immutable.Seq x$152 = qual$4.copy$default$17();
            boolean x$153 = qual$4.copy$default$18();
            boolean x$154 = qual$4.copy$default$19();
            Map x$155 = qual$4.copy$default$20();
            Option x$156 = qual$4.copy$default$21();
            CatalogTable newTable = qual$4.copy(x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "tgt"), "HiveClientSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            this.client().alterTable("default", "src", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "tgt"), "HiveClientSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "src"), "HiveClientSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("alterTable - change database", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogDatabase tempDB = new CatalogDatabase("temporary", "test create", this.tempDatabasePath(), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
            this.client().createDatabase(tempDB, true);
            CatalogTable qual$5 = this.client().getTable("default", "tgt");
            TableIdentifier x$157 = TableIdentifier$.MODULE$.apply("tgt", (Option)new Some((Object)"temporary"));
            CatalogTableType x$158 = qual$5.copy$default$2();
            CatalogStorageFormat x$159 = qual$5.copy$default$3();
            StructType x$160 = qual$5.copy$default$4();
            Option x$161 = qual$5.copy$default$5();
            scala.collection.immutable.Seq x$162 = qual$5.copy$default$6();
            Option x$163 = qual$5.copy$default$7();
            String x$164 = qual$5.copy$default$8();
            long x$165 = qual$5.copy$default$9();
            long x$166 = qual$5.copy$default$10();
            String x$167 = qual$5.copy$default$11();
            Map x$168 = qual$5.copy$default$12();
            Option x$169 = qual$5.copy$default$13();
            Option x$170 = qual$5.copy$default$14();
            Option x$171 = qual$5.copy$default$15();
            Option x$172 = qual$5.copy$default$16();
            scala.collection.immutable.Seq x$173 = qual$5.copy$default$17();
            boolean x$174 = qual$5.copy$default$18();
            boolean x$175 = qual$5.copy$default$19();
            Map x$176 = qual$5.copy$default$20();
            Option x$177 = qual$5.copy$default$21();
            CatalogTable newTable = qual$5.copy(x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("temporary", "tgt"), "HiveClientSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            this.client().alterTable("default", "tgt", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.client().tableExists("temporary", "tgt"), "HiveClientSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "tgt"), "HiveClientSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("alterTable - change database and table names", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogTable qual$6 = this.client().getTable("temporary", "tgt");
            TableIdentifier x$178 = TableIdentifier$.MODULE$.apply("src", (Option)new Some((Object)"default"));
            CatalogTableType x$179 = qual$6.copy$default$2();
            CatalogStorageFormat x$180 = qual$6.copy$default$3();
            StructType x$181 = qual$6.copy$default$4();
            Option x$182 = qual$6.copy$default$5();
            scala.collection.immutable.Seq x$183 = qual$6.copy$default$6();
            Option x$184 = qual$6.copy$default$7();
            String x$185 = qual$6.copy$default$8();
            long x$186 = qual$6.copy$default$9();
            long x$187 = qual$6.copy$default$10();
            String x$188 = qual$6.copy$default$11();
            Map x$189 = qual$6.copy$default$12();
            Option x$190 = qual$6.copy$default$13();
            Option x$191 = qual$6.copy$default$14();
            Option x$192 = qual$6.copy$default$15();
            Option x$193 = qual$6.copy$default$16();
            scala.collection.immutable.Seq x$194 = qual$6.copy$default$17();
            boolean x$195 = qual$6.copy$default$18();
            boolean x$196 = qual$6.copy$default$19();
            Map x$197 = qual$6.copy$default$20();
            Option x$198 = qual$6.copy$default$21();
            CatalogTable newTable = qual$6.copy(x$178, x$179, x$180, x$181, x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "src"), "HiveClientSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
            this.client().alterTable("temporary", "tgt", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "src"), "HiveClientSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("temporary", "tgt"), "HiveClientSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        this.test("listTables(database)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().listTables("default").diff((Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)"temporary", (List)new .colon.colon((Object)"view1", (List)Nil$.MODULE$)))));
            Nil$ $org_scalatest_assert_macro_right = Nil$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        this.test("listTables(database, pattern)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().listTables("default", "src"));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"src", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left2 = this.client().listTables("default", "nonexist");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("listTablesByType(database, pattern, tableType)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().listTablesByType("default", "view1", CatalogTableType$.MODULE$.VIEW()));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"view1", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left2 = this.client().listTablesByType("default", "nonexist", CatalogTableType$.MODULE$.VIEW());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        this.test("dropTable", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.client().dropTable("default", "temporary", false, true);
            this.client().dropTable("default", "view1", false, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().listTables("default"));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"src", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        this.storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty());
        this.test("sql create partitioned table", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TableIdentifier x$199 = TableIdentifier$.MODULE$.apply("src_part", (Option)new Some((Object)"default"));
            CatalogTableType x$200 = CatalogTableType$.MODULE$.MANAGED();
            StructType x$201 = new StructType().add("value", "int").add("key1", "int").add("key2", "int");
            .colon.colon x$202 = new .colon.colon((Object)"key1", (List)new .colon.colon((Object)"key2", (List)Nil$.MODULE$));
            CatalogStorageFormat x$203 = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
            Option x$204 = CatalogTable$.MODULE$.apply$default$5();
            Option x$205 = CatalogTable$.MODULE$.apply$default$7();
            String x$206 = CatalogTable$.MODULE$.apply$default$8();
            long x$207 = CatalogTable$.MODULE$.apply$default$9();
            long x$208 = CatalogTable$.MODULE$.apply$default$10();
            String x$209 = CatalogTable$.MODULE$.apply$default$11();
            Map x$210 = CatalogTable$.MODULE$.apply$default$12();
            Option x$211 = CatalogTable$.MODULE$.apply$default$13();
            Option x$212 = CatalogTable$.MODULE$.apply$default$14();
            Option x$213 = CatalogTable$.MODULE$.apply$default$15();
            Option x$214 = CatalogTable$.MODULE$.apply$default$16();
            scala.collection.immutable.Seq x$215 = CatalogTable$.MODULE$.apply$default$17();
            boolean x$216 = CatalogTable$.MODULE$.apply$default$18();
            boolean x$217 = CatalogTable$.MODULE$.apply$default$19();
            Map x$218 = CatalogTable$.MODULE$.apply$default$20();
            Option x$219 = CatalogTable$.MODULE$.apply$default$21();
            CatalogTable table = new CatalogTable(x$199, x$200, x$203, x$201, x$204, (scala.collection.immutable.Seq)x$202, x$205, x$206, x$207, x$208, x$209, x$210, x$211, x$212, x$213, x$214, x$215, x$216, x$217, x$218, x$219);
            this.client().createTable(table, false);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.testPartitionCount = 2;
        this.test("createPartitions", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq partitions = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.testPartitionCount()).map((Function1 & Serializable)key2 -> HiveClientSuite.$anonfun$new$42(this, BoxesRunTime.unboxToInt((Object)key2)));
            this.client().createPartitions(this.client().getTable("default", "src_part"), (scala.collection.immutable.Seq)partitions, true);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        this.test("getPartitionNames(catalogTable)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            IndexedSeq partitionNames;
            IndexedSeq $org_scalatest_assert_macro_left = partitionNames = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.testPartitionCount()).map((Function1 & Serializable)key2 -> HiveClientSuite.$anonfun$new$44(BoxesRunTime.unboxToInt((Object)key2)));
            HiveClient qual$7 = this.client();
            CatalogTable x$220 = this.client().getTable("default", "src_part");
            Option x$221 = qual$7.getPartitionNames$default$2();
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right = qual$7.getPartitionNames(x$220, x$221);
            IndexedSeq indexedSeq = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(indexedSeq != null ? !indexedSeq.equals(seq) : seq != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.test("getPartitions(db, table, spec)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            int $org_scalatest_assert_macro_left = this.testPartitionCount();
            int $org_scalatest_assert_macro_right = this.client().getPartitions("default", "src_part", (Option)None$.MODULE$).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        this.test("getPartitionsByFilter", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            scala.collection.immutable.Seq result;
            String x$222 = "key2";
            IntegerType$ x$223 = IntegerType$.MODULE$;
            boolean x$224 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$225 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$226 = AttributeReference$.MODULE$.apply$default$5("key2", (DataType)x$223, x$224, x$225);
            scala.collection.immutable.Seq x$227 = AttributeReference$.MODULE$.apply$default$6("key2", (DataType)x$223, x$224, x$225);
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = result = this.client().getPartitionsByFilter(this.client().getRawHiveTable("default", "src_part"), (scala.collection.immutable.Seq)new .colon.colon((Object)new EqualTo((Expression)new AttributeReference("key2", (DataType)x$223, x$224, x$225, x$226, x$227), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        this.test("getPartition", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> this.client().getPartition("default", "src_part", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")}))), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("getPartitionOption(db: String, table: String, spec: TablePartitionSpec)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Option partition = this.client().getPartitionOption("default", "src_part", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partition.isDefined(), "partition.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        this.test("getPartitionOption(table: CatalogTable, spec: TablePartitionSpec)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Option partition = this.client().getPartitionOption(this.client().getRawHiveTable("default", "src_part"), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partition.isDefined(), "partition.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        this.test("getPartitions(db: String, table: String)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            int $org_scalatest_assert_macro_left = this.testPartitionCount();
            int $org_scalatest_assert_macro_right = this.client().getPartitions("default", "src_part", (Option)None$.MODULE$).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        this.test("loadPartition", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            partSpec.put("key1", "1");
            partSpec.put("key2", "2");
            this.client().loadPartition(this.emptyDir(), "default", "src_part", partSpec, false, false, false);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        this.test("loadDynamicPartitions", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            partSpec.put("key1", "1");
            partSpec.put("key2", "");
            this.client().loadDynamicPartitions(this.emptyDir(), "default", "src_part", partSpec, false, 1);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        this.test("renamePartitions", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Map oldSpec = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"1")}));
            Map newSpec = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"3")}));
            this.client().renamePartitions("default", "src_part", (scala.collection.immutable.Seq)new .colon.colon((Object)oldSpec, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)newSpec, (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().getPartitionOption("default", "src_part", newSpec).isDefined(), "HiveClientSuite.this.client.getPartitionOption(\"default\", \"src_part\", newSpec).isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
        this.test("alterPartitions", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Map spec = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")}));
            Map parameters = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalSize"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFiles"), (Object)"1")}));
            URI newLocation = new URI(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Utils$.MODULE$.createTempDir().toURI().toString()), "/"));
            CatalogStorageFormat storage = this.storageFormat().copy((Option)new Some((Object)newLocation), this.storageFormat().copy$default$2(), this.storageFormat().copy$default$3(), this.storageFormat().copy$default$4(), this.storageFormat().copy$default$5(), this.storageFormat().copy$default$6());
            CatalogTablePartition partition = new CatalogTablePartition(spec, storage, parameters, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            this.client().alterPartitions("default", "src_part", (scala.collection.immutable.Seq)new .colon.colon((Object)partition, (List)Nil$.MODULE$));
            Option $org_scalatest_assert_macro_left = this.client().getPartition("default", "src_part", spec).storage().locationUri();
            URI $org_scalatest_assert_macro_right = newLocation;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
            Option $org_scalatest_assert_macro_left2 = this.client().getPartition("default", "src_part", spec).parameters().get((Object)"totalSize");
            String $org_scalatest_assert_macro_right2 = "0";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        this.test("dropPartitions", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Map spec = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"3")}));
            this.client().dropPartitions("default", "src_part", (scala.collection.immutable.Seq)new .colon.colon((Object)spec, (List)Nil$.MODULE$), true, true, false);
            Option $org_scalatest_assert_macro_left = this.client().getPartitionOption("default", "src_part", spec);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        this.test("createPartitions if already exists", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            .colon.colon partitions = new .colon.colon((Object)new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"101"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"102")})), this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6()), (List)Nil$.MODULE$);
            CatalogTable table = this.client().getTable("default", "src_part");
            try {
                PartitionsAlreadyExistException e;
                this.client().createPartitions(table, (scala.collection.immutable.Seq)partitions, false);
                PartitionsAlreadyExistException x$228 = e = (PartitionsAlreadyExistException)this.intercept((Function0)((JFunction0.mcV.sp & Serializable)() -> HiveClientSuite.$anonfun$new$57(this, table, (scala.collection.immutable.Seq)partitions)), ClassTag$.MODULE$.apply(PartitionsAlreadyExistException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
                String x$229 = "PARTITIONS_ALREADY_EXIST";
                Map x$230 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)"PARTITION (`key1` = 101, `key2` = 102)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`default`.`src_part`")}));
                Option x$231 = this.checkError$default$3();
                boolean x$232 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$233 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$228, "PARTITIONS_ALREADY_EXIST", x$231, x$230, x$232, x$233);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.client().dropPartitions("default", "src_part", (scala.collection.immutable.Seq)partitions.map((Function1 & Serializable)x$4 -> x$4.spec()), true, false, false);
            }
            return boxedUnit;
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
        this.test("createFunction", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String functionClass = "org.apache.spark.MyFunc1";
            this.client().createFunction("default", this.function("func1", functionClass));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        this.test("functionExists", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().functionExists("default", "func1"), "HiveClientSuite.this.client.functionExists(\"default\", \"func1\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        this.test("renameFunction", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.client().renameFunction("default", "func1", "func2");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().functionExists("default", "func2"), "HiveClientSuite.this.client.functionExists(\"default\", \"func2\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
        this.test("alterFunction", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String functionClass = "org.apache.spark.MyFunc2";
            this.client().alterFunction("default", this.function("func2", functionClass));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
        this.test("getFunction", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogFunction func = this.client().getFunction("default", "func2");
            String $org_scalatest_assert_macro_left = func.className();
            String $org_scalatest_assert_macro_right = "org.apache.spark.MyFunc2";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
        this.test("getFunctionOption", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().getFunctionOption("default", "func2").isDefined(), "HiveClientSuite.this.client.getFunctionOption(\"default\", \"func2\").isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
            Option $org_scalatest_assert_macro_left = this.client().getFunctionOption("default", "the_func_not_exists");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
        this.test("listFunctions", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = this.client().listFunctions("default", "fun.*");
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        this.test("dropFunction", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.client().dropFunction("default", "func2");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = this.client().listFunctions("default", "fun.*");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        this.test("sql set command", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> this.client().runSqlHive("SET spark.sql.test.key=1"), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.test("sql create index and reset", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            if (this.ver().compare((package.HiveVersion)package.hive$.v3_0$.MODULE$) < 0) {
                this.client().runSqlHive("CREATE TABLE indexed_table (key INT)");
                return this.client().runSqlHive("CREATE INDEX index_1 ON TABLE indexed_table(key) as 'COMPACT' WITH DEFERRED REBUILD");
            }
            return BoxedUnit.UNIT;
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
        this.test("sql read hive materialized view", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String string = $this.version;
            String string2 = "2.3";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.client().runSqlHive("CREATE TABLE materialized_view_tbl (c1 INT)");
                this.client().runSqlHive("CREATE MATERIALIZED VIEW mv1 AS SELECT * FROM materialized_view_tbl");
                AnalysisException x$234 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])this.versionSpark().table("mv1").collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
                String x$235 = "UNSUPPORTED_FEATURE.HIVE_TABLE_TYPE";
                Map x$236 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`mv1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableType"), (Object)"materialized view")}));
                Option x$237 = this.checkError$default$3();
                boolean x$238 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$239 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$234, "UNSUPPORTED_FEATURE.HIVE_TABLE_TYPE", x$237, x$236, x$238, x$239);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        this.test("version", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String $org_scalatest_assert_macro_left = this.client().version().fullVersion();
            String $org_scalatest_assert_macro_right = $this.version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        this.test("getConf", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer("success");
            String $org_scalatest_assert_macro_right = this.client().getConf("test", null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        this.test("setOut", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.client().setOut(new PrintStream(new ByteArrayOutputStream())), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
        this.test("setInfo", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.client().setInfo(new PrintStream(new ByteArrayOutputStream())), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        this.test("setError", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.client().setError(new PrintStream(new ByteArrayOutputStream())), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
        this.test("newSession", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            HiveClient newClient;
            HiveClient $org_scalatest_assert_macro_left = newClient = this.client().newSession();
            Object $org_scalatest_assert_macro_right = null;
            HiveClient hiveClient = $org_scalatest_assert_macro_left;
            Object var5_4 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, hiveClient == null ? var5_4 != null : !hiveClient.equals(var5_4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
        this.test("withHiveState and addJar", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            String newClassPath = ".";
            this.client().addJar(newClassPath);
            return BoxesRunTime.unboxToBoolean((Object)this.client().withHiveState((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                MutableURLClassLoader classLoader = (MutableURLClassLoader)Thread.currentThread().getContextClassLoader();
                URL[] urls = classLoader.getURLs();
                return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])urls), (Object)new File(newClassPath).toURI().toURL());
            }));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
        this.test("reset", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.client().reset();
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = this.client().listTables("default");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        this.test("CREATE TABLE AS SELECT", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool bool;
            Option totalSize;
            this.versionSpark().sql("CREATE TABLE tbl AS SELECT 1 AS a");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.versionSpark().table("tbl").collect()));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$);
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            CatalogTable tableMeta = this.versionSpark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("tbl"));
            Option $org_scalatest_assert_macro_left2 = totalSize = tableMeta.stats().map((Function1 & Serializable)x$5 -> x$5.sizeInBytes());
            Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left3.value()) {
                BigInt $org_scalatest_assert_macro_left4 = (BigInt)totalSize.get();
                BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.int2bigInt(0);
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
        this.test("CREATE Partitioned TABLE AS SELECT", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool bool;
            Bool bool2;
            this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE tbl(c1 string)\n          |USING hive\n          |PARTITIONED BY (ds STRING)\n          ")));
            this.versionSpark().sql("INSERT OVERWRITE TABLE tbl partition (ds='2') SELECT '1'");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.versionSpark().table("tbl").collect()));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2"})), (List)Nil$.MODULE$);
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
            Map partMeta = this.versionSpark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply("tbl"), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2")}))).parameters();
            Option totalSize = partMeta.get((Object)"totalSize").map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6))));
            Option numFiles = partMeta.get((Object)"numFiles").map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$7))));
            Option $org_scalatest_assert_macro_left2 = totalSize;
            Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left3.value()) {
                Option $org_scalatest_assert_macro_left4 = numFiles;
                bool2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "nonEmpty", $org_scalatest_assert_macro_left4.nonEmpty(), Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right2 = bool2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
            this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |ALTER TABLE tbl PARTITION (ds='2')\n          |SET SERDEPROPERTIES ('newKey' = 'vvv')\n          ")));
            Map newPartMeta = this.versionSpark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply("tbl"), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2")}))).parameters();
            Option newTotalSize = newPartMeta.get((Object)"totalSize").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8))));
            Option newNumFiles = newPartMeta.get((Object)"numFiles").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9))));
            Option $org_scalatest_assert_macro_left5 = newTotalSize;
            Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left6.value()) {
                Option $org_scalatest_assert_macro_left7 = newNumFiles;
                bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "nonEmpty", $org_scalatest_assert_macro_left7.nonEmpty(), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left6.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
        this.test("Delete the temporary staging directory and files after each insert", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)tmpDir -> {
            this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE tab(c1 string)\n             |USING HIVE\n             |location '" + tmpDir.toURI().toString() + "'\n             ")));
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)i -> HiveClientSuite.$anonfun$new$95($this, BoxesRunTime.unboxToInt((Object)i)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)HiveClientSuite.listFiles$1(tmpDir).length()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
        this.test("SPARK-13709: reading partitioned Avro table with nested schema", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)dir -> {
            HiveClientSuite.$anonfun$new$100(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
        this.test("CTAS for managed data source tables", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.versionSpark().range(1L).write().saveAsTable("t");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.versionSpark().table("t").collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
            this.versionSpark().sql("create table t1 using parquet as select 2 as a");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.versionSpark().table("t1").collect());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
        this.test("Decimal support of Avro Hive serde", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "tab1";
            String avroSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      |  \"name\": \"test_record\",\n      |  \"type\": \"record\",\n      |  \"fields\": [ {\n      |    \"name\": \"f0\",\n      |    \"type\": [\n      |      \"null\",\n      |      {\n      |        \"precision\": 38,\n      |        \"scale\": 2,\n      |        \"type\": \"bytes\",\n      |        \"logicalType\": \"decimal\"\n      |      }\n      |    ]\n      |  } ]\n      |}\n        "));
            package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)isPartitioned -> {
                this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    String partitionClause = isPartitioned ? "PARTITIONED BY (ds STRING)" : "";
                    $this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE " + tableName$2 + "\n             |" + partitionClause + "\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |TBLPROPERTIES ('avro.schema.literal' = '" + avroSchema$2 + "')\n           ")));
                    if (isPartitioned) {
                        String insertStmt = "INSERT OVERWRITE TABLE " + tableName$2 + " partition (ds='a') SELECT 1.3";
                        $this.versionSpark().sql(insertStmt);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName$2).collect());
                        Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30, 'a'").collect();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 858));
                        return;
                    }
                    String insertStmt = "INSERT OVERWRITE TABLE " + tableName$2 + " SELECT 1.3";
                    $this.versionSpark().sql(insertStmt);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName$2).collect());
                    Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30").collect();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 863));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        this.test("read avro file containing decimal", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            URL url = Thread.currentThread().getContextClassLoader().getResource("avroDecimal");
            String location = new File(url.getFile()).toURI().toString();
            String tableName = "tab1";
            String avroSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |  \"name\": \"test_record\",\n        |  \"type\": \"record\",\n        |  \"fields\": [ {\n        |    \"name\": \"f0\",\n        |    \"type\": [\n        |      \"null\",\n        |      {\n        |        \"precision\": 38,\n        |        \"scale\": 2,\n        |        \"type\": \"bytes\",\n        |        \"logicalType\": \"decimal\"\n        |      }\n        |    ]\n        |  } ]\n        |}\n        "));
            this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.versionSpark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + tableName + "\n           |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n           |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n           |STORED AS\n           |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n           |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n           |LOCATION '" + location + "'\n           |TBLPROPERTIES ('avro.schema.literal' = '" + avroSchema + "')\n           ")));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.versionSpark().table(tableName).collect());
                Row[] $org_scalatest_assert_macro_right = (Row[])this.versionSpark().sql("SELECT 1.30").collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
        this.test("SPARK-17920: Insert into/overwrite avro table", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Utils$.MODULE$.isWindows(), "org.apache.spark.util.Utils.isWindows", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 913));
            this.withTempDir((Function1 & Serializable)dir -> {
                HiveClientSuite.$anonfun$new$110(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
    }
}

