/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveVersionSuite;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u0013&\u0001IB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006/\u0002!\t\u0005\u0017\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u00191\u0007\u0001)A\u0005?\"9q\r\u0001b\u0001\n\u0013A\u0007BB5\u0001A\u0003%a\tC\u0004k\u0001\t\u0007I\u0011\u00025\t\r-\u0004\u0001\u0015!\u0003G\u0011\u001da\u0007A1A\u0005\n5DaA\u001f\u0001!\u0002\u0013q\u0007bB>\u0001\u0005\u0004%I!\u001c\u0005\u0007y\u0002\u0001\u000b\u0011\u00028\t\u000fu\u0004!\u0019!C\u0005}\"9\u0011Q\u0001\u0001!\u0002\u0013y\b\u0002CA\u0004\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005%\u0001\u0001)A\u0005\u007f\"A\u00111\u0002\u0001C\u0002\u0013%a\u0010C\u0004\u0002\u000e\u0001\u0001\u000b\u0011B@\t\u0011\u0005=\u0001A1A\u0005\nyDq!!\u0005\u0001A\u0003%q\u0010C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016!A\u0011Q\u0004\u0001!\u0002\u0013\t9\u0002C\u0005\u0002 \u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011q\u0006\u0001!\u0002\u0013\t\u0019\u0003C\u0006\u00022\u0001\u0001\r\u00111A\u0005\n\u0005M\u0002bCA\u001e\u0001\u0001\u0007\t\u0019!C\u0005\u0003{A1\"a\u0011\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00026!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\u0007\u0003O\u0002A\u0011\t-\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l!9\u0011\u0011\u000e\u0001\u0005\n\u0005\u0005\u0006bBA5\u0001\u0011%\u0011Q\u0018\u0005\b\u0003S\u0002A\u0011BAg\u0005mA\u0015N^3QCJ$\u0018\u000e^5p]\u001aKG\u000e^3sS:<7+^5uK*\u0011aeJ\u0001\u0007G2LWM\u001c;\u000b\u0005!J\u0013\u0001\u00025jm\u0016T!AK\u0016\u0002\u0007M\fHN\u0003\u0002-[\u0005)1\u000f]1sW*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001a8{A\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u0011\u0011&4XMV3sg&|gnU;ji\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u0018\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u001f:\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\u001c\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bQ\u0001\u001d7b]NT!AQ\u0015\u0002\u0011\r\fG/\u00197zgRL!\u0001R \u0003\u0013M\u000bF\nS3ma\u0016\u0014\u0018a\u0002<feNLwN\u001c\t\u0003\u000fBs!\u0001\u0013(\u0011\u0005%cU\"\u0001&\u000b\u0005-\u000b\u0014A\u0002\u001fs_>$hHC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyE*\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(M\u0003\u0019a\u0014N\\5u}Q\u0011QK\u0016\t\u0003i\u0001AQ!\u0012\u0002A\u0002\u0019\u000b!BY3g_J,W)Y2i)\u0005I\u0006C\u0001.\\\u001b\u0005a\u0015B\u0001/M\u0005\u0011)f.\u001b;\u0002\u001fQ\u0014\u0018\u0010R5sK\u000e$8+\u001d7LKf,\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fA\u0001\\1oO*\tA-\u0001\u0003kCZ\f\u0017BA)b\u0003A!(/\u001f#je\u0016\u001cGoU9m\u0017\u0016L\b%A\u0006gC2d'-Y2l\u0017\u0016LX#\u0001$\u0002\u0019\u0019\fG\u000e\u001c2bG.\\U-\u001f\u0011\u0002'A\u0014XO\\5oO\u001a\u000b7\u000f\u001e$bY2\u0014\u0017mY6\u0002)A\u0014XO\\5oO\u001a\u000b7\u000f\u001e$bY2\u0014\u0017mY6!\u0003\u001d!7OV1mk\u0016,\u0012A\u001c\t\u0003_^t!\u0001];\u000e\u0003ET!A]:\u0002\u0013%lW.\u001e;bE2,'B\u0001;M\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mF\fQAU1oO\u0016L!\u0001_=\u0003\u0013%s7\r\\;tSZ,'B\u0001<r\u0003!!7OV1mk\u0016\u0004\u0013A\u00025WC2,X-A\u0004i-\u0006dW/\u001a\u0011\u0002\u0015\rDWO\\6WC2,X-F\u0001\u0000!\u0011\u0001\u0018\u0011A0\n\u0007\u0005\r\u0011OA\u0002TKF\f1b\u00195v].4\u0016\r\\;fA\u0005IA-\u0019;f-\u0006dW/Z\u0001\u000bI\u0006$XMV1mk\u0016\u0004\u0013\u0001\u00043bi\u0016\u001cFO\u001d,bYV,\u0017!\u00043bi\u0016\u001cFO\u001d,bYV,\u0007%A\tuS6,7\u000f^1naN#(OV1mk\u0016\f!\u0003^5nKN$\u0018-\u001c9TiJ4\u0016\r\\;fA\u0005\u0011B/Z:u!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\t\t9\u0002E\u0002[\u00033I1!a\u0007M\u0005\rIe\u000e^\u0001\u0014i\u0016\u001cH\u000fU1si&$\u0018n\u001c8D_VtG\u000fI\u0001\u000egR|'/Y4f\r>\u0014X.\u0019;\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%\u0012)A\u0004dCR\fGn\\4\n\t\u00055\u0012q\u0005\u0002\u0015\u0007\u0006$\u0018\r\\8h'R|'/Y4f\r>\u0014X.\u0019;\u0002\u001dM$xN]1hK\u001a{'/\\1uA\u000512\r\\5f]R<\u0016\u000e\u001e5pkR$\u0015N]3diN\u000bH.\u0006\u0002\u00026A\u0019A'a\u000e\n\u0007\u0005eRE\u0001\u0006ISZ,7\t\\5f]R\f!d\u00197jK:$x+\u001b;i_V$H)\u001b:fGR\u001c\u0016\u000f\\0%KF$2!WA \u0011%\t\teGA\u0001\u0002\u0004\t)$A\u0002yIE\nqc\u00197jK:$x+\u001b;i_V$H)\u001b:fGR\u001c\u0016\u000f\u001c\u0011\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0003k\tI\u0005C\u0004\u0002Lu\u0001\r!!\u0014\u0002\u0019Q\u0014\u0018\u0010R5sK\u000e$8+\u001d7\u0011\u0007i\u000by%C\u0002\u0002R1\u0013qAQ8pY\u0016\fg.\u0001\u0003biR\u0014H\u0003BA,\u0003G\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;\n\u0015aC3yaJ,7o]5p]NLA!!\u0019\u0002\\\tI\u0011\t\u001e;sS\n,H/\u001a\u0005\u0007\u0003Kr\u0002\u0019\u0001$\u0002\t9\fW.Z\u0001\nE\u00164wN]3BY2\fq\u0004^3ti6+G/Y:u_J,\u0007+\u0019:uSRLwN\u001c$jYR,'/\u001b8h)=I\u0016QNA<\u0003\u0017\u000by)!&\u0002\u001a\u0006u\u0005bBA8A\u0001\u0007\u0011\u0011O\u0001\u000bM&dG/\u001a:FqB\u0014\b\u0003BA-\u0003gJA!!\u001e\u0002\\\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u0005e\u0004\u00051\u0001\u0002|\u0005QQ\r\u001f9fGR,G\rR:\u0011\r\u0005u\u0014qQA\f\u001d\u0011\ty(a!\u000f\u0007%\u000b\t)C\u0001N\u0013\r\t)\tT\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019!!#\u000b\u0007\u0005\u0015E\nC\u0004\u0002\u000e\u0002\u0002\r!a\u001f\u0002\u0013\u0015D\b/Z2uK\u0012D\u0005bBAIA\u0001\u0007\u00111S\u0001\u000fKb\u0004Xm\u0019;fI\u000eCWO\\6t!\u0015\ti(a\"G\u0011\u001d\t9\n\ta\u0001\u0003'\u000b\u0011\"\u001a=qK\u000e$X\r\u001a#\t\u000f\u0005m\u0005\u00051\u0001\u0002\u0014\u0006yQ\r\u001f9fGR,G\rR1uKN$(\u000fC\u0004\u0002 \u0002\u0002\r!a%\u0002)\u0015D\b/Z2uK\u0012$\u0016.\\3ti\u0006l\u0007o\u001d;s)EI\u00161UAS\u0003O\u000bI+a+\u0002.\u0006=\u00161\u0017\u0005\b\u0003_\n\u0003\u0019AA9\u0011\u001d\tI(\ta\u0001\u0003wBq!!$\"\u0001\u0004\tY\bC\u0004\u0002\u0012\u0006\u0002\r!a%\t\u000f\u0005]\u0015\u00051\u0001\u0002\u0014\"9\u00111T\u0011A\u0002\u0005M\u0005bBAYC\u0001\u0007\u00111S\u0001\u0015Kb\u0004Xm\u0019;fIRKW.Z:uC6\u00048\u000b\u001e:\t\u000f\u0005U\u0016\u00051\u0001\u00028\u0006IAO]1og\u001a|'/\u001c\t\b5\u0006e\u0016\u0011OA9\u0013\r\tY\f\u0014\u0002\n\rVt7\r^5p]F\"R!WA`\u0003\u0003Dq!a\u001c#\u0001\u0004\t\t\bC\u0004\u0002D\n\u0002\r!!2\u0002-\u0015D\b/Z2uK\u0012\u0004\u0016M\u001d;ji&|gnQ;cKN\u0004b!! \u0002\b\u0006\u001d\u0007c\u0004.\u0002J\u0006m\u00141PAJ\u0003'\u000b\u0019*a%\n\u0007\u0005-GJ\u0001\u0004UkBdWM\u000e\u000b\b3\u0006=\u0017\u0011[Aj\u0011\u001d\tyg\ta\u0001\u0003cBq!a1$\u0001\u0004\t)\rC\u0004\u00026\u000e\u0002\r!a.")
public class HivePartitionFilteringSuite
extends HiveVersionSuite
implements SQLHelper {
    private final String tryDirectSqlKey;
    private final String fallbackKey;
    private final String pruningFastFallback;
    private final Range.Inclusive dsValue;
    private final Range.Inclusive hValue;
    private final Seq<String> chunkValue;
    private final Seq<String> dateValue;
    private final Seq<String> dateStrValue;
    private final Seq<String> timestampStrValue;
    private final int testPartitionCount;
    private final CatalogStorageFormat storageFormat;
    private HiveClient clientWithoutDirectSql;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        HivePartitionFilteringSuite hivePartitionFilteringSuite = this;
        synchronized (hivePartitionFilteringSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        System.gc();
    }

    private String tryDirectSqlKey() {
        return this.tryDirectSqlKey;
    }

    private String fallbackKey() {
        return this.fallbackKey;
    }

    private String pruningFastFallback() {
        return this.pruningFastFallback;
    }

    private Range.Inclusive dsValue() {
        return this.dsValue;
    }

    private Range.Inclusive hValue() {
        return this.hValue;
    }

    private Seq<String> chunkValue() {
        return this.chunkValue;
    }

    private Seq<String> dateValue() {
        return this.dateValue;
    }

    private Seq<String> dateStrValue() {
        return this.dateStrValue;
    }

    private Seq<String> timestampStrValue() {
        return this.timestampStrValue;
    }

    private int testPartitionCount() {
        return this.testPartitionCount;
    }

    private CatalogStorageFormat storageFormat() {
        return this.storageFormat;
    }

    private HiveClient clientWithoutDirectSql() {
        return this.clientWithoutDirectSql;
    }

    private void clientWithoutDirectSql_$eq(HiveClient x$1) {
        this.clientWithoutDirectSql = x$1;
    }

    private HiveClient init(boolean tryDirectSql) {
        IndexedSeq partitions;
        Configuration hadoopConf = new Configuration();
        hadoopConf.setBoolean(this.tryDirectSqlKey(), tryDirectSql);
        hadoopConf.set("hive.metastore.warehouse.dir", Utils$.MODULE$.createTempDir().toURI().toString());
        HiveClient client = this.buildClient(hadoopConf);
        StructType tableSchema = new StructType().add("value", "int").add("ds", "int").add("h", "int").add("chunk", "string").add("d", "date").add("datestr", "string").add("timestampstr", "string");
        TableIdentifier x$1 = TableIdentifier$.MODULE$.apply("test", (Option)new Some((Object)"default"));
        CatalogTableType x$2 = CatalogTableType$.MODULE$.MANAGED();
        StructType x$3 = tableSchema;
        .colon.colon x$4 = new .colon.colon((Object)"ds", (List)new .colon.colon((Object)"h", (List)new .colon.colon((Object)"chunk", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"datestr", (List)new .colon.colon((Object)"timestampstr", (List)Nil$.MODULE$))))));
        CatalogStorageFormat x$5 = this.storageFormat();
        Option x$6 = CatalogTable$.MODULE$.apply$default$5();
        Option x$7 = CatalogTable$.MODULE$.apply$default$7();
        String x$8 = CatalogTable$.MODULE$.apply$default$8();
        long x$9 = CatalogTable$.MODULE$.apply$default$9();
        long x$10 = CatalogTable$.MODULE$.apply$default$10();
        String x$11 = CatalogTable$.MODULE$.apply$default$11();
        Map x$12 = CatalogTable$.MODULE$.apply$default$12();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Option x$16 = CatalogTable$.MODULE$.apply$default$16();
        Seq x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        boolean x$19 = CatalogTable$.MODULE$.apply$default$19();
        Map x$20 = CatalogTable$.MODULE$.apply$default$20();
        Option x$21 = CatalogTable$.MODULE$.apply$default$21();
        CatalogTable table = new CatalogTable(x$1, x$2, x$5, x$3, x$6, (Seq)x$4, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        client.createTable(table, false);
        IndexedSeq $org_scalatest_assert_macro_left = partitions = (IndexedSeq)this.dsValue().flatMap((Function1 & Serializable)ds -> HivePartitionFilteringSuite.$anonfun$init$1(this, BoxesRunTime.unboxToInt((Object)ds)));
        int $org_scalatest_assert_macro_right = this.testPartitionCount();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        client.createPartitions(table, (Seq)partitions, false);
        return client;
    }

    private Attribute attr(String name) {
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])this.client().getTable("default", "test").partitionSchema().fields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)HivePartitionFilteringSuite.$anonfun$attr$1(name, field)));
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField field2 = (StructField)some.value();
            String x$1 = field2.name();
            DataType x$2 = field2.dataType();
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
            return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        }
        if (None$.MODULE$.equals(option)) {
            throw this.fail("Illegal name of partition attribute: " + name, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }
        throw new MatchError((Object)option);
    }

    public void beforeAll() {
        super.beforeAll();
        this.client_$eq(this.init(true));
        this.clientWithoutDirectSql_$eq(this.init(false));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr, Seq<String> expectedTimestampstr) {
        Tuple6 tuple6 = new Tuple6(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr, expectedTimestampstr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple6<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple6), (Function1<Expression, Expression>)(Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr, Seq<String> expectedTimestampStr, Function1<Expression, Expression> transform) {
        Tuple6 tuple6 = new Tuple6(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr, expectedTimestampStr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple6<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple6), transform);
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple6<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes) {
        this.testMetastorePartitionFiltering(filterExpr, expectedPartitionCubes, (Function1<Expression, Expression>)(Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple6<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes, Function1<Expression, Expression> transform) {
        int actualFilteredPartitionCount;
        Seq filteredPartitions = this.client().getPartitionsByFilter(this.client().getRawHiveTable("default", "test"), (Seq)new .colon.colon((Object)((Expression)transform.apply((Object)filterExpr)), (List)Nil$.MODULE$));
        int expectedPartitionCount = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)expectedPartitionCubes.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$3(x0$1)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Seq expectedPartitions = (Seq)((IterableOnceOps)expectedPartitionCubes.map((Function1 & Serializable)x0$2 -> {
            Tuple6 tuple6 = x0$2;
            if (tuple6 != null) {
                Seq expectedDs = (Seq)tuple6._1();
                Seq expectedH = (Seq)tuple6._2();
                Seq expectedChunks = (Seq)tuple6._3();
                Seq expectedD = (Seq)tuple6._4();
                Seq expectedDatestr = (Seq)tuple6._5();
                Seq expectedTimestampStr = (Seq)tuple6._6();
                return (Seq)expectedDs.flatMap((Function1 & Serializable)ds -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$5(expectedH, expectedChunks, expectedD, expectedDatestr, expectedTimestampStr, BoxesRunTime.unboxToInt((Object)ds)));
            }
            throw new MatchError((Object)tuple6);
        })).reduce((Function2 & Serializable)(x$5, x$6) -> (Seq)x$5.$plus$plus((IterableOnce)x$6));
        int $org_scalatest_assert_macro_left = actualFilteredPartitionCount = filteredPartitions.size();
        int $org_scalatest_assert_macro_right = expectedPartitionCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected " + expectedPartitionCount + " partitions but got " + actualFilteredPartitionCount), Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
        Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)filteredPartitions.map((Function1 & Serializable)x$7 -> x$7.spec().toSet())).toSet();
        Set $org_scalatest_assert_macro_right2 = expectedPartitions.toSet();
        Set set = $org_scalatest_assert_macro_left2;
        Set set2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
    }

    public static final /* synthetic */ Seq $anonfun$init$2(HivePartitionFilteringSuite $this, int ds$1, int h) {
        return (Seq)$this.chunkValue().flatMap((Function1 & Serializable)chunk -> (Seq)$this.dateValue().flatMap((Function1 & Serializable)date -> (Seq)$this.dateStrValue().flatMap((Function1 & Serializable)dateStr -> (Seq)$this.timestampStrValue().map((Function1 & Serializable)timestampStr -> new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), date), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), dateStr), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampstr"), timestampStr)})), $this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6())))));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$init$1(HivePartitionFilteringSuite $this, int ds) {
        return (IndexedSeq)$this.hValue().flatMap((Function1 & Serializable)h -> HivePartitionFilteringSuite.$anonfun$init$2($this, ds, BoxesRunTime.unboxToInt((Object)h)));
    }

    public static final /* synthetic */ boolean $anonfun$attr$1(String name$1, StructField field) {
        return field.name().equals(name$1);
    }

    private final void check$1(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)result, this.dateValue(), this.dateStrValue(), this.timestampStrValue());
    }

    private final void check$2(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)result, this.dateStrValue(), this.timestampStrValue());
    }

    public static final /* synthetic */ void $anonfun$new$66(HivePartitionFilteringSuite $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            String pruningFastFallbackEnabled = (String)tuple2._1();
            Seq prunedPartition = (Seq)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pruningFastFallback()), (Object)pruningFastFallbackEnabled)}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)$this.attr("datestr")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20200104)), (Seq<Object>)$this.dsValue(), (Seq<Object>)$this.hValue(), $this.chunkValue(), $this.dateValue(), (Seq<String>)prunedPartition, $this.timestampStrValue()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$testMetastorePartitionFiltering$3(Tuple6 x0$1) {
        Tuple6 tuple6 = x0$1;
        if (tuple6 != null) {
            Seq expectedDs = (Seq)tuple6._1();
            Seq expectedH = (Seq)tuple6._2();
            Seq expectedChunks = (Seq)tuple6._3();
            Seq expectedD = (Seq)tuple6._4();
            Seq expectedDatestr = (Seq)tuple6._5();
            Seq expectedTimestampStr = (Seq)tuple6._6();
            return expectedDs.size() * expectedH.size() * expectedChunks.size() * expectedD.size() * expectedDatestr.size() * expectedTimestampStr.size();
        }
        throw new MatchError((Object)tuple6);
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$6(Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, Seq expectedTimestampStr$1, int ds$2, int h) {
        return (Seq)expectedChunks$1.flatMap((Function1 & Serializable)chunk -> (Seq)expectedD$1.flatMap((Function1 & Serializable)d -> (Seq)expectedDatestr$1.flatMap((Function1 & Serializable)datestr -> (Seq)expectedTimestampStr$1.map((Function1 & Serializable)timestampstr -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), d), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), datestr), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampstr"), timestampstr)}))))));
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$5(Seq expectedH$1, Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, Seq expectedTimestampStr$1, int ds) {
        return (Seq)expectedH$1.flatMap((Function1 & Serializable)h -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$6(expectedChunks$1, expectedD$1, expectedDatestr$1, expectedTimestampStr$1, ds, BoxesRunTime.unboxToInt((Object)h)));
    }

    public HivePartitionFilteringSuite(String version) {
        super(version);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        this.tryDirectSqlKey = HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname;
        this.fallbackKey = SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FALLBACK_ON_EXCEPTION().key();
        this.pruningFastFallback = SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FAST_FALLBACK().key();
        this.dsValue = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170103);
        this.hValue = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4);
        this.chunkValue = new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))));
        this.dateValue = new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)new .colon.colon((Object)ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME(), (List)Nil$.MODULE$))));
        this.dateStrValue = new .colon.colon((Object)"2020-01-01", (List)new .colon.colon((Object)"2020-01-02", (List)new .colon.colon((Object)"2020-01-03", (List)new .colon.colon((Object)"20200104", (List)new .colon.colon((Object)"20200105", (List)Nil$.MODULE$)))));
        this.timestampStrValue = new .colon.colon((Object)"2021-01-01 00:00:00", (List)new .colon.colon((Object)"2021-01-02 00:00:00", (List)Nil$.MODULE$));
        this.testPartitionCount = this.dsValue().size() * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size() * this.timestampStrValue().size();
        this.storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        this.test("getPartitionsByFilter returns all partitions when " + this.fallbackKey() + "=true", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"true")}), (Function0 & Serializable)() -> {
            Seq filteredPartitions;
            Seq $org_scalatest_assert_macro_left = filteredPartitions = this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = this.testPartitionCount();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("getPartitionsByFilter should fail when " + this.fallbackKey() + "=false", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"false")}), (Function0 & Serializable)() -> {
            RuntimeException e = (RuntimeException)this.intercept((Function0 & Serializable)() -> this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Caught Hive MetaException";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("getPartitionsByFilter: ds<=>20170101", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("getPartitionsByFilter: ds=20170101", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("getPartitionsByFilter: ds=(20170101 + 1) and h=0", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 0), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("getPartitionsByFilter: chunk='aa'", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("aa")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)"aa"), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("getPartitionsByFilter: cast(chunk as int)=1 (not a valid partition predicate)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("getPartitionsByFilter: cast(chunk as boolean)=true (not a valid partition predicate)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)BooleanType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.booleanToLiteral(true)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("getPartitionsByFilter: 20170101=ds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$eq$eq$eq((Expression)this.attr("ds")), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("getPartitionsByFilter: ds=20170101 and h=2", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("getPartitionsByFilter: cast(ds as long)=20170101L and h=2", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(20170101L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("getPartitionsByFilter: ds=20170101 or ds=20170102", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170102), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using IN expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using IN expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using INSET expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof In) {
                In in = (In)expression;
                Expression v = in.value();
                Seq list = in.list();
                if (in.inSetConvertible()) {
                    return new InSet(v, ((IterableOnceOps)list.map((Function1 & Serializable)x$2 -> x$2.eval(package$.MODULE$.EmptyRow()))).toSet());
                }
            }
            throw new MatchError((Object)expression);
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using INSET expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable)x0$2 -> {
            Expression expression = x0$2;
            if (expression instanceof In) {
                In in = (In)expression;
                Expression v = in.value();
                Seq list = in.list();
                if (in.inSetConvertible()) {
                    return new InSet(v, ((IterableOnceOps)list.map((Function1 & Serializable)x$3 -> x$3.eval(package$.MODULE$.EmptyRow()))).toSet());
                }
            }
            throw new MatchError((Object)expression);
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using IN expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)"ba").$colon$colon((Object)"ab"), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using INSET expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)"ba").$colon$colon((Object)"ab"), this.dateValue(), this.dateStrValue(), this.timestampStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable)x0$3 -> {
            Expression expression = x0$3;
            if (expression instanceof In) {
                In in = (In)expression;
                Expression v = in.value();
                Seq list = in.list();
                if (in.inSetConvertible()) {
                    return new InSet(v, ((IterableOnceOps)list.map((Function1 & Serializable)x$4 -> x$4.eval(package$.MODULE$.EmptyRow()))).toSet());
                }
            }
            throw new MatchError((Object)expression);
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<2)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple6 day1 = new Tuple6((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue());
            Tuple6 day2 = new Tuple6((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue());
            Tuple6 tuple6 = day1;
            Tuple6 tuple62 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2)))), (Seq<Tuple6<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple62).$colon$colon((Object)tuple6));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<(1+1))", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple6 day1 = new Tuple6((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue());
            Tuple6 day2 = new Tuple6((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue());
            Tuple6 tuple6 = day1;
            Tuple6 tuple62 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))))), (Seq<Tuple6<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple62).$colon$colon((Object)tuple6));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((ds=20170101 and h>=2) or (ds=20170102 and h<2))", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple6 day1 = new Tuple6((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 4), (Object)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue(), this.timestampStrValue());
            Tuple6 day2 = new Tuple6((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1), (Object)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue(), this.timestampStrValue());
            Tuple6 tuple6 = day1;
            Tuple6 tuple62 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2))))), (Seq<Tuple6<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple62).$colon$colon((Object)tuple6));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        this.test("getPartitionsByFilter: chunk contains bb", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).contains((Expression)package.expressions$.MODULE$.stringToLiteral("bb")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)new .colon.colon((Object)"bb", (List)Nil$.MODULE$), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        this.test("getPartitionsByFilter: chunk startsWith b", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).startsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        this.test("getPartitionsByFilter: chunk endsWith b", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).endsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((cast(ds as string)>'20170102')", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)StringType$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.stringToLiteral("20170102"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        this.test("getPartitionsByFilter: ds<>20170101", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("getPartitionsByFilter: h<>0 and chunk<>ab and d<>2019-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$bang$eq((Expression)package.expressions$.MODULE$.stringToLiteral("ab")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), (Seq<String>)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))), (Seq<String>)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        this.test("getPartitionsByFilter: d=2019-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)new .colon.colon((Object)"2019-01-01", (List)Nil$.MODULE$), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("getPartitionsByFilter: d>2019-01-02", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-02"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.test("getPartitionsByFilter: In(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$)).map((Function1 & Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$)), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        this.test("getPartitionsByFilter: InSet(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)new InSet((Expression)this.attr("d"), (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02"}))).map((Function1 & Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)).eval(package$.MODULE$.EmptyRow()))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$)), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        this.test("getPartitionsByFilter: not in/inset string type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"aa"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"ab"), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)));
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"aa"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"ab"), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$))))), this.chunkValue());
            Object[] objectArray = new Object[2];
            Literal qual$1 = Literal$.MODULE$.apply((Object)"aa");
            InternalRow x$1 = qual$1.eval$default$1();
            objectArray[0] = qual$1.eval(x$1);
            Literal qual$2 = Literal$.MODULE$.apply((Object)"ab");
            InternalRow x$2 = qual$2.eval$default$1();
            objectArray[1] = qual$2.eval(x$2);
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)));
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"aa", "ab", null})))), this.chunkValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        this.test("getPartitionsByFilter: not in/inset date type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$));
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$))))), this.dateValue());
            Object[] objectArray = new Object[2];
            Literal qual$3 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$3 = qual$3.eval$default$1();
            objectArray[0] = qual$3.eval(x$3);
            Literal qual$4 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$4 = qual$4.eval$default$1();
            objectArray[1] = qual$4.eval(x$4);
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$));
            Object[] objectArray2 = new Object[3];
            Literal qual$5 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$5 = qual$5.eval$default$1();
            objectArray2[0] = qual$5.eval(x$5);
            Literal qual$6 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$6 = qual$6.eval$default$1();
            objectArray2[1] = qual$6.eval(x$6);
            objectArray2[2] = null;
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray2)))), this.dateValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        this.test("getPartitionsByFilter: cast(datestr as date)= 2020-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).cast((DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2020-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)filterExpr, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL with other filter", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)filterExpr).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)new .colon.colon((Object)"2019-01-01", (List)Nil$.MODULE$), this.dateStrValue(), this.timestampStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
        this.test("getPartitionsByFilter: d =!= 2019-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        this.test("getPartitionsByFilter: d =!= 2019-01-01 || IS NULL", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull()), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        this.test("getPartitionsByFilter: d <=> 2019-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        this.test("getPartitionsByFilter: d <=> null", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)new Literal(null, (DataType)DateType$.MODULE$)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
        this.test("SPARK-35437: getPartitionsByFilter: substr(chunk,0,1)=a", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ab", (List)Nil$.MODULE$))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.chunkValue()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Substring((Expression)this.attr("chunk"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)t._2()), this.dateValue(), this.dateStrValue(), this.timestampStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        this.test("SPARK-35437: getPartitionsByFilter: year(d)=2019", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.dateValue()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Year((Expression)this.attr("d"))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2019)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)t._2()), this.dateStrValue(), this.timestampStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
        this.test("SPARK-35437: getPartitionsByFilter: datestr=concat(2020-,01-,01)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"2020-01-01", (List)Nil$.MODULE$)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.dateStrValue()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).$eq$eq$eq((Expression)new Concat((Seq)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("2020-"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("01-"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("01"), (List)Nil$.MODULE$))))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), (Seq<String>)((Seq)t._2()), this.timestampStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        this.test("SPARK-35437: getPartitionsByFilter: ds=20170101 when " + this.fallbackKey() + "=true", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), (Object)"true")}), (Function0 & Serializable)() -> {
            Seq filteredPartitions;
            Seq $org_scalatest_assert_macro_left = filteredPartitions = this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = 1 * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size() * this.timestampStrValue().size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
        this.test("SPARK-35437: getPartitionsByFilter: relax cast if does not need timezone", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            if (!SQLConf$.MODULE$.get().ansiEnabled()) {
                new .colon.colon((Object)new Tuple2((Object)"true", (Object)Nil$.MODULE$.$colon$colon((Object)"20200104")), (List)new .colon.colon((Object)new Tuple2((Object)"false", this.dateStrValue()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$4 -> {
                    HivePartitionFilteringSuite.$anonfun$new$66(this, x0$4);
                    return BoxedUnit.UNIT;
                });
                new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)pruningFastFallbackEnabled -> {
                    this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), (Object)pruningFastFallbackEnabled)}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("timestampstr")).cast((DataType)TimestampType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.timestampToLiteral(Timestamp.valueOf("2021-01-01 00:00:00"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), this.timestampStrValue()));
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
    }
}

