/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00114A!\u0003\u0006\u0001/!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u0018\u0001A\u0003%\u0001\u0006C\u00031\u0001\u0011\u0005\u0013\u0007C\u00039\u0001\u0011\u0005\u0013\u0007C\u0003:\u0001\u0011\u0005\u0013\u0007C\u0003;\u0001\u0011%1\bC\u0004Y\u0001E\u0005I\u0011B-\u0003E!Kg/Z%oG>l\u0007/\u0019;jE2,7i\u001c7UsB,7\t[1oO\u0016\u001cV/\u001b;f\u0015\tYA\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QBD\u0001\u0005Q&4XM\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003AI!a\u0007\t\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\ti\u0002%D\u0001\u001f\u0015\tyB\"\u0001\u0003uKN$\u0018BA\u0011\u001f\u0005E!Vm\u001d;ISZ,7+\u001b8hY\u0016$xN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"!\n\u0001\u000e\u0003)\tqaY1uC2|w-F\u0001)!\tIS&D\u0001+\u0015\t13F\u0003\u0002-\u001d\u0005A1-\u0019;bYf\u001cH/\u0003\u0002/U\tyQ\t\u001f;fe:\fGnQ1uC2|w-\u0001\u0005dCR\fGn\\4!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u00013!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0011)f.\u001b;\u0002\u0013\u00054G/\u001a:FC\u000eD\u0017\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0002\u001dQ,7\u000f^!mi\u0016\u0014H+\u00192mKR)!\u0007P%L'\")Qh\u0002a\u0001}\u0005IA/\u00192mK:\u000bW.\u001a\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005#T\"\u0001\"\u000b\u0005\r3\u0012A\u0002\u001fs_>$h(\u0003\u0002Fi\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)E\u0007C\u0003K\u000f\u0001\u0007a(A\bde\u0016\fG/\u001a+bE2,7\u000b^7u\u0011\u0015au\u00011\u0001N\u00035)\b\u000fZ1uK\u0012\u001c6\r[3nCB\u0011a*U\u0007\u0002\u001f*\u0011\u0001KD\u0001\u0006if\u0004Xm]\u0005\u0003%>\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d!v\u0001%AA\u0002U\u000ba\u0002[5wK\u000e{W\u000e]1uS\ndW\r\u0005\u00024-&\u0011q\u000b\u000e\u0002\b\u0005>|G.Z1o\u0003a!Xm\u001d;BYR,'\u000fV1cY\u0016$C-\u001a4bk2$H\u0005N\u000b\u00025*\u0012QkW\u0016\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u0019\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002d=\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class HiveIncompatibleColTypeChangeSuite
extends SparkFunSuite
implements TestHiveSingleton {
    private final ExternalCatalog catalog;
    private boolean enableAutoThreadAudit;
    private SparkSession spark;
    private TestHiveContext hiveContext;
    private HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private ExternalCatalog catalog() {
        return this.catalog;
    }

    public void beforeAll() {
        super.beforeAll();
        this.hiveClient().runSqlHive("SET hive.metastore.disallow.incompatible.col.type.changes=true");
    }

    @Override
    public void afterEach() {
        this.catalog().listTables("default").foreach((Function1 & Serializable)t -> {
            HiveIncompatibleColTypeChangeSuite.$anonfun$afterEach$1(this, t);
            return BoxedUnit.UNIT;
        });
        this.spark().sessionState().catalog().reset();
    }

    @Override
    public void afterAll() {
        try {
            this.hiveClient().runSqlHive("SET hive.metastore.disallow.incompatible.col.type.changes=false");
        }
        finally {
            TestHiveSingleton.afterAll$(this);
        }
    }

    private void testAlterTable(String tableName, String createTableStmt, StructType updatedSchema, boolean hiveCompatible) {
        this.spark().sql(createTableStmt);
        CatalogTable oldTable = this.catalog().getTable("default", tableName);
        this.catalog().createTable(oldTable, true);
        this.catalog().alterTableSchema("default", tableName, updatedSchema);
        CatalogTable updatedTable = this.catalog().getTable("default", tableName);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(updatedTable.schema().fieldNames());
        String[] $org_scalatest_assert_macro_right = updatedSchema.fieldNames();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveIncompatibleColTypeChangeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    private boolean testAlterTable$default$4() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$afterEach$1(HiveIncompatibleColTypeChangeSuite $this, String t) {
        $this.catalog().dropTable("default", t, true, false);
    }

    public HiveIncompatibleColTypeChangeSuite() {
        TestHiveSingleton.$init$(this);
        this.catalog = this.spark().sessionState().catalog().externalCatalog();
        this.test("SPARK-21617: ALTER TABLE for non-compatible DataSource tables", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) USING json", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), false), new Position("HiveIncompatibleColTypeChangeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("SPARK-21617: ALTER TABLE for Hive-compatible DataSource tables", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) USING parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), new Position("HiveIncompatibleColTypeChangeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("SPARK-21617: ALTER TABLE for Hive tables", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) STORED AS parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), new Position("HiveIncompatibleColTypeChangeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("SPARK-21617: ALTER TABLE with incompatible schema on Hive-compatible table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$1 = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 string) USING parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveIncompatibleColTypeChangeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            String x$2 = "_LEGACY_ERROR_TEMP_3065";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"org.apache.hadoop.hive.ql.metadata.HiveException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"Unable to alter table. The following columns have types incompatible with the existing columns in their respective positions :\ncol")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "_LEGACY_ERROR_TEMP_3065", x$4, x$3, x$5, x$6);
        }, new Position("HiveIncompatibleColTypeChangeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        Statics.releaseFence();
    }
}

