/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.security;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.sql.hive.security.HiveHadoopDelegationTokenManagerSuite$;
import org.apache.spark.sql.hive.security.NoHiveTest$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u00192A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0013a\u0002BB\u0013\u0001A\u0003%QDA\u0013ISZ,\u0007*\u00193p_B$U\r\\3hCRLwN\u001c+pW\u0016tW*\u00198bO\u0016\u00148+^5uK*\u0011aaB\u0001\tg\u0016\u001cWO]5us*\u0011\u0001\"C\u0001\u0005Q&4XM\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u0017%\u0011ac\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005)\u0011A\u00035bI>|\u0007oQ8oMV\tQ\u0004\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!1m\u001c8g\u0015\t\u0011S\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003I}\u0011QbQ8oM&<WO]1uS>t\u0017a\u00035bI>|\u0007oQ8oM\u0002\u0002")
public class HiveHadoopDelegationTokenManagerSuite
extends SparkFunSuite {
    private final Configuration hadoopConf = new Configuration();

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public HiveHadoopDelegationTokenManagerSuite() {
        this.test("default configuration", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            HadoopDelegationTokenManager manager = new HadoopDelegationTokenManager(new SparkConf(false), this.hadoopConf(), null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(manager.isProviderLoaded("hive"), "manager.isProviderLoaded(\"hive\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveHadoopDelegationTokenManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        }, new Position("HiveHadoopDelegationTokenManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("using deprecated configurations", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false).set("spark.yarn.security.credentials.hive.enabled", "false");
            HadoopDelegationTokenManager manager = new HadoopDelegationTokenManager(sparkConf, this.hadoopConf(), null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(manager.isProviderLoaded("hive"), "manager.isProviderLoaded(\"hive\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveHadoopDelegationTokenManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("HiveHadoopDelegationTokenManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("SPARK-23209: obtain tokens when Hive classes are not available", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader noHive = new ClassLoader(null, currentLoader){
                private final ClassLoader currentLoader$1;

                public Class<?> loadClass(String name, boolean resolve) {
                    if (name.startsWith("org.apache.hive") || name.startsWith("org.apache.hadoop.hive")) {
                        throw new ClassNotFoundException(name);
                    }
                    .colon.colon prefixExcludeList = new .colon.colon((Object)"java", (List)new .colon.colon((Object)"scala", (List)new .colon.colon((Object)"com.sun.", (List)new .colon.colon((Object)"sun.", (List)new .colon.colon((Object)"jdk.", (List)Nil$.MODULE$)))));
                    if (prefixExcludeList.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$loadClass$1(name, x$1)))) {
                        return this.currentLoader$1.loadClass(name);
                    }
                    Class<?> found = this.findLoadedClass(name);
                    if (found != null) {
                        return found;
                    }
                    String classFileName = name.replaceAll("\\.", "/") + ".class";
                    InputStream in = this.currentLoader$1.getResourceAsStream(classFileName);
                    if (in != null) {
                        byte[] bytes = in.readAllBytes();
                        return this.defineClass(name, bytes, 0, bytes.length);
                    }
                    throw new ClassNotFoundException(name);
                }

                public static final /* synthetic */ boolean $anonfun$loadClass$1(String name$1, String x$1) {
                    return name$1.startsWith(x$1);
                }
                {
                    this.currentLoader$1 = currentLoader$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$loadClass$1$adapted(java.lang.String java.lang.String )}, serializedLambda);
                }
            };
            return Utils$.MODULE$.withContextClassLoader(noHive, (Function0 & Serializable)() -> {
                Class<?> test = noHive.loadClass(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(NoHiveTest$.MODULE$.getClass().getName()), "$"));
                return test.getMethod("runTest", new Class[0]).invoke(null, new Object[0]);
            });
        }, new Position("HiveHadoopDelegationTokenManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
    }
}

