/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.test;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SQLContext;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.sql.hive.test.TestHiveQueryExecution;
import org.apache.spark.sql.hive.test.TestHiveSessionStateBuilder;
import org.apache.spark.sql.hive.test.TestHiveSharedState;
import org.apache.spark.sql.hive.test.TestHiveSharedState$;
import org.apache.spark.sql.hive.test.TestHiveSparkSession$TestTable$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.thrift.protocol.TBinaryProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\t]h!B A\u0001\tc\u0005\u0002C-\u0001\u0005\u000b\u0007I\u0011B.\t\u0011\u0001\u0004!\u0011!Q\u0001\nqC\u0001\u0002\u001b\u0001\u0003\u0006\u0004%I!\u001b\u0005\tc\u0002\u0011\t\u0011)A\u0005U\"A1\u000f\u0001BC\u0002\u0013%A\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003v\u0011!i\bA!b\u0001\n\u0013q\b\"CA\u0003\u0001\t\u0005\t\u0015!\u0003\u0000\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!a\u0002\u0001\t\u0003\t)\u0002C\u0004\u0002\b\u0001!\t!a\u0007\t\u0015\u0005E\u0002\u0001#b\u0001\n\u0003\n\u0019\u0004\u0003\u0006\u00028\u0001A)\u0019!C!\u0003sA!\"!\u0010\u0001\u0011\u000b\u0007I\u0011AA \u0011\u0019)\u0005\u0001\"\u0011\u0002B!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\t\u0003\u000f\u0003\u0001\u0019!C\u0005}\"I\u0011\u0011\u0012\u0001A\u0002\u0013%\u00111\u0012\u0005\b\u0003/\u0003\u0001\u0015)\u0003\u0000\u0011\u001d\tI\n\u0001C\u0001\u00037C!\"!)\u0001\u0011\u000b\u0007I\u0011AAR\u0011)\t9\f\u0001EC\u0002\u0013\u0005\u00111\u0015\u0005\b\u0003s\u0003A\u0011BA^\u0011%\t\t\r\u0001b\u0001\n\u0003\t\u0019\r\u0003\u0005\u0002F\u0002\u0001\u000b\u0011BAT\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002`\u0002!\t!!9\t\u0013\u0005\r\bA1A\u0005\u0002\u0005\u0015\b\u0002CA|\u0001\u0001\u0006I!a:\u0007\r\u0005e\b\u0001QA~\u0011)\u0011I\u0002\tBK\u0002\u0013\u0005!1\u0004\u0005\u000b\u0005;\u0001#\u0011#Q\u0001\n\u0005=\u0004B\u0003B\u0010A\tU\r\u0011\"\u0001\u0003\"!Q!q\u0006\u0011\u0003\u0012\u0003\u0006IAa\t\t\u000f\u0005\u001d\u0001\u0005\"\u0001\u00032!I!1\b\u0011\u0002\u0002\u0013\u0005#Q\b\u0005\n\u0005\u007f\u0001\u0013\u0011!C\u0001\u0005\u0003B\u0011B!\u0013!\u0003\u0003%\tAa\u0013\t\u0013\tU\u0003%!A\u0005B\t]\u0003\"\u0003B3A\u0005\u0005I\u0011\u0001B4\u0011%\u0011Y\u0007IA\u0001\n\u0003\u0012i\u0007C\u0005\u0003r\u0001\n\t\u0011\"\u0011\u0003t!I!Q\u000f\u0011\u0002\u0002\u0013\u0005#q\u000f\u0005\n\u0005s\u0002\u0013\u0011!C!\u0005w:\u0011Ba \u0001\u0003\u0003E\tA!!\u0007\u0013\u0005e\b!!A\t\u0002\t\r\u0005bBA\u0004a\u0011\u0005!Q\u0013\u0005\n\u0005k\u0002\u0014\u0011!C#\u0005oB\u0011Ba&1\u0003\u0003%\tI!'\t\u0013\t}\u0005'!A\u0005\u0002\n\u0005fa\u0002B[\u0001%\u0011%q\u0017\u0005\n\u000bV\u0012\t\u0011)A\u0005\u0003_Bq!a\u00026\t\u0003\u0011I\fC\u0004\u0003@V\"\tA!1\t\u0015\t\r\u0007!!A\u0005\u0014\t\u0013)\r\u0003\u0006\u0003J\u0002A)\u0019!C\u0001\u0005\u0017DqAa7\u0001\t\u0003\u0011i\u000eC\u0004\u0003d\u0002!\tA!:\t\u000f\t5\b\u0001\"\u0001\u0003p\"9!1\u001f\u0001\u0005\u0002\tU(\u0001\u0006+fgRD\u0015N^3Ta\u0006\u00148nU3tg&|gN\u0003\u0002B\u0005\u0006!A/Z:u\u0015\t\u0019E)\u0001\u0003iSZ,'BA#G\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sON\u0019\u0001!T*\u0011\u00059\u000bV\"A(\u000b\u0005A#\u0015aB2mCN\u001c\u0018nY\u0005\u0003%>\u0013Ab\u00159be.\u001cVm]:j_:\u0004\"\u0001V,\u000e\u0003US!A\u0016$\u0002\u0011%tG/\u001a:oC2L!\u0001W+\u0003\u000f1{wmZ5oO\u0006\u00111oY\u0002\u0001+\u0005a\u0006CA/_\u001b\u00051\u0015BA0G\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\r\u00198\r\t\u0015\u0003\u0005\t\u0004\"a\u00194\u000e\u0003\u0011T\u0011!Z\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0012\u0014\u0011\u0002\u001e:b]NLWM\u001c;\u0002'\u0015D\u0018n\u001d;j]\u001e\u001c\u0006.\u0019:fIN#\u0018\r^3\u0016\u0003)\u00042aY6n\u0013\taGM\u0001\u0004PaRLwN\u001c\t\u0003]>l\u0011\u0001Q\u0005\u0003a\u0002\u00131\u0003V3ti\"Kg/Z*iCJ,Gm\u0015;bi\u0016\fA#\u001a=jgRLgnZ*iCJ,Gm\u0015;bi\u0016\u0004\u0003F\u0001\u0003c\u0003I\u0001\u0018M]3oiN+7o]5p]N#\u0018\r^3\u0016\u0003U\u00042aY6w!\t9\u00180D\u0001y\u0015\t1F)\u0003\u0002{q\na1+Z:tS>t7\u000b^1uK\u0006\u0019\u0002/\u0019:f]R\u001cVm]:j_:\u001cF/\u0019;fA!\u0012aAY\u0001\u000fY>\fG\rV3tiR\u000b'\r\\3t+\u0005y\bcA2\u0002\u0002%\u0019\u00111\u00013\u0003\u000f\t{w\u000e\\3b]\u0006yAn\\1e)\u0016\u001cH\u000fV1cY\u0016\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0001C\u00018\u0001\u0011\u0015I\u0016\u00021\u0001]\u0011\u0015A\u0017\u00021\u0001k\u0011\u0015\u0019\u0018\u00021\u0001v\u0011\u0015i\u0018\u00021\u0001\u0000)\u0019\tY!a\u0006\u0002\u001a!)\u0011L\u0003a\u00019\")QP\u0003a\u0001\u007fRA\u00111BA\u000f\u0003?\ty\u0003C\u0003Z\u0017\u0001\u0007A\fC\u0004\u0002\"-\u0001\r!a\t\u0002\u0015!Lg/Z\"mS\u0016tG\u000f\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tICQ\u0001\u0007G2LWM\u001c;\n\t\u00055\u0012q\u0005\u0002\u000b\u0011&4Xm\u00117jK:$\b\"B?\f\u0001\u0004y\u0018aC:iCJ,Gm\u0015;bi\u0016,\u0012!\u001c\u0015\u0003\u0019\t\fAb]3tg&|gn\u0015;bi\u0016,\u0012A\u001e\u0015\u0003\u001b\t\fA\"\\3uC\u0012\fG/\u0019%jm\u0016,\"!a\t\u0015\t\u0005\r\u00131\u000e\t\u0005\u0003\u000b\n)G\u0004\u0003\u0002H\u0005\u0005d\u0002BA%\u0003?rA!a\u0013\u0002^9!\u0011QJA.\u001d\u0011\ty%!\u0017\u000f\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016[\u0003\u0019a$o\\8u}%\t1*\u0003\u0002J\u0015&\u0011q\tS\u0005\u0003\u000b\u001aK!\u0001\u0015#\n\u0007\u0005\rt*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0014\u0011\u000e\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a\u0019P\u0011\u001d\tig\u0004a\u0001\u0003_\nqa]9m)\u0016DH\u000f\u0005\u0003\u0002r\u0005ed\u0002BA:\u0003k\u00022!!\u0015e\u0013\r\t9\bZ\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]D-\u0001\u0006oK^\u001cVm]:j_:$\"!a\u0003\u0002\u0019\rdwN\\3TKN\u001c\u0018n\u001c8\u0015\u00035\u000b1bY1dQ\u0016$\u0016M\u00197fg\u0006y1-Y2iKR\u000b'\r\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0006M\u0005cA2\u0002\u0010&\u0019\u0011\u0011\u00133\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+\u001b\u0012\u0011!a\u0001\u007f\u0006\u0019\u0001\u0010J\u0019\u0002\u0019\r\f7\r[3UC\ndWm\u001d\u0011\u0002\u001dM,GoQ1dQ\u0016$\u0016M\u00197fgR!\u0011QRAO\u0011\u0019\ty*\u0006a\u0001\u007f\u0006\t1-\u0001\u0005iSZ,\u0007j\\7f+\t\t)\u000b\u0005\u0003dW\u0006\u001d\u0006\u0003BAU\u0003gk!!a+\u000b\t\u00055\u0016qV\u0001\u0003S>T!!!-\u0002\t)\fg/Y\u0005\u0005\u0003k\u000bYK\u0001\u0003GS2,\u0017a\u00035jm\u0016$UM\u001e%p[\u0016\fA\"\u001a8w-\u0006\u0014Hk\u001c$jY\u0016$B!!*\u0002>\"9\u0011q\u0018\rA\u0002\u0005=\u0014AB3omZ\u000b'/A\u0007iSZ,g)\u001b7fgR+W\u000e]\u000b\u0003\u0003O\u000ba\u0002[5wK\u001aKG.Z:UK6\u0004\b%A\u0006hKRD\u0015N^3GS2,G\u0003BAT\u0003\u0017Dq!!4\u001c\u0001\u0004\ty'\u0001\u0003qCRD\u0017!D9v_R,\u0007*\u001b<f\r&dW\r\u0006\u0003\u0002T\u0006u\u0007\u0003BAk\u00037l!!a6\u000b\t\u0005e\u0017qV\u0001\u0005Y\u0006tw-\u0003\u0003\u0002|\u0005]\u0007bBAg9\u0001\u0007\u0011qN\u0001\u0011O\u0016$x+\u0019:fQ>,8/\u001a)bi\"$\"!a\u001c\u0002\u001d\u0011,7o\u0019:jE\u0016$G+\u00192mKV\u0011\u0011q\u001d\t\u0005\u0003S\f\u00190\u0004\u0002\u0002l*!\u0011Q^Ax\u0003!i\u0017\r^2iS:<'bAAyI\u0006!Q\u000f^5m\u0013\u0011\t)0a;\u0003\u000bI+w-\u001a=\u0002\u001f\u0011,7o\u0019:jE\u0016$G+\u00192mK\u0002\u0012\u0011\u0002V3tiR\u000b'\r\\3\u0014\u000f\u0001\niPa\u0001\u0003\nA\u00191-a@\n\u0007\t\u0005AM\u0001\u0004B]f\u0014VM\u001a\t\u0004G\n\u0015\u0011b\u0001B\u0004I\n9\u0001K]8ek\u000e$\b\u0003\u0002B\u0006\u0005'qAA!\u0004\u0003\u00129!\u0011\u0011\u000bB\b\u0013\u0005)\u0017bAA2I&!!Q\u0003B\f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\u0019\u0007Z\u0001\u0005]\u0006lW-\u0006\u0002\u0002p\u0005)a.Y7fA\u0005A1m\\7nC:$7/\u0006\u0002\u0003$A)1M!\n\u0003*%\u0019!q\u00053\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0003d\u0005W\ti)C\u0002\u0003.\u0011\u0014\u0011BR;oGRLwN\u001c\u0019\u0002\u0013\r|W.\\1oIN\u0004CC\u0002B\u001a\u0005o\u0011I\u0004E\u0002\u00036\u0001j\u0011\u0001\u0001\u0005\b\u00053)\u0003\u0019AA8\u0011\u001d\u0011y\"\na\u0001\u0005G\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAj\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011\u0019\u0005E\u0002d\u0005\u000bJ1Aa\u0012e\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011iEa\u0015\u0011\u0007\r\u0014y%C\u0002\u0003R\u0011\u00141!\u00118z\u0011%\t)\nKA\u0001\u0002\u0004\u0011\u0019%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u0006\u0005\u0004\u0003\\\t\u0005$QJ\u0007\u0003\u0005;R1Aa\u0018e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005G\u0012iF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA@\u0003j!I\u0011Q\u0013\u0016\u0002\u0002\u0003\u0007!QJ\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002T\n=\u0004\"CAKW\u0005\u0005\t\u0019\u0001B\"\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\"\u0003!!xn\u0015;sS:<GCAAj\u0003\u0019)\u0017/^1mgR\u0019qP! \t\u0013\u0005Ue&!AA\u0002\t5\u0013!\u0003+fgR$\u0016M\u00197f!\r\u0011)\u0004M\n\u0006a\t\u0015%\u0011\u0013\t\u000b\u0005\u000f\u0013i)a\u001c\u0003$\tMRB\u0001BE\u0015\r\u0011Y\tZ\u0001\beVtG/[7f\u0013\u0011\u0011yI!#\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002*\nM\u0015\u0002\u0002B\u000b\u0003W#\"A!!\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\tM\"1\u0014BO\u0011\u001d\u0011Ib\ra\u0001\u0003_BqAa\b4\u0001\u0004\u0011\u0019#\u0001\u0006v]\u0006\u0004\b\u000f\\=TKF$BAa)\u00032B!1m\u001bBS!\u001d\u0019'qUA8\u0005WK1A!+e\u0005\u0019!V\u000f\u001d7feA1!1\u0002BW\u0005SIAAa,\u0003\u0018\t\u00191+Z9\t\u0013\tMF'!AA\u0002\tM\u0012a\u0001=%a\t11+\u001d7D[\u0012\u001c2!NA\u007f)\u0011\u0011YL!0\u0011\u0007\tUR\u0007\u0003\u0004Fo\u0001\u0007\u0011qN\u0001\u0004G6$WC\u0001B\u0015\u0003\u0019\u0019\u0016\u000f\\\"nIR!!1\u0018Bd\u0011\u0019)\u0015\b1\u0001\u0002p\u0005QA/Z:u)\u0006\u0014G.Z:\u0016\u0005\t5\u0007\u0003\u0003Bh\u0005+\fyGa\r\u000e\u0005\tE'\u0002\u0002Bj\u0005;\nq!\\;uC\ndW-\u0003\u0003\u0003X\nE'a\u0002%bg\"l\u0015\r\u001d\u0015\u0003u\t\f\u0011C]3hSN$XM\u001d+fgR$\u0016M\u00197f)\u0011\tiIa8\t\u000f\t\u00058\b1\u0001\u00034\u0005IA/Z:u)\u0006\u0014G.Z\u0001\u0010O\u0016$Hj\\1eK\u0012$\u0016M\u00197fgV\u0011!q\u001d\t\u0007\u0005\u001f\u0014I/a\u001c\n\t\t-(\u0011\u001b\u0002\b\u0011\u0006\u001c\bnU3u\u00035aw.\u00193UKN$H+\u00192mKR!\u0011Q\u0012By\u0011\u001d\u0011I\"\u0010a\u0001\u0003_\nQA]3tKR$\"!!$")
public class TestHiveSparkSession
extends org.apache.spark.sql.classic.SparkSession {
    private transient TestHiveSharedState sharedState;
    private transient SessionState sessionState;
    private HiveClient metadataHive;
    private Option<File> hiveHome;
    private Option<File> hiveDevHome;
    private volatile TestHiveSparkSession$TestTable$ TestTable$module;
    private transient HashMap<String, TestTable> testTables;
    private final transient SparkContext sc;
    private transient Option<TestHiveSharedState> existingSharedState;
    private final transient Option<SessionState> parentSessionState;
    private final boolean loadTestTables;
    private boolean cacheTables;
    private final File hiveFilesTemp;
    private final Regex describedTable;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public TestHiveSparkSession$TestTable$ TestTable() {
        if (this.TestTable$module == null) {
            this.TestTable$lzycompute$1();
        }
        return this.TestTable$module;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private Option<TestHiveSharedState> existingSharedState() {
        return this.existingSharedState;
    }

    private Option<SessionState> parentSessionState() {
        return this.parentSessionState;
    }

    private boolean loadTestTables() {
        return this.loadTestTables;
    }

    private TestHiveSharedState sharedState$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.sharedState = (TestHiveSharedState)((Object)this.existingSharedState().getOrElse((Function0 & Serializable)() -> new TestHiveSharedState(this.sc(), TestHiveSharedState$.MODULE$.$lessinit$greater$default$2())));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        this.existingSharedState = null;
        return this.sharedState;
    }

    public TestHiveSharedState sharedState() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.sharedState$lzycompute();
        }
        return this.sharedState;
    }

    private SessionState sessionState$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.sessionState = new TestHiveSessionStateBuilder(this, this.parentSessionState()).build();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.sessionState;
    }

    public SessionState sessionState() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.sessionState$lzycompute();
        }
        return this.sessionState;
    }

    private HiveClient metadataHive$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataHive = ((HiveExternalCatalog)this.sharedState().externalCatalog().unwrapped()).client().newSession();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataHive;
    }

    public HiveClient metadataHive() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metadataHive$lzycompute();
        }
        return this.metadataHive;
    }

    public Dataset<Row> sql(String sqlText) {
        return (Dataset)this.withActive((Function0 & Serializable)() -> {
            LogicalPlan plan = this.sessionState().sqlParser().parsePlan(sqlText);
            return Dataset$.MODULE$.ofRows((org.apache.spark.sql.classic.SparkSession)this, plan);
        });
    }

    public TestHiveSparkSession newSession() {
        return (TestHiveSparkSession)((Object)this.withActive((Function0 & Serializable)() -> new TestHiveSparkSession(this.sc(), (Option<TestHiveSharedState>)new Some((Object)this.sharedState()), (Option<SessionState>)None$.MODULE$, this.loadTestTables())));
    }

    public org.apache.spark.sql.classic.SparkSession cloneSession() {
        return (org.apache.spark.sql.classic.SparkSession)this.withActive((Function0 & Serializable)() -> {
            TestHiveSparkSession result = new TestHiveSparkSession(this.sparkContext(), (Option<TestHiveSharedState>)new Some((Object)this.sharedState()), (Option<SessionState>)new Some((Object)this.sessionState()), this.loadTestTables());
            result.sessionState();
            result.sessionState().artifactManager();
            return result;
        });
    }

    private boolean cacheTables() {
        return this.cacheTables;
    }

    private void cacheTables_$eq(boolean x$1) {
        this.cacheTables = x$1;
    }

    public void setCacheTables(boolean c) {
        this.cacheTables_$eq(c);
    }

    private Option<File> hiveHome$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hiveHome = this.envVarToFile("HIVE_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hiveHome;
    }

    public Option<File> hiveHome() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hiveHome$lzycompute();
        }
        return this.hiveHome;
    }

    private Option<File> hiveDevHome$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hiveDevHome = this.envVarToFile("HIVE_DEV_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.hiveDevHome;
    }

    public Option<File> hiveDevHome() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.hiveDevHome$lzycompute();
        }
        return this.hiveDevHome;
    }

    private Option<File> envVarToFile(String envVar) {
        return Option$.MODULE$.apply((Object)System.getenv(envVar)).map((Function1 & Serializable)x$1 -> new File((String)x$1));
    }

    public File hiveFilesTemp() {
        return this.hiveFilesTemp;
    }

    public File getHiveFile(String path) {
        return new File(Thread.currentThread().getContextClassLoader().getResource(path).getFile());
    }

    private String quoteHiveFile(String path) {
        if (Utils$.MODULE$.isWindows()) {
            return this.getHiveFile(path).getPath().replace('\\', '/');
        }
        return this.getHiveFile(path).getPath();
    }

    public String getWarehousePath() {
        SQLConf tempConf = new SQLConf();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.sc().conf().getAll()), (Function1 & Serializable)x0$1 -> {
            TestHiveSparkSession.$anonfun$getWarehousePath$1(tempConf, x0$1);
            return BoxedUnit.UNIT;
        });
        return tempConf.warehousePath();
    }

    public Regex describedTable() {
        return this.describedTable;
    }

    public SqlCmd SqlCmd(String sql) {
        return new SqlCmd(this, sql);
    }

    private HashMap<String, TestTable> testTables$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.testTables = new HashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.testTables;
    }

    public HashMap<String, TestTable> testTables() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.testTables$lzycompute();
        }
        return this.testTables;
    }

    public void registerTestTable(TestTable testTable) {
        this.testTables().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testTable.name()), (Object)testTable));
    }

    public HashSet<String> getLoadedTables() {
        return this.sharedState().loadedTables();
    }

    public void loadTestTable(String name) {
        if (this.sessionState().catalog().getTempView(name).isEmpty() && !this.sharedState().loadedTables().contains((Object)name)) {
            this.sharedState().loadedTables().$plus$eq((Object)name);
            this.logDebug((Function0 & Serializable)() -> "Loading test table " + name);
            Seq createCmds = (Seq)this.testTables().get((Object)name).map((Function1 & Serializable)x$2 -> x$2.commands()).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error("Unknown test table " + name));
            if (this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY()) == null) {
                v0 = SQLExecution$.MODULE$.withNewExecutionId(new QueryExecution((org.apache.spark.sql.classic.SparkSession)this, (LogicalPlan)new OneRowRelation(), QueryExecution$.MODULE$.$lessinit$greater$default$3(), QueryExecution$.MODULE$.$lessinit$greater$default$4(), QueryExecution$.MODULE$.$lessinit$greater$default$5()), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0)(JFunction0.mcV.sp & Serializable)() -> createCmds.foreach((Function1 & Serializable)x$3 -> {
                    x$3.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                }));
            } else {
                createCmds.foreach((Function1 & Serializable)x$4 -> {
                    x$4.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                });
                v0 = BoxedUnit.UNIT;
            }
            if (this.cacheTables()) {
                new SQLContext((org.apache.spark.sql.classic.SparkSession)this).cacheTable(name);
                return;
            }
            return;
        }
    }

    public void reset() {
        try {
            CollectionConverters$.MODULE$.MapHasAsScala(((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration().getLoggers()).asScala().foreach((Function1 & Serializable)x0$1 -> {
                TestHiveSparkSession.$anonfun$reset$1(x0$1);
                return BoxedUnit.UNIT;
            });
            File warehouseDir = new File(new URI(this.sparkContext().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key())).getPath());
            Utils$.MODULE$.deleteRecursively(warehouseDir);
            warehouseDir.mkdir();
            this.sharedState().cacheManager().clearCache();
            this.sharedState().loadedTables().clear();
            this.sessionState().catalog().reset();
            this.sessionState().catalogManager().reset();
            this.metadataHive().reset();
            Configuration hadoopConf = this.sessionState().newHadoopConf();
            Path location = new Path(hadoopConf.get("hive.exec.scratchdir"));
            FileSystem fs = location.getFileSystem(hadoopConf);
            fs.delete(location, true);
            this.sessionState().conf().setConfString("fs.defaultFS", new File(".").toURI().toString());
            this.metadataHive().runSqlHive("RESET");
            this.metadataHive().runSqlHive("set hive.table.parameters.default=");
            this.metadataHive().runSqlHive("set hive.metastore.partition.name.whitelist.pattern=.*");
            this.sessionState().catalog().setCurrentDatabase("default");
        }
        catch (Exception e) {
            this.logError((Function0 & Serializable)() -> "FATAL ERROR: Failed to reset TestDB state.", e);
        }
    }

    private final void TestTable$lzycompute$1() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if (this.TestTable$module == null) {
                this.TestTable$module = new TestHiveSparkSession$TestTable$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(TestHiveSparkSession $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.sc().hadoopConfiguration().set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getWarehousePath$1(SQLConf tempConf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            tempConf$1.setConfString(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String createTableSQL$1(String tblName) {
        return "CREATE TABLE " + tblName + " (key INT, value STRING) STORED AS textfile";
    }

    public static final /* synthetic */ void $anonfun$new$5(TestHiveSparkSession $this, String ds$1, String hr) {
        $this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |LOAD DATA LOCAL INPATH '" + $this.quoteHiveFile("data/files/kv1.txt") + "'\n             |OVERWRITE INTO TABLE srcpart PARTITION (ds='" + ds$1 + "',hr='" + hr + "')\n          "))).cmd().apply$mcV$sp();
    }

    public static final /* synthetic */ void $anonfun$new$4(TestHiveSparkSession $this, String ds) {
        new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)hr -> {
            TestHiveSparkSession.$anonfun$new$5($this, ds, hr);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(TestHiveSparkSession $this, String ds) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)hr -> $this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |LOAD DATA LOCAL INPATH '" + $this.quoteHiveFile("data/files/kv1.txt") + "'\n             |OVERWRITE INTO TABLE srcpart1 PARTITION (ds='" + ds + "',hr='" + hr + "')\n          "))).cmd().apply$mcV$sp());
    }

    public static final /* synthetic */ void $anonfun$reset$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LoggerConfig log = (LoggerConfig)tuple2._2();
            if (!log.getName().contains("org.apache.spark")) {
                log.setLevel(Level.WARN);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public TestHiveSparkSession(SparkContext sc, Option<TestHiveSharedState> existingSharedState, Option<SessionState> parentSessionState, boolean loadTestTables) {
        block0: {
            this.sc = sc;
            this.existingSharedState = existingSharedState;
            this.parentSessionState = parentSessionState;
            this.loadTestTables = loadTestTables;
            super(sc);
            SparkSession$.MODULE$.setDefaultSession((SparkSession)this);
            SparkSession$.MODULE$.setActiveSession((SparkSession)this);
            Map metastoreTempConf = (Map)((MapOps)HiveUtils$.MODULE$.newTemporaryConfiguration(false).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_INTEGER_JDO_PUSHDOWN.varname), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.scratchdir"), (Object)TestHiveContext$.MODULE$.makeScratchDir().toURI().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY.varname), (Object)"1")})))).$plus$plus((IterableOnce)existingSharedState.map((Function1 & Serializable)state -> {
                String connKey = state.sparkContext().hadoopConfiguration().get("javax.jdo.option.ConnectionURL");
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"javax.jdo.option.ConnectionURL"), (Object)connKey);
            }));
            metastoreTempConf.foreach((Function1 & Serializable)x0$1 -> {
                TestHiveSparkSession.$anonfun$new$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            Object object = sc.conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
            String string = "hive";
            Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null));
            this.cacheTables = false;
            System.clearProperty("spark.hostPort");
            Object object2 = parentSessionState.isEmpty() ? System.setProperty("test.tmp.dir", Utils$.MODULE$.createTempDir().toURI().getPath()) : BoxedUnit.UNIT;
            this.hiveFilesTemp = File.createTempFile("catalystHiveFiles", "");
            this.hiveFilesTemp().delete();
            this.hiveFilesTemp().mkdir();
            ShutdownHookManager$.MODULE$.registerShutdownDeleteDir(this.hiveFilesTemp());
            this.describedTable = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("DESCRIBE (\\w+)"));
            if (!loadTestTables) break block0;
            Seq hiveQTestUtilTables = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestTable[]{new TestTable(this, "src", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(TestHiveSparkSession.createTableSQL$1("src")).cmd(), this.SqlCmd("LOAD DATA LOCAL INPATH '" + this.quoteHiveFile("data/files/kv1.txt") + "' INTO TABLE src").cmd()})), new TestTable(this, "src1", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(TestHiveSparkSession.createTableSQL$1("src1")).cmd(), this.SqlCmd("LOAD DATA LOCAL INPATH '" + this.quoteHiveFile("data/files/kv3.txt") + "' INTO TABLE src1").cmd()})), new TestTable(this, "srcpart", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
                this.SqlCmd(TestHiveSparkSession.createTableSQL$1("srcpart") + " PARTITIONED BY (ds STRING, hr STRING)").cmd().apply$mcV$sp();
                new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ds -> {
                    TestHiveSparkSession.$anonfun$new$4(this, ds);
                    return BoxedUnit.UNIT;
                });
            }})), new TestTable(this, "srcpart1", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
                this.SqlCmd(TestHiveSparkSession.createTableSQL$1("srcpart1") + " PARTITIONED BY (ds STRING, hr INT)").cmd().apply$mcV$sp();
                new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ds -> {
                    TestHiveSparkSession.$anonfun$new$7(this, ds);
                    return BoxedUnit.UNIT;
                });
            }})), new TestTable(this, "src_thrift", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
                this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE src_thrift(fake INT)\n           |ROW FORMAT SERDE '" + ThriftDeserializer.class.getName() + "'\n           |WITH SERDEPROPERTIES(\n           |  'serialization.class'='org.apache.spark.sql.hive.test.Complex',\n           |  'serialization.format'='" + TBinaryProtocol.class.getName() + "'\n           |)\n           |STORED AS\n           |INPUTFORMAT '" + SequenceFileInputFormat.class.getName() + "'\n           |OUTPUTFORMAT '" + SequenceFileOutputFormat.class.getName() + "'\n        "))).cmd().apply$mcV$sp();
                this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |LOAD DATA LOCAL INPATH '" + this.quoteHiveFile("data/files/complex.seq") + "'\n           |INTO TABLE src_thrift\n        "))).cmd().apply$mcV$sp();
            }})), new TestTable(this, "serdeins", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE serdeins (key INT, value STRING)\n           |ROW FORMAT SERDE '" + LazySimpleSerDe.class.getCanonicalName() + "'\n           |WITH SERDEPROPERTIES ('field.delim'='\\t')\n         "))).cmd(), this.SqlCmd("INSERT OVERWRITE TABLE serdeins SELECT * FROM src").cmd()})), new TestTable(this, "episodes", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE episodes (title STRING, air_date STRING, doctor INT)\n           |STORED AS avro\n           |TBLPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n         "))).cmd(), this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |LOAD DATA LOCAL INPATH '" + this.quoteHiveFile("data/files/episodes.avro") + "'\n           |INTO TABLE episodes\n         "))).cmd()})), new TestTable(this, "episodes_part", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE episodes_part (title STRING, air_date STRING, doctor INT)\n           |PARTITIONED BY (doctor_pt INT)\n           |STORED AS avro\n           |TBLPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n         "))).cmd(), this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |ALTER TABLE episodes_part SET SERDEPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n          "))).cmd(), this.SqlCmd("\n          INSERT OVERWRITE TABLE episodes_part PARTITION (doctor_pt=1)\n          SELECT title, air_date, doctor FROM episodes\n        ").cmd()})), new TestTable(this, "src_json", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE src_json (json STRING) STORED AS TEXTFILE\n         "))).cmd(), this.SqlCmd("LOAD DATA LOCAL INPATH '" + this.quoteHiveFile("data/files/json.txt") + "' INTO TABLE src_json").cmd()}))}));
            hiveQTestUtilTables.foreach((Function1 & Serializable)testTable -> {
                this.registerTestTable(testTable);
                return BoxedUnit.UNIT;
            });
        }
    }

    public TestHiveSparkSession(SparkContext sc, boolean loadTestTables) {
        this(sc, (Option<TestHiveSharedState>)None$.MODULE$, (Option<SessionState>)None$.MODULE$, loadTestTables);
    }

    public TestHiveSparkSession(SparkContext sc, HiveClient hiveClient, boolean loadTestTables) {
        this(sc, (Option<TestHiveSharedState>)new Some((Object)new TestHiveSharedState(sc, (Option<HiveClient>)new Some((Object)hiveClient))), (Option<SessionState>)None$.MODULE$, loadTestTables);
    }

    public class SqlCmd {
        private final String sql;
        public final /* synthetic */ TestHiveSparkSession $outer;

        public Function0<BoxedUnit> cmd() {
            return (JFunction0.mcV.sp & Serializable)() -> new TestHiveQueryExecution($this.sql).executedPlan().executeCollect();
        }

        public /* synthetic */ TestHiveSparkSession org$apache$spark$sql$hive$test$TestHiveSparkSession$SqlCmd$$$outer() {
            return this.$outer;
        }

        public SqlCmd(TestHiveSparkSession $outer, String sql) {
            this.sql = sql;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class TestTable
    implements Product,
    Serializable {
        private final String name;
        private final Seq<Function0<BoxedUnit>> commands;
        public final /* synthetic */ TestHiveSparkSession $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public Seq<Function0<BoxedUnit>> commands() {
            return this.commands;
        }

        public String productPrefix() {
            return "TestTable";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.commands();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestTable;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "commands";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestTable)) return false;
            if (((TestTable)object).org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer() != this.org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestTable testTable = (TestTable)x$1;
            String string = this.name();
            String string2 = testTable.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Function0<BoxedUnit>> seq = this.commands();
            Seq<Function0<BoxedUnit>> seq2 = testTable.commands();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!testTable.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TestHiveSparkSession org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer() {
            return this.$outer;
        }

        public TestTable(TestHiveSparkSession $outer, String name, Seq<Function0<BoxedUnit>> commands) {
            this.name = name;
            this.commands = commands;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

