/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkApplication;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$;
import org.apache.spark.deploy.k8s.submit.Client;
import org.apache.spark.deploy.k8s.submit.ClientArguments;
import org.apache.spark.deploy.k8s.submit.ClientArguments$;
import org.apache.spark.deploy.k8s.submit.DriverConfigOrchestrator;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcherImpl;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00053Q!\u0001\u0002\u0001\u00119\u00111dS;cKJtW\r^3t\u00072LWM\u001c;BaBd\u0017nY1uS>t'BA\u0002\u0005\u0003\u0019\u0019XOY7ji*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u0019!W\r\u001d7ps*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u00051\u0011B\u0001\r\u0007\u0005A\u0019\u0006/\u0019:l\u0003B\u0004H.[2bi&|g\u000eC\u0003\u001b\u0001\u0011\u0005A$\u0001\u0004=S:LGOP\u0002\u0001)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011\u0001\t\u0003\n\u0013!B:uCJ$Hc\u0001\u0012&cA\u0011\u0001cI\u0005\u0003IE\u0011A!\u00168ji\")ae\ba\u0001O\u0005!\u0011M]4t!\r\u0001\u0002FK\u0005\u0003SE\u0011Q!\u0011:sCf\u0004\"a\u000b\u0018\u000f\u0005Aa\u0013BA\u0017\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\n\u0002\"\u0002\u001a \u0001\u0004\u0019\u0014\u0001B2p]\u001a\u0004\"\u0001N\u001b\u000e\u0003!I!A\u000e\u0005\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"\u0002\u001d\u0001\t\u0013I\u0014a\u0001:v]R\u0019!EO \t\u000bm:\u0004\u0019\u0001\u001f\u0002\u001f\rd\u0017.\u001a8u\u0003J<W/\\3oiN\u0004\"AH\u001f\n\u0005y\u0012!aD\"mS\u0016tG/\u0011:hk6,g\u000e^:\t\u000b\u0001;\u0004\u0019A\u001a\u0002\u0013M\u0004\u0018M]6D_:4\u0007")
public class KubernetesClientApplication
implements SparkApplication {
    public void start(String[] args, SparkConf conf) {
        ClientArguments parsedArguments = ClientArguments$.MODULE$.fromCommandLineArgs(args);
        this.run(parsedArguments, conf);
    }

    private void run(ClientArguments clientArguments, SparkConf sparkConf) {
        String namespace = (String)sparkConf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        String kubernetesAppId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID().toString().replaceAll("-", "")}));
        long launchTime = System.currentTimeMillis();
        boolean waitForAppCompletion = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(Config$.MODULE$.WAIT_FOR_APP_COMPLETION()));
        String appName = (String)sparkConf.getOption("spark.app.name").getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "spark";
            }
        });
        String master = sparkConf.get("spark.master").substring("k8s://".length());
        None$ loggingInterval = waitForAppCompletion ? new Some(sparkConf.get(Config$.MODULE$.REPORT_INTERVAL())) : None$.MODULE$;
        LoggingPodStatusWatcherImpl watcher = new LoggingPodStatusWatcherImpl(kubernetesAppId, (Option<Object>)loggingInterval);
        DriverConfigOrchestrator orchestrator = new DriverConfigOrchestrator(kubernetesAppId, launchTime, clientArguments.mainAppResource(), appName, clientArguments.mainClass(), clientArguments.driverArgs(), sparkConf);
        Utils$.MODULE$.tryWithResource((Function0)new Serializable(this, sparkConf, namespace, master){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final String namespace$1;
            private final String master$1;

            public final KubernetesClient apply() {
                return SparkKubernetesClientFactory$.MODULE$.createKubernetesClient(this.master$1, (Option<String>)new Some((Object)this.namespace$1), Config$.MODULE$.KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX(), this.sparkConf$1, (Option<File>)None$.MODULE$, (Option<File>)None$.MODULE$);
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.namespace$1 = namespace$1;
                this.master$1 = master$1;
            }
        }, (Function1)new Serializable(this, sparkConf, waitForAppCompletion, appName, watcher, orchestrator){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final boolean waitForAppCompletion$1;
            private final String appName$1;
            private final LoggingPodStatusWatcherImpl watcher$1;
            private final DriverConfigOrchestrator orchestrator$1;

            public final void apply(KubernetesClient kubernetesClient) {
                Client client = new Client(this.orchestrator$1.getAllConfigurationSteps(), this.sparkConf$1, kubernetesClient, this.waitForAppCompletion$1, this.appName$1, this.watcher$1);
                client.run();
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.waitForAppCompletion$1 = waitForAppCompletion$1;
                this.appName$1 = appName$1;
                this.watcher$1 = watcher$1;
                this.orchestrator$1 = orchestrator$1;
            }
        });
    }
}

