/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigBuilder;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Config$
implements Logging {
    public static final Config$ MODULE$;
    private final ConfigEntry<String> KUBERNETES_NAMESPACE;
    private final OptionalConfigEntry<String> CONTAINER_IMAGE;
    private final ConfigEntry<Option<String>> DRIVER_CONTAINER_IMAGE;
    private final ConfigEntry<Option<String>> EXECUTOR_CONTAINER_IMAGE;
    private final ConfigEntry<String> CONTAINER_IMAGE_PULL_POLICY;
    private final OptionalConfigEntry<String> IMAGE_PULL_SECRETS;
    private final String KUBERNETES_AUTH_DRIVER_CONF_PREFIX;
    private final String KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX;
    private final String KUBERNETES_AUTH_CLIENT_MODE_PREFIX;
    private final String OAUTH_TOKEN_CONF_SUFFIX;
    private final String OAUTH_TOKEN_FILE_CONF_SUFFIX;
    private final String CLIENT_KEY_FILE_CONF_SUFFIX;
    private final String CLIENT_CERT_FILE_CONF_SUFFIX;
    private final String CA_CERT_FILE_CONF_SUFFIX;
    private final OptionalConfigEntry<String> KUBERNETES_SERVICE_ACCOUNT_NAME;
    private final OptionalConfigEntry<String> KUBERNETES_DRIVER_LIMIT_CORES;
    private final ConfigEntry<Object> KUBERNETES_DRIVER_SUBMIT_CHECK;
    private final OptionalConfigEntry<String> KUBERNETES_EXECUTOR_LIMIT_CORES;
    private final OptionalConfigEntry<String> KUBERNETES_EXECUTOR_REQUEST_CORES;
    private final OptionalConfigEntry<String> KUBERNETES_DRIVER_POD_NAME;
    private final ConfigEntry<String> KUBERNETES_EXECUTOR_POD_NAME_PREFIX;
    private final OptionalConfigEntry<String> KUBERNETES_PYSPARK_PY_FILES;
    private final OptionalConfigEntry<String> KUBERNETES_PYSPARK_MAIN_APP_RESOURCE;
    private final OptionalConfigEntry<String> KUBERNETES_PYSPARK_APP_ARGS;
    private final OptionalConfigEntry<String> KUBERNETES_R_MAIN_APP_RESOURCE;
    private final OptionalConfigEntry<String> KUBERNETES_R_APP_ARGS;
    private final ConfigEntry<Object> KUBERNETES_ALLOCATION_BATCH_SIZE;
    private final ConfigEntry<Object> KUBERNETES_ALLOCATION_BATCH_DELAY;
    private final ConfigEntry<Object> KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS;
    private final ConfigEntry<Object> WAIT_FOR_APP_COMPLETION;
    private final ConfigEntry<Object> REPORT_INTERVAL;
    private final ConfigEntry<Object> KUBERNETES_EXECUTOR_API_POLLING_INTERVAL;
    private final ConfigEntry<Object> KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL;
    private final ConfigEntry<Object> MEMORY_OVERHEAD_FACTOR;
    private final ConfigEntry<String> PYSPARK_MAJOR_PYTHON_VERSION;
    private final OptionalConfigEntry<String> APP_RESOURCE_TYPE;
    private final String KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX;
    private final String KUBERNETES_NODE_SELECTOR_PREFIX;
    private final String KUBERNETES_DRIVER_LABEL_PREFIX;
    private final String KUBERNETES_DRIVER_ANNOTATION_PREFIX;
    private final String KUBERNETES_DRIVER_SECRETS_PREFIX;
    private final String KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX;
    private final String KUBERNETES_DRIVER_VOLUMES_PREFIX;
    private final String KUBERNETES_EXECUTOR_LABEL_PREFIX;
    private final String KUBERNETES_EXECUTOR_ANNOTATION_PREFIX;
    private final String KUBERNETES_EXECUTOR_SECRETS_PREFIX;
    private final String KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX;
    private final String KUBERNETES_EXECUTOR_VOLUMES_PREFIX;
    private final String KUBERNETES_VOLUMES_HOSTPATH_TYPE;
    private final String KUBERNETES_VOLUMES_PVC_TYPE;
    private final String KUBERNETES_VOLUMES_EMPTYDIR_TYPE;
    private final String KUBERNETES_VOLUMES_MOUNT_PATH_KEY;
    private final String KUBERNETES_VOLUMES_MOUNT_READONLY_KEY;
    private final String KUBERNETES_VOLUMES_OPTIONS_PATH_KEY;
    private final String KUBERNETES_VOLUMES_OPTIONS_CLAIM_NAME_KEY;
    private final String KUBERNETES_VOLUMES_OPTIONS_MEDIUM_KEY;
    private final String KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY;
    private final String KUBERNETES_DRIVER_ENV_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Config$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public ConfigEntry<String> KUBERNETES_NAMESPACE() {
        return this.KUBERNETES_NAMESPACE;
    }

    public OptionalConfigEntry<String> CONTAINER_IMAGE() {
        return this.CONTAINER_IMAGE;
    }

    public ConfigEntry<Option<String>> DRIVER_CONTAINER_IMAGE() {
        return this.DRIVER_CONTAINER_IMAGE;
    }

    public ConfigEntry<Option<String>> EXECUTOR_CONTAINER_IMAGE() {
        return this.EXECUTOR_CONTAINER_IMAGE;
    }

    public ConfigEntry<String> CONTAINER_IMAGE_PULL_POLICY() {
        return this.CONTAINER_IMAGE_PULL_POLICY;
    }

    public OptionalConfigEntry<String> IMAGE_PULL_SECRETS() {
        return this.IMAGE_PULL_SECRETS;
    }

    public String KUBERNETES_AUTH_DRIVER_CONF_PREFIX() {
        return this.KUBERNETES_AUTH_DRIVER_CONF_PREFIX;
    }

    public String KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX() {
        return this.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX;
    }

    public String KUBERNETES_AUTH_CLIENT_MODE_PREFIX() {
        return this.KUBERNETES_AUTH_CLIENT_MODE_PREFIX;
    }

    public String OAUTH_TOKEN_CONF_SUFFIX() {
        return this.OAUTH_TOKEN_CONF_SUFFIX;
    }

    public String OAUTH_TOKEN_FILE_CONF_SUFFIX() {
        return this.OAUTH_TOKEN_FILE_CONF_SUFFIX;
    }

    public String CLIENT_KEY_FILE_CONF_SUFFIX() {
        return this.CLIENT_KEY_FILE_CONF_SUFFIX;
    }

    public String CLIENT_CERT_FILE_CONF_SUFFIX() {
        return this.CLIENT_CERT_FILE_CONF_SUFFIX;
    }

    public String CA_CERT_FILE_CONF_SUFFIX() {
        return this.CA_CERT_FILE_CONF_SUFFIX;
    }

    public OptionalConfigEntry<String> KUBERNETES_SERVICE_ACCOUNT_NAME() {
        return this.KUBERNETES_SERVICE_ACCOUNT_NAME;
    }

    public OptionalConfigEntry<String> KUBERNETES_DRIVER_LIMIT_CORES() {
        return this.KUBERNETES_DRIVER_LIMIT_CORES;
    }

    public ConfigEntry<Object> KUBERNETES_DRIVER_SUBMIT_CHECK() {
        return this.KUBERNETES_DRIVER_SUBMIT_CHECK;
    }

    public OptionalConfigEntry<String> KUBERNETES_EXECUTOR_LIMIT_CORES() {
        return this.KUBERNETES_EXECUTOR_LIMIT_CORES;
    }

    public OptionalConfigEntry<String> KUBERNETES_EXECUTOR_REQUEST_CORES() {
        return this.KUBERNETES_EXECUTOR_REQUEST_CORES;
    }

    public OptionalConfigEntry<String> KUBERNETES_DRIVER_POD_NAME() {
        return this.KUBERNETES_DRIVER_POD_NAME;
    }

    public ConfigEntry<String> KUBERNETES_EXECUTOR_POD_NAME_PREFIX() {
        return this.KUBERNETES_EXECUTOR_POD_NAME_PREFIX;
    }

    public OptionalConfigEntry<String> KUBERNETES_PYSPARK_PY_FILES() {
        return this.KUBERNETES_PYSPARK_PY_FILES;
    }

    public OptionalConfigEntry<String> KUBERNETES_PYSPARK_MAIN_APP_RESOURCE() {
        return this.KUBERNETES_PYSPARK_MAIN_APP_RESOURCE;
    }

    public OptionalConfigEntry<String> KUBERNETES_PYSPARK_APP_ARGS() {
        return this.KUBERNETES_PYSPARK_APP_ARGS;
    }

    public OptionalConfigEntry<String> KUBERNETES_R_MAIN_APP_RESOURCE() {
        return this.KUBERNETES_R_MAIN_APP_RESOURCE;
    }

    public OptionalConfigEntry<String> KUBERNETES_R_APP_ARGS() {
        return this.KUBERNETES_R_APP_ARGS;
    }

    public ConfigEntry<Object> KUBERNETES_ALLOCATION_BATCH_SIZE() {
        return this.KUBERNETES_ALLOCATION_BATCH_SIZE;
    }

    public ConfigEntry<Object> KUBERNETES_ALLOCATION_BATCH_DELAY() {
        return this.KUBERNETES_ALLOCATION_BATCH_DELAY;
    }

    public ConfigEntry<Object> KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS() {
        return this.KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS;
    }

    public ConfigEntry<Object> WAIT_FOR_APP_COMPLETION() {
        return this.WAIT_FOR_APP_COMPLETION;
    }

    public ConfigEntry<Object> REPORT_INTERVAL() {
        return this.REPORT_INTERVAL;
    }

    public ConfigEntry<Object> KUBERNETES_EXECUTOR_API_POLLING_INTERVAL() {
        return this.KUBERNETES_EXECUTOR_API_POLLING_INTERVAL;
    }

    public ConfigEntry<Object> KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL() {
        return this.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL;
    }

    public ConfigEntry<Object> MEMORY_OVERHEAD_FACTOR() {
        return this.MEMORY_OVERHEAD_FACTOR;
    }

    public ConfigEntry<String> PYSPARK_MAJOR_PYTHON_VERSION() {
        return this.PYSPARK_MAJOR_PYTHON_VERSION;
    }

    public OptionalConfigEntry<String> APP_RESOURCE_TYPE() {
        return this.APP_RESOURCE_TYPE;
    }

    public String KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX() {
        return this.KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX;
    }

    public String KUBERNETES_NODE_SELECTOR_PREFIX() {
        return this.KUBERNETES_NODE_SELECTOR_PREFIX;
    }

    public String KUBERNETES_DRIVER_LABEL_PREFIX() {
        return this.KUBERNETES_DRIVER_LABEL_PREFIX;
    }

    public String KUBERNETES_DRIVER_ANNOTATION_PREFIX() {
        return this.KUBERNETES_DRIVER_ANNOTATION_PREFIX;
    }

    public String KUBERNETES_DRIVER_SECRETS_PREFIX() {
        return this.KUBERNETES_DRIVER_SECRETS_PREFIX;
    }

    public String KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX() {
        return this.KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX;
    }

    public String KUBERNETES_DRIVER_VOLUMES_PREFIX() {
        return this.KUBERNETES_DRIVER_VOLUMES_PREFIX;
    }

    public String KUBERNETES_EXECUTOR_LABEL_PREFIX() {
        return this.KUBERNETES_EXECUTOR_LABEL_PREFIX;
    }

    public String KUBERNETES_EXECUTOR_ANNOTATION_PREFIX() {
        return this.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX;
    }

    public String KUBERNETES_EXECUTOR_SECRETS_PREFIX() {
        return this.KUBERNETES_EXECUTOR_SECRETS_PREFIX;
    }

    public String KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX() {
        return this.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX;
    }

    public String KUBERNETES_EXECUTOR_VOLUMES_PREFIX() {
        return this.KUBERNETES_EXECUTOR_VOLUMES_PREFIX;
    }

    public String KUBERNETES_VOLUMES_HOSTPATH_TYPE() {
        return this.KUBERNETES_VOLUMES_HOSTPATH_TYPE;
    }

    public String KUBERNETES_VOLUMES_PVC_TYPE() {
        return this.KUBERNETES_VOLUMES_PVC_TYPE;
    }

    public String KUBERNETES_VOLUMES_EMPTYDIR_TYPE() {
        return this.KUBERNETES_VOLUMES_EMPTYDIR_TYPE;
    }

    public String KUBERNETES_VOLUMES_MOUNT_PATH_KEY() {
        return this.KUBERNETES_VOLUMES_MOUNT_PATH_KEY;
    }

    public String KUBERNETES_VOLUMES_MOUNT_READONLY_KEY() {
        return this.KUBERNETES_VOLUMES_MOUNT_READONLY_KEY;
    }

    public String KUBERNETES_VOLUMES_OPTIONS_PATH_KEY() {
        return this.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY;
    }

    public String KUBERNETES_VOLUMES_OPTIONS_CLAIM_NAME_KEY() {
        return this.KUBERNETES_VOLUMES_OPTIONS_CLAIM_NAME_KEY;
    }

    public String KUBERNETES_VOLUMES_OPTIONS_MEDIUM_KEY() {
        return this.KUBERNETES_VOLUMES_OPTIONS_MEDIUM_KEY;
    }

    public String KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY() {
        return this.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY;
    }

    public String KUBERNETES_DRIVER_ENV_PREFIX() {
        return this.KUBERNETES_DRIVER_ENV_PREFIX;
    }

    private Config$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.KUBERNETES_NAMESPACE = new ConfigBuilder("spark.kubernetes.namespace").doc("The namespace that will be used for running the driver and executor pods.").stringConf().createWithDefault((Object)"default");
        this.CONTAINER_IMAGE = new ConfigBuilder("spark.kubernetes.container.image").doc("Container image to use for Spark containers. Individual container types (e.g. driver or executor) can also be configured to use different images if desired, by setting the container type-specific image name.").stringConf().createOptional();
        this.DRIVER_CONTAINER_IMAGE = new ConfigBuilder("spark.kubernetes.driver.container.image").doc("Container image to use for the driver.").fallbackConf(this.CONTAINER_IMAGE());
        this.EXECUTOR_CONTAINER_IMAGE = new ConfigBuilder("spark.kubernetes.executor.container.image").doc("Container image to use for the executors.").fallbackConf(this.CONTAINER_IMAGE());
        this.CONTAINER_IMAGE_PULL_POLICY = new ConfigBuilder("spark.kubernetes.container.image.pullPolicy").doc("Kubernetes image pull policy. Valid values are Always, Never, and IfNotPresent.").stringConf().checkValues((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Always", "Never", "IfNotPresent"}))).createWithDefault((Object)"IfNotPresent");
        this.IMAGE_PULL_SECRETS = new ConfigBuilder("spark.kubernetes.container.image.pullSecrets").doc("Comma separated list of the Kubernetes secrets used to access private image registries.").stringConf().createOptional();
        this.KUBERNETES_AUTH_DRIVER_CONF_PREFIX = "spark.kubernetes.authenticate.driver";
        this.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX = "spark.kubernetes.authenticate.driver.mounted";
        this.KUBERNETES_AUTH_CLIENT_MODE_PREFIX = "spark.kubernetes.authenticate";
        this.OAUTH_TOKEN_CONF_SUFFIX = "oauthToken";
        this.OAUTH_TOKEN_FILE_CONF_SUFFIX = "oauthTokenFile";
        this.CLIENT_KEY_FILE_CONF_SUFFIX = "clientKeyFile";
        this.CLIENT_CERT_FILE_CONF_SUFFIX = "clientCertFile";
        this.CA_CERT_FILE_CONF_SUFFIX = "caCertFile";
        this.KUBERNETES_SERVICE_ACCOUNT_NAME = new ConfigBuilder(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".serviceAccountName"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()}))).doc("Service account that is used when running the driver pod. The driver pod uses this service account when requesting executor pods from the API server. If specific credentials are given for the driver pod to use, the driver will favor using those credentials instead.").stringConf().createOptional();
        this.KUBERNETES_DRIVER_LIMIT_CORES = new ConfigBuilder("spark.kubernetes.driver.limit.cores").doc("Specify the hard cpu limit for the driver pod").stringConf().createOptional();
        this.KUBERNETES_DRIVER_SUBMIT_CHECK = new ConfigBuilder("spark.kubernetes.submitInDriver").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.KUBERNETES_EXECUTOR_LIMIT_CORES = new ConfigBuilder("spark.kubernetes.executor.limit.cores").doc("Specify the hard cpu limit for each executor pod").stringConf().createOptional();
        this.KUBERNETES_EXECUTOR_REQUEST_CORES = new ConfigBuilder("spark.kubernetes.executor.request.cores").doc("Specify the cpu request for each executor pod").stringConf().createOptional();
        this.KUBERNETES_DRIVER_POD_NAME = new ConfigBuilder("spark.kubernetes.driver.pod.name").doc("Name of the driver pod.").stringConf().createOptional();
        this.KUBERNETES_EXECUTOR_POD_NAME_PREFIX = new ConfigBuilder("spark.kubernetes.executor.podNamePrefix").doc("Prefix to use in front of the executor pod names.").internal().stringConf().createWithDefault((Object)"spark");
        this.KUBERNETES_PYSPARK_PY_FILES = new ConfigBuilder("spark.kubernetes.python.pyFiles").doc("The PyFiles that are distributed via client arguments").internal().stringConf().createOptional();
        this.KUBERNETES_PYSPARK_MAIN_APP_RESOURCE = new ConfigBuilder("spark.kubernetes.python.mainAppResource").doc("The main app resource for pyspark jobs").internal().stringConf().createOptional();
        this.KUBERNETES_PYSPARK_APP_ARGS = new ConfigBuilder("spark.kubernetes.python.appArgs").doc("The app arguments for PySpark Jobs").internal().stringConf().createOptional();
        this.KUBERNETES_R_MAIN_APP_RESOURCE = new ConfigBuilder("spark.kubernetes.r.mainAppResource").doc("The main app resource for SparkR jobs").internal().stringConf().createOptional();
        this.KUBERNETES_R_APP_ARGS = new ConfigBuilder("spark.kubernetes.r.appArgs").doc("The app arguments for SparkR Jobs").internal().stringConf().createOptional();
        this.KUBERNETES_ALLOCATION_BATCH_SIZE = new ConfigBuilder("spark.kubernetes.allocation.batch.size").doc("Number of pods to launch at once in each round of executor allocation.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int value) {
                return this.apply$mcZI$sp(value);
            }

            public boolean apply$mcZI$sp(int value) {
                return value > 0;
            }
        }, "Allocation batch size should be a positive integer").createWithDefault((Object)BoxesRunTime.boxToInteger((int)5));
        this.KUBERNETES_ALLOCATION_BATCH_DELAY = new ConfigBuilder("spark.kubernetes.allocation.batch.delay").doc("Time to wait between each round of executor allocation.").timeConf(TimeUnit.MILLISECONDS).checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long value) {
                return this.apply$mcZJ$sp(value);
            }

            public boolean apply$mcZJ$sp(long value) {
                return value > 0L;
            }
        }, "Allocation batch delay must be a positive time value.").createWithDefaultString("1s");
        this.KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS = new ConfigBuilder("spark.kubernetes.executor.lostCheck.maxAttempts").doc("Maximum number of attempts allowed for checking the reason of an executor loss before it is assumed that the executor failed.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int value) {
                return this.apply$mcZI$sp(value);
            }

            public boolean apply$mcZI$sp(int value) {
                return value > 0;
            }
        }, "Maximum attempts of checks of executor lost reason must be a positive integer").createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.WAIT_FOR_APP_COMPLETION = new ConfigBuilder("spark.kubernetes.submission.waitAppCompletion").doc("In cluster mode, whether to wait for the application to finish before exiting the launcher process.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.REPORT_INTERVAL = new ConfigBuilder("spark.kubernetes.report.interval").doc("Interval between reports of the current app status in cluster mode.").timeConf(TimeUnit.MILLISECONDS).checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long interval) {
                return this.apply$mcZJ$sp(interval);
            }

            public boolean apply$mcZJ$sp(long interval) {
                return interval > 0L;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logging interval must be a positive time value."})).s((Seq)Nil$.MODULE$)).createWithDefaultString("1s");
        this.KUBERNETES_EXECUTOR_API_POLLING_INTERVAL = new ConfigBuilder("spark.kubernetes.executor.apiPollingInterval").doc("Interval between polls against the Kubernetes API server to inspect the state of executors.").timeConf(TimeUnit.MILLISECONDS).checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long interval) {
                return this.apply$mcZJ$sp(interval);
            }

            public boolean apply$mcZJ$sp(long interval) {
                return interval > 0L;
            }
        }, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"API server polling interval must be a"})).s((Seq)Nil$.MODULE$)).append((Object)" positive time value.").toString()).createWithDefaultString("30s");
        this.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL = new ConfigBuilder("spark.kubernetes.executor.eventProcessingInterval").doc("Interval between successive inspection of executor events sent from the Kubernetes API.").timeConf(TimeUnit.MILLISECONDS).checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long interval) {
                return this.apply$mcZJ$sp(interval);
            }

            public boolean apply$mcZJ$sp(long interval) {
                return interval > 0L;
            }
        }, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event processing interval must be a positive"})).s((Seq)Nil$.MODULE$)).append((Object)" time value.").toString()).createWithDefaultString("1s");
        this.MEMORY_OVERHEAD_FACTOR = new ConfigBuilder("spark.kubernetes.memoryOverheadFactor").doc("This sets the Memory Overhead Factor that will allocate memory to non-JVM jobs which in the case of JVM tasks will default to 0.10 and 0.40 for non-JVM jobs").doubleConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double mem_overhead) {
                return this.apply$mcZD$sp(mem_overhead);
            }

            public boolean apply$mcZD$sp(double mem_overhead) {
                return mem_overhead >= 0.0 && mem_overhead < 1.0;
            }
        }, "Ensure that memory overhead is a double between 0 --> 1.0").createWithDefault((Object)BoxesRunTime.boxToDouble((double)0.1));
        this.PYSPARK_MAJOR_PYTHON_VERSION = new ConfigBuilder("spark.kubernetes.pyspark.pythonVersion").doc("This sets the major Python version. Either 2 or 3. (Python2 or Python3)").stringConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String pv) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2", "3"})).contains((Object)pv);
            }
        }, "Ensure that major Python version is either Python2 or Python3").createWithDefault((Object)"2");
        this.APP_RESOURCE_TYPE = new ConfigBuilder("spark.kubernetes.resource.type").doc("This sets the resource type internally").internal().stringConf().createOptional();
        this.KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX = "spark.kubernetes.authenticate.submission";
        this.KUBERNETES_NODE_SELECTOR_PREFIX = "spark.kubernetes.node.selector.";
        this.KUBERNETES_DRIVER_LABEL_PREFIX = "spark.kubernetes.driver.label.";
        this.KUBERNETES_DRIVER_ANNOTATION_PREFIX = "spark.kubernetes.driver.annotation.";
        this.KUBERNETES_DRIVER_SECRETS_PREFIX = "spark.kubernetes.driver.secrets.";
        this.KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX = "spark.kubernetes.driver.secretKeyRef.";
        this.KUBERNETES_DRIVER_VOLUMES_PREFIX = "spark.kubernetes.driver.volumes.";
        this.KUBERNETES_EXECUTOR_LABEL_PREFIX = "spark.kubernetes.executor.label.";
        this.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX = "spark.kubernetes.executor.annotation.";
        this.KUBERNETES_EXECUTOR_SECRETS_PREFIX = "spark.kubernetes.executor.secrets.";
        this.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX = "spark.kubernetes.executor.secretKeyRef.";
        this.KUBERNETES_EXECUTOR_VOLUMES_PREFIX = "spark.kubernetes.executor.volumes.";
        this.KUBERNETES_VOLUMES_HOSTPATH_TYPE = "hostPath";
        this.KUBERNETES_VOLUMES_PVC_TYPE = "persistentVolumeClaim";
        this.KUBERNETES_VOLUMES_EMPTYDIR_TYPE = "emptyDir";
        this.KUBERNETES_VOLUMES_MOUNT_PATH_KEY = "mount.path";
        this.KUBERNETES_VOLUMES_MOUNT_READONLY_KEY = "mount.readOnly";
        this.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY = "options.path";
        this.KUBERNETES_VOLUMES_OPTIONS_CLAIM_NAME_KEY = "options.claimName";
        this.KUBERNETES_VOLUMES_OPTIONS_MEDIUM_KEY = "options.medium";
        this.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY = "options.sizeLimit";
        this.KUBERNETES_DRIVER_ENV_PREFIX = "spark.kubernetes.driverEnv.";
    }
}

