/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.ui.SparkUI$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a!B\u0001\u0003\u0001!q!A\u0006\"bg&\u001cGI]5wKJ4U-\u0019;ve\u0016\u001cF/\u001a9\u000b\u0005\r!\u0011\u0001\u00034fCR,(/Z:\u000b\u0005\u00151\u0011aA69g*\u0011q\u0001C\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\t\u0011i\u0001!\u0011!Q\u0001\nq\tAaY8oM\u000e\u0001\u0001cA\u000f\u001fA5\tA!\u0003\u0002 \t\tq1*\u001e2fe:,G/Z:D_:4\u0007CA\u000f\"\u0013\t\u0011CA\u0001\u000fLk\n,'O\\3uKN$%/\u001b<feN\u0003XmY5gS\u000e\u001cuN\u001c4\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u0017\u0001!)!d\ta\u00019!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0013!\u00043sSZ,'\u000fU8e\u001d\u0006lW-F\u0001,!\ta3G\u0004\u0002.cA\u0011a&E\u0007\u0002_)\u0011\u0001gG\u0001\u0007yI|w\u000e\u001e \n\u0005I\n\u0012A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\t\t\r]\u0002\u0001\u0015!\u0003,\u00039!'/\u001b<feB{GMT1nK\u0002Bq!\u000f\u0001C\u0002\u0013%!&\u0001\u000bee&4XM]\"p]R\f\u0017N\\3s\u00136\fw-\u001a\u0005\u0007w\u0001\u0001\u000b\u0011B\u0016\u0002+\u0011\u0014\u0018N^3s\u0007>tG/Y5oKJLU.Y4fA!9Q\b\u0001b\u0001\n\u0013Q\u0013A\u00043sSZ,'o\u00119v\u0007>\u0014Xm\u001d\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u0016\u0002\u001f\u0011\u0014\u0018N^3s\u0007B,8i\u001c:fg\u0002Bq!\u0011\u0001C\u0002\u0013%!)\u0001\tee&4XM\u001d'j[&$8i\u001c:fgV\t1\tE\u0002\u0011\t.J!!R\t\u0003\r=\u0003H/[8o\u0011\u00199\u0005\u0001)A\u0005\u0007\u0006\tBM]5wKJd\u0015.\\5u\u0007>\u0014Xm\u001d\u0011\t\u000f%\u0003!\u0019!C\u0005\u0015\u0006yAM]5wKJlU-\\8ss6K')F\u0001L!\t\u0001B*\u0003\u0002N#\t!Aj\u001c8h\u0011\u0019y\u0005\u0001)A\u0005\u0017\u0006\u0001BM]5wKJlU-\\8ss6K'\t\t\u0005\b#\u0002\u0011\r\u0011\"\u0003K\u0003EiW-\\8ss>3XM\u001d5fC\u0012l\u0015N\u0011\u0005\u0007'\u0002\u0001\u000b\u0011B&\u0002%5,Wn\u001c:z\u001fZ,'\u000f[3bI6K'\t\t\u0005\b+\u0002\u0011\r\u0011\"\u0003K\u0003m!'/\u001b<fe6+Wn\u001c:z/&$\bn\u0014<fe\",\u0017\rZ'j\u0005\"1q\u000b\u0001Q\u0001\n-\u000bA\u0004\u001a:jm\u0016\u0014X*Z7pef<\u0016\u000e\u001e5Pm\u0016\u0014\b.Z1e\u001b&\u0014\u0005\u0005C\u0003Z\u0001\u0011\u0005#,\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u0002\\=B\u0011Q\u0004X\u0005\u0003;\u0012\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006?b\u0003\raW\u0001\u0004a>$\u0007\"B1\u0001\t\u0003\u0012\u0017\u0001I4fi\u0006#G-\u001b;j_:\fG\u000eU8e'f\u001cH/Z7Qe>\u0004XM\u001d;jKN$\u0012a\u0019\t\u0005Y\u0011\\3&\u0003\u0002fk\t\u0019Q*\u00199\t\u000b\u001d\u0004A\u0011\t5\u0002A\u001d,G/\u00113eSRLwN\\1m\u0017V\u0014WM\u001d8fi\u0016\u001c(+Z:pkJ\u001cWm\u001d\u000b\u0002SB\u0019!n\u001c:\u000f\u0005-lgB\u0001\u0018m\u0013\u0005\u0011\u0012B\u00018\u0012\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001]9\u0003\u0007M+\u0017O\u0003\u0002o#A\u00111O`\u0007\u0002i*\u0011QO^\u0001\u0006[>$W\r\u001c\u0006\u0003ob\f1!\u00199j\u0015\tI(0\u0001\u0006lk\n,'O\\3uKNT!a\u001f?\u0002\u000f\u0019\f'M]5dq)\tQ0\u0001\u0002j_&\u0011q\u0010\u001e\u0002\f\u0011\u0006\u001cX*\u001a;bI\u0006$\u0018\r")
public class BasicDriverFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<KubernetesDriverSpecificConf> conf;
    private final String driverPodName;
    private final String driverContainerImage;
    private final String driverCpuCores;
    private final Option<String> driverLimitCores;
    private final long driverMemoryMiB;
    private final long memoryOverheadMiB;
    private final long driverMemoryWithOverheadMiB;

    private String driverPodName() {
        return this.driverPodName;
    }

    private String driverContainerImage() {
        return this.driverContainerImage;
    }

    private String driverCpuCores() {
        return this.driverCpuCores;
    }

    private Option<String> driverLimitCores() {
        return this.driverLimitCores;
    }

    private long driverMemoryMiB() {
        return this.driverMemoryMiB;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long driverMemoryWithOverheadMiB() {
        return this.driverMemoryWithOverheadMiB;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Seq driverCustomEnvs = (Seq)this.conf.roleEnvs().toSeq().map((Function1 & Serializable & scala.Serializable)env -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValue((String)env._2())).build(), Seq$.MODULE$.canBuildFrom());
        Quantity driverCpuQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(this.driverCpuCores())).build();
        Quantity driverMemoryQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringBuilder(2).append(this.driverMemoryWithOverheadMiB()).append("Mi").toString())).build();
        Option maybeCpuLimitQuantity = this.driverLimitCores().map((Function1 & Serializable & scala.Serializable)limitCores -> new Tuple2((Object)"cpu", (Object)((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(limitCores)).build()));
        int driverPort = this.conf.sparkConf().getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        int driverBlockManagerPort = this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        int driverUIPort = SparkUI$.MODULE$.getUIPort(this.conf.sparkConf());
        Container driverContainer = ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).withName(Constants$.MODULE$.DRIVER_CONTAINER_NAME())).withImage(this.driverContainerImage())).withImagePullPolicy(this.conf.imagePullPolicy())).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverBlockManagerPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.UI_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverUIPort)).withProtocol("TCP")).endPort()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(driverCustomEnvs).asJava())).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_BIND_ADDRESS()).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).endEnv()).withNewResources().addToRequests("cpu", driverCpuQuantity).addToLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Option$.MODULE$.option2Iterable(maybeCpuLimitQuantity).toMap(Predef$.MODULE$.$conforms())).asJava()).addToRequests("memory", driverMemoryQuantity).addToLimits("memory", driverMemoryQuantity)).endResources()).build();
        Pod driverPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod.pod()).editOrNewMetadata().withName(this.driverPodName()).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.roleLabels()).asJava()).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.roleAnnotations()).asJava())).endMetadata()).withNewSpec().withRestartPolicy("Never").withNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.nodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.conf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        return new SparkPod(driverPod, driverContainer);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        scala.collection.mutable.Map additionalProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME().key()), (Object)this.driverPodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.id"), (Object)this.conf.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX().key()), (Object)this.conf.appResourceNamePrefix()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK().key()), (Object)"true")}));
        Iterable<String> resolvedSparkJars = KubernetesUtils$.MODULE$.resolveFileUrisAndPath((Iterable<String>)this.conf.sparkJars());
        Iterable<String> resolvedSparkFiles = KubernetesUtils$.MODULE$.resolveFileUrisAndPath((Iterable<String>)this.conf.sparkFiles());
        Object object = resolvedSparkJars.nonEmpty() ? additionalProps.put((Object)"spark.jars", (Object)resolvedSparkJars.mkString(",")) : BoxedUnit.UNIT;
        Object object2 = resolvedSparkFiles.nonEmpty() ? additionalProps.put((Object)"spark.files", (Object)resolvedSparkFiles.mkString(",")) : BoxedUnit.UNIT;
        return additionalProps.toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public BasicDriverFeatureStep(KubernetesConf<KubernetesDriverSpecificConf> conf) {
        this.conf = conf;
        this.driverPodName = (String)((Option)conf.get((ConfigEntry<KubernetesDriverSpecificConf>)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append($this.conf.appResourceNamePrefix()).append("-driver").toString());
        this.driverContainerImage = (String)conf.get(Config$.MODULE$.DRIVER_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("Must specify the driver container image");
        });
        this.driverCpuCores = conf.get("spark.driver.cores", "1");
        this.driverLimitCores = (Option)conf.get((ConfigEntry<KubernetesDriverSpecificConf>)Config$.MODULE$.KUBERNETES_DRIVER_LIMIT_CORES());
        this.driverMemoryMiB = BoxesRunTime.unboxToLong((Object)conf.get((ConfigEntry<KubernetesDriverSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY()));
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)conf.get((ConfigEntry<KubernetesDriverSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)((int)(BoxesRunTime.unboxToDouble((Object)$this.conf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) * (double)this.driverMemoryMiB())), Constants$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        this.driverMemoryWithOverheadMiB = this.driverMemoryMiB() + this.memoryOverheadMiB();
    }
}

