/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\u00119\u0011Q#\u00128w'\u0016\u001c'/\u001a;t\r\u0016\fG/\u001e:f'R,\u0007O\u0003\u0002\u0004\t\u0005Aa-Z1ukJ,7O\u0003\u0002\u0006\r\u0005\u00191\u000eO:\u000b\u0005\u001dA\u0011A\u00023fa2|\u0017P\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Y9R\"\u0001\u0002\n\u0005a\u0011!aG&vE\u0016\u0014h.\u001a;fg\u001a+\u0017\r^;sK\u000e{gNZ5h'R,\u0007\u000f\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u00039YWOY3s]\u0016$Xm]\"p]\u001a\u001c\u0001\u0001\r\u0002\u001eGA\u0019adH\u0011\u000e\u0003\u0011I!\u0001\t\u0003\u0003\u001d-+(-\u001a:oKR,7oQ8oMB\u0011!e\t\u0007\u0001\t%!\u0013$!A\u0001\u0002\u000b\u0005QEA\u0002`IE\n\"AJ\u0015\u0011\u0005A9\u0013B\u0001\u0015\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\b\u0016\n\u0005-\"!AG&vE\u0016\u0014h.\u001a;fgJ{G.Z*qK\u000eLg-[2D_:4\u0007\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00020aA\u0011a\u0003\u0001\u0005\u000651\u0002\r!\r\u0019\u0003eQ\u00022AH\u00104!\t\u0011C\u0007B\u0005%a\u0005\u0005\t\u0011!B\u0001K!)a\u0007\u0001C!o\u0005a1m\u001c8gS\u001e,(/\u001a)pIR\u0011\u0001h\u000f\t\u0003=eJ!A\u000f\u0003\u0003\u0011M\u0003\u0018M]6Q_\u0012DQ\u0001P\u001bA\u0002a\n1\u0001]8e\u0011\u0015q\u0004\u0001\"\u0011@\u0003\u0001:W\r^!eI&$\u0018n\u001c8bYB{GmU=ti\u0016l\u0007K]8qKJ$\u0018.Z:\u0015\u0003\u0001\u0003B!\u0011%L\u0017:\u0011!I\u0012\t\u0003\u0007Fi\u0011\u0001\u0012\u0006\u0003\u000bn\ta\u0001\u0010:p_Rt\u0014BA$\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0004\u001b\u0006\u0004(BA$\u0012!\t\tE*\u0003\u0002N\u0015\n11\u000b\u001e:j]\u001eDQa\u0014\u0001\u0005BA\u000b\u0001eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d7*\u001e2fe:,G/Z:SKN|WO]2fgR\t\u0011\u000bE\u0002S/js!aU+\u000f\u0005\r#\u0016\"\u0001\n\n\u0005Y\u000b\u0012a\u00029bG.\fw-Z\u0005\u00031f\u00131aU3r\u0015\t1\u0016\u0003\u0005\u0002\\M6\tAL\u0003\u0002^=\u0006)Qn\u001c3fY*\u0011q\fY\u0001\u0004CBL'BA1c\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003G\u0012\fqAZ1ce&\u001c\u0007HC\u0001f\u0003\tIw.\u0003\u0002h9\nY\u0001*Y:NKR\fG-\u0019;b\u0001")
public class EnvSecretsFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Iterable addedEnvSecrets = (Iterable)this.kubernetesConf.roleSecretEnvNamesToKeyRefs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String envName = (String)tuple2._1();
            String keyRef = (String)tuple2._2();
            String[] keyRefParts = keyRef.split(":");
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyRefParts)).size() == 2, (Function0 & Serializable & scala.Serializable)() -> "SecretKeyRef must be in the form name:key.");
            String name = keyRefParts[0];
            String key = keyRefParts[1];
            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarFluentImpl)new EnvVarBuilder().withName(envName)).withNewValueFrom().withNewSecretKeyRef().withKey(key).withName(name)).endSecretKeyRef()).endValueFrom()).build();
            return envVar;
        }, Iterable$.MODULE$.canBuildFrom());
        Container containerWithEnvVars = ((ContainerBuilder)new ContainerBuilder(pod.container()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(addedEnvSecrets.toSeq()).asJava())).build();
        return new SparkPod(pod.pod(), containerWithEnvVars);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public EnvSecretsFeatureStep(KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

