/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features.bindings;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3Q!\u0001\u0002\u0001\u0015A\u0011q\u0003U=uQ>tGI]5wKJ4U-\u0019;ve\u0016\u001cF/\u001a9\u000b\u0005\r!\u0011\u0001\u00032j]\u0012LgnZ:\u000b\u0005\u00151\u0011\u0001\u00034fCR,(/Z:\u000b\u0005\u001dA\u0011aA69g*\u0011\u0011BC\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c2\u0001A\t\u0018!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fMB\u0011\u0001$G\u0007\u0002\t%\u0011!\u0004\u0002\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\t\u0011q\u0001!\u0011!Q\u0001\ny\tab[;cKJtW\r^3t\u0007>tgm\u0001\u0001\u0011\u0007}\u0001#%D\u0001\u0007\u0013\t\tcA\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0011\u0005}\u0019\u0013B\u0001\u0013\u0007\u0005qYUOY3s]\u0016$Xm\u001d#sSZ,'o\u00159fG&4\u0017nY\"p]\u001aDQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDC\u0001\u0015+!\tI\u0003!D\u0001\u0003\u0011\u0015aR\u00051\u0001\u001f\u0011\u0015a\u0003\u0001\"\u0011.\u00031\u0019wN\u001c4jOV\u0014X\rU8e)\tq\u0013\u0007\u0005\u0002 _%\u0011\u0001G\u0002\u0002\t'B\f'o\u001b)pI\")!g\u000ba\u0001]\u0005\u0019\u0001o\u001c3\t\u000bQ\u0002A\u0011I\u001b\u0002A\u001d,G/\u00113eSRLwN\\1m!>$7+_:uK6\u0004&o\u001c9feRLWm\u001d\u000b\u0002mA!qGP!B\u001d\tAD\b\u0005\u0002:'5\t!H\u0003\u0002<;\u00051AH]8pizJ!!P\n\u0002\rA\u0013X\rZ3g\u0013\ty\u0004IA\u0002NCBT!!P\n\u0011\u0005]\u0012\u0015BA\"A\u0005\u0019\u0019FO]5oO\")Q\t\u0001C!\r\u0006\u0001s-\u001a;BI\u0012LG/[8oC2\\UOY3s]\u0016$Xm\u001d*fg>,(oY3t)\u00059\u0005c\u0001%N!:\u0011\u0011j\u0013\b\u0003s)K\u0011\u0001F\u0005\u0003\u0019N\tq\u0001]1dW\u0006<W-\u0003\u0002O\u001f\n\u00191+Z9\u000b\u00051\u001b\u0002CA)]\u001b\u0005\u0011&BA*U\u0003\u0015iw\u000eZ3m\u0015\t)f+A\u0002ba&T!a\u0016-\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002Z5\u00069a-\u00192sS\u000eD$\"A.\u0002\u0005%|\u0017BA/S\u0005-A\u0015m]'fi\u0006$\u0017\r^1")
public class PythonDriverFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        KubernetesDriverSpecificConf roleConf = this.kubernetesConf.roleSpecificConf();
        Predef$.MODULE$.require(roleConf.mainAppResource().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "PySpark Main Resource must be defined");
        Option maybePythonArgs = Option$.MODULE$.apply(roleConf.appArgs()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).map((Function1 & Serializable & scala.Serializable)pyArgs -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_ARGS())).withValue(pyArgs.mkString(" "))).build());
        Option maybePythonFiles = this.kubernetesConf.pyFiles().map((Function1 & Serializable & scala.Serializable)pyFiles -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_FILES())).withValue(KubernetesUtils$.MODULE$.resolveFileUrisAndPath((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])pyFiles.split(","))).mkString(":"))).build());
        Seq envSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_PRIMARY())).withValue(KubernetesUtils$.MODULE$.resolveFileUri((String)this.kubernetesConf.pySparkMainResource().get()))).build(), ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_PYSPARK_MAJOR_PYTHON_VERSION())).withValue(this.kubernetesConf.pySparkPythonVersion())).build()}));
        Seq pythonEnvs = (Seq)((TraversableLike)envSeq.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maybePythonArgs).toSeq(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maybePythonFiles).toSeq(), Seq$.MODULE$.canBuildFrom());
        Container withPythonPrimaryContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(pythonEnvs).asJava())).addToArgs(new String[]{"driver-py"})).addToArgs(new String[]{"--properties-file", Constants$.MODULE$.SPARK_CONF_PATH()})).addToArgs(new String[]{"--class", roleConf.mainClass()})).build();
        return new SparkPod(pod.pod(), withPythonPrimaryContainer);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.APP_RESOURCE_TYPE().key()), (Object)"python")}));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public PythonDriverFeatureStep(KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

