/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!B\u0001\u0003\u0001\u0011q!a\u0007'pO\u001eLgn\u001a)pIN#\u0018\r^;t/\u0006$8\r[3s\u00136\u0004HN\u0003\u0002\u0004\t\u000511/\u001e2nSRT!!\u0002\u0004\u0002\u0007-D4O\u0003\u0002\b\u0011\u00051A-\u001a9m_fT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=92\u0004\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\tA\u0012$D\u0001\u0003\u0013\tQ\"AA\fM_\u001e<\u0017N\\4Q_\u0012\u001cF/\u0019;vg^\u000bGo\u00195feB\u0011AdH\u0007\u0002;)\u0011a\u0004C\u0001\tS:$XM\u001d8bY&\u0011\u0001%\b\u0002\b\u0019><w-\u001b8h\u0011!\u0011\u0003A!A!\u0002\u0013!\u0013!B1qa&#7\u0001\u0001\t\u0003K9r!A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\u001a\u0013A\u0002\u001fs_>$hHC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#&\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017+\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014\u0001F7bs\n,Gj\\4hS:<\u0017J\u001c;feZ\fG\u000eE\u00025k]j\u0011AK\u0005\u0003m)\u0012aa\u00149uS>t\u0007C\u0001\u001b9\u0013\tI$F\u0001\u0003M_:<\u0007\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\bF\u0002>}}\u0002\"\u0001\u0007\u0001\t\u000b\tR\u0004\u0019\u0001\u0013\t\u000bIR\u0004\u0019A\u001a\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\u0006\u0011\u0002o\u001c3D_6\u0004H.\u001a;fI\u001a+H/\u001e:f+\u0005\u0019\u0005C\u0001#J\u001b\u0005)%B\u0001$H\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0011N\tA!\u001e;jY&\u0011!*\u0012\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0011\u0019a\u0005\u0001)A\u0005\u0007\u0006\u0019\u0002o\u001c3D_6\u0004H.\u001a;fI\u001a+H/\u001e:fA!9a\n\u0001b\u0001\n\u0013y\u0015!C:dQ\u0016$W\u000f\\3s+\u0005\u0001\u0006C\u0001#R\u0013\t\u0011VI\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016Da\u0001\u0016\u0001!\u0002\u0013\u0001\u0016AC:dQ\u0016$W\u000f\\3sA!9a\u000b\u0001b\u0001\n\u00139\u0016a\u00037pOJ+hN\\1cY\u0016,\u0012\u0001\u0017\t\u0003!eK!AW\t\u0003\u0011I+hN\\1cY\u0016Da\u0001\u0018\u0001!\u0002\u0013A\u0016\u0001\u00047pOJ+hN\\1cY\u0016\u0004\u0003b\u00020\u0001\u0001\u0004%IaX\u0001\u0004a>$W#\u00011\u0011\u0007Q*\u0014\r\u0005\u0002c[6\t1M\u0003\u0002eK\u0006)Qn\u001c3fY*\u0011amZ\u0001\u0004CBL'B\u00015j\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003U.\fqAZ1ce&\u001c\u0007HC\u0001m\u0003\tIw.\u0003\u0002oG\n\u0019\u0001k\u001c3\t\u000fA\u0004\u0001\u0019!C\u0005c\u00069\u0001o\u001c3`I\u0015\fHC\u0001:v!\t!4/\u0003\u0002uU\t!QK\\5u\u0011\u001d1x.!AA\u0002\u0001\f1\u0001\u001f\u00132\u0011\u0019A\b\u0001)Q\u0005A\u0006!\u0001o\u001c3!\u0011\u0015Q\b\u0001\"\u0003|\u0003\u0015\u0001\b.Y:f+\u0005!\u0003\"B?\u0001\t\u0003q\u0018!B:uCJ$H#\u0001:\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u0005iQM^3oiJ+7-Z5wK\u0012$RA]A\u0003\u0003WAq!a\u0002\u0000\u0001\u0004\tI!\u0001\u0004bGRLwN\u001c\t\u0005\u0003\u0017\t)C\u0004\u0003\u0002\u000e\u0005}a\u0002BA\b\u00037qA!!\u0005\u0002\u001a9!\u00111CA\f\u001d\r9\u0013QC\u0005\u0002Y&\u0011!n[\u0005\u0003Q&L1!!\bh\u0003\u0019\u0019G.[3oi&!\u0011\u0011EA\u0012\u0003\u001d9\u0016\r^2iKJT1!!\bh\u0013\u0011\t9#!\u000b\u0003\r\u0005\u001bG/[8o\u0015\u0011\t\t#a\t\t\u000by{\b\u0019A1\t\u000f\u0005=\u0002\u0001\"\u0011\u00022\u00059qN\\\"m_N,Gc\u0001:\u00024!A\u0011QGA\u0017\u0001\u0004\t9$A\u0001f!\u0011\tI$a\u000f\u000e\u0005\u0005\r\u0012\u0002BA\u001f\u0003G\u0011\u0011dS;cKJtW\r^3t\u00072LWM\u001c;Fq\u000e,\u0007\u000f^5p]\"1\u0011\u0011\t\u0001\u0005\ny\fa\u0002\\8h'\"|'\u000f^*uCR,8\u000f\u0003\u0004\u0002F\u0001!IA`\u0001\u000eY><Gj\u001c8h'R\fG/^:\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u0005a\u0001.Y:D_6\u0004H.\u001a;fIR\u0011\u0011Q\n\t\u0004i\u0005=\u0013bAA)U\t9!i\\8mK\u0006t\u0007BBA+\u0001\u0011%a0\u0001\u0006dY>\u001cXmV1uG\"Dq!!\u0017\u0001\t\u0013\tY&\u0001\bg_Jl\u0017\r\u001e)pIN#\u0018\r^3\u0015\u0007\u0011\ni\u0006\u0003\u0004_\u0003/\u0002\r!\u0019\u0005\b\u0003C\u0002A\u0011BA2\u0003E1wN]7biB\u000b\u0017N]:Ck:$G.\u001a\u000b\u0004I\u0005\u0015\u0004\u0002CA4\u0003?\u0002\r!!\u001b\u0002\u000bA\f\u0017N]:\u0011\r\u0005-\u0014QOA>\u001d\u0011\ti'!\u001d\u000f\u0007\u001d\ny'C\u0001,\u0013\r\t\u0019HK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9(!\u001f\u0003\u0007M+\u0017OC\u0002\u0002t)\u0002R\u0001NA?I\u0011J1!a +\u0005\u0019!V\u000f\u001d7fe!1\u00111\u0011\u0001\u0005By\fq\"Y<bSR\u001cu.\u001c9mKRLwN\u001c\u0005\b\u0003\u000f\u0003A\u0011BAE\u0003U\u0019wN\u001c;bS:,'o\u001d#fg\u000e\u0014\u0018\u000e\u001d;j_:$2\u0001JAF\u0011\u001d\ti)!\"A\u0002\u0005\f\u0011\u0001\u001d\u0005\b\u0003#\u0003A\u0011BAJ\u0003i\u0019wN\u001c;bS:,'o\u0015;biV\u001cH)Z:de&\u0004H/[8o)\u0011\tI'!&\t\u0011\u0005]\u0015q\u0012a\u0001\u00033\u000bqbY8oi\u0006Lg.\u001a:Ti\u0006$Xo\u001d\t\u0004E\u0006m\u0015bAAOG\ny1i\u001c8uC&tWM]*uCR,8\u000fC\u0004\u0002\"\u0002!I!a)\u0002\u0015\u0019|'/\\1u)&lW\rF\u0002%\u0003KC\u0001\"a*\u0002 \u0002\u0007\u0011\u0011V\u0001\u0005i&lW\rE\u0002c\u0003WK1!!,d\u0005\u0011!\u0016.\\3")
public class LoggingPodStatusWatcherImpl
implements LoggingPodStatusWatcher,
Logging {
    private final String appId;
    private final Option<Object> maybeLoggingInterval;
    private final CountDownLatch podCompletedFuture;
    private final ScheduledExecutorService scheduler;
    private final Runnable logRunnable;
    private Option<Pod> pod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CountDownLatch podCompletedFuture() {
        return this.podCompletedFuture;
    }

    private ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    private Runnable logRunnable() {
        return this.logRunnable;
    }

    private Option<Pod> pod() {
        return this.pod;
    }

    private void pod_$eq(Option<Pod> x$1) {
        this.pod = x$1;
    }

    private String phase() {
        return (String)this.pod().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getStatus().getPhase()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown");
    }

    public void start() {
        this.maybeLoggingInterval.foreach((Function1 & Serializable & scala.Serializable)interval -> LoggingPodStatusWatcherImpl.$anonfun$start$1(this, BoxesRunTime.unboxToLong((Object)interval)));
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        this.pod_$eq((Option<Pod>)Option$.MODULE$.apply((Object)pod));
        Watcher.Action action2 = action;
        boolean bl = Watcher.Action.DELETED.equals(action2) ? true : Watcher.Action.ERROR.equals(action2);
        if (bl) {
            this.closeWatch();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            this.logLongStatus();
            if (this.hasCompleted()) {
                this.closeWatch();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void onClose(KubernetesClientException e) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Stopping watching application ").append($this.appId).append(" with last-observed phase ").append(this.phase()).toString());
        this.closeWatch();
    }

    public void org$apache$spark$deploy$k8s$submit$LoggingPodStatusWatcherImpl$$logShortStatus() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Application status for ").append($this.appId).append(" (phase: ").append(this.phase()).append(")").toString());
    }

    private void logLongStatus() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("State changed, new state: ").append(this.pod().map((Function1 & Serializable & scala.Serializable)pod -> this.formatPodState((Pod)pod)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown")).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasCompleted() {
        String string = this.phase();
        String string2 = "Succeeded";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.phase();
        String string4 = "Failed";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private void closeWatch() {
        this.podCompletedFuture().countDown();
        this.scheduler().shutdown();
    }

    private String formatPodState(Pod pod) {
        Seq details = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"pod name", (Object)pod.getMetadata().getName()), new Tuple2((Object)"namespace", (Object)pod.getMetadata().getNamespace()), new Tuple2((Object)"labels", (Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(pod.getMetadata().getLabels()).asScala()).mkString(", ")), new Tuple2((Object)"pod uid", (Object)pod.getMetadata().getUid()), new Tuple2((Object)"creation time", (Object)this.formatTime(pod.getMetadata().getCreationTimestamp())), new Tuple2((Object)"service account name", (Object)pod.getSpec().getServiceAccountName()), new Tuple2((Object)"volumes", (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getSpec().getVolumes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Buffer$.MODULE$.canBuildFrom())).mkString(", ")), new Tuple2((Object)"node name", (Object)pod.getSpec().getNodeName()), new Tuple2((Object)"start time", (Object)this.formatTime(pod.getStatus().getStartTime())), new Tuple2((Object)"container images", (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getImage(), Buffer$.MODULE$.canBuildFrom())).mkString(", ")), new Tuple2((Object)"phase", (Object)pod.getStatus().getPhase()), new Tuple2((Object)"status", (Object)pod.getStatus().getContainerStatuses().toString())}));
        return this.formatPairsBundle((Seq<Tuple2<String, String>>)details);
    }

    private String formatPairsBundle(Seq<Tuple2<String, String>> pairs) {
        return ((TraversableOnce)pairs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(5).append("\n\t ").append(k).append(": ").append(Option$.MODULE$.apply((Object)v).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LoggingPodStatusWatcherImpl.$anonfun$formatPairsBundle$2(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("");
    }

    @Override
    public void awaitCompletion() {
        this.podCompletedFuture().await();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)this.pod().map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(27).append("Container final statuses:\n\n").append(this.containersDescription((Pod)p)).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "No containers were found in the driver pod."));
    }

    private String containersDescription(Pod p) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)status -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container name", (Object)status.getName()), new Tuple2((Object)"Container image", (Object)status.getImage())}))).$plus$plus(this.containerStatusDescription((ContainerStatus)status), Seq$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)pairs -> this.formatPairsBundle((Seq<Tuple2<String, String>>)pairs), Buffer$.MODULE$.canBuildFrom())).mkString("\n\n");
    }

    private Seq<Tuple2<String, String>> containerStatusDescription(ContainerStatus containerStatus) {
        ContainerState state = containerStatus.getState();
        return (Seq)Option$.MODULE$.apply((Object)state.getRunning()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)state.getTerminated())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)state.getWaiting())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq seq;
            KubernetesResource kubernetesResource = x0$2;
            if (kubernetesResource instanceof ContainerStateRunning) {
                ContainerStateRunning containerStateRunning = (ContainerStateRunning)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Running"), new Tuple2((Object)"Container started at", (Object)this.formatTime(containerStateRunning.getStartedAt()))}));
            } else if (kubernetesResource instanceof ContainerStateWaiting) {
                ContainerStateWaiting containerStateWaiting = (ContainerStateWaiting)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Waiting"), new Tuple2((Object)"Pending reason", (Object)containerStateWaiting.getReason())}));
            } else if (kubernetesResource instanceof ContainerStateTerminated) {
                ContainerStateTerminated containerStateTerminated = (ContainerStateTerminated)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Terminated"), new Tuple2((Object)"Exit code", (Object)containerStateTerminated.getExitCode().toString())}));
            } else {
                throw new SparkException(new StringBuilder(34).append("Unexpected container status type ").append(kubernetesResource.getClass()).append(".").toString());
            }
            return seq;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"N/A")})));
    }

    private String formatTime(Time time) {
        return time != null ? time.getTime() : "N/A";
    }

    public static final /* synthetic */ ScheduledFuture $anonfun$start$1(LoggingPodStatusWatcherImpl $this, long interval) {
        return $this.scheduler().scheduleAtFixedRate($this.logRunnable(), 0L, interval, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ boolean $anonfun$formatPairsBundle$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public LoggingPodStatusWatcherImpl(String appId, Option<Object> maybeLoggingInterval) {
        this.appId = appId;
        this.maybeLoggingInterval = maybeLoggingInterval;
        Logging.$init$((Logging)this);
        this.podCompletedFuture = new CountDownLatch(1);
        this.scheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("logging-pod-status-watcher");
        this.logRunnable = new Runnable(this){
            private final /* synthetic */ LoggingPodStatusWatcherImpl $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$k8s$submit$LoggingPodStatusWatcherImpl$$logShortStatus();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.pod = Option$.MODULE$.empty();
    }
}

