/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue!B\u0001\u0003\u0001!q!!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN\u001d\u0006\u0003\u0007\u0011\t1a\u001b\u001dt\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011!C:dQ\u0016$W\u000f\\3s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0005\u0002\u0011%tG/\u001a:oC2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001B\u0001B\u0003%a$\u0001\u0003d_:47\u0001\u0001\t\u0003?\u0001j\u0011\u0001C\u0005\u0003C!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nq\"\u001a=fGV$xN\u001d\"vS2$WM\u001d\t\u0003K\u0019j\u0011AA\u0005\u0003O\t\u0011\u0011dS;cKJtW\r^3t\u000bb,7-\u001e;pe\n+\u0018\u000e\u001c3fe\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u00111\u0006N\u0007\u0002Y)\u0011QFL\u0001\u0007G2LWM\u001c;\u000b\u0005=\u0002\u0014AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0011GM\u0001\bM\u0006\u0014'/[29\u0015\u0005\u0019\u0014AA5p\u0013\t)DF\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\"Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\bt]\u0006\u00048\u000f[8ugN#xN]3\u0011\u0005\u0015J\u0014B\u0001\u001e\u0003\u0005i)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u0011!a\u0004A!A!\u0002\u0013i\u0014!B2m_\u000e\\\u0007C\u0001 B\u001b\u0005y$B\u0001!\t\u0003\u0011)H/\u001b7\n\u0005\t{$!B\"m_\u000e\\\u0007\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\b\u0006\u0004G\u000f\"K%j\u0013\t\u0003K\u0001AQ\u0001H\"A\u0002yAQaI\"A\u0002\u0011BQ!K\"A\u0002)BQaN\"A\u0002aBQ\u0001P\"A\u0002uBq!\u0014\u0001C\u0002\u0013%a*A\nF1\u0016\u001bU\u000bV(S?&#ulQ(V\u001dR+%+F\u0001P!\t\u0001\u0006,D\u0001R\u0015\t\u00116+\u0001\u0004bi>l\u0017n\u0019\u0006\u0003)V\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u0001eKC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e\u000b&AC!u_6L7\rT8oO\"11\f\u0001Q\u0001\n=\u000bA#\u0012-F\u0007V#vJU0J\t~\u001bu*\u0016(U\u000bJ\u0003\u0003bB/\u0001\u0005\u0004%IAX\u0001\u0017i>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sgV\tq\f\u0005\u0002QA&\u0011\u0011-\u0015\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\r\r\u0004\u0001\u0015!\u0003`\u0003]!x\u000e^1m\u000bb\u0004Xm\u0019;fI\u0016CXmY;u_J\u001c\b\u0005C\u0004f\u0001\t\u0007I\u0011\u00024\u0002#A|G-\u00117m_\u000e\fG/[8o'&TX-F\u0001h!\t\u0001\u0002.\u0003\u0002j#\t\u0019\u0011J\u001c;\t\r-\u0004\u0001\u0015!\u0003h\u0003I\u0001x\u000eZ!mY>\u001c\u0017\r^5p]NK'0\u001a\u0011\t\u000f5\u0004!\u0019!C\u0005]\u0006\u0011\u0002o\u001c3BY2|7-\u0019;j_:$U\r\\1z+\u0005y\u0007C\u0001\tq\u0013\t\t\u0018C\u0001\u0003M_:<\u0007BB:\u0001A\u0003%q.A\nq_\u0012\fE\u000e\\8dCRLwN\u001c#fY\u0006L\b\u0005C\u0004v\u0001\t\u0007I\u0011\u00028\u0002%A|Gm\u0011:fCRLwN\u001c+j[\u0016|W\u000f\u001e\u0005\u0007o\u0002\u0001\u000b\u0011B8\u0002'A|Gm\u0011:fCRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\t\u000fe\u0004!\u0019!C\u0005u\u0006Ia.Y7fgB\f7-Z\u000b\u0002wB\u0019A0a\u0002\u000f\u0007u\f\u0019\u0001\u0005\u0002\u007f#5\tqPC\u0002\u0002\u0002u\ta\u0001\u0010:p_Rt\u0014bAA\u0003#\u00051\u0001K]3eK\u001aLA!!\u0003\u0002\f\t11\u000b\u001e:j]\u001eT1!!\u0002\u0012\u0011\u001d\ty\u0001\u0001Q\u0001\nm\f!B\\1nKN\u0004\u0018mY3!\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\"A\flk\n,'O\\3uKN$%/\u001b<feB{GMT1nKV\u0011\u0011q\u0003\t\u0005!\u0005e10C\u0002\u0002\u001cE\u0011aa\u00149uS>t\u0007\u0002CA\u0010\u0001\u0001\u0006I!a\u0006\u00021-,(-\u001a:oKR,7\u000f\u0012:jm\u0016\u0014\bk\u001c3OC6,\u0007\u0005C\u0005\u0002$\u0001\u0011\r\u0011\"\u0003\u0002&\u0005IAM]5wKJ\u0004v\u000eZ\u000b\u0003\u0003O\u0001R\u0001EA\r\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0003n_\u0012,GNC\u0002\u000249\n1!\u00199j\u0013\u0011\t9$!\f\u0003\u0007A{G\r\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0014\u0003)!'/\u001b<feB{G\r\t\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003\u0003\nQC\\3xYf\u001c%/Z1uK\u0012,\u00050Z2vi>\u00148/\u0006\u0002\u0002DA1\u0011QIA(_>l!!a\u0012\u000b\t\u0005%\u00131J\u0001\b[V$\u0018M\u00197f\u0015\r\ti%E\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA)\u0003\u000f\u00121!T1q\u0011!\t)\u0006\u0001Q\u0001\n\u0005\r\u0013A\u00068fo2L8I]3bi\u0016$W\t_3dkR|'o\u001d\u0011\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\u0005)1\u000f^1siR!\u0011QLA2!\r\u0001\u0012qL\u0005\u0004\u0003C\n\"\u0001B+oSRDq!!\u001a\u0002X\u0001\u000710A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\u0005\b\u0003S\u0002A\u0011AA6\u0003e\u0019X\r\u001e+pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0015\t\u0005u\u0013Q\u000e\u0005\b\u0003_\n9\u00071\u0001h\u0003\u0015!x\u000e^1m\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\nab\u001c8OK^\u001cf.\u00199tQ>$8\u000f\u0006\u0004\u0002^\u0005]\u0014\u0011\u0010\u0005\b\u0003K\n\t\b1\u0001|\u0011!\tY(!\u001dA\u0002\u0005u\u0014!C:oCB\u001c\bn\u001c;t!\u0019\ty(!#\u0002\u0010:!\u0011\u0011QAC\u001d\rq\u00181Q\u0005\u0002%%\u0019\u0011qQ\t\u0002\u000fA\f7m[1hK&!\u00111RAG\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000f\u000b\u0002cA\u0013\u0002\u0012&\u0019\u00111\u0013\u0002\u0003)\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8u\u0001")
public class ExecutorPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicLong EXECUTOR_ID_COUNTER;
    private final AtomicInteger totalExpectedExecutors;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long podCreationTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final Option<Pod> driverPod;
    private final Map<Object, Object> newlyCreatedExecutors;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicLong EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private AtomicInteger totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private Option<Pod> driverPod() {
        return this.driverPod;
    }

    private Map<Object, Object> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    public void start(String applicationId) {
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setTotalExpectedExecutors(int total) {
        this.totalExpectedExecutors().set(total);
    }

    private void onNewSnapshots(String applicationId, Seq<ExecutorPodsSnapshot> snapshots) {
        block0: {
            int currentPendingExecutors;
            block2: {
                int currentTotalExpectedExecutors;
                int currentRunningExecutors;
                block1: {
                    this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom()));
                    this.newlyCreatedExecutors().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        BoxedUnit boxedUnit;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            long execId = tuple2._1$mcJ$sp();
                            long timeCreated = tuple2._2$mcJ$sp();
                            long currentTime = $this.clock.getTimeMillis();
                            if (currentTime - timeCreated > this.podCreationTimeout()) {
                                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(182).append("Executor with id ").append(execId).append(" was not detected in the Kubernetes").append(new StringBuilder(52).append(" cluster after ").append(this.podCreationTimeout()).append(" milliseconds despite the fact that a").toString()).append(" previous allocation attempt tried to create it. The executor may have been").append(" deleted but the application missed the deletion event.").toString());
                                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), ((Object)BoxesRunTime.boxToLong((long)execId)).toString())).delete());
                                boxedUnit = this.newlyCreatedExecutors().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                            } else {
                                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(new StringBuilder(31).append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString()).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return boxedUnit2;
                    });
                    if (!snapshots.nonEmpty()) break block0;
                    ExecutorPodsSnapshot latestSnapshot = (ExecutorPodsSnapshot)snapshots.last();
                    currentRunningExecutors = latestSnapshot.executorPods().values().count((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$6(x0$2)));
                    currentPendingExecutors = latestSnapshot.executorPods().values().count((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$7(x0$3)));
                    currentTotalExpectedExecutors = this.totalExpectedExecutors().get();
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Currently have ").append(currentRunningExecutors).append(" running executors and").append(new StringBuilder(31).append(" ").append(currentPendingExecutors).append(" pending executors. ").append(this.newlyCreatedExecutors()).append(" executors").toString()).append(" have been requested but are pending appearance in the cluster.").toString());
                    if (!this.newlyCreatedExecutors().isEmpty() || currentPendingExecutors != 0 || currentRunningExecutors >= currentTotalExpectedExecutors) break block1;
                    int numExecutorsToAllocate = package$.MODULE$.min(currentTotalExpectedExecutors - currentRunningExecutors, this.podAllocationSize());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes.").toString());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                        long newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
                        KubernetesConf<KubernetesExecutorSpecificConf> executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, ((Object)BoxesRunTime.boxToLong((long)newExecutorId)).toString(), applicationId, this.driverPod());
                        SparkPod executorPod = $this.executorBuilder.buildFromFeatures(executorConf);
                        Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
                        $this.kubernetesClient.pods().create((Object[])new Pod[]{podWithAttachedContainer});
                        this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)BoxesRunTime.boxToLong((long)$this.clock.getTimeMillis()));
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
                    });
                    break block0;
                }
                if (currentRunningExecutors < currentTotalExpectedExecutors) break block2;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Current number of running executors is equal to the number of requested executors. Not scaling up further.");
                break block0;
            }
            if (!this.newlyCreatedExecutors().nonEmpty() && currentPendingExecutors == 0) break block0;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(171).append("Still waiting for ").append(this.newlyCreatedExecutors().size() + currentPendingExecutors).append(" executors to begin running before requesting for more executors. # of executors in").append(new StringBuilder(61).append(" pending status in the cluster: ").append(currentPendingExecutors).append(". # of executors that we have").toString()).append(" created but we have not observed as being present in the cluster yet:").append(new StringBuilder(2).append(" ").append(this.newlyCreatedExecutors().size()).append(".").toString()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$6(ExecutorPodState x0$2) {
        ExecutorPodState executorPodState = x0$2;
        boolean bl = executorPodState instanceof PodRunning;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$7(ExecutorPodState x0$3) {
        ExecutorPodState executorPodState = x0$3;
        boolean bl = executorPodState instanceof PodPending;
        return bl;
    }

    public ExecutorPodsAllocator(SparkConf conf, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicLong(0L);
        this.totalExpectedExecutors = new AtomicInteger(0);
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, 60000L);
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(46).append("No pod was found named ").append(this.kubernetesDriverPodName()).append(" in the cluster in the ").append(new StringBuilder(53).append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString()).toString());
        }));
        this.newlyCreatedExecutors = Map$.MODULE$.empty();
    }
}

