/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0001\u0003\u0001!q!!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$'BA\u0002\u0005\u0003\rY\u0007h\u001d\u0006\u0003\u000b\u0019\tqa\u00197vgR,'O\u0003\u0002\b\u0011\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Ei\u0011\u0001B\u0005\u0003%\u0011\u0011QdQ8beN,wI]1j]\u0016$7k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\u0005\t\u000f\u0001\u0011\t\u0011)A\u0005+\r\u0001\u0001C\u0001\f\u0018\u001b\u00051\u0011B\u0001\r\u0007\u0005E!\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\u001c\u0005\n5\u0001\u0011\t\u0011)A\u00057\u0005\naA\u001d9d\u000b:4\bC\u0001\u000f \u001b\u0005i\"B\u0001\u0010\t\u0003\r\u0011\boY\u0005\u0003Au\u0011aA\u00159d\u000b:4\u0018B\u0001\u000e\u0012\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u!\t)c&D\u0001'\u0015\t9\u0003&\u0001\u0004dY&,g\u000e\u001e\u0006\u0003S)\n!b[;cKJtW\r^3t\u0015\tYC&A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u00035\n!![8\n\u0005=2#\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014a\u0006:fcV,7\u000f^#yK\u000e,Ho\u001c:t'\u0016\u0014h/[2f!\t\u0019$(D\u00015\u0015\t)d'\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u000e\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0002s\u0005!!.\u0019<b\u0013\tYDGA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!i\u0004A!A!\u0002\u0013q\u0014AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0003\u007f\u0001k\u0011AA\u0005\u0003\u0003\n\u0011!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016D\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\ra>$\u0017\t\u001c7pG\u0006$xN\u001d\t\u0003\u007f\u0015K!A\u0012\u0002\u0003+\u0015CXmY;u_J\u0004v\u000eZ:BY2|7-\u0019;pe\"A\u0001\n\u0001B\u0001B\u0003%\u0011*A\u000bmS\u001a,7-_2mK\u00163XM\u001c;IC:$G.\u001a:\u0011\u0005}R\u0015BA&\u0003\u0005q)\u00050Z2vi>\u0014\bk\u001c3t\u0019&4WmY=dY\u0016l\u0015M\\1hKJD\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAT\u0001\fo\u0006$8\r[#wK:$8\u000f\u0005\u0002@\u001f&\u0011\u0001K\u0001\u0002 \u000bb,7-\u001e;peB{Gm],bi\u000eD7K\\1qg\"|GoU8ve\u000e,\u0007\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\u0002\u0015A|G\u000e\\#wK:$8\u000f\u0005\u0002@)&\u0011QK\u0001\u0002\"\u000bb,7-\u001e;peB{Gm\u001d)pY2LgnZ*oCB\u001c\bn\u001c;T_V\u00148-\u001a\u0005\u0006/\u0002!\t\u0001W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015eS6\fX/_?\u0002\f'\r\u0005\u0002@\u0001!)qA\u0016a\u0001+!)!D\u0016a\u00017!)1E\u0016a\u0001I!)\u0011G\u0016a\u0001e!)QH\u0016a\u0001}!)1I\u0016a\u0001\t\")\u0001J\u0016a\u0001\u0013\")QJ\u0016a\u0001\u001d\")!K\u0016a\u0001'\"9A\r\u0001b\u0001\n\u0017)\u0017A\u0006:fcV,7\u000f^#yK\u000e,Ho\u001c:D_:$X\r\u001f;\u0016\u0003\u0019\u0004\"aZ6\u000e\u0003!T!!N5\u000b\u0003)\fQa]2bY\u0006L!\u0001\u001c5\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW\r\u0003\u0004o\u0001\u0001\u0006IAZ\u0001\u0018e\u0016\fX/Z:u\u000bb,7-\u001e;pe\u000e{g\u000e^3yi\u0002Bq\u0001\u001d\u0001C\u0002\u0013E\u0013/\u0001\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|W#\u0001:\u0011\u0005M$X\"A5\n\u0005UL'A\u0002#pk\ndW\r\u0003\u0004x\u0001\u0001\u0006IA]\u0001\u0014[&t'+Z4jgR,'/\u001a3SCRLw\u000e\t\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0003AIg.\u001b;jC2,\u00050Z2vi>\u00148/F\u0001|!\t\u0019H0\u0003\u0002~S\n\u0019\u0011J\u001c;\t\r}\u0004\u0001\u0015!\u0003|\u0003EIg.\u001b;jC2,\u00050Z2vi>\u00148\u000f\t\u0005\t\u0003\u0007\u0001A\u0011\u0001\u0002\u0002\u0006\u0005\u0001Bm\u001c*f[>4X-\u0012=fGV$xN\u001d\u000b\u0007\u0003\u000f\ti!a\n\u0011\u0007M\fI!C\u0002\u0002\f%\u0014A!\u00168ji\"A\u0011qBA\u0001\u0001\u0004\t\t\"\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\u0004B!a\u0005\u0002\"9!\u0011QCA\u000f!\r\t9\"[\u0007\u0003\u00033Q1!a\u0007\u0015\u0003\u0019a$o\\8u}%\u0019\u0011qD5\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\ty\"\u001b\u0005\t\u0003S\t\t\u00011\u0001\u0002,\u00051!/Z1t_:\u00042AFA\u0017\u0013\r\tyC\u0002\u0002\u0013\u000bb,7-\u001e;pe2{7o\u001d*fCN|g\u000eC\u0004\u00024\u0001!\t%!\u000e\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005\u001d\u0001bBA\u001d\u0001\u0011\u0005\u0013QG\u0001\u0005gR|\u0007\u000fC\u0004\u0002>\u0001!\t%a\u0010\u0002/\u0011|'+Z9vKN$Hk\u001c;bY\u0016CXmY;u_J\u001cH\u0003BA!\u0003\u001b\u0002RaZA\"\u0003\u000fJ1!!\u0012i\u0005\u00191U\u000f^;sKB\u00191/!\u0013\n\u0007\u0005-\u0013NA\u0004C_>dW-\u00198\t\u000f\u0005=\u00131\ba\u0001w\u0006q!/Z9vKN$X\r\u001a+pi\u0006d\u0007bBA*\u0001\u0011\u0005\u0013QK\u0001\u001egV4g-[2jK:$(+Z:pkJ\u001cWm\u001d*fO&\u001cH/\u001a:fIR\u0011\u0011q\t\u0005\b\u00033\u0002A\u0011IA.\u000399W\r^#yK\u000e,Ho\u001c:JIN$\"!!\u0018\u0011\r\u0005}\u0013\u0011NA\t\u001d\u0011\t\t'!\u001a\u000f\t\u0005]\u00111M\u0005\u0002U&\u0019\u0011qM5\u0002\u000fA\f7m[1hK&!\u00111NA7\u0005\r\u0019V-\u001d\u0006\u0004\u0003OJ\u0007bBA9\u0001\u0011\u0005\u00131O\u0001\u0010I>\\\u0015\u000e\u001c7Fq\u0016\u001cW\u000f^8sgR!\u0011\u0011IA;\u0011!\t9(a\u001cA\u0002\u0005u\u0013aC3yK\u000e,Ho\u001c:JINDq!a\u001f\u0001\t\u0003\ni(\u0001\u000bde\u0016\fG/\u001a#sSZ,'/\u00128ea>Lg\u000e\u001e\u000b\u0005\u0003\u007f\n9\t\u0005\u0003\u0002\u0002\u0006\rU\"\u0001\u0001\n\u0007\u0005\u0015\u0015C\u0001\bEe&4XM]#oIB|\u0017N\u001c;\t\u0011\u0005%\u0015\u0011\u0010a\u0001\u0003\u0017\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\u0019\ty&!\u001b\u0002\u000eB91/a$\u0002\u0012\u0005E\u0011bAAIS\n1A+\u001e9mKJ2a!!&\u0001\t\u0005]%\u0001G&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s\u000b:$\u0007o\\5oiN!\u00111SA@\u0011-Q\u00121\u0013B\u0001B\u0003%1$a'\n\u0007i\t\u0019\tC\u0006\u0002 \u0006M%\u0011!Q\u0001\n\u0005-\u0015aD:qCJ\\\u0007K]8qKJ$\u0018.Z:\t\u000f]\u000b\u0019\n\"\u0001\u0002$R1\u0011QUAT\u0003S\u0003B!!!\u0002\u0014\"1!$!)A\u0002mA\u0001\"a(\u0002\"\u0002\u0007\u00111\u0012\u0005\t\u0003[\u000b\u0019\n\"\u0011\u00020\u0006qqN\u001c#jg\u000e|gN\\3di\u0016$G\u0003BA\u0004\u0003cC\u0001\"a-\u0002,\u0002\u0007\u0011QW\u0001\u000beB\u001c\u0017\t\u001a3sKN\u001c\bc\u0001\u000f\u00028&\u0019\u0011\u0011X\u000f\u0003\u0015I\u00038-\u00113ee\u0016\u001c8\u000f")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final KubernetesClient kubernetesClient;
    private final ExecutorService requestExecutorsService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final ExecutionContextExecutorService requestExecutorContext;
    private final double minRegisteredRatio;
    private final int initialExecutors;

    private ExecutionContextExecutorService requestExecutorContext() {
        return this.requestExecutorContext;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        this.removeExecutor(executorId, reason);
    }

    public void start() {
        super.start();
        if (!Utils$.MODULE$.isDynamicAllocationEnabled(this.conf())) {
            this.podAllocator.setTotalExpectedExecutors(this.initialExecutors());
        }
        this.lifecycleEventHandler.start(this);
        this.podAllocator.start(this.applicationId());
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
    }

    public void stop() {
        super.stop();
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown($this.requestExecutorsService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.podAllocator.setTotalExpectedExecutors(requestedTotal);
            return true;
        }, (ExecutionContext)this.requestExecutorContext());
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Boolean2boolean((Boolean)((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])executorIds.toArray(ClassTag$.MODULE$.apply(String.class)))).delete()), (ExecutionContext)this.requestExecutorContext());
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new KubernetesDriverEndpoint(this, super.rpcEnv(), properties);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv, KubernetesClient kubernetesClient, ExecutorService requestExecutorsService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.kubernetesClient = kubernetesClient;
        this.requestExecutorsService = requestExecutorsService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, rpcEnv);
        this.requestExecutorContext = ExecutionContext$.MODULE$.fromExecutorService(requestExecutorsService);
        this.minRegisteredRatio = this.conf().getOption("spark.scheduler.minRegisteredResourcesRatio").isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            super((CoarseGrainedSchedulerBackend)$outer, rpcEnv, sparkProperties);
        }
    }
}

