/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154Qa\u0002\u0005\u0001\u001dQA\u0001b\b\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006c\u0001!\tA\r\u0005\u0006s\u0001!\tE\u000f\u0005\u0006\u0001\u0002!\t%\u0011\u0005\u0006!\u0002!\t%\u0015\u0005\u0006S\u0002!IA\u001b\u0002\u0018\u001b>,h\u000e^*fGJ,Go\u001d$fCR,(/Z*uKBT!!\u0003\u0006\u0002\u0011\u0019,\u0017\r^;sKNT!a\u0003\u0007\u0002\u0007-D4O\u0003\u0002\u000e\u001d\u00051A-\u001a9m_fT!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001d;5\t\u0001\"\u0003\u0002\u001f\u0011\tY2*\u001e2fe:,G/Z:GK\u0006$XO]3D_:4\u0017nZ*uKB\fab[;cKJtW\r^3t\u0007>tgm\u0001\u00011\u0005\tB\u0003cA\u0012%M5\t!\"\u0003\u0002&\u0015\tq1*\u001e2fe:,G/Z:D_:4\u0007CA\u0014)\u0019\u0001!\u0011\"K\u0001\u0002\u0002\u0003\u0005)\u0011\u0001\u0016\u0003\u0007}#\u0013'\u0005\u0002,]A\u0011a\u0003L\u0005\u0003[]\u0011qAT8uQ&tw\r\u0005\u0002$_%\u0011\u0001G\u0003\u0002\u001b\u0017V\u0014WM\u001d8fi\u0016\u001c(k\u001c7f'B,7-\u001b4jG\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M\"\u0004C\u0001\u000f\u0001\u0011\u0015y\"\u00011\u00016a\t1\u0004\bE\u0002$I]\u0002\"a\n\u001d\u0005\u0013%\"\u0014\u0011!A\u0001\u0006\u0003Q\u0013\u0001D2p]\u001aLw-\u001e:f!>$GCA\u001e?!\t\u0019C(\u0003\u0002>\u0015\tA1\u000b]1sWB{G\rC\u0003@\u0007\u0001\u00071(A\u0002q_\u0012\f\u0001eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d\u0007k\u001c3TsN$X-\u001c)s_B,'\u000f^5fgR\t!\t\u0005\u0003D\u00156keB\u0001#I!\t)u#D\u0001G\u0015\t9\u0005%\u0001\u0004=e>|GOP\u0005\u0003\u0013^\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\ri\u0015\r\u001d\u0006\u0003\u0013^\u0001\"a\u0011(\n\u0005=c%AB*ue&tw-\u0001\u0011hKR\fE\rZ5uS>t\u0017\r\\&vE\u0016\u0014h.\u001a;fgJ+7o\\;sG\u0016\u001cH#\u0001*\u0011\u0007MC6L\u0004\u0002U-:\u0011Q)V\u0005\u00021%\u0011qkF\u0001\ba\u0006\u001c7.Y4f\u0013\tI&LA\u0002TKFT!aV\f\u0011\u0005q;W\"A/\u000b\u0005y{\u0016!B7pI\u0016d'B\u00011b\u0003\r\t\u0007/\u001b\u0006\u0003E\u000e\f!b[;cKJtW\r^3t\u0015\t!W-A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003\u0019\f!![8\n\u0005!l&a\u0003%bg6+G/\u00193bi\u0006\f\u0001c]3de\u0016$hk\u001c7v[\u0016t\u0015-\\3\u0015\u00055[\u0007\"\u00027\u0007\u0001\u0004i\u0015AC:fGJ,GOT1nK\u0002")
public class MountSecretsFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Iterable addedVolumes = (Iterable)this.kubernetesConf.roleSecretNamesToMountPaths().keys().map((Function1 & Serializable & scala.Serializable)secretName -> ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeFluentImpl)new VolumeBuilder().withName(this.secretVolumeName((String)secretName))).withNewSecret().withSecretName(secretName)).endSecret()).build(), scala.collection.Iterable$.MODULE$.canBuildFrom());
        Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editOrNewSpec().addToVolumes((Volume[])addedVolumes.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
        scala.collection.immutable.Iterable addedVolumeMounts = (scala.collection.immutable.Iterable)this.kubernetesConf.roleSecretNamesToMountPaths().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String secretName = (String)tuple2._1();
            String mountPath = (String)tuple2._2();
            VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)new VolumeMountBuilder().withName(this.secretVolumeName(secretName))).withMountPath(mountPath)).build();
            return volumeMount;
        }, Iterable$.MODULE$.canBuildFrom());
        Container containerWithMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])addedVolumeMounts.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
        return new SparkPod(podWithVolumes, containerWithMounts);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private String secretVolumeName(String secretName) {
        return new StringBuilder(7).append(secretName).append("-volume").toString();
    }

    public MountSecretsFeatureStep(KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

