/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f!B\u000e\u001d\u0001yA\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011)\u0003!\u0011!Q\u0001\n-CQA\u0015\u0001\u0005\u0002MCqa\u0016\u0001C\u0002\u0013%\u0001\f\u0003\u0004b\u0001\u0001\u0006I!\u0017\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u00199\u0007\u0001)A\u0005I\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007BB7\u0001A\u0003%!\u000eC\u0004o\u0001\u0001\u0007I\u0011B8\t\u0011}\u0004\u0001\u0019!C\u0005\u0003\u0003Aq!!\u0004\u0001A\u0003&\u0001\u000fC\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003'\u0002A\u0011BA\u000b\u0011\u001d\t)\u0006\u0001C\u0005\u0003+Aq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002b\u0001!I!!\u0006\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBAE\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!)\u0001\t\u0013\t\u0019KA\u000eM_\u001e<\u0017N\\4Q_\u0012\u001cF/\u0019;vg^\u000bGo\u00195fe&k\u0007\u000f\u001c\u0006\u0003;y\taa];c[&$(BA\u0010!\u0003\rY\u0007h\u001d\u0006\u0003C\t\na\u0001Z3qY>L(BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0014\t\u0001I\u0013'\u000e\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019y%M[3diB\u0011!gM\u0007\u00029%\u0011A\u0007\b\u0002\u0018\u0019><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJ\u0004\"AN\u001d\u000e\u0003]R!\u0001\u000f\u0012\u0002\u0011%tG/\u001a:oC2L!AO\u001c\u0003\u000f1{wmZ5oO\u0006)\u0011\r\u001d9JI\u000e\u0001\u0001C\u0001 H\u001d\tyT\t\u0005\u0002A\u00076\t\u0011I\u0003\u0002Cy\u00051AH]8pizR\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011aiQ\u0001\u0015[\u0006L(-\u001a'pO\u001eLgnZ%oi\u0016\u0014h/\u00197\u0011\u00071ku*D\u0001D\u0013\tq5I\u0001\u0004PaRLwN\u001c\t\u0003\u0019BK!!U\"\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Q+f\u000b\u0005\u00023\u0001!)1h\u0001a\u0001{!)!j\u0001a\u0001\u0017\u0006\u0011\u0002o\u001c3D_6\u0004H.\u001a;fI\u001a+H/\u001e:f+\u0005I\u0006C\u0001.`\u001b\u0005Y&B\u0001/^\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003=6\nA!\u001e;jY&\u0011\u0001m\u0017\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0003M\u0001x\u000eZ\"p[BdW\r^3e\rV$XO]3!\u0003%\u00198\r[3ek2,'/F\u0001e!\tQV-\u0003\u0002g7\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%A\u0006m_\u001e\u0014VO\u001c8bE2,W#\u00016\u0011\u0005)Z\u0017B\u00017,\u0005!\u0011VO\u001c8bE2,\u0017\u0001\u00047pOJ+hN\\1cY\u0016\u0004\u0013a\u00019pIV\t\u0001\u000fE\u0002M\u001bF\u0004\"A]?\u000e\u0003MT!\u0001^;\u0002\u000b5|G-\u001a7\u000b\u0005Y<\u0018aA1qS*\u0011\u00010_\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001>|\u0003\u001d1\u0017M\u0019:jGbR\u0011\u0001`\u0001\u0003S>L!A`:\u0003\u0007A{G-A\u0004q_\u0012|F%Z9\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004\u0019\u0006\u0015\u0011bAA\u0004\u0007\n!QK\\5u\u0011!\tYaCA\u0001\u0002\u0004\u0001\u0018a\u0001=%c\u0005!\u0001o\u001c3!\u0003\u0015\u0001\b.Y:f+\u0005i\u0014!B:uCJ$HCAA\u0002\u00035)g/\u001a8u%\u0016\u001cW-\u001b<fIR1\u00111AA\u000e\u0003\u0003Bq!!\b\u0010\u0001\u0004\ty\"\u0001\u0004bGRLwN\u001c\t\u0005\u0003C\tYD\u0004\u0003\u0002$\u0005Ub\u0002BA\u0013\u0003cqA!a\n\u000209!\u0011\u0011FA\u0017\u001d\r\u0001\u00151F\u0005\u0002y&\u0011!p_\u0005\u0003qfL1!a\rx\u0003\u0019\u0019G.[3oi&!\u0011qGA\u001d\u0003\u001d9\u0016\r^2iKJT1!a\rx\u0013\u0011\ti$a\u0010\u0003\r\u0005\u001bG/[8o\u0015\u0011\t9$!\u000f\t\u000b9|\u0001\u0019A9\u0002\u000f=t7\t\\8tKR!\u00111AA$\u0011\u001d\tI\u0005\u0005a\u0001\u0003\u0017\n\u0011!\u001a\t\u0005\u0003\u001b\ny%\u0004\u0002\u0002:%!\u0011\u0011KA\u001d\u0005eYUOY3s]\u0016$Xm]\"mS\u0016tG/\u0012=dKB$\u0018n\u001c8\u0002\u001d1|wm\u00155peR\u001cF/\u0019;vg\u0006iAn\\4M_:<7\u000b^1ukN\fA\u0002[1t\u0007>l\u0007\u000f\\3uK\u0012$\"!a\u0017\u0011\u00071\u000bi&C\u0002\u0002`\r\u0013qAQ8pY\u0016\fg.\u0001\u0006dY>\u001cXmV1uG\"\faBZ8s[\u0006$\bk\u001c3Ti\u0006$X\rF\u0002>\u0003OBQA\\\u000bA\u0002E\f\u0011CZ8s[\u0006$\b+Y5sg\n+h\u000e\u001a7f)\ri\u0014Q\u000e\u0005\b\u0003_2\u0002\u0019AA9\u0003\u0015\u0001\u0018-\u001b:t!\u0019\t\u0019(! \u0002\u0004:!\u0011QOA=\u001d\r\u0001\u0015qO\u0005\u0002\t&\u0019\u00111P\"\u0002\u000fA\f7m[1hK&!\u0011qPAA\u0005\r\u0019V-\u001d\u0006\u0004\u0003w\u001a\u0005#\u0002'\u0002\u0006vj\u0014bAAD\u0007\n1A+\u001e9mKJ\nq\"Y<bSR\u001cu.\u001c9mKRLwN\\\u0001\u0016G>tG/Y5oKJ\u001cH)Z:de&\u0004H/[8o)\ri\u0014q\u0012\u0005\u0007\u0003#C\u0002\u0019A9\u0002\u0003A\f!dY8oi\u0006Lg.\u001a:Ti\u0006$Xo\u001d#fg\u000e\u0014\u0018\u000e\u001d;j_:$B!!\u001d\u0002\u0018\"9\u0011\u0011T\rA\u0002\u0005m\u0015aD2p]R\f\u0017N\\3s'R\fG/^:\u0011\u0007I\fi*C\u0002\u0002 N\u0014qbQ8oi\u0006Lg.\u001a:Ti\u0006$Xo]\u0001\u000bM>\u0014X.\u0019;US6,GcA\u001f\u0002&\"1\u0011q\u0015\u000eA\u0002u\nA\u0001^5nK\u0002")
public class LoggingPodStatusWatcherImpl
implements LoggingPodStatusWatcher,
Logging {
    private final String appId;
    private final Option<Object> maybeLoggingInterval;
    private final CountDownLatch podCompletedFuture;
    private final ScheduledExecutorService scheduler;
    private final Runnable logRunnable;
    private Option<Pod> pod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CountDownLatch podCompletedFuture() {
        return this.podCompletedFuture;
    }

    private ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    private Runnable logRunnable() {
        return this.logRunnable;
    }

    private Option<Pod> pod() {
        return this.pod;
    }

    private void pod_$eq(Option<Pod> x$1) {
        this.pod = x$1;
    }

    private String phase() {
        return (String)this.pod().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getStatus().getPhase()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown");
    }

    public void start() {
        this.maybeLoggingInterval.foreach((Function1 & Serializable & scala.Serializable)interval -> LoggingPodStatusWatcherImpl.$anonfun$start$1(this, BoxesRunTime.unboxToLong((Object)interval)));
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        this.pod_$eq((Option<Pod>)Option$.MODULE$.apply((Object)pod));
        Watcher.Action action2 = action;
        boolean bl = Watcher.Action.DELETED.equals(action2) ? true : Watcher.Action.ERROR.equals(action2);
        if (bl) {
            this.closeWatch();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            this.logLongStatus();
            if (this.hasCompleted()) {
                this.closeWatch();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void onClose(KubernetesClientException e) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Stopping watching application ").append($this.appId).append(" with last-observed phase ").append(this.phase()).toString());
        this.closeWatch();
    }

    public void org$apache$spark$deploy$k8s$submit$LoggingPodStatusWatcherImpl$$logShortStatus() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Application status for ").append($this.appId).append(" (phase: ").append(this.phase()).append(")").toString());
    }

    private void logLongStatus() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("State changed, new state: ").append(this.pod().map((Function1 & Serializable & scala.Serializable)pod -> this.formatPodState((Pod)pod)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown")).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasCompleted() {
        String string = this.phase();
        String string2 = "Succeeded";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.phase();
        String string4 = "Failed";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private void closeWatch() {
        this.podCompletedFuture().countDown();
        this.scheduler().shutdown();
    }

    private String formatPodState(Pod pod) {
        Seq details = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"pod name", (Object)pod.getMetadata().getName()), new Tuple2((Object)"namespace", (Object)pod.getMetadata().getNamespace()), new Tuple2((Object)"labels", (Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(pod.getMetadata().getLabels()).asScala()).mkString(", ")), new Tuple2((Object)"pod uid", (Object)pod.getMetadata().getUid()), new Tuple2((Object)"creation time", (Object)this.formatTime(pod.getMetadata().getCreationTimestamp())), new Tuple2((Object)"service account name", (Object)pod.getSpec().getServiceAccountName()), new Tuple2((Object)"volumes", (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getSpec().getVolumes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Buffer$.MODULE$.canBuildFrom())).mkString(", ")), new Tuple2((Object)"node name", (Object)pod.getSpec().getNodeName()), new Tuple2((Object)"start time", (Object)this.formatTime(pod.getStatus().getStartTime())), new Tuple2((Object)"container images", (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getImage(), Buffer$.MODULE$.canBuildFrom())).mkString(", ")), new Tuple2((Object)"phase", (Object)pod.getStatus().getPhase()), new Tuple2((Object)"status", (Object)pod.getStatus().getContainerStatuses().toString())}));
        return this.formatPairsBundle((Seq<Tuple2<String, String>>)details);
    }

    private String formatPairsBundle(Seq<Tuple2<String, String>> pairs) {
        return ((TraversableOnce)pairs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(5).append("\n\t ").append(k).append(": ").append(Option$.MODULE$.apply((Object)v).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LoggingPodStatusWatcherImpl.$anonfun$formatPairsBundle$2(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("");
    }

    @Override
    public void awaitCompletion() {
        this.podCompletedFuture().await();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)this.pod().map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(27).append("Container final statuses:\n\n").append(this.containersDescription((Pod)p)).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "No containers were found in the driver pod."));
    }

    private String containersDescription(Pod p) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)status -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container name", (Object)status.getName()), new Tuple2((Object)"Container image", (Object)status.getImage())}))).$plus$plus(this.containerStatusDescription((ContainerStatus)status), Seq$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)pairs -> this.formatPairsBundle((Seq<Tuple2<String, String>>)pairs), Buffer$.MODULE$.canBuildFrom())).mkString("\n\n");
    }

    private Seq<Tuple2<String, String>> containerStatusDescription(ContainerStatus containerStatus) {
        ContainerState state = containerStatus.getState();
        return (Seq)Option$.MODULE$.apply((Object)state.getRunning()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)state.getTerminated())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)state.getWaiting())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            KubernetesResource kubernetesResource = x0$1;
            if (kubernetesResource instanceof ContainerStateRunning) {
                ContainerStateRunning containerStateRunning = (ContainerStateRunning)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Running"), new Tuple2((Object)"Container started at", (Object)this.formatTime(containerStateRunning.getStartedAt()))}));
            } else if (kubernetesResource instanceof ContainerStateWaiting) {
                ContainerStateWaiting containerStateWaiting = (ContainerStateWaiting)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Waiting"), new Tuple2((Object)"Pending reason", (Object)containerStateWaiting.getReason())}));
            } else if (kubernetesResource instanceof ContainerStateTerminated) {
                ContainerStateTerminated containerStateTerminated = (ContainerStateTerminated)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Terminated"), new Tuple2((Object)"Exit code", (Object)containerStateTerminated.getExitCode().toString())}));
            } else {
                throw new SparkException(new StringBuilder(34).append("Unexpected container status type ").append(kubernetesResource.getClass()).append(".").toString());
            }
            return seq;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"N/A")})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String formatTime(String time) {
        if (time == null) {
            String string = time;
            String string2 = "";
            if (string == null) {
                if (string2 == null) return "N/A";
            } else if (string.equals(string2)) return "N/A";
        }
        String string = time;
        return string;
    }

    public static final /* synthetic */ ScheduledFuture $anonfun$start$1(LoggingPodStatusWatcherImpl $this, long interval) {
        return $this.scheduler().scheduleAtFixedRate($this.logRunnable(), 0L, interval, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ boolean $anonfun$formatPairsBundle$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public LoggingPodStatusWatcherImpl(String appId, Option<Object> maybeLoggingInterval) {
        this.appId = appId;
        this.maybeLoggingInterval = maybeLoggingInterval;
        Logging.$init$((Logging)this);
        this.podCompletedFuture = new CountDownLatch(1);
        this.scheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("logging-pod-status-watcher");
        this.logRunnable = new Runnable(this){
            private final /* synthetic */ LoggingPodStatusWatcherImpl $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$k8s$submit$LoggingPodStatusWatcherImpl$$logShortStatus();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.pod = Option$.MODULE$.empty();
    }
}

