/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.spark_project.guava.io.BaseEncoding;
import org.spark_project.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!\u0002\u0011\"\u0001\u001dj\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b)\u0003A\u0011A&\t\u000fI\u0003!\u0019!C\u0005'\"1!\r\u0001Q\u0001\nQCqa\u0019\u0001C\u0002\u0013%1\u000b\u0003\u0004e\u0001\u0001\u0006I\u0001\u0016\u0005\bK\u0002\u0011\r\u0011\"\u0003T\u0011\u00191\u0007\u0001)A\u0005)\"9q\r\u0001b\u0001\n\u0013\u0019\u0006B\u00025\u0001A\u0003%A\u000bC\u0004j\u0001\t\u0007I\u0011B*\t\r)\u0004\u0001\u0015!\u0003U\u0011\u001dY\u0007A1A\u0005\n1Da!\u001e\u0001!\u0002\u0013i\u0007b\u0002<\u0001\u0005\u0004%Ia\u0015\u0005\u0007o\u0002\u0001\u000b\u0011\u0002+\t\u000fa\u0004!\u0019!C\u0005'\"1\u0011\u0010\u0001Q\u0001\nQCqA\u001f\u0001C\u0002\u0013%1\u000b\u0003\u0004|\u0001\u0001\u0006I\u0001\u0016\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nyD\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u000f\u0005%\u0001\u0001)A\u0005/\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000\t1CI]5wKJ\\UOY3s]\u0016$Xm]\"sK\u0012,g\u000e^5bYN4U-\u0019;ve\u0016\u001cF/\u001a9\u000b\u0005\t\u001a\u0013\u0001\u00034fCR,(/Z:\u000b\u0005\u0011*\u0013aA69g*\u0011aeJ\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c2\u0001\u0001\u00185!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fMB\u0011QGN\u0007\u0002C%\u0011q'\t\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\u0002\u001d-,(-\u001a:oKR,7oQ8oM\u000e\u0001\u0001GA\u001eB!\raThP\u0007\u0002G%\u0011ah\t\u0002\u000f\u0017V\u0014WM\u001d8fi\u0016\u001c8i\u001c8g!\t\u0001\u0015\t\u0004\u0001\u0005\u0013\t\u000b\u0011\u0011!A\u0001\u0006\u0003\u0019%aA0%cE\u0011Ai\u0012\t\u0003_\u0015K!A\u0012\u0019\u0003\u000f9{G\u000f[5oOB\u0011q\u0006S\u0005\u0003\u0013B\u00121!\u00118z\u0003\u0019a\u0014N\\5u}Q\u0011A*\u0014\t\u0003k\u0001AQ\u0001\u000f\u0002A\u00029\u0003$aT)\u0011\u0007qj\u0004\u000b\u0005\u0002A#\u0012I!)TA\u0001\u0002\u0003\u0015\taQ\u0001\u001b[\u0006L(-Z'pk:$X\rZ(BkRDGk\\6f]\u001aKG.Z\u000b\u0002)B\u0019q&V,\n\u0005Y\u0003$AB(qi&|g\u000e\u0005\u0002Y?:\u0011\u0011,\u0018\t\u00035Bj\u0011a\u0017\u0006\u00039f\na\u0001\u0010:p_Rt\u0014B\u000101\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0003\u0014aG7bs\n,Wj\\;oi\u0016$w*Q;uQR{7.\u001a8GS2,\u0007%A\rnCf\u0014W-T8v]R,Gm\u00117jK:$8*Z=GS2,\u0017AG7bs\n,Wj\\;oi\u0016$7\t\\5f]R\\U-\u001f$jY\u0016\u0004\u0013AG7bs\n,Wj\\;oi\u0016$7\t\\5f]R\u001cUM\u001d;GS2,\u0017aG7bs\n,Wj\\;oi\u0016$7\t\\5f]R\u001cUM\u001d;GS2,\u0007%\u0001\fnCf\u0014W-T8v]R,GmQ1DKJ$h)\u001b7f\u0003]i\u0017-\u001f2f\u001b>,h\u000e^3e\u0007\u0006\u001cUM\u001d;GS2,\u0007%\u0001\u000bee&4XM]*feZL7-Z!dG>,h\u000e^\u0001\u0016IJLg/\u001a:TKJ4\u0018nY3BG\u000e|WO\u001c;!\u0003Ay\u0017-\u001e;i)>\\WM\u001c\"bg\u00164D'F\u0001n!\rySK\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017B\u00011q\u0003Ey\u0017-\u001e;i)>\\WM\u001c\"bg\u00164D\u0007I\u0001\u0011G\u0006\u001cUM\u001d;ECR\f')Y:fmQ\n\u0011cY1DKJ$H)\u0019;b\u0005\u0006\u001cXM\u000e\u001b!\u0003M\u0019G.[3oi.+\u0017\u0010R1uC\n\u000b7/\u001a\u001c5\u0003Q\u0019G.[3oi.+\u0017\u0010R1uC\n\u000b7/\u001a\u001c5A\u0005!2\r\\5f]R\u001cUM\u001d;ECR\f')Y:fmQ\nQc\u00197jK:$8)\u001a:u\t\u0006$\u0018MQ1tKZ\"\u0004%A\ttQ>,H\u000eZ'pk:$8+Z2sKR,\u0012A \t\u0003_}L1!!\u00011\u0005\u001d\u0011un\u001c7fC:\f!c\u001d5pk2$Wj\\;oiN+7M]3uA\u0005YBM]5wKJ\u001c%/\u001a3f]RL\u0017\r\\:TK\u000e\u0014X\r\u001e(b[\u0016,\u0012aV\u0001\u001dIJLg/\u001a:De\u0016$WM\u001c;jC2\u001c8+Z2sKRt\u0015-\\3!\u00031\u0019wN\u001c4jOV\u0014X\rU8e)\u0011\ty!!\u0006\u0011\u0007q\n\t\"C\u0002\u0002\u0014\r\u0012\u0001b\u00159be.\u0004v\u000e\u001a\u0005\b\u0003/I\u0002\u0019AA\b\u0003\r\u0001x\u000eZ\u0001!O\u0016$\u0018\t\u001a3ji&|g.\u00197Q_\u0012\u001c\u0016p\u001d;f[B\u0013x\u000e]3si&,7\u000f\u0006\u0002\u0002\u001eA)\u0001,a\bX/&\u0019\u0011\u0011E1\u0003\u00075\u000b\u0007/\u0001\u0011hKR\fE\rZ5uS>t\u0017\r\\&vE\u0016\u0014h.\u001a;fgJ+7o\\;sG\u0016\u001cHCAA\u0014!\u0019\tI#a\r\u0002:9!\u00111FA\u0018\u001d\rQ\u0016QF\u0005\u0002c%\u0019\u0011\u0011\u0007\u0019\u0002\u000fA\f7m[1hK&!\u0011QGA\u001c\u0005\r\u0019V-\u001d\u0006\u0004\u0003c\u0001\u0004\u0003BA\u001e\u0003#j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0006[>$W\r\u001c\u0006\u0005\u0003\u0007\n)%A\u0002ba&TA!a\u0012\u0002J\u0005Q1.\u001e2fe:,G/Z:\u000b\t\u0005-\u0013QJ\u0001\bM\u0006\u0014'/[29\u0015\t\ty%\u0001\u0002j_&!\u00111KA\u001f\u0005-A\u0015m]'fi\u0006$\u0017\r^1\u0002)M\fg-\u001a$jY\u0016\u001cuN\u001c4U_\n\u000b7/\u001a\u001c5)\u0015!\u0016\u0011LA/\u0011\u0019\tY\u0006\ba\u0001/\u0006!1m\u001c8g\u0011\u0019\ty\u0006\ba\u0001/\u0006Aa-\u001b7f)f\u0004X-A\tsKN|GN^3TK\u000e\u0014X\r\u001e#bi\u0006$b!!\b\u0002f\u0005%\u0004BBA4;\u0001\u0007A+A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ\"sK\u0012,g\u000e^5bY\"1\u00111N\u000fA\u0002]\u000b!b]3de\u0016$h*Y7f\u0003U\u0011Xm]8mm\u0016\u001cVm\u0019:fi2{7-\u0019;j_:$r\u0001VA9\u0003k\nI\b\u0003\u0004\u0002ty\u0001\r\u0001V\u0001\u0015[>,h\u000e^3e+N,'o\u00159fG&4\u0017.\u001a3\t\r\u0005]d\u00041\u0001U\u0003e1\u0018\r\\;f\u001b>,h\u000e^3e\rJ|WnU;c[&$H/\u001a:\t\r\u0005md\u00041\u0001X\u0003aiw.\u001e8uK\u0012\u001c\u0015M\\8oS\u000e\fG\u000eT8dCRLwN\\\u0001\u0018GJ,\u0017\r^3De\u0016$WM\u001c;jC2\u001c8+Z2sKR$\"!!!\u0011\t\u0005m\u00121Q\u0005\u0005\u0003\u000b\u000biD\u0001\u0004TK\u000e\u0014X\r\u001e")
public class DriverKubernetesCredentialsFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<?> kubernetesConf;
    private final Option<String> maybeMountedOAuthTokenFile;
    private final Option<String> maybeMountedClientKeyFile;
    private final Option<String> maybeMountedClientCertFile;
    private final Option<String> maybeMountedCaCertFile;
    private final Option<String> driverServiceAccount;
    private final Option<String> oauthTokenBase64;
    private final Option<String> caCertDataBase64;
    private final Option<String> clientKeyDataBase64;
    private final Option<String> clientCertDataBase64;
    private final boolean shouldMountSecret;
    private final String driverCredentialsSecretName;

    private Option<String> maybeMountedOAuthTokenFile() {
        return this.maybeMountedOAuthTokenFile;
    }

    private Option<String> maybeMountedClientKeyFile() {
        return this.maybeMountedClientKeyFile;
    }

    private Option<String> maybeMountedClientCertFile() {
        return this.maybeMountedClientCertFile;
    }

    private Option<String> maybeMountedCaCertFile() {
        return this.maybeMountedCaCertFile;
    }

    private Option<String> driverServiceAccount() {
        return this.driverServiceAccount;
    }

    private Option<String> oauthTokenBase64() {
        return this.oauthTokenBase64;
    }

    private Option<String> caCertDataBase64() {
        return this.caCertDataBase64;
    }

    private Option<String> clientKeyDataBase64() {
        return this.clientKeyDataBase64;
    }

    private Option<String> clientCertDataBase64() {
        return this.clientCertDataBase64;
    }

    private boolean shouldMountSecret() {
        return this.shouldMountSecret;
    }

    private String driverCredentialsSecretName() {
        return this.driverCredentialsSecretName;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        SparkPod sparkPod;
        if (!this.shouldMountSecret()) {
            sparkPod = pod.copy((Pod)KubernetesUtils$.MODULE$.buildPodWithServiceAccount(this.driverServiceAccount(), pod).getOrElse((Function0 & Serializable & scala.Serializable)() -> pod.pod()), pod.copy$default$2());
        } else {
            Pod driverPodWithMountedKubernetesCredentials = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)new PodBuilder(pod.pod()).editOrNewSpec().addNewVolume().withName(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME()).withNewSecret().withSecretName(this.driverCredentialsSecretName())).endSecret()).endVolume()).endSpec()).build();
            Container driverContainerWithMountedSecretVolume = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(pod.container()).addNewVolumeMount().withName(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME()).withMountPath(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRETS_BASE_DIR())).endVolumeMount()).build();
            sparkPod = new SparkPod(driverPodWithMountedKubernetesCredentials, driverContainerWithMountedSecretVolume);
        }
        return sparkPod;
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        Option<String> resolvedMountedOAuthTokenFile = this.resolveSecretLocation(this.maybeMountedOAuthTokenFile(), this.oauthTokenBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_PATH());
        Option<String> resolvedMountedClientKeyFile = this.resolveSecretLocation(this.maybeMountedClientKeyFile(), this.clientKeyDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_PATH());
        Option<String> resolvedMountedClientCertFile = this.resolveSecretLocation(this.maybeMountedClientCertFile(), this.clientCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_PATH());
        Option<String> resolvedMountedCaCertFile = this.resolveSecretLocation(this.maybeMountedCaCertFile(), this.caCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_PATH());
        scala.collection.immutable.Map redactedTokens = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.kubernetesConf.sparkConf().getAll())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DriverKubernetesCredentialsFeatureStep.$anonfun$getAdditionalPodSystemProperties$1(x$1))))).toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> "<present_but_redacted>");
        return redactedTokens.$plus$plus((GenTraversableOnce)resolvedMountedCaCertFile.map((Function1 & Serializable & scala.Serializable)file -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString()), file)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)resolvedMountedClientKeyFile.map((Function1 & Serializable & scala.Serializable)file -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString()), file)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)resolvedMountedClientCertFile.map((Function1 & Serializable & scala.Serializable)file -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString()), file)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)resolvedMountedOAuthTokenFile.map((Function1 & Serializable & scala.Serializable)file -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()).toString()), file)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return this.shouldMountSecret() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Secret[]{this.createCredentialsSecret()})) : (Seq)Seq$.MODULE$.empty();
    }

    private Option<String> safeFileConfToBase64(String conf, String fileType) {
        return this.kubernetesConf.getOption(conf).map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3)).map((Function1 & Serializable & scala.Serializable)file -> {
            Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> String.format("%s provided at %s does not exist or is not a file.", fileType, file.getAbsolutePath()));
            return BaseEncoding.base64().encode(Files.toByteArray((File)file));
        });
    }

    private scala.collection.immutable.Map<String, String> resolveSecretData(Option<String> userSpecifiedCredential, String secretName) {
        return (scala.collection.immutable.Map)userSpecifiedCredential.map((Function1 & Serializable & scala.Serializable)valueBase64 -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)secretName), valueBase64)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    private Option<String> resolveSecretLocation(Option<String> mountedUserSpecified, Option<String> valueMountedFromSubmitter, String mountedCanonicalLocation) {
        return mountedUserSpecified.orElse((Function0 & Serializable & scala.Serializable)() -> valueMountedFromSubmitter.map((Function1 & Serializable & scala.Serializable)x$4 -> mountedCanonicalLocation));
    }

    private Secret createCredentialsSecret() {
        scala.collection.immutable.Map allSecretData = this.resolveSecretData(this.clientKeyDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_SECRET_NAME()).$plus$plus(this.resolveSecretData(this.clientCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_SECRET_NAME())).$plus$plus(this.resolveSecretData(this.caCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_SECRET_NAME())).$plus$plus(this.resolveSecretData(this.oauthTokenBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_SECRET_NAME()));
        return ((SecretBuilder)((SecretFluentImpl)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(this.driverCredentialsSecretName())).endMetadata()).withData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)allSecretData).asJava())).build();
    }

    public static final /* synthetic */ boolean $anonfun$getAdditionalPodSystemProperties$1(Tuple2 x$1) {
        return ((String)x$1._1()).endsWith(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX());
    }

    public DriverKubernetesCredentialsFeatureStep(KubernetesConf<?> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
        this.maybeMountedOAuthTokenFile = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()).toString());
        this.maybeMountedClientKeyFile = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString());
        this.maybeMountedClientCertFile = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString());
        this.maybeMountedCaCertFile = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString());
        this.driverServiceAccount = (Option)kubernetesConf.get((ConfigEntry<?>)Config$.MODULE$.KUBERNETES_SERVICE_ACCOUNT_NAME());
        this.oauthTokenBase64 = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()).toString()).map((Function1 & Serializable & scala.Serializable)token -> BaseEncoding.base64().encode(token.getBytes(StandardCharsets.UTF_8)));
        this.caCertDataBase64 = this.safeFileConfToBase64(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString(), "Driver CA cert file");
        this.clientKeyDataBase64 = this.safeFileConfToBase64(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString(), "Driver client key file");
        this.clientCertDataBase64 = this.safeFileConfToBase64(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString(), "Driver client cert file");
        this.shouldMountSecret = this.oauthTokenBase64().isDefined() || this.caCertDataBase64().isDefined() || this.clientKeyDataBase64().isDefined() || this.clientCertDataBase64().isDefined();
        this.driverCredentialsSecretName = new StringBuilder(23).append(kubernetesConf.appResourceNamePrefix()).append("-kubernetes-credentials").toString();
    }
}

