/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkApplication;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$;
import org.apache.spark.deploy.k8s.submit.Client;
import org.apache.spark.deploy.k8s.submit.ClientArguments;
import org.apache.spark.deploy.k8s.submit.ClientArguments$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientApplication$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder$;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcherImpl;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3Q!\u0003\u0006\u0001!YAQ!\t\u0001\u0005\u0002\rBQA\n\u0001\u0005B\u001dBQ!\u0011\u0001\u0005\n\t;aA\u0013\u0006\t\u0002AYeAB\u0005\u000b\u0011\u0003\u0001B\nC\u0003\"\u000b\u0011\u0005Q\nC\u0003O\u000b\u0011\u0005q\nC\u0003R\u000b\u0011\u0005!KA\u000eLk\n,'O\\3uKN\u001cE.[3oi\u0006\u0003\b\u000f\\5dCRLwN\u001c\u0006\u0003\u00171\taa];c[&$(BA\u0007\u000f\u0003\rY\u0007h\u001d\u0006\u0003\u001fA\ta\u0001Z3qY>L(BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011AD\u0005\u0003A9\u0011\u0001c\u00159be.\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\n\t\u0003K\u0001i\u0011AC\u0001\u0006gR\f'\u000f\u001e\u000b\u0004Q-Z\u0004C\u0001\r*\u0013\tQ\u0013D\u0001\u0003V]&$\b\"\u0002\u0017\u0003\u0001\u0004i\u0013\u0001B1sON\u00042\u0001\u0007\u00181\u0013\ty\u0013DA\u0003BeJ\f\u0017\u0010\u0005\u00022q9\u0011!G\u000e\t\u0003gei\u0011\u0001\u000e\u0006\u0003k\t\na\u0001\u0010:p_Rt\u0014BA\u001c\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]J\u0002\"\u0002\u001f\u0003\u0001\u0004i\u0014\u0001B2p]\u001a\u0004\"AP \u000e\u0003AI!\u0001\u0011\t\u0003\u0013M\u0003\u0018M]6D_:4\u0017a\u0001:v]R\u0019\u0001f\u0011%\t\u000b\u0011\u001b\u0001\u0019A#\u0002\u001f\rd\u0017.\u001a8u\u0003J<W/\\3oiN\u0004\"!\n$\n\u0005\u001dS!aD\"mS\u0016tG/\u0011:hk6,g\u000e^:\t\u000b%\u001b\u0001\u0019A\u001f\u0002\u0013M\u0004\u0018M]6D_:4\u0017aG&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003B\u0004H.[2bi&|g\u000e\u0005\u0002&\u000bM\u0011Qa\u0006\u000b\u0002\u0017\u0006Qq-\u001a;BaBt\u0015-\\3\u0015\u0005A\u0002\u0006\"\u0002\u001f\b\u0001\u0004i\u0014!F4fiJ+7o\\;sG\u0016t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u000b\u0003aMCQ\u0001\u0016\u0005A\u0002A\nq!\u00199q\u001d\u0006lW\r")
public class KubernetesClientApplication
implements SparkApplication {
    public static String getResourceNamePrefix(String string) {
        return KubernetesClientApplication$.MODULE$.getResourceNamePrefix(string);
    }

    public static String getAppName(SparkConf sparkConf) {
        return KubernetesClientApplication$.MODULE$.getAppName(sparkConf);
    }

    public void start(String[] args, SparkConf conf) {
        ClientArguments parsedArguments = ClientArguments$.MODULE$.fromCommandLineArgs(args);
        this.run(parsedArguments, conf);
    }

    private void run(ClientArguments clientArguments, SparkConf sparkConf) {
        String appName = (String)sparkConf.getOption("spark.app.name").getOrElse((Function0 & Serializable & scala.Serializable)() -> "spark");
        String kubernetesAppId = new StringBuilder(6).append("spark-").append(UUID.randomUUID().toString().replaceAll("-", "")).toString();
        boolean waitForAppCompletion = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(Config$.MODULE$.WAIT_FOR_APP_COMPLETION()));
        String kubernetesResourceNamePrefix = KubernetesClientApplication$.MODULE$.getResourceNamePrefix(appName);
        sparkConf.set(Config$.MODULE$.KUBERNETES_PYSPARK_PY_FILES(), clientArguments.maybePyFiles().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf = KubernetesConf$.MODULE$.createDriverConf(sparkConf, appName, kubernetesResourceNamePrefix, kubernetesAppId, clientArguments.mainAppResource(), clientArguments.mainClass(), clientArguments.driverArgs(), clientArguments.maybePyFiles());
        KubernetesDriverBuilder builder = new KubernetesDriverBuilder(KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$1(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$2(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$3(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$4(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$5(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$6(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$7(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$8(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$9(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$10());
        String namespace = kubernetesConf.namespace();
        String master = KubernetesUtils$.MODULE$.parseMasterUrl(sparkConf.get("spark.master"));
        None$ loggingInterval = waitForAppCompletion ? new Some(sparkConf.get(Config$.MODULE$.REPORT_INTERVAL())) : None$.MODULE$;
        LoggingPodStatusWatcherImpl watcher = new LoggingPodStatusWatcherImpl(kubernetesAppId, (Option<Object>)loggingInterval, waitForAppCompletion);
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SparkKubernetesClientFactory$.MODULE$.createKubernetesClient(master, (Option<String>)new Some((Object)namespace), Config$.MODULE$.KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX(), sparkConf, (Option<File>)None$.MODULE$, (Option<File>)None$.MODULE$), (Function1 & Serializable & scala.Serializable)kubernetesClient -> {
            KubernetesClientApplication.$anonfun$run$5(builder, kubernetesConf, waitForAppCompletion, appName, watcher, kubernetesResourceNamePrefix, kubernetesClient);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$run$5(KubernetesDriverBuilder builder$1, KubernetesConf kubernetesConf$1, boolean waitForAppCompletion$1, String appName$1, LoggingPodStatusWatcherImpl watcher$1, String kubernetesResourceNamePrefix$1, KubernetesClient kubernetesClient) {
        Client client = new Client(builder$1, kubernetesConf$1, kubernetesClient, waitForAppCompletion$1, appName$1, watcher$1, kubernetesResourceNamePrefix$1);
        client.run();
    }
}

