/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3Q!\u0002\u0004\u0001\u0019IA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006O\u0001!\t\u0005\u000b\u0005\u0006]\u0001!Ia\f\u0002\u0018\u001b>,h\u000e\u001e,pYVlWm\u001d$fCR,(/Z*uKBT!a\u0002\u0005\u0002\u0011\u0019,\u0017\r^;sKNT!!\u0003\u0006\u0002\u0007-D4O\u0003\u0002\f\u0019\u00051A-\u001a9m_fT!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\ta!\u0003\u0002\u001d\r\tY2*\u001e2fe:,G/Z:GK\u0006$XO]3D_:4\u0017nZ*uKB\fAaY8oM\u000e\u0001\u0001C\u0001\u0011\"\u001b\u0005A\u0011B\u0001\u0012\t\u00059YUOY3s]\u0016$Xm]\"p]\u001a\fa\u0001P5oSRtDCA\u0013'!\tQ\u0002\u0001C\u0003\u001e\u0005\u0001\u0007q$\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u0002*YA\u0011\u0001EK\u0005\u0003W!\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006[\r\u0001\r!K\u0001\u0004a>$\u0017\u0001E2p]N$(/^2u->dW/\\3t)\t\u0001\u0004\u000bE\u00022sqr!AM\u001c\u000f\u0005M2T\"\u0001\u001b\u000b\u0005Ur\u0012A\u0002\u001fs_>$h(C\u0001\u0017\u0013\tAT#A\u0004qC\u000e\\\u0017mZ3\n\u0005iZ$\u0001C%uKJ\f'\r\\3\u000b\u0005a*\u0002\u0003\u0002\u000b>\u007f5K!AP\u000b\u0003\rQ+\b\u000f\\33!\t\u00015*D\u0001B\u0015\t\u00115)A\u0003n_\u0012,GN\u0003\u0002E\u000b\u0006\u0019\u0011\r]5\u000b\u0005\u0019;\u0015AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0001*S\u0001\bM\u0006\u0014'/[29\u0015\u0005Q\u0015AA5p\u0013\ta\u0015IA\u0006W_2,X.Z'pk:$\bC\u0001!O\u0013\ty\u0015I\u0001\u0004W_2,X.\u001a\u0005\u0006#\u0012\u0001\rAU\u0001\fm>dW/\\3Ta\u0016\u001c7\u000fE\u00022sM\u0003\"\u0001\t+\n\u0005UC!\u0001F&vE\u0016\u0014h.\u001a;fgZ{G.^7f'B,7\r")
public class MountVolumesFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf conf;

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Tuple2 tuple2 = this.constructVolumes((Iterable<KubernetesVolumeSpec>)this.conf.volumes()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable volumeMounts = (Iterable)tuple2._1();
        Iterable volumes = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)volumeMounts, (Object)volumes);
        Tuple2 tuple23 = tuple22;
        Iterable volumeMounts2 = (Iterable)tuple23._1();
        Iterable volumes2 = (Iterable)tuple23._2();
        Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editSpec().addToVolumes((Volume[])volumes2.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
        Container containerWithVolumeMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])volumeMounts2.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
        return new SparkPod(podWithVolumes, containerWithVolumeMounts);
    }

    private Iterable<Tuple2<VolumeMount, Volume>> constructVolumes(Iterable<KubernetesVolumeSpec> volumeSpecs) {
        return (Iterable)volumeSpecs.map((Function1 & Serializable & scala.Serializable)spec -> {
            VolumeBuilder volumeBuilder;
            VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)((VolumeMountFluentImpl)((VolumeMountFluentImpl)new VolumeMountBuilder().withMountPath(spec.mountPath())).withReadOnly(Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly()))).withSubPath(spec.mountSubPath())).withName(spec.volumeName())).build();
            KubernetesVolumeSpecificConf kubernetesVolumeSpecificConf = spec.volumeConf();
            if (kubernetesVolumeSpecificConf instanceof KubernetesHostPathVolumeConf) {
                KubernetesHostPathVolumeConf kubernetesHostPathVolumeConf = (KubernetesHostPathVolumeConf)kubernetesVolumeSpecificConf;
                String hostPath = kubernetesHostPathVolumeConf.hostPath();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withHostPath(new HostPathVolumeSource(hostPath, ""));
            } else if (kubernetesVolumeSpecificConf instanceof KubernetesPVCVolumeConf) {
                KubernetesPVCVolumeConf kubernetesPVCVolumeConf = (KubernetesPVCVolumeConf)kubernetesVolumeSpecificConf;
                String claimName = kubernetesPVCVolumeConf.claimName();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly())));
            } else if (kubernetesVolumeSpecificConf instanceof KubernetesEmptyDirVolumeConf) {
                KubernetesEmptyDirVolumeConf kubernetesEmptyDirVolumeConf = (KubernetesEmptyDirVolumeConf)kubernetesVolumeSpecificConf;
                Option<String> medium = kubernetesEmptyDirVolumeConf.medium();
                Option<String> sizeLimit = kubernetesEmptyDirVolumeConf.sizeLimit();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withEmptyDir(new EmptyDirVolumeSource((String)medium.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), new Quantity((String)sizeLimit.orNull(Predef$.MODULE$.$conforms()))));
            } else {
                throw new MatchError((Object)kubernetesVolumeSpecificConf);
            }
            VolumeBuilder volumeBuilder2 = volumeBuilder;
            Volume volume = ((VolumeBuilder)volumeBuilder2.withName(spec.volumeName())).build();
            return new Tuple2((Object)volumeMount, (Object)volume);
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public MountVolumesFeatureStep(KubernetesConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
    }
}

