/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!B\f\u0019\u0001y!\u0003\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011A\u001a\t\u0011a\u0002!\u0011!Q\u0001\nQB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A1\n\u0001B\u0001B\u0003%A\nC\u0003a\u0001\u0011\u0005\u0011\rC\u0004h\u0001\t\u0007I\u0011\u00025\t\r-\u0004\u0001\u0015!\u0003j\u0011!a\u0007\u0001#b\u0001\n\u0013i\u0007\"B9\u0001\t\u0003\u0011\b\"B>\u0001\t\u0013a\bbBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\ty\u0006\u0001C\u0005\u0003CBq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u001e9\u0011\u0011\u0015\r\t\n\u0005\rfAB\f\u0019\u0011\u0013\t)\u000b\u0003\u0004a'\u0011\u0005\u0011q\u0015\u0005\n\u0003S\u001b\"\u0019!C\u0001\u0003WC\u0001\"!,\u0014A\u0003%\u0011Q\u0013\u0002\u001d\u000bb,7-\u001e;peB{Gm\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0015\tI\"$A\u0002lqMT!a\u0007\u000f\u0002\u000f\rdWo\u001d;fe*\u0011QDH\u0001\ng\u000eDW\rZ;mKJT!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-_5\tQF\u0003\u0002/=\u0005A\u0011N\u001c;fe:\fG.\u0003\u00021[\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001!F\u00015!\t)d'D\u0001\u001f\u0013\t9dDA\u0005Ta\u0006\u00148nQ8oM\u0006)1m\u001c8gA\u0005\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003w\u0011k\u0011\u0001\u0010\u0006\u0003{y\naa\u00197jK:$(BA A\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003\u0003\n\u000bqAZ1ce&\u001c\u0007HC\u0001D\u0003\tIw.\u0003\u0002Fy\t\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\tA\u0015*D\u0001\u0019\u0013\tQ\u0005D\u0001\u000eFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^:Ti>\u0014X-A\u000bsK6|g/\u001a3Fq\u0016\u001cW\u000f^8sg\u000e\u000b7\r[3\u0011\t53\u0006\fW\u0007\u0002\u001d*\u0011q\nU\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003#J\u000baaY8n[>t'BA*U\u0003\u00199wn\\4mK*\tQ+A\u0002d_6L!a\u0016(\u0003\u000b\r\u000b7\r[3\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00027b]\u001eT\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\n!Aj\u001c8h\u0003\u0019a\u0014N\\5u}Q)!m\u00193fMB\u0011\u0001\n\u0001\u0005\u0006c\u0019\u0001\r\u0001\u000e\u0005\u0006s\u0019\u0001\rA\u000f\u0005\u0006\r\u001a\u0001\ra\u0012\u0005\u0006\u0017\u001a\u0001\r\u0001T\u0001\u0018KZ,g\u000e\u001e)s_\u000e,7o]5oO&sG/\u001a:wC2,\u0012!\u001b\t\u0003M)L!aX\u0014\u00021\u00154XM\u001c;Qe>\u001cWm]:j]\u001eLe\u000e^3sm\u0006d\u0007%A\u000btQ>,H\u000e\u001a#fY\u0016$X-\u0012=fGV$xN]:\u0016\u00039\u0004\"AJ8\n\u0005A<#a\u0002\"p_2,\u0017M\\\u0001\u0006gR\f'\u000f\u001e\u000b\u0003gZ\u0004\"A\n;\n\u0005U<#\u0001B+oSRDQa\u001e\u0006A\u0002a\f\u0001c]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005!K\u0018B\u0001>\u0019\u0005\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u00039ygNT3x':\f\u0007o\u001d5piN$2a]?\u007f\u0011\u001598\u00021\u0001y\u0011\u0019y8\u00021\u0001\u0002\u0002\u0005I1O\\1qg\"|Go\u001d\t\u0007\u0003\u0007\t\u0019\"!\u0007\u000f\t\u0005\u0015\u0011q\u0002\b\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0013bAA\tO\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000b\u0003/\u00111aU3r\u0015\r\t\tb\n\t\u0004\u0011\u0006m\u0011bAA\u000f1\t!R\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\fac\u001c8GS:\fGNT8o\t\u0016dW\r^3e'R\fG/\u001a\u000b\ng\u0006\r\u0012QFA\u0019\u0003gAq!!\n\r\u0001\u0004\t9#\u0001\u0005q_\u0012\u001cF/\u0019;f!\rA\u0015\u0011F\u0005\u0004\u0003WA\"!\u0004$j]\u0006d\u0007k\u001c3Ti\u0006$X\r\u0003\u0004\u000201\u0001\r![\u0001\u0007Kb,7-\u00133\t\u000b]d\u0001\u0019\u0001=\t\u000f\u0005UB\u00021\u0001\u00028\u0005)R\r_3d\u0013\u0012\u001c(+Z7pm\u0016$\u0017J\u001c*pk:$\u0007#BA\u001d\u0003\u0007JWBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011I\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002F\u0005m\"aA*fi\u0006)\"/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n\u0017b\u001aHcA:\u0002L!9\u0011QJ\u0007A\u0002\u0005=\u0013AC;qI\u0006$X\r\u001a)pIB!\u0011\u0011KA.\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013!B7pI\u0016d'bAA-}\u0005\u0019\u0011\r]5\n\t\u0005u\u00131\u000b\u0002\u0004!>$\u0017a\u0006:f[>4X-\u0012=fGV$xN\u001d$s_6\u001c\u0006/\u0019:l)\u001d\u0019\u00181MA3\u0003OBQa\u001e\bA\u0002aDq!!\n\u000f\u0001\u0004\t9\u0003\u0003\u0004\u000209\u0001\r![\u0001\u000fM&tG-\u0012=jiJ+\u0017m]8o)\u0019\ti'!\u001e\u0002xA!\u0011qNA9\u001b\u0005a\u0012bAA:9\tqQ\t_3dkR|'/\u0012=ji\u0016$\u0007bBA\u0013\u001f\u0001\u0007\u0011q\u0005\u0005\u0007\u0003_y\u0001\u0019A5\u0002#\u0015D\u0018\u000e\u001e*fCN|g.T3tg\u0006<W\r\u0006\u0005\u0002~\u00055\u0015qRAI!\u0011\ty(a\"\u000f\t\u0005\u0005\u00151\u0011\t\u0004\u0003\u000f9\u0013bAACO\u00051\u0001K]3eK\u001aLA!!#\u0002\f\n11\u000b\u001e:j]\u001eT1!!\"(\u0011\u001d\t)\u0003\u0005a\u0001\u0003OAa!a\f\u0011\u0001\u0004I\u0007bBAJ!\u0001\u0007\u0011QS\u0001\tKbLGoQ8eKB\u0019a%a&\n\u0007\u0005euEA\u0002J]R\fABZ5oI\u0016C\u0018\u000e^\"pI\u0016$B!!&\u0002 \"9\u0011QE\tA\u0002\u0005\u001d\u0012\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\t\u0003\u0011N\u0019\"aE\u0013\u0015\u0005\u0005\r\u0016!E+O\u0017:{uKT0F1&#vlQ(E\u000bV\u0011\u0011QS\u0001\u0013+:[ejT,O?\u0016C\u0016\nV0D\u001f\u0012+\u0005\u0005")
public class ExecutorPodsLifecycleManager
implements Logging {
    private boolean shouldDeleteExecutors;
    private final SparkConf conf;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Cache<Long, Long> removedExecutorsCache;
    private final long eventProcessingInterval;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    private long eventProcessingInterval() {
        return this.eventProcessingInterval;
    }

    private boolean shouldDeleteExecutors$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if (!this.bitmap$0) {
                this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
                this.bitmap$0 = true;
            }
        }
        return this.shouldDeleteExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return !this.bitmap$0 ? this.shouldDeleteExecutors$lzycompute() : this.shouldDeleteExecutors;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        this.snapshotsStore.addSubscriber(this.eventProcessingInterval(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        block1: {
            HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
            snapshots.foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
                return BoxedUnit.UNIT;
            });
            if (snapshots.nonEmpty()) {
                ExecutorPodsSnapshot latestSnapshot = (ExecutorPodsSnapshot)snapshots.last();
                ((IterableLike)((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$7(x$2)), Seq$.MODULE$.canBuildFrom())).toSet().$minus$minus((GenTraversableOnce)latestSnapshot.executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound)).foreach((Function1 & Serializable & scala.Serializable)missingExecutorId -> ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$8(this, schedulerBackend, execIdsRemovedInThisRound, BoxesRunTime.unboxToLong((Object)missingExecutorId)));
            }
            if (!execIdsRemovedInThisRound.nonEmpty()) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Removed executors with ids ").append(execIdsRemovedInThisRound.mkString(",")).append(" from Spark that were either found to be deleted or non-existent in the cluster.").toString());
        }
    }

    private void onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, Set<Object> execIdsRemovedInRound) {
        this.removeExecutorFromSpark(schedulerBackend, podState, execId);
        if (this.shouldDeleteExecutors()) {
            this.removeExecutorFromK8s(podState.pod());
        }
        execIdsRemovedInRound.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
    }

    private void removeExecutorFromK8s(Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).delete());
    }

    private void removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        block0: {
            if (this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) != null) break block0;
            this.removedExecutorsCache.put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)execId)).toString(), (ExecutorLossReason)exitReason);
        }
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("The executor with id ").append(execId).append(" was deleted by a user or the framework.").toString());
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean exitCausedByApp = tuple22._1$mcZ$sp();
        String exitMessage = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        Tuple2 tuple24 = tuple23;
        boolean exitCausedByApp2 = tuple24._1$mcZ$sp();
        String exitMessage2 = (String)tuple24._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        Option reason = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)pod.getStatus().getMessage());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n       |The executor with id ").append(execId).append(" exited with exit code ").append(exitCode).append(".\n       |The API gave the following brief reason: ").append(reason.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following message: ").append(message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(pod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(containerStatus))).map((Function1 & Serializable & scala.Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Snapshot reported deleted executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                    $this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId);
                    boxedUnit = execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodFailed) {
                    PodFailed podFailed = (PodFailed)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Snapshot reported failed executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                    $this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, (Set<Object>)execIdsRemovedInThisRound$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (executorPodState instanceof PodSucceeded) {
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    if (schedulerBackend$2.isExecutorActive(((Object)BoxesRunTime.boxToLong((long)execId)).toString())) {
                        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Snapshot reported succeeded executor with id ").append(execId).append(", ").append("even though the application has not requested for it to be removed.").toString());
                    } else {
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Snapshot reported succeeded executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).append(".").toString());
                    }
                    $this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, (Set<Object>)execIdsRemovedInThisRound$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$7(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ Object $anonfun$onNewSnapshots$8(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, long missingExecutorId) {
        BoxedUnit boxedUnit;
        if ($this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)missingExecutorId)) == null) {
            String exitReasonMessage = new StringBuilder(191).append("The executor with ID ").append(missingExecutorId).append(" was not found in the").append(" cluster but we didn't get a reason why. Marking the executor as failed. The").append(" executor may have been deleted but the driver missed the deletion event.").toString();
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> exitReasonMessage);
            ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
            schedulerBackend$2.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)missingExecutorId)).toString(), (ExecutorLossReason)exitReason);
            boxedUnit = execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)missingExecutorId));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ContainerStatus containerStatus) {
        return containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Cache<Long, Long> removedExecutorsCache) {
        this.conf = conf;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.removedExecutorsCache = removedExecutorsCache;
        Logging.$init$((Logging)this);
        this.eventProcessingInterval = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
    }
}

