/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%g!B\u0010!\u0001\u0019b\u0003\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011!a\u0006A!A!\u0002\u0013i\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015DQ\u0001\u001b\u0001\u0005\u0002%Dq\u0001\u001e\u0001C\u0002\u0013ES\u000f\u0003\u0004}\u0001\u0001\u0006IA\u001e\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t)\u0001\u0001Q\u0001\n}D\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0017A\u0001\"a\u0005\u0001\t\u0003\u0001\u0013Q\u0003\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0013\u0001\t\u0003\n9\u0005C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\tY\t\u0001C)\u0003\u001b3a!!*\u0001\t\u0005\u001d\u0006B\u00025\u001c\t\u0003\tI\u000bC\u0004\u0002.n!\t%a,\t\u001d\u0005\u0005\u0007\u0001%A\u0002\u0002\u0003%I!a\u0011\u0002D\n\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI*\u0011\u0011EI\u0001\u0004Wb\u001a(BA\u0012%\u0003\u001d\u0019G.^:uKJT!!\n\u0014\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0014\u0005\u0001i\u0003C\u0001\u00180\u001b\u0005\u0011\u0013B\u0001\u0019#\u0005u\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$7\u0001\u0001\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012\u0011\u0003V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018*\u001c9m\u0003\t\u00198\r\u0005\u00029s5\ta%\u0003\u0002;M\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003{\u0019k\u0011A\u0010\u0006\u0003\u007f\u0001\u000baa\u00197jK:$(BA!C\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003\u0007\u0012\u000bqAZ1ce&\u001c\u0007HC\u0001F\u0003\tIw.\u0003\u0002H}\t\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u0010Kb,7-\u001e;peN+'O^5dKB\u0011!*U\u0007\u0002\u0017*\u0011A*T\u0001\u000bG>t7-\u001e:sK:$(B\u0001(P\u0003\u0011)H/\u001b7\u000b\u0003A\u000bAA[1wC&\u0011!k\u0013\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0003+Zk\u0011\u0001I\u0005\u0003/\u0002\u0012!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fA\u0002]8e\u00032dwnY1u_J\u0004\"!\u0016.\n\u0005m\u0003#!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]\u0001\u0016Y&4WmY=dY\u0016,e/\u001a8u\u0011\u0006tG\r\\3s!\t)f,\u0003\u0002`A\taR\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018aC<bi\u000eDWI^3oiN\u0004\"!\u00162\n\u0005\r\u0004#aH#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQNs\u0017\r]:i_R\u001cv.\u001e:dK\u0006Q\u0001o\u001c7m\u000bZ,g\u000e^:\u0011\u0005U3\u0017BA4!\u0005\u0005*\u00050Z2vi>\u0014\bk\u001c3t!>dG.\u001b8h':\f\u0007o\u001d5piN{WO]2f\u0003\u0019a\u0014N\\5u}QQ!n\u001b7n]>\u0004\u0018O]:\u0011\u0005U\u0003\u0001\"B\u0013\u000b\u0001\u0004\u0011\u0004\"\u0002\u001c\u000b\u0001\u00049\u0004\"B\u001e\u000b\u0001\u0004a\u0004\"\u0002%\u000b\u0001\u0004I\u0005\"B*\u000b\u0001\u0004!\u0006\"\u0002-\u000b\u0001\u0004I\u0006\"\u0002/\u000b\u0001\u0004i\u0006\"\u00021\u000b\u0001\u0004\t\u0007\"\u00023\u000b\u0001\u0004)\u0017AE7j]J+w-[:uKJ,GMU1uS>,\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0002s\u0006)1oY1mC&\u00111\u0010\u001f\u0002\u0007\t>,(\r\\3\u0002'5LgNU3hSN$XM]3e%\u0006$\u0018n\u001c\u0011\u0002!%t\u0017\u000e^5bY\u0016CXmY;u_J\u001cX#A@\u0011\u0007]\f\t!C\u0002\u0002\u0004a\u00141!\u00138u\u0003EIg.\u001b;jC2,\u00050Z2vi>\u00148\u000fI\u0001\u0016g\"|W\u000f\u001c3EK2,G/Z#yK\u000e,Ho\u001c:t+\t\tY\u0001E\u0002x\u0003\u001bI1!a\u0004y\u0005\u001d\u0011un\u001c7fC:\fac\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148\u000fI\u0001\u0011I>\u0014V-\\8wK\u0016CXmY;u_J$b!a\u0006\u0002\u001e\u0005]\u0002cA<\u0002\u001a%\u0019\u00111\u0004=\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003?\t\u0002\u0019AA\u0011\u0003))\u00070Z2vi>\u0014\u0018\n\u001a\t\u0005\u0003G\t\tD\u0004\u0003\u0002&\u00055\u0002cAA\u0014q6\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\t\u0014A\u0002\u001fs_>$h(C\u0002\u00020a\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u001a\u0003k\u0011aa\u0015;sS:<'bAA\u0018q\"9\u0011\u0011H\tA\u0002\u0005m\u0012A\u0002:fCN|g\u000eE\u00024\u0003{I1!a\u0010%\u0005I)\u00050Z2vi>\u0014Hj\\:t%\u0016\f7o\u001c8\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e)\t\t\t#A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002\u0018\u0005!1\u000f^8q\u0003]!wNU3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0002P\u0005e\u0003CBA)\u0003+\nY!\u0004\u0002\u0002T)\u0011A\n_\u0005\u0005\u0003/\n\u0019F\u0001\u0004GkR,(/\u001a\u0005\u0007\u00037*\u0002\u0019A@\u0002\u001dI,\u0017/^3ti\u0016$Gk\u001c;bY\u0006i2/\u001e4gS\u000eLWM\u001c;SKN|WO]2fgJ+w-[:uKJ,G\r\u0006\u0002\u0002\f\u0005qq-\u001a;Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001cHCAA3!\u0019\t9'!\u001d\u0002\"9!\u0011\u0011NA7\u001d\u0011\t9#a\u001b\n\u0003eL1!a\u001cy\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001d\u0002v\t\u00191+Z9\u000b\u0007\u0005=\u00040A\be_.KG\u000e\\#yK\u000e,Ho\u001c:t)\u0011\ty%a\u001f\t\u000f\u0005u\u0004\u00041\u0001\u0002f\u0005YQ\r_3dkR|'/\u00133t\u0003Q\u0019'/Z1uK\u0012\u0013\u0018N^3s\u000b:$\u0007o\\5oiR\u0011\u00111\u0011\t\u0005\u0003\u000b\u000b9)D\u0001\u0001\u0013\r\tIi\f\u0002\u000f\tJLg/\u001a:F]\u0012\u0004x.\u001b8u\u0003I\u0019'/Z1uKR{7.\u001a8NC:\fw-\u001a:\u0015\u0005\u0005=\u0005#B<\u0002\u0012\u0006U\u0015bAAJq\n1q\n\u001d;j_:\u0004B!a&\u0002\"6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*\u0001\u0005tK\u000e,(/\u001b;z\u0015\r\tyJJ\u0001\u0007I\u0016\u0004Hn\\=\n\t\u0005\r\u0016\u0011\u0014\u0002\u001d\u0011\u0006$wn\u001c9EK2,w-\u0019;j_:$vn[3o\u001b\u0006t\u0017mZ3s\u0005aYUOY3s]\u0016$Xm\u001d#sSZ,'/\u00128ea>Lg\u000e^\n\u00047\u0005\rECAAV!\r\t)iG\u0001\u000f_:$\u0015n]2p]:,7\r^3e)\u0011\t9\"!-\t\u000f\u0005MV\u00041\u0001\u00026\u0006Q!\u000f]2BI\u0012\u0014Xm]:\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/'\u0003\r\u0011\boY\u0005\u0005\u0003\u007f\u000bIL\u0001\u0006Sa\u000e\fE\r\u001a:fgN\f1c];qKJ$\u0013\r\u001d9mS\u000e\fG/[8o\u0013\u0012LA!!\u0011\u0002F&\u0019\u0011q\u0019\u0013\u0003!M\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final SparkContext sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    private final ScheduledExecutorService executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteExecutors;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        block0: {
            if (!this.isExecutorActive(executorId)) break block0;
            this.removeExecutor(executorId, reason);
        }
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$applicationId());
    }

    public void start() {
        super.start();
        this.podAllocator.setTotalExpectedExecutors(this.initialExecutors());
        this.lifecycleEventHandler.start(this);
        this.podAllocator.start(this.applicationId());
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
    }

    public void stop() {
        super.stop();
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteExecutors()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        this.podAllocator.setTotalExpectedExecutors(requestedTotal);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        executorIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (((PodList)running.list()).getItems().isEmpty()) break block0;
                        $this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Forcefully deleting ").append(((PodList)running.list()).getItems().size()).append(" pods ").append("(out of ").append($this.executorIds$1.size()).append(") that are still running after graceful shutdown period.").toString());
                        running.delete();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 ), $anonfun$run$2(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

