/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mg!B\u0011#\u0001!r\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011\u0019\u0004!\u0011!Q\u0001\n\u001dDQA\u001b\u0001\u0005\u0002-DqA\u001e\u0001C\u0002\u0013Es\u000f\u0003\u0004\u007f\u0001\u0001\u0006I\u0001\u001f\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011\u0011\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A\u0011Q\u0003\u0001!\u0002\u0013\ty\u0001\u0003\u0005\u0002\u0018\u0001!\tAIA\r\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002N\u0001!\t%a\u0013\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003w\u0002A\u0011IA?\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!a$\u0001\t#\n\t\nC\u0004\u0002*\u0002!\t&a+\u0007\r\u0005M\u0006\u0001BA[\u0011\u0019QG\u0004\"\u0001\u00028\"9\u00111\u0018\u000f\u0005B\u0005u\u0006BDAh\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\u001d\u0013\u0011\u001b\u0005\u000f\u0003/\u0004\u0001\u0013aA\u0001\u0002\u0013%\u00111JAm\u0005\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0015\t\u0019C%A\u0002lqMT!!\n\u0014\u0002\u000f\rdWo\u001d;fe*\u0011q\u0005K\u0001\ng\u000eDW\rZ;mKJT!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\n\u0003\u0001=\u0002\"\u0001M\u0019\u000e\u0003\u0011J!A\r\u0013\u0003;\r{\u0017M]:f\u000fJ\f\u0017N\\3e'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u001c\u0001\u0001\u0005\u00026m5\ta%\u0003\u00028M\t\tB+Y:l'\u000eDW\rZ;mKJLU\u000e\u001d7\u0002\u0005M\u001c\u0007C\u0001\u001e<\u001b\u0005A\u0013B\u0001\u001f)\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003AYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\u0005\u0002@\u00116\t\u0001I\u0003\u0002B\u0005\u000611\r\\5f]RT!a\u0011#\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002F\r\u00069a-\u00192sS\u000eD$\"A$\u0002\u0005%|\u0017BA%A\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG/A\bfq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f!\ta5+D\u0001N\u0015\tqu*\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001U)\u0002\tU$\u0018\u000e\u001c\u0006\u0002%\u0006!!.\u0019<b\u0013\t!VJ\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fab\u001d8baNDw\u000e^:Ti>\u0014X\r\u0005\u0002X16\t!%\u0003\u0002ZE\tQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006a\u0001o\u001c3BY2|7-\u0019;peB\u0011q\u000bX\u0005\u0003;\n\u0012Q#\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'/A\u000bmS\u001a,7-_2mK\u00163XM\u001c;IC:$G.\u001a:\u0011\u0005]\u0003\u0017BA1#\u0005q)\u00050Z2vi>\u0014\bk\u001c3t\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\f1b^1uG\",e/\u001a8ugB\u0011q\u000bZ\u0005\u0003K\n\u0012q$\u0012=fGV$xN\u001d)pIN<\u0016\r^2i':\f\u0007o\u001d5piN{WO]2f\u0003)\u0001x\u000e\u001c7Fm\u0016tGo\u001d\t\u0003/\"L!!\u001b\u0012\u0003C\u0015CXmY;u_J\u0004v\u000eZ:Q_2d\u0017N\\4T]\u0006\u00048\u000f[8u'>,(oY3\u0002\rqJg.\u001b;?))aWN\\8qcJ\u001cH/\u001e\t\u0003/\u0002AQa\n\u0006A\u0002QBQ\u0001\u000f\u0006A\u0002eBQ!\u0010\u0006A\u0002yBQA\u0013\u0006A\u0002-CQ!\u0016\u0006A\u0002YCQA\u0017\u0006A\u0002mCQA\u0018\u0006A\u0002}CQA\u0019\u0006A\u0002\rDQA\u001a\u0006A\u0002\u001d\f!#\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_V\t\u0001\u0010\u0005\u0002zy6\t!PC\u0001|\u0003\u0015\u00198-\u00197b\u0013\ti(P\u0001\u0004E_V\u0014G.Z\u0001\u0014[&t'+Z4jgR,'/\u001a3SCRLw\u000eI\u0001\u0011S:LG/[1m\u000bb,7-\u001e;peN,\"!a\u0001\u0011\u0007e\f)!C\u0002\u0002\bi\u00141!\u00138u\u0003EIg.\u001b;jC2,\u00050Z2vi>\u00148\u000fI\u0001\u0016g\"|W\u000f\u001c3EK2,G/Z#yK\u000e,Ho\u001c:t+\t\ty\u0001E\u0002z\u0003#I1!a\u0005{\u0005\u001d\u0011un\u001c7fC:\fac\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148\u000fI\u0001\u0011I>\u0014V-\\8wK\u0016CXmY;u_J$b!a\u0007\u0002\"\u0005m\u0002cA=\u0002\u001e%\u0019\u0011q\u0004>\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003G\t\u0002\u0019AA\u0013\u0003))\u00070Z2vi>\u0014\u0018\n\u001a\t\u0005\u0003O\t)D\u0004\u0003\u0002*\u0005E\u0002cAA\u0016u6\u0011\u0011Q\u0006\u0006\u0004\u0003_\u0019\u0014A\u0002\u001fs_>$h(C\u0002\u00024i\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u001c\u0003s\u0011aa\u0015;sS:<'bAA\u001au\"9\u0011QH\tA\u0002\u0005}\u0012A\u0002:fCN|g\u000eE\u00026\u0003\u0003J1!a\u0011'\u0005I)\u00050Z2vi>\u0014Hj\\:t%\u0016\f7o\u001c8\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e)\t\t)#A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002\u001c\u0005!1\u000f^8q\u0003]!wNU3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0002T\u0005u\u0003CBA+\u00033\ny!\u0004\u0002\u0002X)\u0011aJ_\u0005\u0005\u00037\n9F\u0001\u0004GkR,(/\u001a\u0005\b\u0003?*\u0002\u0019AA\u0002\u00039\u0011X-];fgR,G\rV8uC2\fQd];gM&\u001c\u0017.\u001a8u%\u0016\u001cx.\u001e:dKN\u0014VmZ5ti\u0016\u0014X\r\u001a\u000b\u0003\u0003\u001f\tabZ3u\u000bb,7-\u001e;pe&#7\u000f\u0006\u0002\u0002jA1\u00111NA;\u0003KqA!!\u001c\u0002r9!\u00111FA8\u0013\u0005Y\u0018bAA:u\u00069\u0001/Y2lC\u001e,\u0017\u0002BA<\u0003s\u00121aU3r\u0015\r\t\u0019H_\u0001\u0010I>\\\u0015\u000e\u001c7Fq\u0016\u001cW\u000f^8sgR!\u00111KA@\u0011\u001d\t\t\t\u0007a\u0001\u0003S\n1\"\u001a=fGV$xN]%eg\u0006!2M]3bi\u0016$%/\u001b<fe\u0016sG\r]8j]R$\"!a\"\u0011\t\u0005%\u00151R\u0007\u0002\u0001%\u0019\u0011QR\u0019\u0003\u001d\u0011\u0013\u0018N^3s\u000b:$\u0007o\\5oi\u0006\u00112M]3bi\u0016$vn[3o\u001b\u0006t\u0017mZ3s)\t\t\u0019\nE\u0003z\u0003+\u000bI*C\u0002\u0002\u0018j\u0014aa\u00149uS>t\u0007\u0003BAN\u0003Kk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\tg\u0016\u001cWO]5us*\u0019\u00111\u0015\u0015\u0002\r\u0011,\u0007\u000f\\8z\u0013\u0011\t9+!(\u00039!\u000bGm\\8q\t\u0016dWmZ1uS>tGk\\6f]6\u000bg.Y4fe\u0006i\u0011n\u001d\"mC\u000e\\G.[:uK\u0012$b!a\u0004\u0002.\u0006=\u0006bBA\u00127\u0001\u0007\u0011Q\u0005\u0005\b\u0003c[\u0002\u0019AA\u0013\u0003!Awn\u001d;oC6,'\u0001G&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s\u000b:$\u0007o\\5oiN\u0019A$a\"\u0015\u0005\u0005e\u0006cAAE9\u0005qqN\u001c#jg\u000e|gN\\3di\u0016$G\u0003BA\u000e\u0003\u007fCq!!1\u001f\u0001\u0004\t\u0019-\u0001\u0006sa\u000e\fE\r\u001a:fgN\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013D\u0013a\u0001:qG&!\u0011QZAd\u0005)\u0011\u0006oY!eIJ,7o]\u0001\u0014gV\u0004XM\u001d\u0013baBd\u0017nY1uS>t\u0017\nZ\u0005\u0005\u0003\u000b\n\u0019.C\u0002\u0002V\u001a\u0012\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0002\u0015M,\b/\u001a:%gR|\u0007/C\u0002\u0002NE\u0002")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final SparkContext sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    private final ScheduledExecutorService executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteExecutors;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    private /* synthetic */ void super$stop() {
        super.stop();
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        block0: {
            if (!this.isExecutorActive(executorId)) break block0;
            this.removeExecutor(executorId, reason);
        }
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$applicationId());
    }

    public void start() {
        super.start();
        this.podAllocator.setTotalExpectedExecutors(this.initialExecutors());
        this.lifecycleEventHandler.start(this);
        this.podAllocator.start(this.applicationId());
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
    }

    public void stop() {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.super$stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteExecutors()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        this.podAllocator.setTotalExpectedExecutors(requestedTotal);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        executorIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (((PodList)running.list()).getItems().isEmpty()) break block0;
                        $this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Forcefully deleting ").append(((PodList)running.list()).getItems().size()).append(" pods ").append("(out of ").append($this.executorIds$1.size()).append(") that are still running after graceful shutdown period.").toString());
                        running.delete();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 ), $anonfun$run$2(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isBlacklisted(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

