/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SecurityManager;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicExecutorFeatureStep;
import org.apache.spark.deploy.k8s.features.EnvSecretsFeatureStep;
import org.apache.spark.deploy.k8s.features.ExecutorKubernetesCredentialsFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.LocalDirsFeatureStep;
import org.apache.spark.deploy.k8s.features.LocalDirsFeatureStep$;
import org.apache.spark.deploy.k8s.features.MountSecretsFeatureStep;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u2Qa\u0001\u0003\u0001\u0015AAQa\u0006\u0001\u0005\u0002eAQ\u0001\b\u0001\u0005\u0002u\u0011\u0011dS;cKJtW\r^3t\u000bb,7-\u001e;pe\n+\u0018\u000e\u001c3fe*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u001d\u0019G.^:uKJT!!\u0003\u0006\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005Q\u0002CA\u000e\u0001\u001b\u0005!\u0011!\u00052vS2$gI]8n\r\u0016\fG/\u001e:fgR!a$\n\u00161!\ty2%D\u0001!\u0015\t)\u0011E\u0003\u0002#\u0015\u00051A-\u001a9m_fL!\u0001\n\u0011\u0003\u0011M\u0003\u0018M]6Q_\u0012DQA\n\u0002A\u0002\u001d\nAaY8oMB\u0011q\u0004K\u0005\u0003S\u0001\u0012acS;cKJtW\r^3t\u000bb,7-\u001e;pe\u000e{gN\u001a\u0005\u0006W\t\u0001\r\u0001L\u0001\u0007g\u0016\u001cWj\u001a:\u0011\u00055rS\"\u0001\u0006\n\u0005=R!aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\t\u000bE\u0012\u0001\u0019\u0001\u001a\u0002\r\rd\u0017.\u001a8u!\t\u00194(D\u00015\u0015\t\tTG\u0003\u00027o\u0005Q1.\u001e2fe:,G/Z:\u000b\u0005aJ\u0014a\u00024bEJL7\r\u000f\u0006\u0002u\u0005\u0011\u0011n\\\u0005\u0003yQ\u0012\u0001cS;cKJtW\r^3t\u00072LWM\u001c;")
public class KubernetesExecutorBuilder {
    public SparkPod buildFromFeatures(KubernetesExecutorConf conf, SecurityManager secMgr, KubernetesClient client) {
        SparkPod initialPod = (SparkPod)((Option)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).map((Function1 & Serializable & scala.Serializable)file -> KubernetesUtils$.MODULE$.loadPodFromTemplate(client, new File((String)file), (Option<String>)((Option)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkPod$.MODULE$.initialPod());
        Seq features = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesFeatureConfigStep[]{new BasicExecutorFeatureStep(conf, secMgr), new ExecutorKubernetesCredentialsFeatureStep(conf), new MountSecretsFeatureStep(conf), new EnvSecretsFeatureStep(conf), new MountVolumesFeatureStep(conf), new LocalDirsFeatureStep(conf, LocalDirsFeatureStep$.MODULE$.$lessinit$greater$default$2())}));
        return (SparkPod)features.foldLeft((Object)initialPod, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SparkPod pod = (SparkPod)tuple2._1();
            KubernetesFeatureConfigStep feature = (KubernetesFeatureConfigStep)tuple2._2();
            SparkPod sparkPod = feature.configurePod(pod);
            return sparkPod;
        });
    }
}

