/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u001de!\u0002\u001b6\u0001m\n\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011\u0015)\b\u0001\"\u0001w\u0011\u001dq\bA1A\u0005\n}D\u0001\"a\u0006\u0001A\u0003%\u0011\u0011\u0001\u0005\n\u00033\u0001!\u0019!C\u0005\u00037A\u0001\"a\u000b\u0001A\u0003%\u0011Q\u0004\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003_A\u0001\"!\u0014\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003\u001f\u0002!\u0019!C\u0005\u0003#B\u0001\"a\u0015\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003/B\u0001\"a\u0018\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003/B\u0001\"a\u0019\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003K\u0002!\u0019!C\u0005\u0003/B\u0001\"a\u001a\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003/B\u0001\"a\u001b\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003[\u0002!\u0019!C\u0005\u0003_B\u0001\"a\"\u0001A\u0003%\u0011\u0011\u000f\u0005\n\u0003\u0013\u0003!\u0019!C\u0005\u0003\u0017C\u0001\"a%\u0001A\u0003%\u0011Q\u0012\u0005\n\u0003+\u0003!\u0019!C\u0005\u0003/C\u0001\"a(\u0001A\u0003%\u0011\u0011\u0014\u0005\n\u0003C\u0003!\u0019!C\u0001\u0003GC\u0001\"a.\u0001A\u0003%\u0011Q\u0015\u0005\n\u0003s\u0003!\u0019!C\u0005\u0003wC\u0001\"!3\u0001A\u0003%\u0011Q\u0018\u0005\n\u0003\u0017\u0004!\u0019!C\u0005\u0003\u001bD\u0001\"!5\u0001A\u0003%\u0011q\u001a\u0005\n\u0003'\u0004!\u0019!C\u0005\u0003/C\u0001\"!6\u0001A\u0003%\u0011\u0011\u0014\u0005\u000b\u0003/\u0004!\u0019!C\u0001k\u0005e\u0007\u0002CAq\u0001\u0001\u0006I!a7\t\u0013\u0005\r\b\u00011A\u0005\n\u0005\u0015\b\"CAw\u0001\u0001\u0007I\u0011BAx\u0011!\tY\u0010\u0001Q!\n\u0005\u001d\b\"CA\u007f\u0001\u0001\u0007I\u0011BA\u0000\u0011%\u0011i\u0001\u0001a\u0001\n\u0013\u0011y\u0001\u0003\u0005\u0003\u0014\u0001\u0001\u000b\u0015\u0002B\u0001\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?AqAa\f\u0001\t\u0003\u0011\t\u0004C\u0004\u0003>\u0001!\tAa\u0010\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H!9!1\r\u0001\u0005\n\t\u0015\u0004b\u0002B;\u0001\u0011%!q\u000f\u0002\u0016\u000bb,7-\u001e;peB{Gm]!mY>\u001c\u0017\r^8s\u0015\t1t'A\u0002lqMT!\u0001O\u001d\u0002\u000f\rdWo\u001d;fe*\u0011!hO\u0001\ng\u000eDW\rZ;mKJT!\u0001P\u001f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\n\u0004\u0001\tC\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g\r\u0005\u0002J\u00196\t!J\u0003\u0002Lw\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002N\u0015\n9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002R%6\t1(\u0003\u0002Tw\tI1\u000b]1sW\u000e{gNZ\u0001\u0007g\u0016\u001cWj\u001a:\u0011\u0005E3\u0016BA,<\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\u0018aD3yK\u000e,Ho\u001c:Ck&dG-\u001a:\u0011\u0005i[V\"A\u001b\n\u0005q+$!G&vE\u0016\u0014h.\u001a;fg\u0016CXmY;u_J\u0014U/\u001b7eKJ\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005}CW\"\u00011\u000b\u0005\u0005\u0014\u0017AB2mS\u0016tGO\u0003\u0002dI\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005\u00154\u0017a\u00024bEJL7\r\u000f\u0006\u0002O\u0006\u0011\u0011n\\\u0005\u0003S\u0002\u0014\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u0011!\f\\\u0005\u0003[V\u0012!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fQa\u00197pG.\u0004\"\u0001]:\u000e\u0003ET!A]\u001e\u0002\tU$\u0018\u000e\\\u0005\u0003iF\u0014Qa\u00117pG.\fa\u0001P5oSRtDcB<ysj\\H0 \t\u00035\u0002AQAT\u0004A\u0002ACQ\u0001V\u0004A\u0002UCQ\u0001W\u0004A\u0002eCQ!X\u0004A\u0002yCQA[\u0004A\u0002-DQA\\\u0004A\u0002=\f1#\u0012-F\u0007V#vJU0J\t~\u001bu*\u0016(U\u000bJ+\"!!\u0001\u0011\t\u0005\r\u00111C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u00051\u0011\r^8nS\u000eTA!a\u0003\u0002\u000e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007I\fyA\u0003\u0002\u0002\u0012\u0005!!.\u0019<b\u0013\u0011\t)\"!\u0002\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u000bF1\u0016\u001bU\u000bV(S?&#ulQ(V\u001dR+%\u000bI\u0001+i>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sgB+'OU3t_V\u00148-\u001a)s_\u001aLG.Z%e+\t\ti\u0002\u0005\u0005\u0002 \u0005\u0005\u0012QEA\u0013\u001b\t\tI!\u0003\u0003\u0002$\u0005%!!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u00191)a\n\n\u0007\u0005%BIA\u0002J]R\f1\u0006^8uC2,\u0005\u0010]3di\u0016$W\t_3dkR|'o\u001d)feJ+7o\\;sG\u0016\u0004&o\u001c4jY\u0016LE\rI\u0001\u0016eBLE\rV8SKN|WO]2f!J|g-\u001b7f+\t\t\t\u0004\u0005\u0005\u00024\u0005u\u0012QEA!\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003w!\u0015AC2pY2,7\r^5p]&!\u0011qHA\u001b\u0005\u001dA\u0015m\u001d5NCB\u0004B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fZ\u0014\u0001\u0003:fg>,(oY3\n\t\u0005-\u0013Q\t\u0002\u0010%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK\u00061\"\u000f]%e)>\u0014Vm]8ve\u000e,\u0007K]8gS2,\u0007%A\tq_\u0012\fE\u000e\\8dCRLwN\\*ju\u0016,\"!!\n\u0002%A|G-\u00117m_\u000e\fG/[8o'&TX\rI\u0001\u0013a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u00170\u0006\u0002\u0002ZA\u00191)a\u0017\n\u0007\u0005uCI\u0001\u0003M_:<\u0017a\u00059pI\u0006cGn\\2bi&|g\u000eR3mCf\u0004\u0013A\u00059pI\u000e\u0013X-\u0019;j_:$\u0016.\\3pkR\f1\u0003]8e\u0007J,\u0017\r^5p]RKW.Z8vi\u0002\n\u0011\u0004\u001a:jm\u0016\u0014\bk\u001c3SK\u0006$\u0017N\\3tgRKW.Z8vi\u0006QBM]5wKJ\u0004v\u000e\u001a*fC\u0012Lg.Z:t)&lWm\\;uA\u0005\u0019R\r_3dkR|'/\u00133mKRKW.Z8vi\u0006!R\r_3dkR|'/\u00133mKRKW.Z8vi\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0005\u0005E\u0004\u0003BA:\u0003\u0003sA!!\u001e\u0002~A\u0019\u0011q\u000f#\u000e\u0005\u0005e$bAA>\u001f\u00061AH]8pizJ1!a E\u0003\u0019\u0001&/\u001a3fM&!\u00111QAC\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0010#\u0002\u00159\fW.Z:qC\u000e,\u0007%A\flk\n,'O\\3uKN$%/\u001b<feB{GMT1nKV\u0011\u0011Q\u0012\t\u0006\u0007\u0006=\u0015\u0011O\u0005\u0004\u0003##%AB(qi&|g.\u0001\rlk\n,'O\\3uKN$%/\u001b<feB{GMT1nK\u0002\nQc\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148/\u0006\u0002\u0002\u001aB\u00191)a'\n\u0007\u0005uEIA\u0004C_>dW-\u00198\u0002-MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u0002\n\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0016\u0005\u0005\u0015\u0006#B\"\u0002\u0010\u0006\u001d\u0006\u0003BAU\u0003gk!!a+\u000b\t\u00055\u0016qV\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003c\u0013\u0017aA1qS&!\u0011QWAV\u0005\r\u0001v\u000eZ\u0001\u000bIJLg/\u001a:Q_\u0012\u0004\u0013!\u00068fo2L8I]3bi\u0016$W\t_3dkR|'o]\u000b\u0003\u0003{\u0003\u0002\"a\r\u0002@\u0006e\u00131Y\u0005\u0005\u0003\u0003\f)DA\u0007MS:\\W\r\u001a%bg\"l\u0015\r\u001d\t\b\u0007\u0006\u0015\u0017QEA-\u0013\r\t9\r\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0002-9,w\u000f\\=De\u0016\fG/\u001a3Fq\u0016\u001cW\u000f^8sg\u0002\nqd]2iK\u0012,H.\u001a:L]><hNT3xYf\u001c%/Z1uK\u0012,\u00050Z2t+\t\ty\r\u0005\u0005\u00024\u0005}\u0016\u0011LA\u0013\u0003\u0001\u001a8\r[3ek2,'o\u00138po:tUm\u001e7z\u0007J,\u0017\r^3e\u000bb,7m\u001d\u0011\u00021\u0011Lh.Y7jG\u0006cGn\\2bi&|g.\u00128bE2,G-A\res:\fW.[2BY2|7-\u0019;j_:,e.\u00192mK\u0012\u0004\u0013A\u00058v[>+Ho\u001d;b]\u0012Lgn\u001a)pIN,\"!a7\u0011\t\u0005\r\u0011Q\\\u0005\u0005\u0003?\f)AA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0014]Vlw*\u001e;ti\u0006tG-\u001b8h!>$7\u000fI\u0001\rY\u0006\u001cHo\u00158baNDw\u000e^\u000b\u0003\u0003O\u00042AWAu\u0013\r\tY/\u000e\u0002\u0015\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;\u0002!1\f7\u000f^*oCB\u001c\bn\u001c;`I\u0015\fH\u0003BAy\u0003o\u00042aQAz\u0013\r\t)\u0010\u0012\u0002\u0005+:LG\u000fC\u0005\u0002z&\n\t\u00111\u0001\u0002h\u0006\u0019\u0001\u0010J\u0019\u0002\u001b1\f7\u000f^*oCB\u001c\bn\u001c;!\u0003I!W\r\\3uK\u0012,\u00050Z2vi>\u0014\u0018\nZ:\u0016\u0005\t\u0005\u0001C\u0002B\u0002\u0005\u0013\tI&\u0004\u0002\u0003\u0006)!!qAA\u001d\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003\f\t\u0015!aA*fi\u00061B-\u001a7fi\u0016$W\t_3dkR|'/\u00133t?\u0012*\u0017\u000f\u0006\u0003\u0002r\nE\u0001\"CA}Y\u0005\u0005\t\u0019\u0001B\u0001\u0003M!W\r\\3uK\u0012,\u00050Z2vi>\u0014\u0018\nZ:!Q\ri#q\u0003\t\u0004\u0007\ne\u0011b\u0001B\u000e\t\nAao\u001c7bi&dW-A\u0003ti\u0006\u0014H\u000f\u0006\u0004\u0002r\n\u0005\"Q\u0005\u0005\b\u0005Gq\u0003\u0019AA9\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI\"9!q\u0005\u0018A\u0002\t%\u0012\u0001E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\rQ&1F\u0005\u0004\u0005[)$!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017!G:fiR{G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN$B!!=\u00034!9!QG\u0018A\u0002\t]\u0012a\u0007:fg>,(oY3Qe>4\u0017\u000e\\3U_R{G/\u00197Fq\u0016\u001c7\u000f\u0005\u0005\u0002t\te\u0012\u0011IA\u0013\u0013\u0011\u0011Y$!\"\u0003\u00075\u000b\u0007/A\u0005jg\u0012+G.\u001a;fIR!\u0011\u0011\u0014B!\u0011\u001d\u0011\u0019\u0005\ra\u0001\u0003c\n!\"\u001a=fGV$xN]%e\u00039ygNT3x':\f\u0007o\u001d5piN$\u0002\"!=\u0003J\t-#Q\n\u0005\b\u0005G\t\u0004\u0019AA9\u0011\u001d\u00119#\ra\u0001\u0005SAqAa\u00142\u0001\u0004\u0011\t&A\u0005t]\u0006\u00048\u000f[8ugB1!1\u000bB/\u0003OtAA!\u0016\u0003Z9!\u0011q\u000fB,\u0013\u0005)\u0015b\u0001B.\t\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B0\u0005C\u00121aU3r\u0015\r\u0011Y\u0006R\u0001\u0014e\u0016\fX/Z:u\u001d\u0016<X\t_3dkR|'o\u001d\u000b\u000b\u0003c\u00149Ga\u001b\u0003p\tE\u0004b\u0002B5e\u0001\u0007\u0011QE\u0001\tKb\u0004Xm\u0019;fI\"9!Q\u000e\u001aA\u0002\u0005\u0015\u0012a\u0002:v]:Lgn\u001a\u0005\b\u0005G\u0011\u0004\u0019AA9\u0011\u001d\u0011\u0019H\ra\u0001\u0003K\t\u0011C]3t_V\u00148-\u001a)s_\u001aLG.Z%e\u0003YI7/\u0012=fGV$xN]%eY\u0016$\u0016.\\3e\u001fV$HCBAM\u0005s\u0012\u0019\tC\u0004\u0003|M\u0002\rA! \u0002\u000bM$\u0018\r^3\u0011\u0007i\u0013y(C\u0002\u0003\u0002V\u0012\u0001#\u0012=fGV$xN\u001d)pIN#\u0018\r^3\t\u000f\t\u00155\u00071\u0001\u0002Z\u0005Y1-\u001e:sK:$H+[7f\u0001")
public class ExecutorPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicLong EXECUTOR_ID_COUNTER;
    private final ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long podCreationTimeout;
    private final long driverPodReadinessTimeout;
    private final long executorIdleTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors;
    private final LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs;
    private final boolean dynamicAllocationEnabled;
    private final AtomicInteger numOutstandingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private volatile Set<Object> deletedExecutorIds;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicLong EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId() {
        return this.totalExpectedExecutorsPerResourceProfileId;
    }

    private HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private long driverPodReadinessTimeout() {
        return this.driverPodReadinessTimeout;
    }

    private long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    private LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    private LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs() {
        return this.schedulerKnownNewlyCreatedExecs;
    }

    private boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public AtomicInteger numOutstandingPods() {
        return this.numOutstandingPods;
    }

    private ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    private void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    private Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    private void deletedExecutorIds_$eq(Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    public void start(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend) {
        this.driverPod().foreach((Function1 & Serializable & scala.Serializable)pod -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Waitable)this.kubernetesClient.pods().withName(pod.getMetadata().getName())).waitUntilReady(this.driverPodReadinessTimeout(), TimeUnit.SECONDS));
            return BoxedUnit.UNIT;
        });
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setTotalExpectedExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        block0: {
            resourceProfileToTotalExecs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1)));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Set total expected execs to ").append(this.totalExpectedExecutorsPerResourceProfileId()).toString());
            if (this.numOutstandingPods().get() != 0) break block0;
            this.snapshotsStore.notifySubscribers();
        }
    }

    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(executorId)).toLong()));
    }

    private void onNewSnapshots(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        Seq k8sKnownExecIds = (Seq)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom());
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        this.schedulerKnownNewlyCreatedExecs().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        Set schedulerKnownExecs = ((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$2(x$3)), Seq$.MODULE$.canBuildFrom())).toSet();
        this.schedulerKnownNewlyCreatedExecs().$plus$plus$eq((TraversableOnce)this.newlyCreatedExecutors().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> schedulerKnownExecs.contains((Object)BoxesRunTime.boxToLong((long)x$4))).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5._1$mcI$sp())));
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)this.schedulerKnownNewlyCreatedExecs().keySet());
        long currentTime = this.clock.getTimeMillis();
        scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long execId = tuple2._1$mcJ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            long timeCreated = tuple22._2$mcJ$sp();
            if (currentTime - timeCreated > this.podCreationTimeout()) {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)execId)));
                return iterable;
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timedOut.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(230).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)timedOut);
            if (this.shouldDeleteExecutors()) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)timedOut.toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$9(BoxesRunTime.unboxToLong((Object)x$6)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
            }
        }
        if (snapshots.nonEmpty()) {
            this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
        }
        ObjectRef _deletedExecutorIds = ObjectRef.create(this.deletedExecutorIds());
        if (snapshots.nonEmpty()) {
            Set existingExecs = this.lastSnapshot().executorPods().keySet();
            _deletedExecutorIds.elem = (Set)((Set)_deletedExecutorIds.elem).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)elem -> existingExecs.contains((Object)BoxesRunTime.boxToLong((long)elem)));
        }
        Map notDeletedPods = this.lastSnapshot().executorPods().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> !((Set)_deletedExecutorIds$1.elem).contains((Object)BoxesRunTime.boxToLong((long)x$7)));
        HashMap rpIdToExecsAndPodState = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.totalExpectedExecutorsPerResourceProfileId().size() <= 1) {
            rpIdToExecsAndPodState.update((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()), (Object)HashMap$.MODULE$.empty().$plus$plus$eq((TraversableOnce)notDeletedPods));
        } else {
            notDeletedPods.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$12(rpIdToExecsAndPodState, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        IntRef totalPendingCount = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.totalExpectedExecutorsPerResourceProfileId()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ExecutorPodsAllocator.$anonfun$onNewSnapshots$14(this, rpIdToExecsAndPodState, schedulerKnownExecs, currentTime, _deletedExecutorIds, applicationId, totalPendingCount, snapshots, x0$3);
            return BoxedUnit.UNIT;
        });
        this.deletedExecutorIds_$eq((Set<Object>)((Set)_deletedExecutorIds.elem));
        this.numOutstandingPods().set(totalPendingCount.elem + this.newlyCreatedExecutors().size());
    }

    private void requestNewExecutors(int expected, int running, String applicationId, int resourceProfileId) {
        int numExecutorsToAllocate = package$.MODULE$.min(expected - running, this.podAllocationSize());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes for ").append("ResourceProfile Id: ").append(resourceProfileId).append(", target: ").append(expected).append(" running: ").append(running).append(".").toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            long newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
            KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, ((Object)BoxesRunTime.boxToLong((long)newExecutorId)).toString(), applicationId, this.driverPod(), resourceProfileId);
            KubernetesExecutorSpec resolvedExecutorSpec = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
            SparkPod executorPod = resolvedExecutorSpec.pod();
            Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
            Pod createdExecutorPod = (Pod)$this.kubernetesClient.pods().create((Object)podWithAttachedContainer);
            try {
                Seq<HasMetadata> resources = resolvedExecutorSpec.executorKubernetesResources();
                KubernetesUtils$.MODULE$.addOwnerReference(createdExecutorPod, resources);
                ((IterableLike)resources.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$requestNewExecutors$3(x$10)))).foreach((Function1 & Serializable & scala.Serializable)resource -> {
                    PersistentVolumeClaim pvc = (PersistentVolumeClaim)resource;
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Trying to create PersistentVolumeClaim ").append(pvc.getMetadata().getName()).append(" with ").append("StorageClass ").append(pvc.getSpec().getStorageClassName()).toString());
                    return (PersistentVolumeClaim)$this.kubernetesClient.persistentVolumeClaims().create((Object)pvc);
                });
                this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)new Tuple2.mcIJ.sp(resourceProfileId, $this.clock.getTimeMillis()));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    $this.kubernetesClient.pods().delete((Object[])new Pod[]{createdExecutorPod});
                    throw e;
                }
                throw throwable;
            }
        });
    }

    private boolean isExecutorIdleTimedOut(ExecutorPodState state, long currentTime) {
        boolean bl;
        block3: {
            try {
                long creationTime = Instant.parse(state.pod().getMetadata().getCreationTimestamp()).toEpochMilli();
                if (currentTime - creationTime > this.executorIdleTimeout()) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Cannot get the creationTimestamp of the pod: ").append(state.pod()).toString(), e);
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$setTotalExpectedExecutors$1(ExecutorPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ResourceProfile rp = (ResourceProfile)tuple2._1();
        int numExecs = tuple2._2$mcI$sp();
        $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable & scala.Serializable)() -> rp);
        int n = BoxesRunTime.unboxToInt((Object)$this.totalExpectedExecutorsPerResourceProfileId().put(BoxesRunTime.boxToInteger((int)rp.id()), BoxesRunTime.boxToInteger((int)numExecs)));
        return n;
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$9(long x$6) {
        return ((Object)BoxesRunTime.boxToLong((long)x$6)).toString();
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$12(HashMap rpIdToExecsAndPodState$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long execId = tuple2._1$mcJ$sp();
        ExecutorPodState execPodState = (ExecutorPodState)tuple2._2();
        int rpId = new StringOps(Predef$.MODULE$.augmentString((String)execPodState.pod().getMetadata().getLabels().get(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()))).toInt();
        HashMap execPods = (HashMap)rpIdToExecsAndPodState$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        execPods.update((Object)BoxesRunTime.boxToLong((long)execId), (Object)execPodState);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$16(ExecutorPodState x0$4) {
        ExecutorPodState executorPodState = x0$4;
        boolean bl = executorPodState instanceof PodRunning;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$17(Tuple2 x0$5) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$5;
        boolean bl = tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$18(Set schedulerKnownExecs$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long k = tuple2._1$mcJ$sp();
        boolean bl = schedulerKnownExecs$1.contains((Object)BoxesRunTime.boxToLong((long)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$19(int rpId$1, Tuple2 x0$7) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$7;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        int waitingRpId = tuple2._1$mcI$sp();
        boolean bl = rpId$1 == waitingRpId;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$20(int rpId$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int waitingRpId = tuple2._2$mcI$sp();
        boolean bl = rpId$1 == waitingRpId;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$22(ExecutorPodsAllocator $this, long currentTime$1, Tuple2 x0$9) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$9;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        long createTime = tuple2._2$mcJ$sp();
        boolean bl = currentTime$1 - createTime > $this.executorIdleTimeout();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$24(Tuple2 x0$10) {
        long id;
        Tuple2 tuple2 = x0$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = id = tuple2._1$mcJ$sp();
        return l;
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$27(long x$9) {
        return ((Object)BoxesRunTime.boxToLong((long)x$9)).toString();
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$14(ExecutorPodsAllocator $this, HashMap rpIdToExecsAndPodState$1, Set schedulerKnownExecs$1, long currentTime$1, ObjectRef _deletedExecutorIds$1, String applicationId$2, IntRef totalPendingCount$1, Seq snapshots$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            int knownPodCount;
            int rpId = tuple2._1$mcI$sp();
            int targetNum = tuple2._2$mcI$sp();
            HashMap podsForRpId = (HashMap)rpIdToExecsAndPodState$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> HashMap$.MODULE$.empty());
            int currentRunningCount = podsForRpId.values().count((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$16(x0$4)));
            Tuple2 tuple22 = ((TraversableLike)podsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$17(x0$5)))).partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$18(schedulerKnownExecs$1, x0$6)));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            HashMap schedulerKnownPendingExecsForRpId = (HashMap)tuple22._1();
            HashMap currentPendingExecutorsForRpId = (HashMap)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)schedulerKnownPendingExecsForRpId, (Object)currentPendingExecutorsForRpId);
            Tuple2 tuple24 = tuple23;
            HashMap schedulerKnownPendingExecsForRpId2 = (HashMap)tuple24._1();
            HashMap currentPendingExecutorsForRpId2 = (HashMap)tuple24._2();
            IntRef knownPendingCount = IntRef.create((int)currentPendingExecutorsForRpId2.size());
            LinkedHashMap newlyCreatedExecutorsForRpId = (LinkedHashMap)$this.newlyCreatedExecutors().filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$19(rpId, x0$7)));
            LinkedHashMap schedulerKnownNewlyCreatedExecsForRpId = (LinkedHashMap)$this.schedulerKnownNewlyCreatedExecs().filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$20(rpId, x0$8)));
            if (podsForRpId.nonEmpty()) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("ResourceProfile Id: ").append(rpId).append(" ").append("pod allocation status: ").append(currentRunningCount).append(" running, ").append(currentPendingExecutorsForRpId2.size()).append(" unknown pending, ").append(schedulerKnownPendingExecsForRpId2.size()).append(" scheduler backend known pending, ").append(newlyCreatedExecutorsForRpId.size()).append(" unknown newly created, ").append(schedulerKnownNewlyCreatedExecsForRpId.size()).append(" scheduler backend known newly created.").toString());
            }
            if ((knownPodCount = currentRunningCount + currentPendingExecutorsForRpId2.size() + schedulerKnownPendingExecsForRpId2.size() + newlyCreatedExecutorsForRpId.size() + schedulerKnownNewlyCreatedExecsForRpId.size()) > targetNum) {
                scala.collection.mutable.Iterable knownPendingToDelete;
                int excess = knownPodCount - targetNum;
                List newlyCreatedToDelete = ((TraversableOnce)((MapLike)newlyCreatedExecutorsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$22($this, currentTime$1, x0$9)))).keys().take(excess)).toList();
                List toDelete = (List)newlyCreatedToDelete.$plus$plus((GenTraversableOnce)(knownPendingToDelete = (scala.collection.mutable.Iterable)((TraversableLike)((IterableLike)currentPendingExecutorsForRpId2.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)$this.isExecutorIdleTimedOut((ExecutorPodState)x._2(), currentTime$1)))).take(excess - newlyCreatedToDelete.size())).map((Function1 & Serializable & scala.Serializable)x0$10 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$24(x0$10)), Iterable$.MODULE$.canBuildFrom())), List$.MODULE$.canBuildFrom());
                if (toDelete.nonEmpty()) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                    _deletedExecutorIds$1.elem = (Set)((Set)_deletedExecutorIds$1.elem).$plus$plus((GenTraversableOnce)toDelete);
                    Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId$2)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$9 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$27(BoxesRunTime.unboxToLong((Object)x$9)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                        $this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)newlyCreatedToDelete);
                        knownPendingCount$1.elem -= knownPendingToDelete.size();
                    });
                }
            }
            if (newlyCreatedExecutorsForRpId.isEmpty() && knownPodCount < targetNum) {
                $this.requestNewExecutors(targetNum, knownPodCount, applicationId$2, rpId);
            }
            totalPendingCount$1.elem += knownPendingCount.elem;
            if ($this.log().isDebugEnabled() && snapshots$1.nonEmpty()) {
                int outstanding = knownPendingCount.elem + newlyCreatedExecutorsForRpId.size();
                if (currentRunningCount >= targetNum && !$this.dynamicAllocationEnabled()) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Current number of running executors for ResourceProfile Id ").append(rpId).append(" is ").append("equal to the number of requested executors. Not scaling up further.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else if (outstanding > 0) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Still waiting for ").append(outstanding).append(" executors for ResourceProfile ").append("Id ").append(rpId).append(" before requesting more.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$requestNewExecutors$3(HasMetadata x$10) {
        String string = x$10.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicLong(0L);
        this.totalExpectedExecutorsPerResourceProfileId = new ConcurrentHashMap();
        this.rpIdToResourceProfile = new HashMap();
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.driverPodReadinessTimeout = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_DRIVER_READINESS_TIMEOUT()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append((String)name).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.schedulerKnownNewlyCreatedExecs = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.numOutstandingPods = new AtomicInteger();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply();
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
    }
}

