/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SecurityManager;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicExecutorFeatureStep;
import org.apache.spark.deploy.k8s.features.EnvSecretsFeatureStep;
import org.apache.spark.deploy.k8s.features.ExecutorKubernetesCredentialsFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.LocalDirsFeatureStep;
import org.apache.spark.deploy.k8s.features.LocalDirsFeatureStep$;
import org.apache.spark.deploy.k8s.features.MountSecretsFeatureStep;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep;
import org.apache.spark.resource.ResourceProfile;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00153Qa\u0001\u0003\u0001\u0015AAQa\u0006\u0001\u0005\u0002eAQ\u0001\b\u0001\u0005\u0002u\u0011\u0011dS;cKJtW\r^3t\u000bb,7-\u001e;pe\n+\u0018\u000e\u001c3fe*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u001d\u0019G.^:uKJT!!\u0003\u0006\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005Q\u0002CA\u000e\u0001\u001b\u0005!\u0011!\u00052vS2$gI]8n\r\u0016\fG/\u001e:fgR)a$\n\u00161{A\u0011qdI\u0007\u0002A)\u0011Q!\t\u0006\u0003E)\ta\u0001Z3qY>L\u0018B\u0001\u0013!\u0005YYUOY3s]\u0016$Xm]#yK\u000e,Ho\u001c:Ta\u0016\u001c\u0007\"\u0002\u0014\u0003\u0001\u00049\u0013\u0001B2p]\u001a\u0004\"a\b\u0015\n\u0005%\u0002#AF&vE\u0016\u0014h.\u001a;fg\u0016CXmY;u_J\u001cuN\u001c4\t\u000b-\u0012\u0001\u0019\u0001\u0017\u0002\rM,7-T4s!\tic&D\u0001\u000b\u0013\ty#BA\bTK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s\u0011\u0015\t$\u00011\u00013\u0003\u0019\u0019G.[3oiB\u00111gO\u0007\u0002i)\u0011\u0011'\u000e\u0006\u0003m]\n!b[;cKJtW\r^3t\u0015\tA\u0014(A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003i\n!![8\n\u0005q\"$\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0011\u0015q$\u00011\u0001@\u0003=\u0011Xm]8ve\u000e,\u0007K]8gS2,\u0007C\u0001!D\u001b\u0005\t%B\u0001\"\u000b\u0003!\u0011Xm]8ve\u000e,\u0017B\u0001#B\u0005=\u0011Vm]8ve\u000e,\u0007K]8gS2,\u0007")
public class KubernetesExecutorBuilder {
    public KubernetesExecutorSpec buildFromFeatures(KubernetesExecutorConf conf, SecurityManager secMgr, KubernetesClient client, ResourceProfile resourceProfile) {
        SparkPod initialPod = (SparkPod)((Option)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).map((Function1 & Serializable & scala.Serializable)file -> KubernetesUtils$.MODULE$.loadPodFromTemplate(client, new File((String)file), (Option<String>)((Option)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkPod$.MODULE$.initialPod());
        Seq features = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesFeatureConfigStep[]{new BasicExecutorFeatureStep(conf, secMgr, resourceProfile), new ExecutorKubernetesCredentialsFeatureStep(conf), new MountSecretsFeatureStep(conf), new EnvSecretsFeatureStep(conf), new MountVolumesFeatureStep(conf), new LocalDirsFeatureStep(conf, LocalDirsFeatureStep$.MODULE$.$lessinit$greater$default$2())}));
        KubernetesExecutorSpec spec = new KubernetesExecutorSpec(initialPod, (Seq<HasMetadata>)((Seq)Seq$.MODULE$.empty()));
        return (KubernetesExecutorSpec)features.foldLeft((Object)spec, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            KubernetesExecutorSpec spec = (KubernetesExecutorSpec)tuple2._1();
            KubernetesFeatureConfigStep feature = (KubernetesFeatureConfigStep)tuple2._2();
            SparkPod configuredPod = feature.configurePod(spec.pod());
            Seq<HasMetadata> addedResources = feature.getAdditionalKubernetesResources();
            KubernetesExecutorSpec kubernetesExecutorSpec = new KubernetesExecutorSpec(configuredPod, (Seq<HasMetadata>)((Seq)spec.executorKubernetesResources().$plus$plus(addedResources, Seq$.MODULE$.canBuildFrom())));
            return kubernetesExecutorSpec;
        });
    }
}

