/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Stable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Stable
@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\t\u0013\u0001}A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u001d)\u0006A1A\u0005\nYCaA\u0017\u0001!\u0002\u00139\u0006\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0003]\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005f\u0001\u0001\u0007\t\u0011)Q\u0005;\")\u0001\u0010\u0001C\u0001s\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\rbABA\u0014\u0001\u0011\tI\u0003\u0003\u0005|\u001b\t\u0005\t\u0015!\u0003}\u0011\u0019qU\u0002\"\u0001\u0002>!9\u0011QI\u0007\u0005B\u0005\r\"!I#yK\u000e,Ho\u001c:Q_\u0012\u001c\bk\u001c7mS:<7K\\1qg\"|GoU8ve\u000e,'BA\n\u0015\u0003\rY\u0007h\u001d\u0006\u0003+Y\tqa\u00197vgR,'O\u0003\u0002\u00181\u0005I1o\u00195fIVdWM\u001d\u0006\u00033i\tQa\u001d9be.T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\r\u0002\u0011%tG/\u001a:oC2L!a\u000b\u0015\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g!\tqs&D\u0001\u0019\u0013\t\u0001\u0004DA\u0005Ta\u0006\u00148nQ8oM\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003gqj\u0011\u0001\u000e\u0006\u0003kY\naa\u00197jK:$(BA\u001c9\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003si\nqAZ1ce&\u001c\u0007HC\u0001<\u0003\tIw.\u0003\u0002>i\t\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\t\u0001\u0015)D\u0001\u0013\u0013\t\u0011%C\u0001\u000eFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^:Ti>\u0014X-A\bq_2d\u0017N\\4Fq\u0016\u001cW\u000f^8s!\t)E*D\u0001G\u0015\t9\u0005*\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0013&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0017\u0006!!.\u0019<b\u0013\tieI\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD#\u0002)R%N#\u0006C\u0001!\u0001\u0011\u0015aS\u00011\u0001.\u0011\u0015\tT\u00011\u00013\u0011\u0015qT\u00011\u0001@\u0011\u0015\u0019U\u00011\u0001E\u0003=\u0001x\u000e\u001c7j]\u001eLe\u000e^3sm\u0006dW#A,\u0011\u0005\u0005B\u0016BA-#\u0005\u0011auN\\4\u0002!A|G\u000e\\5oO&sG/\u001a:wC2\u0004\u0013!\u00049pY2Lgn\u001a$viV\u0014X-F\u0001^a\tq6\rE\u0002F?\u0006L!\u0001\u0019$\u0003\r\u0019+H/\u001e:f!\t\u00117\r\u0004\u0001\u0005\u0013\u0011T\u0011\u0011!A\u0001\u0006\u00031'aA0%c\u0005q\u0001o\u001c7mS:<g)\u001e;ve\u0016\u0004\u0013CA4k!\t\t\u0003.\u0003\u0002jE\t9aj\u001c;iS:<\u0007CA\u0011l\u0013\ta'EA\u0002B]f\f\u0011\u0003]8mY&twMR;ukJ,w\fJ3r)\ty'\u000f\u0005\u0002\"a&\u0011\u0011O\t\u0002\u0005+:LG\u000fC\u0004t\u0013\u0005\u0005\t\u0019\u0001;\u0002\u0007a$\u0013\u0007\r\u0002voB\u0019Qi\u0018<\u0011\u0005\t<H!\u00033s\u0003\u0003\u0005\tQ!\u0001g\u0003\u0015\u0019H/\u0019:u)\ty'\u0010C\u0003|\u0017\u0001\u0007A0A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\t\u0004{\u0006%ab\u0001@\u0002\u0006A\u0011qPI\u0007\u0003\u0003\u0003Q1!a\u0001\u001f\u0003\u0019a$o\\8u}%\u0019\u0011q\u0001\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\rM#(/\u001b8h\u0015\r\t9A\t\u0015\u0006\u0017\u0005E\u0011Q\u0004\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0005U!!B*j]\u000e,\u0017EAA\u0010\u0003\u0015\u0019d&\r\u00184\u0003\u0011\u0019Ho\u001c9\u0015\u0003=DS\u0001DA\t\u0003;\u0011A\u0002U8mYJ+hN\\1cY\u0016\u001cR!DA\u0016\u0003o\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cQ\u0015\u0001\u00027b]\u001eLA!!\u000e\u00020\t1qJ\u00196fGR\u0004B!!\f\u0002:%!\u00111HA\u0018\u0005!\u0011VO\u001c8bE2,G\u0003BA \u0003\u0007\u00022!!\u0011\u000e\u001b\u0005\u0001\u0001\"B>\u0010\u0001\u0004a\u0018a\u0001:v]\"\u001a\u0001!!\u0013\u0011\t\u0005M\u00111J\u0005\u0005\u0003\u001b\n)B\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000eK\u0002\u0001\u0003#\u0002B!a\u0005\u0002T%!\u0011QKA\u000b\u0005\u0019\u0019F/\u00192mK\u0002")
public class ExecutorPodsPollingSnapshotSource
implements Logging {
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient;
    public final ExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore;
    private final ScheduledExecutorService pollingExecutor;
    private final long pollingInterval;
    private Future<?> pollingFuture;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long pollingInterval() {
        return this.pollingInterval;
    }

    private Future<?> pollingFuture() {
        return this.pollingFuture;
    }

    private void pollingFuture_$eq(Future<?> x$1) {
        this.pollingFuture = x$1;
    }

    public void start(String applicationId) {
        Predef$.MODULE$.require(this.pollingFuture() == null, (Function0 & Serializable & scala.Serializable)() -> "Cannot start polling more than once.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Starting to check for executor pod state every ").append(this.pollingInterval()).append(" ms.").toString());
        this.pollingFuture_$eq(this.pollingExecutor.scheduleWithFixedDelay(new PollRunnable(this, applicationId), this.pollingInterval(), this.pollingInterval(), TimeUnit.MILLISECONDS));
    }

    public void stop() {
        if (this.pollingFuture() != null) {
            this.pollingFuture().cancel(true);
            this.pollingFuture_$eq(null);
        }
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.pollingExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
    }

    public ExecutorPodsPollingSnapshotSource(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, ScheduledExecutorService pollingExecutor) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore = snapshotsStore;
        this.pollingExecutor = pollingExecutor;
        Logging.$init$((Logging)this);
        this.pollingInterval = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_INTERVAL()));
    }

    private class PollRunnable
    implements Runnable {
        private final String applicationId;
        public final /* synthetic */ ExecutorPodsPollingSnapshotSource $outer;

        @Override
        public void run() {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Resynchronizing full executor pod state from Kubernetes.");
                $this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore.replaceSnapshot((Seq<Pod>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((PodList)((Listable)((Filterable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withoutLabel(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL(), "true")).list()).getItems()).asScala()).toSeq());
            });
        }

        public /* synthetic */ ExecutorPodsPollingSnapshotSource org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer() {
            return this.$outer;
        }

        public PollRunnable(ExecutorPodsPollingSnapshotSource $outer, String applicationId) {
            this.applicationId = applicationId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

