/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u2Q!\u0002\u0004\u0001\u0019IA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006O\u0001!\t\u0005\u000b\u0005\u0006]\u0001!Ia\f\u0002\u0018\u001b>,h\u000e^*fGJ,Go\u001d$fCR,(/Z*uKBT!a\u0002\u0005\u0002\u0011\u0019,\u0017\r^;sKNT!!\u0003\u0006\u0002\u0007-D4O\u0003\u0002\f\u0019\u00051A-\u001a9m_fT!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\ta!\u0003\u0002\u001d\r\tY2*\u001e2fe:,G/Z:GK\u0006$XO]3D_:4\u0017nZ*uKB\fab[;cKJtW\r^3t\u0007>tgm\u0001\u0001\u0011\u0005\u0001\nS\"\u0001\u0005\n\u0005\tB!AD&vE\u0016\u0014h.\u001a;fg\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00152\u0003C\u0001\u000e\u0001\u0011\u0015i\"\u00011\u0001 \u00031\u0019wN\u001c4jOV\u0014X\rU8e)\tIC\u0006\u0005\u0002!U%\u00111\u0006\u0003\u0002\t'B\f'o\u001b)pI\")Qf\u0001a\u0001S\u0005\u0019\u0001o\u001c3\u0002!M,7M]3u->dW/\\3OC6,GC\u0001\u0019<!\t\t\u0004H\u0004\u00023mA\u00111'F\u0007\u0002i)\u0011QGH\u0001\u0007yI|w\u000e\u001e \n\u0005]*\u0012A\u0002)sK\u0012,g-\u0003\u0002:u\t11\u000b\u001e:j]\u001eT!aN\u000b\t\u000bq\"\u0001\u0019\u0001\u0019\u0002\u0015M,7M]3u\u001d\u0006lW\r")
public class MountSecretsFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf kubernetesConf;

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Iterable addedVolumes = (Iterable)this.kubernetesConf.secretNamesToMountPaths().keys().map((Function1 & Serializable & scala.Serializable)secretName -> ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeFluentImpl)new VolumeBuilder().withName(this.secretVolumeName((String)secretName))).withNewSecret().withSecretName(secretName)).endSecret()).build(), scala.collection.Iterable$.MODULE$.canBuildFrom());
        Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editOrNewSpec().addToVolumes((Volume[])addedVolumes.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
        scala.collection.immutable.Iterable addedVolumeMounts = (scala.collection.immutable.Iterable)this.kubernetesConf.secretNamesToMountPaths().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String secretName = (String)tuple2._1();
            String mountPath = (String)tuple2._2();
            VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)new VolumeMountBuilder().withName(this.secretVolumeName(secretName))).withMountPath(mountPath)).build();
            return volumeMount;
        }, Iterable$.MODULE$.canBuildFrom());
        Container containerWithMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])addedVolumeMounts.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
        return new SparkPod(podWithVolumes, containerWithMounts);
    }

    private String secretVolumeName(String secretName) {
        return new StringBuilder(7).append(secretName).append("-volume").toString();
    }

    public MountSecretsFeatureStep(KubernetesConf kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
        KubernetesFeatureConfigStep.$init$(this);
    }
}

