/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesNFSVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep$;
import org.apache.spark.internal.config.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!\u0002\u000b\u0016\u0001m\t\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bI\u0002A\u0011A\u001a\t\u000fY\u0002!\u0019!C\u0001o!1a\n\u0001Q\u0001\naBQa\u0014\u0001\u0005BACQA\u0016\u0001\u0005\n]CQa\u001d\u0001\u0005BQDQ\u0001\u001f\u0001\u0005\ne<\u0001\"a\u0004\u0016\u0011\u0003Y\u0012\u0011\u0003\u0004\b)UA\taGA\n\u0011\u0019\u0011$\u0002\"\u0001\u0002\u0016!I\u0011q\u0003\u0006C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003SQ\u0001\u0015!\u0003\u0002\u001c!I\u00111\u0006\u0006C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003[Q\u0001\u0015!\u0003\u0002\u001c!I\u0011q\u0006\u0006C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003cQ\u0001\u0015!\u0003\u0002\u001c!I\u00111\u0007\u0006C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003kQ\u0001\u0015!\u0003\u0002\u001c\t9Rj\\;oiZ{G.^7fg\u001a+\u0017\r^;sKN#X\r\u001d\u0006\u0003-]\t\u0001BZ3biV\u0014Xm\u001d\u0006\u00031e\t1a\u001b\u001dt\u0015\tQ2$\u0001\u0004eKBdw.\u001f\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sON\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tI#&D\u0001\u0016\u0013\tYSCA\u000eLk\n,'O\\3uKN4U-\u0019;ve\u0016\u001cuN\u001c4jON#X\r]\u0001\u0005G>tgm\u0001\u0001\u0011\u0005=\u0002T\"A\f\n\u0005E:\"AD&vE\u0016\u0014h.\u001a;fg\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Q*\u0004CA\u0015\u0001\u0011\u0015a#\u00011\u0001/\u0003M\tG\rZ5uS>t\u0017\r\u001c*fg>,(oY3t+\u0005A\u0004cA\u001d?\u00016\t!H\u0003\u0002<y\u00059Q.\u001e;bE2,'BA\u001f%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u00121\"\u0011:sCf\u0014UO\u001a4feB\u0011\u0011\tT\u0007\u0002\u0005*\u00111\tR\u0001\u0006[>$W\r\u001c\u0006\u0003\u000b\u001a\u000b1!\u00199j\u0015\t9\u0005*\u0001\u0006lk\n,'O\\3uKNT!!\u0013&\u0002\u000f\u0019\f'M]5dq)\t1*\u0001\u0002j_&\u0011QJ\u0011\u0002\f\u0011\u0006\u001cX*\u001a;bI\u0006$\u0018-\u0001\u000bbI\u0012LG/[8oC2\u0014Vm]8ve\u000e,7\u000fI\u0001\rG>tg-[4ve\u0016\u0004v\u000e\u001a\u000b\u0003#R\u0003\"a\f*\n\u0005M;\"\u0001C*qCJ\\\u0007k\u001c3\t\u000bU+\u0001\u0019A)\u0002\u0007A|G-\u0001\td_:\u001cHO];diZ{G.^7fgR\u0011\u0001,\u001c\t\u00043\u0006$gB\u0001.`\u001d\tYf,D\u0001]\u0015\tiV&\u0001\u0004=e>|GOP\u0005\u0002K%\u0011\u0001\rJ\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117M\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t\u0001G\u0005\u0005\u0003$K\u001eT\u0017B\u00014%\u0005\u0019!V\u000f\u001d7feA\u0011\u0011\t[\u0005\u0003S\n\u00131BV8mk6,Wj\\;oiB\u0011\u0011i[\u0005\u0003Y\n\u0013aAV8mk6,\u0007\"\u00028\u0007\u0001\u0004y\u0017a\u0003<pYVlWm\u00159fGN\u00042!W1q!\ty\u0013/\u0003\u0002s/\t!2*\u001e2fe:,G/Z:W_2,X.Z*qK\u000e\f\u0001eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d7*\u001e2fe:,G/Z:SKN|WO]2fgR\tQ\u000fE\u0002Zm\u0002K!a^2\u0003\u0007M+\u0017/A\tdQ\u0016\u001c7\u000e\u0015,D\u00072\f\u0017.\u001c(b[\u0016$\"A_?\u0011\u0005\rZ\u0018B\u0001?%\u0005\u0011)f.\u001b;\t\u000byD\u0001\u0019A@\u0002\u0013\rd\u0017-[7OC6,\u0007\u0003BA\u0001\u0003\u0013qA!a\u0001\u0002\u0006A\u00111\fJ\u0005\u0004\u0003\u000f!\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twMC\u0002\u0002\b\u0011\nq#T8v]R4v\u000e\\;nKN4U-\u0019;ve\u0016\u001cF/\u001a9\u0011\u0005%R1C\u0001\u0006#)\t\t\t\"A\u0007Q-\u000e{vJT0E\u000b6\u000be\nR\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0003mC:<'BAA\u0013\u0003\u0011Q\u0017M^1\n\t\u0005-\u0011qD\u0001\u000f!Z\u001bul\u0014(`\t\u0016k\u0015I\u0014#!\u0003\r\u0001fkQ\u0001\u0005!Z\u001b\u0005%A\u0006Q-\u000e{\u0006kT*U\r&C\u0016\u0001\u0004)W\u0007~\u0003vj\u0015+G\u0013b\u0003\u0013a\u0004)W\u0007~\u000b5iQ#T'~ku\nR#\u0002!A36iX!D\u0007\u0016\u001b6kX'P\t\u0016\u0003\u0003")
public class MountVolumesFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf conf;
    private final ArrayBuffer<HasMetadata> additionalResources;

    public static String PVC_ACCESS_MODE() {
        return MountVolumesFeatureStep$.MODULE$.PVC_ACCESS_MODE();
    }

    public static String PVC_POSTFIX() {
        return MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX();
    }

    public static String PVC() {
        return MountVolumesFeatureStep$.MODULE$.PVC();
    }

    public static String PVC_ON_DEMAND() {
        return MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND();
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    public ArrayBuffer<HasMetadata> additionalResources() {
        return this.additionalResources;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Tuple2 tuple2 = this.constructVolumes((Iterable<KubernetesVolumeSpec>)this.conf.volumes()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable volumeMounts = (Iterable)tuple2._1();
        Iterable volumes = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)volumeMounts, (Object)volumes);
        Iterable volumeMounts2 = (Iterable)tuple22._1();
        Iterable volumes2 = (Iterable)tuple22._2();
        Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editSpec().addToVolumes((Volume[])volumes2.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
        Container containerWithVolumeMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])volumeMounts2.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
        return new SparkPod(podWithVolumes, containerWithVolumeMounts);
    }

    private Iterable<Tuple2<VolumeMount, Volume>> constructVolumes(Iterable<KubernetesVolumeSpec> volumeSpecs) {
        scala.collection.immutable.Iterable duplicateMountPaths = (scala.collection.immutable.Iterable)((TraversableOnce)volumeSpecs.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.mountPath(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq().groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String x = (String)A1._1();
                    Seq ys = (Seq)A1._2();
                    if (ys.length() > 1) {
                        return (B1)new StringBuilder(2).append("'").append(x).append("'").toString();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                Seq ys;
                Tuple2<String, Seq<String>> tuple2 = x1;
                return tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(duplicateMountPaths.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Found duplicated mountPath: ").append(duplicateMountPaths.mkString(", ")).toString());
        return (Iterable)((TraversableLike)volumeSpecs.zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                VolumeBuilder volumeBuilder;
                KubernetesVolumeSpec spec = (KubernetesVolumeSpec)tuple2._1();
                int i = tuple2._2$mcI$sp();
                VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)((VolumeMountFluentImpl)((VolumeMountFluentImpl)new VolumeMountBuilder().withMountPath(spec.mountPath())).withReadOnly(Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly()))).withSubPath(spec.mountSubPath())).withName(spec.volumeName())).build();
                KubernetesVolumeSpecificConf kubernetesVolumeSpecificConf = spec.volumeConf();
                if (kubernetesVolumeSpecificConf instanceof KubernetesHostPathVolumeConf) {
                    KubernetesHostPathVolumeConf kubernetesHostPathVolumeConf = (KubernetesHostPathVolumeConf)kubernetesVolumeSpecificConf;
                    String hostPath = kubernetesHostPathVolumeConf.hostPath();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withHostPath(new HostPathVolumeSource(hostPath, ""));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesPVCVolumeConf) {
                    String claimName;
                    String string;
                    KubernetesPVCVolumeConf kubernetesPVCVolumeConf = (KubernetesPVCVolumeConf)kubernetesVolumeSpecificConf;
                    String claimNameTemplate = kubernetesPVCVolumeConf.claimName();
                    Option<String> storageClass = kubernetesPVCVolumeConf.storageClass();
                    Option<String> size = kubernetesPVCVolumeConf.size();
                    KubernetesConf kubernetesConf = $this.conf;
                    if (kubernetesConf instanceof KubernetesExecutorConf) {
                        KubernetesExecutorConf kubernetesExecutorConf = (KubernetesExecutorConf)kubernetesConf;
                        this.checkPVCClaimName(claimNameTemplate);
                        string = claimNameTemplate.replaceAll(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND(), new StringBuilder(7).append($this.conf.resourceNamePrefix()).append("-exec-").append(kubernetesExecutorConf.executorId()).append(MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX()).append("-").append(i).toString()).replaceAll(Constants$.MODULE$.ENV_EXECUTOR_ID(), kubernetesExecutorConf.executorId());
                    } else {
                        string = claimName = claimNameTemplate.replaceAll(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND(), new StringBuilder(8).append($this.conf.resourceNamePrefix()).append("-driver").append(MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX()).append("-").append(i).toString());
                    }
                    if (storageClass.isDefined() && size.isDefined()) {
                        this.additionalResources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasMetadata[]{((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluentImpl)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluentImpl)((PersistentVolumeClaimFluentImpl)new PersistentVolumeClaimBuilder().withKind(MountVolumesFeatureStep$.MODULE$.PVC())).withApiVersion("v1")).withNewMetadata().withName(claimName).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.conf.appId())).endMetadata()).withNewSpec().withStorageClassName((String)storageClass.get()).withAccessModes(new String[]{MountVolumesFeatureStep$.MODULE$.PVC_ACCESS_MODE()}).withResources(((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().withRequests((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"storage"), (Object)new Quantity((String)size.get()))}))).asJava())).build())).endSpec()).build()}));
                    }
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly())));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesEmptyDirVolumeConf) {
                    KubernetesEmptyDirVolumeConf kubernetesEmptyDirVolumeConf = (KubernetesEmptyDirVolumeConf)kubernetesVolumeSpecificConf;
                    Option<String> medium = kubernetesEmptyDirVolumeConf.medium();
                    Option<String> sizeLimit = kubernetesEmptyDirVolumeConf.sizeLimit();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withEmptyDir(new EmptyDirVolumeSource((String)medium.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Quantity)sizeLimit.map((Function1 & Serializable & scala.Serializable)x$3 -> new Quantity(x$3)).orNull(Predef$.MODULE$.$conforms())));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesNFSVolumeConf) {
                    KubernetesNFSVolumeConf kubernetesNFSVolumeConf = (KubernetesNFSVolumeConf)kubernetesVolumeSpecificConf;
                    String path = kubernetesNFSVolumeConf.path();
                    String server = kubernetesNFSVolumeConf.server();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withNfs(new NFSVolumeSource(path, null, server));
                } else {
                    throw new MatchError((Object)kubernetesVolumeSpecificConf);
                }
                VolumeBuilder volumeBuilder2 = volumeBuilder;
                Volume volume = ((VolumeBuilder)volumeBuilder2.withName(spec.volumeName())).build();
                return new Tuple2((Object)volumeMount, (Object)volume);
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return this.additionalResources().toSeq();
    }

    private void checkPVCClaimName(String claimName) {
        Option executorInstances = (Option)this.conf.get(package$.MODULE$.EXECUTOR_INSTANCES());
        if (executorInstances.isDefined() && BoxesRunTime.unboxToInt((Object)executorInstances.get()) > 1) {
            if (!claimName.contains(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND()) && !claimName.contains(Constants$.MODULE$.ENV_EXECUTOR_ID())) {
                throw new IllegalArgumentException(new StringBuilder(69).append("PVC ClaimName: ").append(claimName).append(" ").append("should contain ").append(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND()).append(" or ").append(Constants$.MODULE$.ENV_EXECUTOR_ID()).append(" ").append("when requiring multiple executors").toString());
            }
            return;
        }
    }

    public MountVolumesFeatureStep(KubernetesConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        this.additionalResources = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    }
}

