/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.util.Locale;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.resource.ResourceProfile$;
import scala.Option;

public final class KubernetesConf$ {
    public static final KubernetesConf$ MODULE$ = new KubernetesConf$();

    public KubernetesDriverConf createDriverConf(SparkConf sparkConf, String appId, MainAppResource mainAppResource, String mainClass, String[] appArgs, Option<String> proxyUser) {
        KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX());
        return new KubernetesDriverConf(sparkConf.clone(), appId, mainAppResource, mainClass, appArgs, proxyUser);
    }

    public KubernetesExecutorConf createExecutorConf(SparkConf sparkConf, String executorId, String appId, Option<Pod> driverPod, int resourceProfileId) {
        return new KubernetesExecutorConf(sparkConf.clone(), appId, executorId, driverPod, resourceProfileId);
    }

    public int createExecutorConf$default$5() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public String getResourceNamePrefix(String appName) {
        String id = KubernetesUtils$.MODULE$.uniqueID(KubernetesUtils$.MODULE$.uniqueID$default$1());
        return new StringBuilder(1).append(appName).append("-").append(id).toString().trim().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\-]", "-").replaceAll("-+", "-");
    }

    public String buildKubernetesResourceName(String vendorDomain, String resourceName) {
        return new StringBuilder(1).append(vendorDomain).append("/").append(resourceName).toString();
    }

    private KubernetesConf$() {
    }
}

