/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.api.plugin.DriverPlugin;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Config$ExecutorRollPolicy$;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExecutorDecommissionInfo;
import org.apache.spark.scheduler.ExecutorDecommissionInfo$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001B\t\u0013\u0001}AQA\u000e\u0001\u0005\u0002]B\u0001B\u000f\u0001\t\u0006\u0004%\ta\u000f\u0005\n\u0005\u0002\u0001\r\u00111A\u0005\n\rC\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011B%\t\u0013I\u0003\u0001\u0019!A!B\u0013!\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u0007;\u0002\u0001\u000b\u0011B+\t\u0011y\u0003\u0001\u0019!C\u0001%}C\u0001b\u0019\u0001A\u0002\u0013\u0005!\u0003\u001a\u0005\u0007M\u0002\u0001\u000b\u0015\u00021\t\u000b\u001d\u0004A\u0011\t5\t\r}\u0004A\u0011IA\u0001\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!a\n\u0001\t\u0013\tI\u0003C\u0004\u0002~\u0001!I!a \t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\nAR\t_3dkR|'OU8mY\u0012\u0013\u0018N^3s!2,x-\u001b8\u000b\u0005M!\u0012aA69g*\u0011QCF\u0001\bG2,8\u000f^3s\u0015\t9\u0002$A\u0005tG\",G-\u001e7fe*\u0011\u0011DG\u0001\u0006gB\f'o\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\u0003\u0006\r\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0007a2,x-\u001b8\u000b\u00055B\u0012aA1qS&\u0011qF\u000b\u0002\r\tJLg/\u001a:QYV<\u0017N\u001c\t\u0003cQj\u0011A\r\u0006\u0003ga\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003kI\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002qA\u0011\u0011\bA\u0007\u0002%\u0005iQ)\u0014)U3~kU\t\u0016*J\u0007N+\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fa\t\u0001\"\u001a=fGV$xN]\u0005\u0003\u0003z\u0012q\"\u0012=fGV$xN]'fiJL7m]\u0001\rgB\f'o[\"p]R,\u0007\u0010^\u000b\u0002\tB\u0011QIR\u0007\u00021%\u0011q\t\u0007\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0011gB\f'o[\"p]R,\u0007\u0010^0%KF$\"A\u0013)\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\tUs\u0017\u000e\u001e\u0005\b#\u0012\t\t\u00111\u0001E\u0003\rAH%M\u0001\u000egB\f'o[\"p]R,\u0007\u0010\u001e\u0011\u0002\u001fA,'/[8eS\u000e\u001cVM\u001d<jG\u0016,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000b!bY8oGV\u0014(/\u001a8u\u0015\tQF%\u0001\u0003vi&d\u0017B\u0001/X\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0011a\u0016\u0014\u0018n\u001c3jGN+'O^5dK\u0002\n\u0001\"\\5o)\u0006\u001c8n]\u000b\u0002AB\u00111*Y\u0005\u0003E2\u00131!\u00138u\u00031i\u0017N\u001c+bg.\u001cx\fJ3r)\tQU\rC\u0004R\u0013\u0005\u0005\t\u0019\u00011\u0002\u00135Lg\u000eV1tWN\u0004\u0013\u0001B5oSR$2!\u001b={!\u0011Q7.\\7\u000e\u0003eK!\u0001\\-\u0003\u00075\u000b\u0007\u000f\u0005\u0002ok:\u0011qn\u001d\t\u0003a2k\u0011!\u001d\u0006\u0003ez\ta\u0001\u0010:p_Rt\u0014B\u0001;M\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Qd\u0005\"B=\f\u0001\u0004!\u0015AA:d\u0011\u0015Y8\u00021\u0001}\u0003\r\u0019G\u000f\u001f\t\u0003SuL!A \u0016\u0003\u001bAcWoZ5o\u0007>tG/\u001a=u\u0003!\u0019\b.\u001e;e_^tG#\u0001&\u0002\u001d\u001d,G\u000fU3bW6+GO]5dgR1\u0011qAA\u0007\u0003G\u00012aSA\u0005\u0013\r\tY\u0001\u0014\u0002\u0005\u0019>tw\rC\u0004\u0002\u00105\u0001\r!!\u0005\u0002\u000fM,X.\\1ssB!\u00111CA\u0010\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011A\u0001<2\u0015\ri\u00131\u0004\u0006\u0004\u0003;A\u0012AB:uCR,8/\u0003\u0003\u0002\"\u0005U!aD#yK\u000e,Ho\u001c:Tk6l\u0017M]=\t\r\u0005\u0015R\u00021\u0001n\u0003\u0011q\u0017-\\3\u0002\r\rDwn\\:f)\u0019\tY#!\r\u0002HA!1*!\fn\u0013\r\ty\u0003\u0014\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005Mb\u00021\u0001\u00026\u0005!A.[:u!\u0019\t9$!\u0011\u0002\u00129!\u0011\u0011HA\u001f\u001d\r\u0001\u00181H\u0005\u0002\u001b&\u0019\u0011q\b'\u0002\u000fA\f7m[1hK&!\u00111IA#\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u007fa\u0005bBA%\u001d\u0001\u0007\u00111J\u0001\u0007a>d\u0017nY=\u0011\t\u00055\u0013Q\u000f\b\u0005\u0003\u001f\nyG\u0004\u0003\u0002R\u0005%d\u0002BA*\u0003KrA!!\u0016\u0002b9!\u0011qKA0\u001d\u0011\tI&!\u0018\u000f\u0007A\fY&C\u0001\u001e\u0013\tYB$\u0003\u0002\u001a5%\u0019\u00111\r\r\u0002\r\u0011,\u0007\u000f\\8z\u0013\r\u0019\u0012q\r\u0006\u0004\u0003GB\u0012\u0002BA6\u0003[\naaQ8oM&<'bA\n\u0002h%!\u0011\u0011OA:\u0003I)\u00050Z2vi>\u0014(k\u001c7m!>d\u0017nY=\u000b\t\u0005-\u0014QN\u0005\u0005\u0003o\nIHA\u0003WC2,X-C\u0002\u0002|1\u00131\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006qr.\u001e;mS\u0016\u00148O\u0012:p[6+H\u000e^5qY\u0016$\u0015.\\3og&|gn\u001d\u000b\u0005\u0003\u0003\u000by\t\u0005\u0004\u0002\u0004\u00065\u0015\u0011C\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017c\u0015AC2pY2,7\r^5p]&!\u00111IAC\u0011\u001d\t\tj\u0004a\u0001\u0003k\t\u0011\u0003\\5ti^KG\u000f[8vi\u0012\u0013\u0018N^3s\u0003!yW\u000f\u001e7jKJ\u001cHCBA\u001b\u0003/\u000bI\nC\u0004\u00024A\u0001\r!!\u000e\t\u000f\u0005m\u0005\u00031\u0001\u0002\u001e\u0006\u0019q-\u001a;\u0011\u000f-\u000by*!\u0005\u0002$&\u0019\u0011\u0011\u0015'\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA&\u0002&&\u0019\u0011q\u0015'\u0003\u000b\u0019cw.\u0019;")
public class ExecutorRollDriverPlugin
implements DriverPlugin,
Logging {
    private ExecutorMetrics EMPTY_METRICS;
    private SparkContext sparkContext;
    private final ScheduledExecutorService periodicService;
    private int minTasks;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void registerMetrics(String x$1, PluginContext x$2) {
        super.registerMetrics(x$1, x$2);
    }

    public Object receive(Object x$1) throws Exception {
        return super.receive(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ExecutorMetrics EMPTY_METRICS$lzycompute() {
        ExecutorRollDriverPlugin executorRollDriverPlugin = this;
        synchronized (executorRollDriverPlugin) {
            if (!this.bitmap$0) {
                this.EMPTY_METRICS = new ExecutorMetrics(Array$.MODULE$.emptyLongArray());
                this.bitmap$0 = true;
            }
        }
        return this.EMPTY_METRICS;
    }

    public ExecutorMetrics EMPTY_METRICS() {
        if (!this.bitmap$0) {
            return this.EMPTY_METRICS$lzycompute();
        }
        return this.EMPTY_METRICS;
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    private ScheduledExecutorService periodicService() {
        return this.periodicService;
    }

    public int minTasks() {
        return this.minTasks;
    }

    public void minTasks_$eq(int x$1) {
        this.minTasks = x$1;
    }

    public java.util.Map<String, String> init(SparkContext sc, PluginContext ctx) {
        long interval = BoxesRunTime.unboxToLong((Object)sc.conf().get(Config$.MODULE$.EXECUTOR_ROLL_INTERVAL()));
        if (interval <= 0L) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Disabled due to invalid interval value, "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)(interval * 1000L)))})))));
            v0 = BoxedUnit.UNIT;
        } else if (!BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.DECOMMISSION_ENABLED()))) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Disabled because ", " is false."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)package$.MODULE$.DECOMMISSION_ENABLED().key())}))));
            v0 = BoxedUnit.UNIT;
        } else {
            this.minTasks_$eq(BoxesRunTime.unboxToInt((Object)sc.conf().get(Config$.MODULE$.MINIMUM_TASKS_PER_EXECUTOR_BEFORE_ROLLING())));
            this.sparkContext_$eq(sc);
            Enumeration.Value policy = Config$ExecutorRollPolicy$.MODULE$.withName((String)sc.conf().get(Config$.MODULE$.EXECUTOR_ROLL_POLICY()));
            v0 = this.periodicService().scheduleAtFixedRate(() -> {
                block5: {
                    try {
                        SchedulerBackend schedulerBackend = this.sparkContext().schedulerBackend();
                        if (schedulerBackend instanceof KubernetesClusterSchedulerBackend) {
                            KubernetesClusterSchedulerBackend kubernetesClusterSchedulerBackend = (KubernetesClusterSchedulerBackend)schedulerBackend;
                            Seq executorSummaryList = this.sparkContext().statusStore().executorList(true);
                            Option<String> option = this.choose((Seq<ExecutorSummary>)executorSummaryList, policy);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                String id = (String)some.value();
                                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Ask to decommission executor ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTOR_ID$.MODULE$, (Object)id)}))));
                                long now = System.currentTimeMillis();
                                kubernetesClusterSchedulerBackend.decommissionExecutor(id, new ExecutorDecommissionInfo("Rolling via " + policy + " at " + now, ExecutorDecommissionInfo$.MODULE$.apply$default$2()), false, kubernetesClusterSchedulerBackend.decommissionExecutor$default$4());
                            } else {
                                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "There is nothing to roll.");
                            }
                            break block5;
                        }
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "This plugin expects " + this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, (Object)KubernetesClusterSchedulerBackend.class.getSimpleName())})));
                    }
                    catch (Throwable e) {
                        this.logError((Function0<String>)(Function0 & Serializable)() -> "Error in rolling thread", e);
                    }
                }
            }, interval, interval, TimeUnit.SECONDS);
        }
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
    }

    public void shutdown() {
        this.periodicService().shutdown();
    }

    private long getPeakMetrics(ExecutorSummary summary, String name) {
        return ((ExecutorMetrics)summary.peakMemoryMetrics().getOrElse((Function0 & Serializable)() -> this.EMPTY_METRICS())).getMetricValue(name);
    }

    private Option<String> choose(Seq<ExecutorSummary> list, Enumeration.Value policy) {
        Seq<ExecutorSummary> seq;
        Seq listWithoutDriver = (Seq)((IterableOps)list.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRollDriverPlugin.$anonfun$choose$1(x$2)))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRollDriverPlugin.$anonfun$choose$2(this, x$3)));
        Enumeration.Value value = policy;
        Enumeration.Value value2 = Config$ExecutorRollPolicy$.MODULE$.ID();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            seq = (Seq<ExecutorSummary>)listWithoutDriver.sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4.id()))), (Ordering)Ordering.Int$.MODULE$);
        } else {
            Enumeration.Value value4 = Config$ExecutorRollPolicy$.MODULE$.ADD_TIME();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                seq = (Seq)listWithoutDriver.sortBy((Function1 & Serializable)x$5 -> x$5.addTime(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            } else {
                Enumeration.Value value6 = Config$ExecutorRollPolicy$.MODULE$.TOTAL_GC_TIME();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    seq = (Seq)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.totalGCTime()), (Ordering)Ordering.Long$.MODULE$)).reverse();
                } else {
                    Enumeration.Value value8 = Config$ExecutorRollPolicy$.MODULE$.TOTAL_DURATION();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        seq = (Seq)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.totalDuration()), (Ordering)Ordering.Long$.MODULE$)).reverse();
                    } else {
                        Enumeration.Value value10 = Config$ExecutorRollPolicy$.MODULE$.AVERAGE_DURATION();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            seq = (Seq)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)ExecutorRollDriverPlugin.$anonfun$choose$7(e)), (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).reverse();
                        } else {
                            Enumeration.Value value12 = Config$ExecutorRollPolicy$.MODULE$.FAILED_TASKS();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                seq = (Seq)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.failedTasks()), (Ordering)Ordering.Int$.MODULE$)).reverse();
                            } else {
                                Enumeration.Value value14 = Config$ExecutorRollPolicy$.MODULE$.PEAK_JVM_ONHEAP_MEMORY();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    seq = (Seq)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)this.getPeakMetrics(x$9, "JVMHeapMemory")), (Ordering)Ordering.Long$.MODULE$)).reverse();
                                } else {
                                    Enumeration.Value value16 = Config$ExecutorRollPolicy$.MODULE$.PEAK_JVM_OFFHEAP_MEMORY();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        seq = (Seq)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)this.getPeakMetrics(x$10, "JVMOffHeapMemory")), (Ordering)Ordering.Long$.MODULE$)).reverse();
                                    } else {
                                        Enumeration.Value value18 = Config$ExecutorRollPolicy$.MODULE$.TOTAL_SHUFFLE_WRITE();
                                        Enumeration.Value value19 = value;
                                        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                            seq = (Seq)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.totalShuffleWrite()), (Ordering)Ordering.Long$.MODULE$)).reverse();
                                        } else {
                                            Enumeration.Value value20 = Config$ExecutorRollPolicy$.MODULE$.DISK_USED();
                                            Enumeration.Value value21 = value;
                                            if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
                                                seq = (Seq)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.diskUsed()), (Ordering)Ordering.Long$.MODULE$)).reverse();
                                            } else {
                                                Enumeration.Value value22 = Config$ExecutorRollPolicy$.MODULE$.OUTLIER();
                                                Enumeration.Value value23 = value;
                                                if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
                                                    seq = (Seq)this.outliersFromMultipleDimensions((Seq<ExecutorSummary>)listWithoutDriver).$plus$plus((IterableOnce)((SeqOps)listWithoutDriver.sortBy((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.totalDuration()), (Ordering)Ordering.Long$.MODULE$)).reverse());
                                                } else {
                                                    Enumeration.Value value24 = Config$ExecutorRollPolicy$.MODULE$.OUTLIER_NO_FALLBACK();
                                                    Enumeration.Value value25 = value;
                                                    if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                                                        seq = this.outliersFromMultipleDimensions((Seq<ExecutorSummary>)listWithoutDriver);
                                                    } else {
                                                        throw new MatchError((Object)value);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Seq<ExecutorSummary> sortedList = seq;
        return sortedList.headOption().map((Function1 & Serializable)x$14 -> x$14.id());
    }

    private Seq<ExecutorSummary> outliersFromMultipleDimensions(Seq<ExecutorSummary> listWithoutDriver) {
        return (Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)this.outliers((Seq<ExecutorSummary>)((Seq)listWithoutDriver.filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRollDriverPlugin.$anonfun$outliersFromMultipleDimensions$1(x$15)))), (Function1<ExecutorSummary, Object>)(Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)ExecutorRollDriverPlugin.$anonfun$outliersFromMultipleDimensions$2(e))).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)e.totalDuration())))).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)e.totalGCTime())))).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)e.failedTasks())))).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)this.getPeakMetrics(e, "JVMHeapMemory"))))).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)this.getPeakMetrics(e, "JVMOffHeapMemory"))))).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)e.totalShuffleWrite())))).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)e.diskUsed())));
    }

    private Seq<ExecutorSummary> outliers(Seq<ExecutorSummary> list, Function1<ExecutorSummary, Object> get) {
        if (list.isEmpty()) {
            return list;
        }
        int size = list.size();
        Seq values = (Seq)list.map(get);
        float mean = BoxesRunTime.unboxToFloat((Object)values.sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)size;
        double sd = Math.sqrt(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)values.map((Function1)(JFunction1.mcFF.sp & Serializable)v -> (v - mean) * (v - mean))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)size);
        return (Seq)((SeqOps)((SeqOps)list.filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ExecutorRollDriverPlugin.$anonfun$outliers$2(get, mean, sd, e)))).sortBy((Function1 & Serializable)e -> BoxesRunTime.boxToFloat((float)ExecutorRollDriverPlugin.$anonfun$outliers$3(get, e)), (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).reverse();
    }

    public static final /* synthetic */ boolean $anonfun$choose$1(ExecutorSummary x$2) {
        return x$2.id().equals(SparkContext$.MODULE$.DRIVER_IDENTIFIER());
    }

    public static final /* synthetic */ boolean $anonfun$choose$2(ExecutorRollDriverPlugin $this, ExecutorSummary x$3) {
        return x$3.totalTasks() >= $this.minTasks();
    }

    public static final /* synthetic */ float $anonfun$choose$7(ExecutorSummary e) {
        return (float)e.totalDuration() / (float)Math.max(1, e.totalTasks());
    }

    public static final /* synthetic */ boolean $anonfun$outliersFromMultipleDimensions$1(ExecutorSummary x$15) {
        return x$15.totalTasks() > 0;
    }

    public static final /* synthetic */ float $anonfun$outliersFromMultipleDimensions$2(ExecutorSummary e) {
        return e.totalDuration() / (long)e.totalTasks();
    }

    public static final /* synthetic */ boolean $anonfun$outliers$2(Function1 get$1, float mean$1, double sd$1, ExecutorSummary e) {
        return (double)(BoxesRunTime.unboxToFloat((Object)get$1.apply((Object)e)) - mean$1) > (double)2 * sd$1;
    }

    public static final /* synthetic */ float $anonfun$outliers$3(Function1 get$1, ExecutorSummary e) {
        return BoxesRunTime.unboxToFloat((Object)get$1.apply((Object)e));
    }

    public ExecutorRollDriverPlugin() {
        Logging.$init$((Logging)this);
        this.periodicService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("executor-roller");
        this.minTasks = 0;
    }
}

