/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Unstable
@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\u0010!\u0001-B\u0011B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u001e\t\u0011q\u0002!Q1A\u0005\u0002uB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0019\u0002\u0011)\u0019!C\u0001\u001b\"AA\u000b\u0001B\u0001B\u0003%a\n\u0003\u0005V\u0001\t\u0015\r\u0011\"\u0001>\u0011!1\u0006A!A!\u0002\u0013q\u0004\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011u\u0003!\u0011!Q\u0001\neC\u0001B\u0018\u0001\u0003\u0006\u0004%\ta\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005A\"AA\r\u0001B\u0001B\u0003%Q\rC\u0003l\u0001\u0011\u0005A\u000eC\u0003v\u0001\u0011\u0005a\u000f\u0003\u0005{\u0001!\u0015\r\u0011\"\u0001>\u0011\u001dY\bA1A\u0005BuBa\u0001 \u0001!\u0002\u0013q\u0004\"B?\u0001\t\u00032\b\"\u0002@\u0001\t\u00032\b\"B@\u0001\t\u00032\bBBA\u0001\u0001\u0011\u0005a\u000f\u0003\u0004\u0002\u0004\u0001!\tA\u001e\u0005\u0007\u0003\u000b\u0001A\u0011\t<\t\r\u0005\u001d\u0001\u0001\"\u0011w\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aa!!\n\u0001\t\u0003zv!CA%A\u0005\u0005\t\u0012AA&\r!y\u0002%!A\t\u0002\u00055\u0003BB6\u001d\t\u0003\t)\u0006C\u0005\u0002Xq\t\n\u0011\"\u0001\u0002Z\t!2*\u001e2fe:,G/Z:Ee&4XM]\"p]\u001aT!!\t\u0012\u0002\u0007-D4O\u0003\u0002$I\u00051A-\u001a9m_fT!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0006\r\t\u0003[9j\u0011\u0001I\u0005\u0003_\u0001\u0012abS;cKJtW\r^3t\u0007>tg\r\u0005\u00022i5\t!G\u0003\u00024I\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0017!C:qCJ\\7i\u001c8g!\tA\u0014(D\u0001%\u0013\tQDEA\u0005Ta\u0006\u00148nQ8oM&\u0011aGL\u0001\u0006CB\u0004\u0018\nZ\u000b\u0002}A\u0011q\b\u0013\b\u0003\u0001\u001a\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u0016\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d#\u0015AB1qa&#\u0007%A\bnC&t\u0017\t\u001d9SKN|WO]2f+\u0005q\u0005CA(S\u001b\u0005\u0001&BA)!\u0003\u0019\u0019XOY7ji&\u00111\u000b\u0015\u0002\u0010\u001b\u0006Lg.\u00119q%\u0016\u001cx.\u001e:dK\u0006\u0001R.Y5o\u0003B\u0004(+Z:pkJ\u001cW\rI\u0001\n[\u0006Lgn\u00117bgN\f!\"\\1j]\u000ec\u0017m]:!\u0003\u001d\t\u0007\u000f]!sON,\u0012!\u0017\t\u00045nsT\"\u0001#\n\u0005q#%!B!se\u0006L\u0018\u0001C1qa\u0006\u0013xm\u001d\u0011\u0002\u0013A\u0014x\u000e_=Vg\u0016\u0014X#\u00011\u0011\u0007i\u000bg(\u0003\u0002c\t\n1q\n\u001d;j_:\f!\u0002\u001d:pqf,6/\u001a:!\u0003\u0015\u0019Gn\\2l!\t1\u0017.D\u0001h\u0015\tAG%\u0001\u0003vi&d\u0017B\u00016h\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}QAQN\\8qcJ\u001cH\u000f\u0005\u0002.\u0001!)a'\u0004a\u0001o!)A(\u0004a\u0001}!)A*\u0004a\u0001\u001d\")Q+\u0004a\u0001}!)q+\u0004a\u00013\")a,\u0004a\u0001A\"9A-\u0004I\u0001\u0002\u0004)\u0017A\u00053sSZ,'OT8eKN+G.Z2u_J,\u0012a\u001e\t\u0005\u007fatd(\u0003\u0002z\u0015\n\u0019Q*\u00199\u0002#\u0011\u0014\u0018N^3s'\u0016\u0014h/[2f\u001d\u0006lW-\u0001\nsKN|WO]2f\u001d\u0006lW\r\u0015:fM&D\u0018a\u0005:fg>,(oY3OC6,\u0007K]3gSb\u0004\u0013A\u00027bE\u0016d7/A\u0006f]ZL'o\u001c8nK:$\u0018aC1o]>$\u0018\r^5p]N\fQb]3sm&\u001cW\rT1cK2\u001c\u0018AE:feZL7-Z!o]>$\u0018\r^5p]N\fqc]3de\u0016$h*Y7fgR{Wj\\;oiB\u000bG\u000f[:\u0002/M,7M]3u\u000b:4h*Y7fgR{7*Z=SK\u001a\u001c\u0018a\u0002<pYVlWm]\u000b\u0003\u0003\u001b\u0001b!a\u0004\u0002\u001a\u0005}a\u0002BA\t\u0003+q1!QA\n\u0013\u0005)\u0015bAA\f\t\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u00111aU3r\u0015\r\t9\u0002\u0012\t\u0004[\u0005\u0005\u0012bAA\u0012A\t!2*\u001e2fe:,G/Z:W_2,X.Z*qK\u000e\fQb]2iK\u0012,H.\u001a:OC6,\u0007f\u0001\u0001\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019$!\f\u0003\u0011Us7\u000f^1cY\u0016D3\u0001AA\u001c!\u0011\tY#!\u000f\n\t\u0005m\u0012Q\u0006\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0015\u0006\u0001\u0005}\u0012Q\t\t\u0005\u0003W\t\t%\u0003\u0003\u0002D\u00055\"!B*j]\u000e,\u0017EAA$\u0003\u0015!d\u0006\r\u00181\u0003QYUOY3s]\u0016$Xm\u001d#sSZ,'oQ8oMB\u0011Q\u0006H\n\u00049\u0005=\u0003c\u0001.\u0002R%\u0019\u00111\u000b#\u0003\r\u0005s\u0017PU3g)\t\tY%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u000b\u0003\u00037R3!ZA/W\t\ty\u0006\u0005\u0003\u0002b\u0005%TBAA2\u0015\u0011\t)'a\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0018\t&!\u00111NA2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class KubernetesDriverConf
extends KubernetesConf
implements Logging {
    private String driverServiceName;
    private final String appId;
    private final MainAppResource mainAppResource;
    private final String mainClass;
    private final String[] appArgs;
    private final Option<String> proxyUser;
    private final Clock clock;
    private final String resourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Clock $lessinit$greater$default$7() {
        return KubernetesDriverConf$.MODULE$.$lessinit$greater$default$7();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String appId() {
        return this.appId;
    }

    public MainAppResource mainAppResource() {
        return this.mainAppResource;
    }

    public String mainClass() {
        return this.mainClass;
    }

    public String[] appArgs() {
        return this.appArgs;
    }

    public Option<String> proxyUser() {
        return this.proxyUser;
    }

    public Map<String, String> driverNodeSelector() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_NODE_SELECTOR_PREFIX());
    }

    private String driverServiceName$lzycompute() {
        KubernetesDriverConf kubernetesDriverConf = this;
        synchronized (kubernetesDriverConf) {
            if (!this.bitmap$0) {
                String string;
                String preferredServiceName = this.resourceNamePrefix() + DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX();
                if (preferredServiceName.length() <= DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()) {
                    string = preferredServiceName;
                } else {
                    String randomServiceId = KubernetesUtils$.MODULE$.uniqueID(this.clock);
                    String shorterServiceName = "spark-" + randomServiceId + DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX();
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Driver's hostname would preferably be "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", but this is too long "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PREFERRED_SERVICE_NAME$.MODULE$, (Object)preferredServiceName)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(must be <= ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_SERVICE_NAME_LENGTH$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"characters). Falling back to use "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " as the driver service's name."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SHORTER_SERVICE_NAME$.MODULE$, (Object)shorterServiceName)})))));
                    string = shorterServiceName;
                }
                this.driverServiceName = string;
                this.bitmap$0 = true;
            }
        }
        return this.driverServiceName;
    }

    public String driverServiceName() {
        if (!this.bitmap$0) {
            return this.driverServiceName$lzycompute();
        }
        return this.driverServiceName;
    }

    @Override
    public String resourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    @Override
    public Map<String, String> labels() {
        Map presetLabels = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_VERSION_LABEL()), (Object)package$.MODULE$.SPARK_VERSION()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_NAME_LABEL()), (Object)KubernetesConf$.MODULE$.getAppNameLabel(this.appName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_DRIVER_ROLE())}));
        Map driverCustomLabels = (Map)KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_LABEL_PREFIX()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, this.appId(), ""));
            }
            throw new MatchError((Object)tuple2);
        });
        presetLabels.keys().foreach((Function1 & Serializable)key -> {
            Predef$.MODULE$.require(!driverCustomLabels.contains((Object)key), (Function0 & Serializable)() -> "Label with key " + key + " is not allowed as it is reserved for Spark bookkeeping operations.");
            return BoxedUnit.UNIT;
        });
        return (Map)driverCustomLabels.$plus$plus((IterableOnce)presetLabels);
    }

    @Override
    public Map<String, String> environment() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_ENV_PREFIX());
    }

    @Override
    public Map<String, String> annotations() {
        return (Map)KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_ANNOTATION_PREFIX()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, this.appId(), ""));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Map<String, String> serviceLabels() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_LABEL_PREFIX());
    }

    public Map<String, String> serviceAnnotations() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_ANNOTATION_PREFIX());
    }

    @Override
    public Map<String, String> secretNamesToMountPaths() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_SECRETS_PREFIX());
    }

    @Override
    public Map<String, String> secretEnvNamesToKeyRefs() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX());
    }

    @Override
    public Seq<KubernetesVolumeSpec> volumes() {
        return KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_VOLUMES_PREFIX());
    }

    @Override
    public Option<String> schedulerName() {
        return Option$.MODULE$.apply(((Option)this.get(Config$.MODULE$.KUBERNETES_DRIVER_SCHEDULER_NAME())).getOrElse((Function0 & Serializable)() -> (String)((Option)this.get(Config$.MODULE$.KUBERNETES_SCHEDULER_NAME())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public KubernetesDriverConf(SparkConf sparkConf, String appId, MainAppResource mainAppResource, String mainClass, String[] appArgs, Option<String> proxyUser, Clock clock) {
        this.appId = appId;
        this.mainAppResource = mainAppResource;
        this.mainClass = mainClass;
        this.appArgs = appArgs;
        this.proxyUser = proxyUser;
        this.clock = clock;
        super(sparkConf);
        Logging.$init$((Logging)this);
        None$ custom = Utils$.MODULE$.isTesting() ? (Option)this.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME_PREFIX()) : None$.MODULE$;
        this.resourceNamePrefix = (String)custom.getOrElse((Function0 & Serializable)() -> KubernetesConf$.MODULE$.getResourceNamePrefix(this.appName()));
    }
}

