/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesNFSVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

@Unstable
@DeveloperApi
public final class KubernetesVolumeUtils$ {
    public static final KubernetesVolumeUtils$ MODULE$ = new KubernetesVolumeUtils$();

    public Seq<KubernetesVolumeSpec> parseVolumesWithPrefix(SparkConf sparkConf, String prefix) {
        Map properties = Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAllWithPrefix(prefix)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return ((IterableOnceOps)this.getVolumeTypesAndNames((Map<String, String>)properties).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String volumeType = (String)tuple2._1();
                String volumeName = (String)tuple2._2();
                String pathKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_PATH_KEY();
                String readOnlyKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_READONLY_KEY();
                String subPathKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_SUBPATH_KEY();
                String labelKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_LABEL_KEY();
                Map volumeLabelsMap = (Map)((MapOps)properties.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesVolumeUtils$.$anonfun$parseVolumesWithPrefix$2(labelKey, x$1)))).map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.replaceAll(labelKey, "")), (Object)v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return new KubernetesVolumeSpec(volumeName, (String)properties.apply((Object)pathKey), (String)properties.getOrElse((Object)subPathKey, (Function0 & Serializable)() -> ""), properties.get((Object)readOnlyKey).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$2)))), MODULE$.parseVolumeSpecificConf((Map<String, String>)properties, volumeType, volumeName, (Option<Map<String, String>>)Option$.MODULE$.apply((Object)volumeLabelsMap)));
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
    }

    private Set<Tuple2<String, String>> getVolumeTypesAndNames(Map<String, String> properties) {
        return ((IterableOnceOps)properties.keys().flatMap((Function1 & Serializable)k -> {
            List list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(k), '.')).toList();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                String tpe = (String)colon2.head();
                List list2 = colon2.next$access$1();
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    String name = (String)colon3.head();
                    return new Some((Object)new Tuple2((Object)tpe, (Object)name));
                }
            }
            return None$.MODULE$;
        })).toSet();
    }

    private KubernetesVolumeSpecificConf parseVolumeSpecificConf(Map<String, String> options, String volumeType, String volumeName, Option<Map<String, String>> labels) {
        String string = volumeType;
        String string2 = Config$.MODULE$.KUBERNETES_VOLUMES_HOSTPATH_TYPE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String pathKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY();
            this.verifyOptionKey(options, pathKey, Config$.MODULE$.KUBERNETES_VOLUMES_HOSTPATH_TYPE());
            return new KubernetesHostPathVolumeConf((String)options.apply((Object)pathKey));
        }
        String string4 = Config$.MODULE$.KUBERNETES_VOLUMES_PVC_TYPE();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            String claimNameKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_CLAIM_NAME_KEY();
            String storageClassKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_CLAIM_STORAGE_CLASS_KEY();
            String sizeLimitKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY();
            this.verifyOptionKey(options, claimNameKey, Config$.MODULE$.KUBERNETES_VOLUMES_PVC_TYPE());
            this.verifySize((Option<String>)options.get((Object)sizeLimitKey));
            return new KubernetesPVCVolumeConf((String)options.apply((Object)claimNameKey), (Option<String>)options.get((Object)storageClassKey), (Option<String>)options.get((Object)sizeLimitKey), labels);
        }
        String string6 = Config$.MODULE$.KUBERNETES_VOLUMES_EMPTYDIR_TYPE();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            String mediumKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_MEDIUM_KEY();
            String sizeLimitKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY();
            this.verifySize((Option<String>)options.get((Object)sizeLimitKey));
            return new KubernetesEmptyDirVolumeConf((Option<String>)options.get((Object)mediumKey), (Option<String>)options.get((Object)sizeLimitKey));
        }
        String string8 = Config$.MODULE$.KUBERNETES_VOLUMES_NFS_TYPE();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            String pathKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY();
            String serverKey = volumeType + "." + volumeName + "." + Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SERVER_KEY();
            this.verifyOptionKey(options, pathKey, Config$.MODULE$.KUBERNETES_VOLUMES_NFS_TYPE());
            this.verifyOptionKey(options, serverKey, Config$.MODULE$.KUBERNETES_VOLUMES_NFS_TYPE());
            return new KubernetesNFSVolumeConf((String)options.apply((Object)pathKey), (String)options.apply((Object)serverKey));
        }
        throw new IllegalArgumentException("Kubernetes Volume type `" + volumeType + "` is not supported");
    }

    private void verifyOptionKey(Map<String, String> options, String key, String msg) {
        if (!options.isDefinedAt((Object)key)) {
            throw new NoSuchElementException(key + " is required for " + msg);
        }
    }

    private void verifySize(Option<String> size) {
        size.foreach((Function1 & Serializable)v -> {
            KubernetesVolumeUtils$.$anonfun$verifySize$1(v);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseVolumesWithPrefix$2(String labelKey$1, Tuple2 x$1) {
        return ((String)x$1._1()).startsWith(labelKey$1);
    }

    public static final /* synthetic */ void $anonfun$verifySize$1(String v) {
        if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(v), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$3))))) && Long.parseLong(v) < 1024L) {
            throw new IllegalArgumentException("Volume size `" + v + "` is smaller than 1KiB. Missing units?");
        }
    }

    private KubernetesVolumeUtils$() {
    }
}

