/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005uh!\u0002\u0011\"\u0001\u001dj\u0003\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011\u0001\u001f\t\u0011\u0005\u0003!\u0011!Q\u0001\nuB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\")A\u000b\u0001C\u0001+\"A!\f\u0001EC\u0002\u0013%1\f\u0003\u0005`\u0001!\u0015\r\u0011\"\u0003a\u0011!!\u0007\u0001#b\u0001\n\u0013)\u0007bB=\u0001\u0001\u0004%I\u0001\u0019\u0005\bu\u0002\u0001\r\u0011\"\u0003|\u0011\u001d\t\u0019\u0001\u0001Q!\n\u0005D\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0013A\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003?Aq!a\u000e\u0001\t\u0003\tI\u0004C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\t\u0019\f\u0001C\u0005\u0003kCq!!2\u0001\t\u0013\t9\rC\u0004\u0002L\u0002!I!!4\b\u000f\u0005M\u0017\u0005#\u0003\u0002V\u001a1\u0001%\tE\u0005\u0003/Da\u0001\u0016\u000e\u0005\u0002\u0005e\u0007\"CAn5\t\u0007I\u0011AAo\u0011!\tyN\u0007Q\u0001\n\u0005}\u0006bBAq5\u0011\u0005\u00111\u001d\u0005\b\u0003STB\u0011AAv\u0005q)\u00050Z2vi>\u0014\bk\u001c3t\u0019&4WmY=dY\u0016l\u0015M\\1hKJT!AI\u0012\u0002\u0007-D4O\u0003\u0002%K\u000591\r\\;ti\u0016\u0014(B\u0001\u0014(\u0003%\u00198\r[3ek2,'O\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h'\r\u0001a\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]:\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005e2$a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0016\u0003u\u0002\"AP \u000e\u0003\u001dJ!\u0001Q\u0014\u0003\u0013M\u0003\u0018M]6D_:4\u0017!B2p]\u001a\u0004\u0013\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u!\t!U*D\u0001F\u0015\t1u)\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u0011&\u000b!b[;cKJtW\r^3t\u0015\tQ5*A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u00031\u000b!![8\n\u00059+%\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u00039\u0019h.\u00199tQ>$8o\u0015;pe\u0016\u0004\"!\u0015*\u000e\u0003\u0005J!aU\u0011\u00035\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\u0002\rqJg.\u001b;?)\u00111v\u000bW-\u0011\u0005E\u0003\u0001\"\u0002\u001e\u0006\u0001\u0004i\u0004\"\u0002\"\u0006\u0001\u0004\u0019\u0005\"B(\u0006\u0001\u0004\u0001\u0016!F:i_VdG\rR3mKR,W\t_3dkR|'o]\u000b\u00029B\u0011q&X\u0005\u0003=B\u0012qAQ8pY\u0016\fg.A\u000bnSN\u001c\u0018N\\4Q_\u0012$U\r^3di\u0012+G\u000e^1\u0016\u0003\u0005\u0004\"a\f2\n\u0005\r\u0004$\u0001\u0002'p]\u001e\fQC]3n_Z,G-\u0012=fGV$xN]:DC\u000eDW-F\u0001g!\u00119\u0007O\u001d:\u000e\u0003!T!!\u001b6\u0002\u000b\r\f7\r[3\u000b\u0005-d\u0017AB2p[6|gN\u0003\u0002n]\u00061qm\\8hY\u0016T\u0011a\\\u0001\u0004G>l\u0017BA9i\u0005\u0015\u0019\u0015m\u00195f!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003mC:<'\"A<\u0002\t)\fg/Y\u0005\u0003GR\f!\u0003\\1ti\u001a+H\u000e\\*oCB\u001c\bn\u001c;Ug\u00061B.Y:u\rVdGn\u00158baNDw\u000e\u001e+t?\u0012*\u0017\u000f\u0006\u0002}\u007fB\u0011q&`\u0005\u0003}B\u0012A!\u00168ji\"A\u0011\u0011\u0001\u0006\u0002\u0002\u0003\u0007\u0011-A\u0002yIE\n1\u0003\\1ti\u001a+H\u000e\\*oCB\u001c\bn\u001c;Ug\u0002\nq\"\u001b8bGRLg/\u0019;fIB{Gm]\u000b\u0003\u0003\u0013\u0001R!a\u0003\u0002\u0016\u0005l!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019\u0002M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\f\u0003\u001b\u0011q\u0001S1tQN+G/\u0001\tj]\u0006\u001cG/\u001b<bi\u0016$\u0007k\u001c3tA\u0005Ia.Y7fgB\f7-Z\u000b\u0003\u0003?\u0001B!!\t\u000209!\u00111EA\u0016!\r\t)\u0003M\u0007\u0003\u0003OQ1!!\u000b<\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0006\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t$a\r\u0003\rM#(/\u001b8h\u0015\r\ti\u0003M\u0001\u000b]\u0006lWm\u001d9bG\u0016\u0004\u0013!B:uCJ$Hc\u0001?\u0002<!9\u0011Q\b\tA\u0002\u0005}\u0012\u0001E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\r\t\u0016\u0011I\u0005\u0004\u0003\u0007\n#!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017AD8o\u001d\u0016<8K\\1qg\"|Go\u001d\u000b\u0006y\u0006%\u00131\n\u0005\b\u0003{\t\u0002\u0019AA \u0011\u001d\ti%\u0005a\u0001\u0003\u001f\n\u0011b\u001d8baNDw\u000e^:\u0011\r\u0005E\u00131LA1\u001d\u0011\t\u0019&a\u0016\u000f\t\u0005\u0015\u0012QK\u0005\u0002c%\u0019\u0011\u0011\f\u0019\u0002\u000fA\f7m[1hK&!\u0011QLA0\u0005\r\u0019V-\u001d\u0006\u0004\u00033\u0002\u0004cA)\u0002d%\u0019\u0011QM\u0011\u0003)\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8u\u0003YygNR5oC2tuN\u001c#fY\u0016$X\rZ*uCR,G#\u0003/\u0002l\u0005U\u0014\u0011PA>\u0011\u001d\tiG\u0005a\u0001\u0003_\n\u0001\u0002]8e'R\fG/\u001a\t\u0004#\u0006E\u0014bAA:C\tia)\u001b8bYB{Gm\u0015;bi\u0016Da!a\u001e\u0013\u0001\u0004\t\u0017AB3yK\u000eLE\rC\u0004\u0002>I\u0001\r!a\u0010\t\r\u0005u$\u00031\u0001]\u00035!W\r\\3uK\u001a\u0013x.\\&9g\u0006)\"/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n\u0017b\u001aH#\u0002?\u0002\u0004\u0006\u0015\u0005BBA<'\u0001\u0007\u0011\rC\u0004\u0002\bN\u0001\r!!#\u0002\u0015U\u0004H-\u0019;fIB{G\r\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\u000b5|G-\u001a7\u000b\u0007\u0005Mu)A\u0002ba&LA!a&\u0002\u000e\n\u0019\u0001k\u001c3\u0002/I,Wn\u001c<f\u000bb,7-\u001e;pe\u001a\u0013x.\\*qCJ\\Gc\u0002/\u0002\u001e\u0006}\u0015\u0011\u0015\u0005\b\u0003{!\u0002\u0019AA \u0011\u001d\ti\u0007\u0006a\u0001\u0003_Ba!a\u001e\u0015\u0001\u0004\t\u0017A\u00044j]\u0012,\u00050\u001b;SK\u0006\u001cxN\u001c\u000b\u0007\u0003O\u000by+!-\u0011\t\u0005%\u00161V\u0007\u0002K%\u0019\u0011QV\u0013\u0003\u001d\u0015CXmY;u_J,\u00050\u001b;fI\"9\u0011QN\u000bA\u0002\u0005=\u0004BBA<+\u0001\u0007\u0011-A\tfq&$(+Z1t_:lUm]:bO\u0016$\u0002\"a\b\u00028\u0006e\u00161\u0018\u0005\b\u0003[2\u0002\u0019AA8\u0011\u0019\t9H\u0006a\u0001C\"9\u0011Q\u0018\fA\u0002\u0005}\u0016\u0001C3ySR\u001cu\u000eZ3\u0011\u0007=\n\t-C\u0002\u0002DB\u00121!\u00138u\u000311\u0017N\u001c3Fq&$8i\u001c3f)\u0011\ty,!3\t\u000f\u00055t\u00031\u0001\u0002p\u0005i\u0011n\u001d)pI&s\u0017m\u0019;jm\u0016$2\u0001XAh\u0011\u001d\t\t\u000e\u0007a\u0001\u0003\u0013\u000b1\u0001]8e\u0003q)\u00050Z2vi>\u0014\bk\u001c3t\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u0004\"!\u0015\u000e\u0014\u0005iqCCAAk\u0003E)fj\u0013(P/:{V\tW%U?\u000e{E)R\u000b\u0003\u0003\u007f\u000b!#\u0016(L\u001d>;fjX#Y\u0013R{6i\u0014#FA\u0005\u0001B-Z:de&\u0014W-\u0012=ji\u000e{G-\u001a\u000b\u0005\u0003?\t)\u000fC\u0004\u0002hz\u0001\r!a0\u0002\t\r|G-Z\u0001\u0017Kb,7-\u001e;pe&s\u0017m\u0019;jm\u0006$\u0018n\u001c8G]V\u0011\u0011Q\u001e\t\u0007\u0003_\fI0!#\u000e\u0005\u0005E(\u0002BAz\u0003k\f\u0001BZ;oGRLwN\u001c\u0006\u0004\u0003o4\u0018\u0001B;uS2LA!a?\u0002r\niQK\\1ss>\u0003XM]1u_J\u0004")
public class ExecutorPodsLifecycleManager
implements Logging {
    private boolean shouldDeleteExecutors;
    private long missingPodDetectDelta;
    private Cache<Long, Long> removedExecutorsCache;
    private final SparkConf conf;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private long lastFullSnapshotTs;
    private final HashSet<Object> inactivatedPods;
    private final String namespace;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static UnaryOperator<Pod> executorInactivationFn() {
        return ExecutorPodsLifecycleManager$.MODULE$.executorInactivationFn();
    }

    public static String describeExitCode(int code) {
        return ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(code);
    }

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    private boolean shouldDeleteExecutors$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldDeleteExecutors;
    }

    private boolean shouldDeleteExecutors() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.shouldDeleteExecutors$lzycompute();
        }
        return this.shouldDeleteExecutors;
    }

    private long missingPodDetectDelta$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.missingPodDetectDelta = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.missingPodDetectDelta;
    }

    private long missingPodDetectDelta() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.missingPodDetectDelta$lzycompute();
        }
        return this.missingPodDetectDelta;
    }

    private Cache<Long, Long> removedExecutorsCache$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.removedExecutorsCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.removedExecutorsCache;
    }

    private Cache<Long, Long> removedExecutorsCache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.removedExecutorsCache$lzycompute();
        }
        return this.removedExecutorsCache;
    }

    private long lastFullSnapshotTs() {
        return this.lastFullSnapshotTs;
    }

    private void lastFullSnapshotTs_$eq(long x$1) {
        this.lastFullSnapshotTs = x$1;
    }

    private HashSet<Object> inactivatedPods() {
        return this.inactivatedPods;
    }

    private String namespace() {
        return this.namespace;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        long eventProcessingInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
        this.snapshotsStore.addSubscriber(eventProcessingInterval, (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
        snapshots.foreach((Function1 & Serializable)snapshot -> {
            ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
            return BoxedUnit.UNIT;
        });
        Object object = this.inactivatedPods().nonEmpty() && snapshots.nonEmpty() ? this.inactivatedPods().filterInPlace((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> ((ExecutorPodsSnapshot)snapshots.last()).executorPods().contains((Object)BoxesRunTime.boxToLong((long)x$2))) : BoxedUnit.UNIT;
        if (snapshots.nonEmpty() && this.lastFullSnapshotTs() != ((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs()) {
            this.lastFullSnapshotTs_$eq(((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs());
            Map lostExecutorsWithRegistrationTs = (Map)((MapOps)schedulerBackend.getExecutorsWithRegistrationTs().map((Function1 & Serializable)t -> new Tuple2.mcJJ.sp(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)t._1())), t._2$mcJ$sp()))).$minus$minus((IterableOnce)((ExecutorPodsSnapshot)snapshots.last()).executorPods().keySet()).$minus$minus((IterableOnce)execIdsRemovedInThisRound);
            lostExecutorsWithRegistrationTs.foreach((Function1 & Serializable)x0$2 -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$9(this, schedulerBackend, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, boolean deleteFromK8s) {
        boolean deleted;
        block0: {
            deleted = this.removeExecutorFromSpark(schedulerBackend, podState, execId);
            if (!deleteFromK8s) break block0;
            this.removeExecutorFromK8s(execId, podState.pod());
        }
        return deleted;
    }

    private void removeExecutorFromK8s(long execId, Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.shouldDeleteExecutors()) {
                PodResource podToDelete = (PodResource)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(updatedPod.getMetadata().getName());
                if (podToDelete.get() != null) {
                    podToDelete.delete();
                    return;
                }
                return;
            }
            if (!this.inactivatedPods().contains((Object)BoxesRunTime.boxToLong((long)execId)) && !this.isPodInactive(updatedPod)) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Marking executor " + updatedPod.getMetadata().getName() + " as inactive since deletion is disabled.");
                ((EditReplacePatchable)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(updatedPod.getMetadata().getName())).edit(ExecutorPodsLifecycleManager$.MODULE$.executorInactivationFn());
                this.inactivatedPods().$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                return;
            }
        });
    }

    private boolean removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        if (this.removedExecutorsCache().getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) == null) {
            this.removedExecutorsCache().put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(Long.toString(execId), (ExecutorLossReason)exitReason);
            return true;
        }
        return false;
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            v0 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)("The executor with id " + execId + " was deleted by a user or the framework."));
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            v0 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean exitCausedByApp = tuple2._1$mcZ$sp();
        String exitMessage = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        boolean exitCausedByApp2 = tuple22._1$mcZ$sp();
        String exitMessage2 = (String)tuple22._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        Option reason = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)pod.getStatus().getMessage());
        String explained = ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(exitCode);
        String exitMsg = "The executor with id " + execId + " exited with exit code " + explained + ".";
        Option reasonStr = reason.map((Function1 & Serializable)r -> "The API gave the following brief reason: " + r);
        Option msgStr = message.map((Function1 & Serializable)m -> "The API gave the following message: " + m);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + exitMsg + "\n       |" + reasonStr.getOrElse((Function0 & Serializable)() -> "") + "\n       |" + msgStr.getOrElse((Function0 & Serializable)() -> "") + "\n       |\n       |The API gave the following container statuses:\n       |\n       |" + KubernetesUtils$.MODULE$.containersDescription(pod, KubernetesUtils$.MODULE$.containersDescription$default$2()) + "\n      "));
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.ListHasAsScala(podState.pod().getStatus().getContainerStatuses()).asScala().find((Function1 & Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(containerStatus))).map((Function1 & Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    private boolean isPodInactive(Pod pod) {
        Object v = pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL());
        String string = "true";
        return !(v != null ? !v.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if ($this.isPodInactive(executorPodState.pod())) {
                    return $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                }
                if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    if ($this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot reported deleted executor with id " + execId + ", pod name " + state.pod().getMetadata().getName());
                    }
                    return $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                }
                if (executorPodState instanceof PodFailed) {
                    boolean deleteFromK8s;
                    PodFailed podFailed = (PodFailed)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot reported failed executor with id " + execId + ", pod name " + state.pod().getMetadata().getName());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (executorPodState instanceof PodSucceeded) {
                    boolean deleteFromK8s;
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        if (schedulerBackend$2.isExecutorActive(Long.toString(execId))) {
                            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot reported succeeded executor with id "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", even though the application has not "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTOR_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)execId))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"requested for it to be removed."}))).log((Seq)Nil$.MODULE$))));
                            return BoxedUnit.UNIT;
                        }
                        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot reported succeeded executor with id " + execId + ", pod name " + state.pod().getMetadata().getName() + ".");
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$9(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long lostExecId = tuple2._1$mcJ$sp();
            long lostExecRegistrationTs = tuple2._2$mcJ$sp();
            if ($this.removedExecutorsCache().getIfPresent((Object)BoxesRunTime.boxToLong((long)lostExecId)) == null && $this.lastFullSnapshotTs() - lostExecRegistrationTs > $this.missingPodDetectDelta()) {
                String exitReasonMessage = "The executor with ID " + lostExecId + " (registered at " + lostExecRegistrationTs + " ms) was not found in the cluster at the polling time (" + $this.lastFullSnapshotTs() + " ms) which is after the accepted detect delta time (" + $this.missingPodDetectDelta() + " ms) configured by `" + Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA().key() + "`. The executor may have been deleted but the driver missed the deletion event. Marking this executor as failed.";
                $this.logDebug((Function0<String>)(Function0 & Serializable)() -> exitReasonMessage);
                ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
                schedulerBackend$2.doRemoveExecutor(Long.toString(lostExecId), (ExecutorLossReason)exitReason);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ContainerStatus containerStatus) {
        return containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore) {
        this.conf = conf;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        Logging.$init$((Logging)this);
        this.lastFullSnapshotTs = 0L;
        this.inactivatedPods = HashSet$.MODULE$.empty();
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
    }
}

