/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkSubmitOptionParser;

class SparkSubmitCommandBuilder
extends AbstractCommandBuilder {
    static final String PYSPARK_SHELL = "pyspark-shell-main";
    static final String PYSPARK_SHELL_RESOURCE = "pyspark-shell";
    static final String SPARKR_SHELL = "sparkr-shell-main";
    static final String SPARKR_SHELL_RESOURCE = "sparkr-shell";
    private static final Map<String, String> specialClasses = new HashMap<String, String>();
    final List<String> sparkArgs = new ArrayList<String>();
    private final boolean printHelp;
    private boolean allowsMixedArguments;

    SparkSubmitCommandBuilder() {
        this.printHelp = false;
    }

    SparkSubmitCommandBuilder(List<String> args) {
        List<String> submitArgs = args;
        if (args.size() > 0 && args.get(0).equals(PYSPARK_SHELL)) {
            this.allowsMixedArguments = true;
            this.appResource = PYSPARK_SHELL_RESOURCE;
            submitArgs = args.subList(1, args.size());
        } else if (args.size() > 0 && args.get(0).equals(SPARKR_SHELL)) {
            this.allowsMixedArguments = true;
            this.appResource = SPARKR_SHELL_RESOURCE;
            submitArgs = args.subList(1, args.size());
        } else {
            this.allowsMixedArguments = false;
        }
        OptionParser parser = new OptionParser();
        parser.parse(submitArgs);
        this.printHelp = parser.helpRequested;
    }

    @Override
    public List<String> buildCommand(Map<String, String> env) throws IOException {
        if (PYSPARK_SHELL_RESOURCE.equals(this.appResource) && !this.printHelp) {
            return this.buildPySparkShellCommand(env);
        }
        if (SPARKR_SHELL_RESOURCE.equals(this.appResource) && !this.printHelp) {
            return this.buildSparkRCommand(env);
        }
        return this.buildSparkSubmitCommand(env);
    }

    List<String> buildSparkSubmitArgs() {
        ArrayList<String> args = new ArrayList<String>();
        SparkSubmitOptionParser parser = new SparkSubmitOptionParser();
        if (this.verbose) {
            parser.getClass();
            args.add("--verbose");
        }
        if (this.master != null) {
            parser.getClass();
            args.add("--master");
            args.add(this.master);
        }
        if (this.deployMode != null) {
            parser.getClass();
            args.add("--deploy-mode");
            args.add(this.deployMode);
        }
        if (this.appName != null) {
            parser.getClass();
            args.add("--name");
            args.add(this.appName);
        }
        for (Map.Entry e : this.conf.entrySet()) {
            parser.getClass();
            args.add("--conf");
            args.add(String.format("%s=%s", e.getKey(), e.getValue()));
        }
        if (this.propertiesFile != null) {
            parser.getClass();
            args.add("--properties-file");
            args.add(this.propertiesFile);
        }
        if (!this.jars.isEmpty()) {
            parser.getClass();
            args.add("--jars");
            args.add(CommandBuilderUtils.join(",", this.jars));
        }
        if (!this.files.isEmpty()) {
            parser.getClass();
            args.add("--files");
            args.add(CommandBuilderUtils.join(",", this.files));
        }
        if (!this.pyFiles.isEmpty()) {
            parser.getClass();
            args.add("--py-files");
            args.add(CommandBuilderUtils.join(",", this.pyFiles));
        }
        if (this.mainClass != null) {
            parser.getClass();
            args.add("--class");
            args.add(this.mainClass);
        }
        args.addAll(this.sparkArgs);
        if (this.appResource != null) {
            args.add(this.appResource);
        }
        args.addAll(this.appArgs);
        return args;
    }

    private List<String> buildSparkSubmitCommand(Map<String, String> env) throws IOException {
        Properties props = this.loadPropertiesFile();
        boolean isClientMode = this.isClientMode(props);
        String extraClassPath = isClientMode ? CommandBuilderUtils.firstNonEmptyValue("spark.driver.extraClassPath", this.conf, props) : null;
        List<String> cmd = this.buildJavaCommand(extraClassPath);
        if (this.isThriftServer(this.mainClass)) {
            this.addOptionString(cmd, System.getenv("SPARK_DAEMON_JAVA_OPTS"));
        }
        this.addOptionString(cmd, System.getenv("SPARK_SUBMIT_OPTS"));
        this.addOptionString(cmd, System.getenv("SPARK_JAVA_OPTS"));
        if (isClientMode) {
            String tsMemory = this.isThriftServer(this.mainClass) ? System.getenv("SPARK_DAEMON_MEMORY") : null;
            String memory = CommandBuilderUtils.firstNonEmpty(tsMemory, CommandBuilderUtils.firstNonEmptyValue("spark.driver.memory", this.conf, props), System.getenv("SPARK_DRIVER_MEMORY"), System.getenv("SPARK_MEM"), "1g");
            cmd.add("-Xms" + memory);
            cmd.add("-Xmx" + memory);
            this.addOptionString(cmd, CommandBuilderUtils.firstNonEmptyValue("spark.driver.extraJavaOptions", this.conf, props));
            CommandBuilderUtils.mergeEnvPathList(env, CommandBuilderUtils.getLibPathEnvName(), CommandBuilderUtils.firstNonEmptyValue("spark.driver.extraLibraryPath", this.conf, props));
        }
        this.addPermGenSizeOpt(cmd);
        cmd.add("org.apache.spark.deploy.SparkSubmit");
        cmd.addAll(this.buildSparkSubmitArgs());
        return cmd;
    }

    private List<String> buildPySparkShellCommand(Map<String, String> env) throws IOException {
        if (!this.appArgs.isEmpty() && ((String)this.appArgs.get(0)).endsWith(".py")) {
            System.err.println("WARNING: Running python applications through 'pyspark' is deprecated as of Spark 1.0.\nUse ./bin/spark-submit <python file>");
            this.appResource = (String)this.appArgs.get(0);
            this.appArgs.remove(0);
            return this.buildCommand(env);
        }
        CommandBuilderUtils.checkArgument(this.appArgs.isEmpty(), "pyspark does not support any application options.", new Object[0]);
        this.constructEnvVarArgs(env, "PYSPARK_SUBMIT_ARGS");
        ArrayList<String> pyargs = new ArrayList<String>();
        pyargs.add(CommandBuilderUtils.firstNonEmpty(System.getenv("PYSPARK_DRIVER_PYTHON"), "python"));
        String pyOpts = System.getenv("PYSPARK_DRIVER_PYTHON_OPTS");
        if (!CommandBuilderUtils.isEmpty(pyOpts)) {
            pyargs.addAll(CommandBuilderUtils.parseOptionString(pyOpts));
        }
        return pyargs;
    }

    private List<String> buildSparkRCommand(Map<String, String> env) throws IOException {
        if (!this.appArgs.isEmpty() && ((String)this.appArgs.get(0)).endsWith(".R")) {
            this.appResource = (String)this.appArgs.get(0);
            this.appArgs.remove(0);
            return this.buildCommand(env);
        }
        this.constructEnvVarArgs(env, "SPARKR_SUBMIT_ARGS");
        String sparkHome = System.getenv("SPARK_HOME");
        env.put("R_PROFILE_USER", CommandBuilderUtils.join(File.separator, sparkHome, "R", "lib", "SparkR", "profile", "shell.R"));
        ArrayList<String> args = new ArrayList<String>();
        args.add(CommandBuilderUtils.firstNonEmpty(System.getenv("SPARKR_DRIVER_R"), "R"));
        return args;
    }

    private void constructEnvVarArgs(Map<String, String> env, String submitArgsEnvVariable) throws IOException {
        Properties props = this.loadPropertiesFile();
        CommandBuilderUtils.mergeEnvPathList(env, CommandBuilderUtils.getLibPathEnvName(), CommandBuilderUtils.firstNonEmptyValue("spark.driver.extraLibraryPath", this.conf, props));
        StringBuilder submitArgs = new StringBuilder();
        for (String arg : this.buildSparkSubmitArgs()) {
            if (submitArgs.length() > 0) {
                submitArgs.append(" ");
            }
            submitArgs.append(CommandBuilderUtils.quoteForCommandString(arg));
        }
        env.put(submitArgsEnvVariable, submitArgs.toString());
    }

    private boolean isClientMode(Properties userProps) {
        String userMaster = CommandBuilderUtils.firstNonEmpty(this.master, (String)userProps.get("spark.master"));
        return userMaster == null || "client".equals(this.deployMode) || !userMaster.equals("yarn-cluster") && this.deployMode == null;
    }

    private boolean isThriftServer(String mainClass) {
        return mainClass != null && mainClass.equals("org.apache.spark.sql.hive.thriftserver.HiveThriftServer2");
    }

    static {
        specialClasses.put("org.apache.spark.repl.Main", "spark-shell");
        specialClasses.put("org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver", "spark-internal");
        specialClasses.put("org.apache.spark.sql.hive.thriftserver.HiveThriftServer2", "spark-internal");
    }

    private class OptionParser
    extends SparkSubmitOptionParser {
        boolean helpRequested = false;

        private OptionParser() {
        }

        @Override
        protected boolean handle(String opt, String value) {
            if (opt.equals("--master")) {
                SparkSubmitCommandBuilder.this.master = value;
            } else if (opt.equals("--deploy-mode")) {
                SparkSubmitCommandBuilder.this.deployMode = value;
            } else if (opt.equals("--properties-file")) {
                SparkSubmitCommandBuilder.this.propertiesFile = value;
            } else if (opt.equals("--driver-memory")) {
                SparkSubmitCommandBuilder.this.conf.put("spark.driver.memory", value);
            } else if (opt.equals("--driver-java-options")) {
                SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraJavaOptions", value);
            } else if (opt.equals("--driver-library-path")) {
                SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraLibraryPath", value);
            } else if (opt.equals("--driver-class-path")) {
                SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraClassPath", value);
            } else if (opt.equals("--conf")) {
                String[] setConf = value.split("=", 2);
                CommandBuilderUtils.checkArgument(setConf.length == 2, "Invalid argument to %s: %s", "--conf", value);
                SparkSubmitCommandBuilder.this.conf.put(setConf[0], setConf[1]);
            } else if (opt.equals("--class")) {
                SparkSubmitCommandBuilder.this.mainClass = value;
                if (specialClasses.containsKey(value)) {
                    SparkSubmitCommandBuilder.this.allowsMixedArguments = true;
                    SparkSubmitCommandBuilder.this.appResource = (String)specialClasses.get(value);
                }
            } else if (opt.equals("--help") || opt.equals("--usage-error")) {
                this.helpRequested = true;
                SparkSubmitCommandBuilder.this.sparkArgs.add(opt);
            } else {
                SparkSubmitCommandBuilder.this.sparkArgs.add(opt);
                if (value != null) {
                    SparkSubmitCommandBuilder.this.sparkArgs.add(value);
                }
            }
            return true;
        }

        @Override
        protected boolean handleUnknown(String opt) {
            if (SparkSubmitCommandBuilder.this.allowsMixedArguments) {
                SparkSubmitCommandBuilder.this.appArgs.add(opt);
                return true;
            }
            CommandBuilderUtils.checkArgument(!opt.startsWith("-"), "Unrecognized option: %s", opt);
            SparkSubmitCommandBuilder.this.sparkArgs.add(opt);
            return false;
        }

        @Override
        protected void handleExtraArgs(List<String> extra) {
            for (String arg : extra) {
                SparkSubmitCommandBuilder.this.sparkArgs.add(arg);
            }
        }
    }
}

