/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkClassCommandBuilder;
import org.apache.spark.launcher.SparkSubmitCommandBuilder;

class Main {
    Main() {
    }

    public static void main(String[] argsArray) throws Exception {
        boolean printUsage;
        boolean printLaunchCommand;
        AbstractCommandBuilder builder;
        CommandBuilderUtils.checkArgument(argsArray.length > 0, "Not enough arguments: missing class name.", new Object[0]);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsArray));
        String className = (String)args.remove(0);
        try {
            builder = className.equals("org.apache.spark.deploy.SparkSubmit") ? new SparkSubmitCommandBuilder(args) : new SparkClassCommandBuilder(className, args);
            printLaunchCommand = !CommandBuilderUtils.isEmpty(System.getenv("SPARK_PRINT_LAUNCH_COMMAND"));
            printUsage = false;
        }
        catch (IllegalArgumentException e) {
            builder = new UsageCommandBuilder(e.getMessage());
            printLaunchCommand = false;
            printUsage = true;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = builder.buildCommand(env);
        if (printLaunchCommand) {
            System.err.println("Spark Command: " + CommandBuilderUtils.join(" ", cmd));
            System.err.println("========================================");
        }
        if (CommandBuilderUtils.isWindows()) {
            if (printUsage) {
                System.out.println(CommandBuilderUtils.join(" ", cmd));
            } else {
                System.out.println(Main.prepareWindowsCommand(cmd, env));
            }
        } else {
            List<String> bashCmd = Main.prepareBashCommand(cmd, env);
            for (String c : bashCmd) {
                System.out.print(c);
                System.out.print('\u0000');
            }
        }
    }

    private static String prepareWindowsCommand(List<String> cmd, Map<String, String> childEnv) {
        StringBuilder cmdline = new StringBuilder();
        for (Map.Entry<String, String> e : childEnv.entrySet()) {
            cmdline.append(String.format("set %s=%s", e.getKey(), e.getValue()));
            cmdline.append(" && ");
        }
        for (String arg : cmd) {
            cmdline.append(CommandBuilderUtils.quoteForBatchScript(arg));
            cmdline.append(" ");
        }
        return cmdline.toString();
    }

    private static List<String> prepareBashCommand(List<String> cmd, Map<String, String> childEnv) {
        if (childEnv.isEmpty()) {
            return cmd;
        }
        ArrayList<String> newCmd = new ArrayList<String>();
        newCmd.add("env");
        for (Map.Entry<String, String> e : childEnv.entrySet()) {
            newCmd.add(String.format("%s=%s", e.getKey(), e.getValue()));
        }
        newCmd.addAll(cmd);
        return newCmd;
    }

    private static class UsageCommandBuilder
    extends AbstractCommandBuilder {
        private final String message;

        UsageCommandBuilder(String message) {
            this.message = message;
        }

        @Override
        public List<String> buildCommand(Map<String, String> env) {
            if (CommandBuilderUtils.isWindows()) {
                return Arrays.asList("set", "SPARK_LAUNCHER_USAGE_ERROR=" + this.message);
            }
            return Arrays.asList("usage", this.message, "1");
        }
    }
}

