/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandBuilderUtils;

class SparkClassCommandBuilder
extends AbstractCommandBuilder {
    private final String className;
    private final List<String> classArgs;

    SparkClassCommandBuilder(String className, List<String> classArgs) {
        this.className = className;
        this.classArgs = classArgs;
    }

    @Override
    public List<String> buildCommand(Map<String, String> env) throws IOException {
        ArrayList<String> javaOptsKeys = new ArrayList<String>();
        String memKey = null;
        String extraClassPath = null;
        if (this.className.equals("org.apache.spark.deploy.master.Master")) {
            javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
            javaOptsKeys.add("SPARK_MASTER_OPTS");
            memKey = "SPARK_DAEMON_MEMORY";
        } else if (this.className.equals("org.apache.spark.deploy.worker.Worker")) {
            javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
            javaOptsKeys.add("SPARK_WORKER_OPTS");
            memKey = "SPARK_DAEMON_MEMORY";
        } else if (this.className.equals("org.apache.spark.deploy.history.HistoryServer")) {
            javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
            javaOptsKeys.add("SPARK_HISTORY_OPTS");
            memKey = "SPARK_DAEMON_MEMORY";
        } else if (this.className.equals("org.apache.spark.executor.CoarseGrainedExecutorBackend")) {
            javaOptsKeys.add("SPARK_JAVA_OPTS");
            javaOptsKeys.add("SPARK_EXECUTOR_OPTS");
            memKey = "SPARK_EXECUTOR_MEMORY";
        } else if (this.className.equals("org.apache.spark.executor.MesosExecutorBackend")) {
            javaOptsKeys.add("SPARK_EXECUTOR_OPTS");
            memKey = "SPARK_EXECUTOR_MEMORY";
        } else if (this.className.equals("org.apache.spark.deploy.ExternalShuffleService")) {
            javaOptsKeys.add("SPARK_DAEMON_JAVA_OPTS");
            javaOptsKeys.add("SPARK_SHUFFLE_OPTS");
            memKey = "SPARK_DAEMON_MEMORY";
        } else if (this.className.startsWith("org.apache.spark.tools.")) {
            String sparkHome = this.getSparkHome();
            File toolsDir = new File(CommandBuilderUtils.join(File.separator, sparkHome, "tools", "target", "scala-" + this.getScalaVersion()));
            CommandBuilderUtils.checkState(toolsDir.isDirectory(), "Cannot find tools build directory.", new Object[0]);
            Pattern re = Pattern.compile("spark-tools_.*\\.jar");
            for (File f : toolsDir.listFiles()) {
                if (!re.matcher(f.getName()).matches()) continue;
                extraClassPath = f.getAbsolutePath();
                break;
            }
            CommandBuilderUtils.checkState(extraClassPath != null, "Failed to find Spark Tools Jar in %s.\nYou need to run \"build/sbt tools/package\" before running %s.", toolsDir.getAbsolutePath(), this.className);
            javaOptsKeys.add("SPARK_JAVA_OPTS");
        }
        List<String> cmd = this.buildJavaCommand(extraClassPath);
        for (String key : javaOptsKeys) {
            this.addOptionString(cmd, System.getenv(key));
        }
        String mem = CommandBuilderUtils.firstNonEmpty(memKey != null ? System.getenv(memKey) : null, "512m");
        cmd.add("-Xms" + mem);
        cmd.add("-Xmx" + mem);
        this.addPermGenSizeOpt(cmd);
        cmd.add(this.className);
        cmd.addAll(this.classArgs);
        return cmd;
    }
}

