/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkClassCommandBuilder;
import org.apache.spark.launcher.SparkSubmitCommandBuilder;
import org.apache.spark.launcher.SparkSubmitOptionParser;

class Main {
    Main() {
    }

    public static void main(String[] argsArray) throws Exception {
        AbstractCommandBuilder builder;
        boolean printLaunchCommand;
        CommandBuilderUtils.checkArgument(argsArray.length > 0, "Not enough arguments: missing class name.", new Object[0]);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsArray));
        String className = (String)args.remove(0);
        boolean bl = printLaunchCommand = !CommandBuilderUtils.isEmpty(System.getenv("SPARK_PRINT_LAUNCH_COMMAND"));
        if (className.equals("org.apache.spark.deploy.SparkSubmit")) {
            try {
                builder = new SparkSubmitCommandBuilder(args);
            }
            catch (IllegalArgumentException e) {
                printLaunchCommand = false;
                System.err.println("Error: " + e.getMessage());
                System.err.println();
                MainClassOptionParser parser = new MainClassOptionParser();
                try {
                    parser.parse(args);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                ArrayList<String> help = new ArrayList<String>();
                if (parser.className != null) {
                    parser.getClass();
                    help.add("--class");
                    help.add(parser.className);
                }
                parser.getClass();
                help.add("--usage-error");
                builder = new SparkSubmitCommandBuilder(help);
            }
        } else {
            builder = new SparkClassCommandBuilder(className, args);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = builder.buildCommand(env);
        if (printLaunchCommand) {
            System.err.println("Spark Command: " + CommandBuilderUtils.join(" ", cmd));
            System.err.println("========================================");
        }
        if (CommandBuilderUtils.isWindows()) {
            System.out.println(Main.prepareWindowsCommand(cmd, env));
        } else {
            List<String> bashCmd = Main.prepareBashCommand(cmd, env);
            for (String c : bashCmd) {
                System.out.print(c);
                System.out.print('\u0000');
            }
        }
    }

    private static String prepareWindowsCommand(List<String> cmd, Map<String, String> childEnv) {
        StringBuilder cmdline = new StringBuilder();
        for (Map.Entry<String, String> e : childEnv.entrySet()) {
            cmdline.append(String.format("set %s=%s", e.getKey(), e.getValue()));
            cmdline.append(" && ");
        }
        for (String arg : cmd) {
            cmdline.append(CommandBuilderUtils.quoteForBatchScript(arg));
            cmdline.append(" ");
        }
        return cmdline.toString();
    }

    private static List<String> prepareBashCommand(List<String> cmd, Map<String, String> childEnv) {
        if (childEnv.isEmpty()) {
            return cmd;
        }
        ArrayList<String> newCmd = new ArrayList<String>();
        newCmd.add("env");
        for (Map.Entry<String, String> e : childEnv.entrySet()) {
            newCmd.add(String.format("%s=%s", e.getKey(), e.getValue()));
        }
        newCmd.addAll(cmd);
        return newCmd;
    }

    private static class MainClassOptionParser
    extends SparkSubmitOptionParser {
        String className;

        private MainClassOptionParser() {
        }

        @Override
        protected boolean handle(String opt, String value) {
            if (opt == "--class") {
                this.className = value;
            }
            return false;
        }

        @Override
        protected boolean handleUnknown(String opt) {
            return false;
        }

        @Override
        protected void handleExtraArgs(List<String> extra) {
        }
    }
}

