/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkSubmitCommandBuilder;
import org.apache.spark.launcher.SparkSubmitOptionParser;

public class SparkLauncher {
    public static final String SPARK_MASTER = "spark.master";
    public static final String DRIVER_MEMORY = "spark.driver.memory";
    public static final String DRIVER_EXTRA_CLASSPATH = "spark.driver.extraClassPath";
    public static final String DRIVER_EXTRA_JAVA_OPTIONS = "spark.driver.extraJavaOptions";
    public static final String DRIVER_EXTRA_LIBRARY_PATH = "spark.driver.extraLibraryPath";
    public static final String EXECUTOR_MEMORY = "spark.executor.memory";
    public static final String EXECUTOR_EXTRA_CLASSPATH = "spark.executor.extraClassPath";
    public static final String EXECUTOR_EXTRA_JAVA_OPTIONS = "spark.executor.extraJavaOptions";
    public static final String EXECUTOR_EXTRA_LIBRARY_PATH = "spark.executor.extraLibraryPath";
    public static final String EXECUTOR_CORES = "spark.executor.cores";
    final SparkSubmitCommandBuilder builder = new SparkSubmitCommandBuilder();

    public SparkLauncher() {
        this(null);
    }

    public SparkLauncher(Map<String, String> env) {
        if (env != null) {
            this.builder.childEnv.putAll(env);
        }
    }

    public SparkLauncher setJavaHome(String javaHome) {
        CommandBuilderUtils.checkNotNull(javaHome, "javaHome");
        this.builder.javaHome = javaHome;
        return this;
    }

    public SparkLauncher setSparkHome(String sparkHome) {
        CommandBuilderUtils.checkNotNull(sparkHome, "sparkHome");
        this.builder.childEnv.put("SPARK_HOME", sparkHome);
        return this;
    }

    public SparkLauncher setPropertiesFile(String path) {
        CommandBuilderUtils.checkNotNull(path, "path");
        this.builder.propertiesFile = path;
        return this;
    }

    public SparkLauncher setConf(String key, String value) {
        CommandBuilderUtils.checkNotNull(key, "key");
        CommandBuilderUtils.checkNotNull(value, "value");
        CommandBuilderUtils.checkArgument(key.startsWith("spark."), "'key' must start with 'spark.'", new Object[0]);
        this.builder.conf.put(key, value);
        return this;
    }

    public SparkLauncher setAppName(String appName) {
        CommandBuilderUtils.checkNotNull(appName, "appName");
        this.builder.appName = appName;
        return this;
    }

    public SparkLauncher setMaster(String master) {
        CommandBuilderUtils.checkNotNull(master, "master");
        this.builder.master = master;
        return this;
    }

    public SparkLauncher setDeployMode(String mode) {
        CommandBuilderUtils.checkNotNull(mode, "mode");
        this.builder.deployMode = mode;
        return this;
    }

    public SparkLauncher setAppResource(String resource) {
        CommandBuilderUtils.checkNotNull(resource, "resource");
        this.builder.appResource = resource;
        return this;
    }

    public SparkLauncher setMainClass(String mainClass) {
        CommandBuilderUtils.checkNotNull(mainClass, "mainClass");
        this.builder.mainClass = mainClass;
        return this;
    }

    public SparkLauncher addSparkArg(String arg) {
        ArgumentValidator validator = new ArgumentValidator(false);
        validator.parse(Arrays.asList(arg));
        this.builder.sparkArgs.add(arg);
        return this;
    }

    public SparkLauncher addSparkArg(String name, String value) {
        ArgumentValidator validator = new ArgumentValidator(true);
        validator.getClass();
        if ("--master".equals(name)) {
            this.setMaster(value);
        } else {
            validator.getClass();
            if ("--properties-file".equals(name)) {
                this.setPropertiesFile(value);
            } else {
                validator.getClass();
                if ("--conf".equals(name)) {
                    String[] vals = value.split("=", 2);
                    this.setConf(vals[0], vals[1]);
                } else {
                    validator.getClass();
                    if ("--class".equals(name)) {
                        this.setMainClass(value);
                    } else {
                        validator.getClass();
                        if ("--jars".equals(name)) {
                            this.builder.jars.clear();
                            for (String jar : value.split(",")) {
                                this.addJar(jar);
                            }
                        } else {
                            validator.getClass();
                            if ("--files".equals(name)) {
                                this.builder.files.clear();
                                for (String file : value.split(",")) {
                                    this.addFile(file);
                                }
                            } else {
                                validator.getClass();
                                if ("--py-files".equals(name)) {
                                    this.builder.pyFiles.clear();
                                    for (String file : value.split(",")) {
                                        this.addPyFile(file);
                                    }
                                } else {
                                    validator.parse(Arrays.asList(name, value));
                                    this.builder.sparkArgs.add(name);
                                    this.builder.sparkArgs.add(value);
                                }
                            }
                        }
                    }
                }
            }
        }
        return this;
    }

    public SparkLauncher addAppArgs(String ... args) {
        for (String arg : args) {
            CommandBuilderUtils.checkNotNull(arg, "arg");
            this.builder.appArgs.add(arg);
        }
        return this;
    }

    public SparkLauncher addJar(String jar) {
        CommandBuilderUtils.checkNotNull(jar, "jar");
        this.builder.jars.add(jar);
        return this;
    }

    public SparkLauncher addFile(String file) {
        CommandBuilderUtils.checkNotNull(file, "file");
        this.builder.files.add(file);
        return this;
    }

    public SparkLauncher addPyFile(String file) {
        CommandBuilderUtils.checkNotNull(file, "file");
        this.builder.pyFiles.add(file);
        return this;
    }

    public SparkLauncher setVerbose(boolean verbose) {
        this.builder.verbose = verbose;
        return this;
    }

    public Process launch() throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        String script = CommandBuilderUtils.isWindows() ? "spark-submit.cmd" : "spark-submit";
        cmd.add(CommandBuilderUtils.join(File.separator, this.builder.getSparkHome(), "bin", script));
        cmd.addAll(this.builder.buildSparkSubmitArgs());
        if (CommandBuilderUtils.isWindows()) {
            ArrayList<String> winCmd = new ArrayList<String>();
            for (String string : cmd) {
                winCmd.add(CommandBuilderUtils.quoteForBatchScript(string));
            }
            cmd = winCmd;
        }
        ProcessBuilder pb = new ProcessBuilder(cmd.toArray(new String[cmd.size()]));
        for (Map.Entry entry : this.builder.childEnv.entrySet()) {
            pb.environment().put((String)entry.getKey(), (String)entry.getValue());
        }
        return pb.start();
    }

    private static class ArgumentValidator
    extends SparkSubmitOptionParser {
        private final boolean hasValue;

        ArgumentValidator(boolean hasValue) {
            this.hasValue = hasValue;
        }

        @Override
        protected boolean handle(String opt, String value) {
            if (value == null && this.hasValue) {
                throw new IllegalArgumentException(String.format("'%s' does not expect a value.", opt));
            }
            return true;
        }

        @Override
        protected boolean handleUnknown(String opt) {
            return true;
        }

        @Override
        protected void handleExtraArgs(List<String> extra) {
        }
    }
}

