/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

class OutputRedirector {
    private final BufferedReader reader;
    private final Logger sink;
    private final Thread thread;
    private volatile boolean active = true;

    OutputRedirector(InputStream in, ThreadFactory tf) {
        this(in, OutputRedirector.class.getName(), tf);
    }

    OutputRedirector(InputStream in, String loggerName, ThreadFactory tf) {
        this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        this.thread = tf.newThread(new Runnable(){

            @Override
            public void run() {
                OutputRedirector.this.redirect();
            }
        });
        this.sink = Logger.getLogger(loggerName);
        this.thread.start();
    }

    private void redirect() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (!this.active) continue;
                this.sink.info(line.replaceFirst("\\s*$", ""));
            }
        }
        catch (IOException e) {
            this.sink.log(Level.FINE, "Error reading child process output.", e);
        }
    }

    void stop() {
        this.active = false;
    }
}

