/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.time.Duration;
import org.apache.spark.launcher.AbstractAppHandle;
import org.apache.spark.launcher.LauncherServer;
import org.apache.spark.launcher.SparkAppHandle;
import org.junit.After;
import org.junit.Assert;
import org.slf4j.bridge.SLF4JBridgeHandler;

class BaseSuite {
    BaseSuite() {
    }

    @After
    public void postChecks() {
        LauncherServer server = LauncherServer.getServer();
        if (server != null) {
            try {
                server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Assert.assertNull((Object)server);
    }

    protected void waitFor(SparkAppHandle handle) throws Exception {
        try {
            this.eventually(Duration.ofSeconds(10L), Duration.ofMillis(10L), () -> Assert.assertTrue((String)"Handle is not in final state.", (boolean)handle.getState().isFinal()));
        }
        finally {
            if (!handle.getState().isFinal()) {
                handle.kill();
            }
        }
        AbstractAppHandle ahandle = (AbstractAppHandle)handle;
        this.eventually(Duration.ofSeconds(10L), Duration.ofMillis(10L), () -> Assert.assertTrue((String)"Handle is still not marked as disposed.", (boolean)ahandle.isDisposed()));
    }

    protected void eventually(Duration timeout, Duration period, Runnable check) throws Exception {
        Assert.assertTrue((String)"Timeout needs to be larger than period.", (timeout.compareTo(period) > 0 ? 1 : 0) != 0);
        long deadline = System.nanoTime() + timeout.toNanos();
        int count = 0;
        while (true) {
            try {
                ++count;
                check.run();
                return;
            }
            catch (Throwable t) {
                if (System.nanoTime() >= deadline) {
                    String msg = String.format("Failed check after %d tries: %s.", count, t.getMessage());
                    throw new IllegalStateException(msg, t);
                }
                Thread.sleep(period.toMillis());
                continue;
            }
            break;
        }
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

