/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.util.Random;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseMatrix$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class SparseMatrix$
implements Serializable {
    public static final SparseMatrix$ MODULE$;

    static {
        new SparseMatrix$();
    }

    public SparseMatrix fromCOO(int numRows, int numCols, Iterable<Tuple3<Object, Object, Object>> entries) {
        Seq sortedEntries = (Seq)entries.toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> v) {
                return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)v._2()), BoxesRunTime.unboxToInt((Object)v._1()));
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        int numEntries = sortedEntries.size();
        if (sortedEntries.nonEmpty()) {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)((Tuple3)sortedEntries.head())._2()), BoxesRunTime.unboxToInt((Object)((Tuple3)sortedEntries.last())._2())}))).foreach((Function1)new Serializable(numCols){
                public static final long serialVersionUID = 0L;
                public final int numCols$5;

                public final void apply(int col) {
                    this.apply$mcVI$sp(col);
                }

                public void apply$mcVI$sp(int col) {
                    Predef$.MODULE$.require(col >= 0 && col < this.numCols$5, (Function0)new Serializable(this, col){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.fromCOO.1 $outer;
                        private final int col$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column index out of range [0, ", "): ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numCols$5), BoxesRunTime.boxToInteger((int)this.col$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.col$1 = col$1;
                        }
                    });
                }
                {
                    this.numCols$5 = numCols$5;
                }
            });
        }
        int[] colPtrs = new int[numCols + 1];
        ArrayBuilder rowIndices = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        rowIndices.sizeHint(numEntries);
        ArrayBuilder values = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        values.sizeHint(numEntries);
        IntRef nnz = new IntRef(0);
        IntRef prevCol = new IntRef(0);
        IntRef prevRow = new IntRef(-1);
        DoubleRef prevVal = new DoubleRef(0.0);
        ((IterableLike)sortedEntries.view().$colon$plus((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)numRows), (Object)BoxesRunTime.boxToInteger((int)numCols), (Object)BoxesRunTime.boxToDouble((double)1.0)), SeqView$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(numRows, colPtrs, rowIndices, values, nnz, prevCol, prevRow, prevVal){
            public static final long serialVersionUID = 0L;
            public final int numRows$5;
            private final int[] colPtrs$1;
            private final ArrayBuilder rowIndices$1;
            private final ArrayBuilder values$1;
            private final IntRef nnz$1;
            private final IntRef prevCol$1;
            public final IntRef prevRow$1;
            private final DoubleRef prevVal$1;

            public final void apply(Tuple3<Object, Object, Object> x0$1) {
                Tuple3<Object, Object, Object> tuple3 = x0$1;
                if (tuple3 != null) {
                    BoxedUnit boxedUnit;
                    int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    if (v != 0.0) {
                        if (i == this.prevRow$1.elem && j == this.prevCol$1.elem) {
                            this.prevVal$1.elem += v;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit2;
                            if (this.prevVal$1.elem != 0.0) {
                                Predef$.MODULE$.require(this.prevRow$1.elem >= 0 && this.prevRow$1.elem < this.numRows$5, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.fromCOO.2 $outer;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Row index out of range [0, ", "): ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numRows$5), BoxesRunTime.boxToInteger((int)this.$outer.prevRow$1.elem)}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                ++this.nnz$1.elem;
                                this.rowIndices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.prevRow$1.elem));
                                boxedUnit2 = this.values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)this.prevVal$1.elem));
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            this.prevRow$1.elem = i;
                            this.prevVal$1.elem = v;
                            while (this.prevCol$1.elem < j) {
                                this.colPtrs$1[this.prevCol$1.elem + 1] = this.nnz$1.elem;
                                ++this.prevCol$1.elem;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                this.numRows$5 = numRows$5;
                this.colPtrs$1 = colPtrs$1;
                this.rowIndices$1 = rowIndices$1;
                this.values$1 = values$1;
                this.nnz$1 = nnz$1;
                this.prevCol$1 = prevCol$1;
                this.prevRow$1 = prevRow$1;
                this.prevVal$1 = prevVal$1;
            }
        });
        return new SparseMatrix(numRows, numCols, colPtrs, (int[])rowIndices.result(), (double[])values.result());
    }

    public SparseMatrix speye(int n) {
        return new SparseMatrix(n, n, (int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), n).toArray(ClassTag$.MODULE$.Int()), (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).toArray(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.fill(n, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }, ClassTag$.MODULE$.Double()));
    }

    private SparseMatrix genRandMatrix(int numRows, int numCols, double density, Random rng) {
        SparseMatrix sparseMatrix;
        Predef$.MODULE$.require(numRows > 0, (Function0)new Serializable(numRows){
            public static final long serialVersionUID = 0L;
            private final int numRows$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numRows must be greater than 0 but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numRows$6)}));
            }
            {
                this.numRows$6 = numRows$6;
            }
        });
        Predef$.MODULE$.require(numCols > 0, (Function0)new Serializable(numCols){
            public static final long serialVersionUID = 0L;
            private final int numCols$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numCols must be greater than 0 but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numCols$6)}));
            }
            {
                this.numCols$6 = numCols$6;
            }
        });
        Predef$.MODULE$.require(density >= 0.0 && density <= 1.0, (Function0)new Serializable(density){
            public static final long serialVersionUID = 0L;
            private final double density$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"density must be a double in the range 0.0 <= d <= 1.0. Currently, density: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.density$1)}));
            }
            {
                this.density$1 = density$1;
            }
        });
        long size = (long)numRows * (long)numCols;
        double expected = (double)size * density;
        Predef$.MODULE$.assert(expected < (double)Integer.MAX_VALUE, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The expected number of nonzeros cannot be greater than Int.MaxValue.";
            }
        });
        int nnz = (int)package$.MODULE$.ceil(expected);
        if (density == 0.0) {
            sparseMatrix = new SparseMatrix(numRows, numCols, new int[numCols + 1], (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
        } else if (density == 1.0) {
            int[] colPtrs = (int[])Array$.MODULE$.tabulate(numCols + 1, (Function1)new Serializable(numRows){
                public static final long serialVersionUID = 0L;
                private final int numRows$6;

                public final int apply(int j) {
                    return this.apply$mcII$sp(j);
                }

                public int apply$mcII$sp(int j) {
                    return j * this.numRows$6;
                }
                {
                    this.numRows$6 = numRows$6;
                }
            }, ClassTag$.MODULE$.Int());
            int[] rowIndices = (int[])Array$.MODULE$.tabulate((int)size, (Function1)new Serializable(numRows){
                public static final long serialVersionUID = 0L;
                private final int numRows$6;

                public final int apply(int idx) {
                    return this.apply$mcII$sp(idx);
                }

                public int apply$mcII$sp(int idx) {
                    return idx % this.numRows$6;
                }
                {
                    this.numRows$6 = numRows$6;
                }
            }, ClassTag$.MODULE$.Int());
            sparseMatrix = new SparseMatrix(numRows, numCols, colPtrs, rowIndices, new double[numRows * numCols]);
        } else if (density < 0.34) {
            HashSet entries = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (entries.size() < nnz) {
                entries.$plus$eq((Object)new Tuple2.mcII.sp(rng.nextInt(numRows), rng.nextInt(numCols)));
            }
            sparseMatrix = this.fromCOO(numRows, numCols, (Iterable<Tuple3<Object, Object, Object>>)((Iterable)entries.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, Object, Object> apply(Tuple2<Object, Object> v) {
                    return new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)1.0));
                }
            }, HashSet$.MODULE$.canBuildFrom())));
        } else {
            long idx = 0L;
            int numSelected = 0;
            int[] colPtrs = new int[numCols + 1];
            int[] rowIndices = new int[nnz];
            for (int j = 0; j < numCols && numSelected < nnz; ++j) {
                int i = 0;
                while (i < numRows && numSelected < nnz) {
                    if (rng.nextDouble() < 1.0 * (double)(nnz - numSelected) / (double)(size - idx)) {
                        rowIndices[numSelected] = i;
                        ++numSelected;
                    }
                    ++i;
                    ++idx;
                }
                colPtrs[j + 1] = numSelected;
            }
            sparseMatrix = new SparseMatrix(numRows, numCols, colPtrs, rowIndices, new double[nnz]);
        }
        return sparseMatrix;
    }

    public SparseMatrix sprand(int numRows, int numCols, double density, Random rng) {
        SparseMatrix mat = this.genRandMatrix(numRows, numCols, density, rng);
        return mat.update((Function1)new Serializable(rng){
            public static final long serialVersionUID = 0L;
            private final Random rng$3;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return this.rng$3.nextDouble();
            }
            {
                this.rng$3 = rng$3;
            }
        });
    }

    public SparseMatrix sprandn(int numRows, int numCols, double density, Random rng) {
        SparseMatrix mat = this.genRandMatrix(numRows, numCols, density, rng);
        return mat.update((Function1)new Serializable(rng){
            public static final long serialVersionUID = 0L;
            private final Random rng$4;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return this.rng$4.nextGaussian();
            }
            {
                this.rng$4 = rng$4;
            }
        });
    }

    public SparseMatrix spdiag(Vector vector) {
        Vector vector2;
        block4: {
            SparseMatrix sparseMatrix;
            block3: {
                int n;
                block2: {
                    n = vector.size();
                    vector2 = vector;
                    if (!(vector2 instanceof SparseVector)) break block2;
                    SparseVector sparseVector = (SparseVector)vector2;
                    sparseMatrix = this.fromCOO(n, n, (Iterable<Tuple3<Object, Object, Object>>)((Iterable)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(sparseVector.indices()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(sparseVector.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple3<Object, Object, Object> apply(Tuple2<Object, Object> v) {
                            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)v._2$mcD$sp()));
                        }
                    }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                    break block3;
                }
                if (!(vector2 instanceof DenseVector)) break block4;
                DenseVector denseVector = (DenseVector)vector2;
                Tuple2[] entries = (Tuple2[])Predef$.MODULE$.doubleArrayOps(denseVector.values()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                Tuple2[] nnzVals = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])entries).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> v) {
                        return v._1$mcD$sp() != 0.0;
                    }
                });
                sparseMatrix = this.fromCOO(n, n, (Iterable<Tuple3<Object, Object, Object>>)((Iterable)Predef$.MODULE$.refArrayOps((Object[])nnzVals).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, Object, Object> apply(Tuple2<Object, Object> v) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)v._1$mcD$sp()));
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            }
            return sparseMatrix;
        }
        throw new MatchError((Object)vector2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparseMatrix$() {
        MODULE$ = this;
    }
}

