/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.linalg.CSCMatrix;
import java.util.Random;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseMatrix$;
import org.apache.spark.ml.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.CustomParallelizable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.mutable.ParArray;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Matrices$ {
    public static final Matrices$ MODULE$;

    static {
        new Matrices$();
    }

    public Matrix dense(int numRows, int numCols, double[] values) {
        return new DenseMatrix(numRows, numCols, values);
    }

    public Matrix sparse(int numRows, int numCols, int[] colPtrs, int[] rowIndices, double[] values) {
        return new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values);
    }

    public Matrix fromBreeze(breeze.linalg.Matrix<Object> breeze) {
        block7: {
            Matrix matrix;
            block6: {
                CSCMatrix cSCMatrix;
                breeze.linalg.Matrix<Object> matrix2;
                block5: {
                    matrix2 = breeze;
                    if (!(matrix2 instanceof breeze.linalg.DenseMatrix)) break block5;
                    breeze.linalg.DenseMatrix denseMatrix = (breeze.linalg.DenseMatrix)matrix2;
                    matrix = new DenseMatrix(denseMatrix.rows(), denseMatrix.cols(), denseMatrix.data$mcD$sp(), denseMatrix.isTranspose());
                    break block6;
                }
                if (!(matrix2 instanceof CSCMatrix)) break block7;
                CSCMatrix cSCMatrix2 = (CSCMatrix)matrix2;
                if (BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(cSCMatrix2.colPtrs()).last()) != cSCMatrix2.data$mcD$sp().length) {
                    CSCMatrix matCopy = cSCMatrix2.copy$mcD$sp();
                    matCopy.compact();
                    cSCMatrix = matCopy;
                } else {
                    cSCMatrix = cSCMatrix2;
                }
                CSCMatrix mat = cSCMatrix;
                matrix = new SparseMatrix(mat.rows(), mat.cols(), mat.colPtrs(), mat.rowIndices(), mat.data$mcD$sp());
            }
            return matrix;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support conversion from type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{breeze.getClass().getName()})));
    }

    public Matrix zeros(int numRows, int numCols) {
        return DenseMatrix$.MODULE$.zeros(numRows, numCols);
    }

    public Matrix ones(int numRows, int numCols) {
        return DenseMatrix$.MODULE$.ones(numRows, numCols);
    }

    public Matrix eye(int n) {
        return DenseMatrix$.MODULE$.eye(n);
    }

    public Matrix speye(int n) {
        return SparseMatrix$.MODULE$.speye(n);
    }

    public Matrix rand(int numRows, int numCols, Random rng) {
        return DenseMatrix$.MODULE$.rand(numRows, numCols, rng);
    }

    public Matrix sprand(int numRows, int numCols, double density, Random rng) {
        return SparseMatrix$.MODULE$.sprand(numRows, numCols, density, rng);
    }

    public Matrix randn(int numRows, int numCols, Random rng) {
        return DenseMatrix$.MODULE$.randn(numRows, numCols, rng);
    }

    public Matrix sprandn(int numRows, int numCols, double density, Random rng) {
        return SparseMatrix$.MODULE$.sprandn(numRows, numCols, density, rng);
    }

    public Matrix diag(Vector vector) {
        return DenseMatrix$.MODULE$.diag(vector);
    }

    public Matrix horzcat(Matrix[] matrices) {
        Matrix matrix;
        if (Predef$.MODULE$.refArrayOps((Object[])matrices).isEmpty()) {
            return new DenseMatrix(0, 0, (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
        }
        if (matrices.length == 1) {
            return matrices[0];
        }
        int numRows = matrices[0].numRows();
        BooleanRef hasSparse = BooleanRef.create((boolean)false);
        IntRef numCols = IntRef.create((int)0);
        Predef$.MODULE$.refArrayOps((Object[])matrices).foreach((Function1)new Serializable(numRows, hasSparse, numCols){
            public static final long serialVersionUID = 0L;
            private final int numRows$7;
            private final BooleanRef hasSparse$1;
            private final IntRef numCols$7;

            public final void apply(Matrix mat) {
                block4: {
                    block3: {
                        Matrix matrix;
                        block2: {
                            Predef$.MODULE$.require(this.numRows$7 == mat.numRows(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "The number of rows of the matrices in this sequence, don't match!";
                                }
                            });
                            matrix = mat;
                            if (!(matrix instanceof SparseMatrix)) break block2;
                            this.hasSparse$1.elem = true;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(matrix instanceof DenseMatrix)) break block4;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.numCols$7.elem += mat.numCols();
                    return;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Unsupported matrix format. Expected ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparseMatrix or DenseMatrix. Instead got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mat.getClass()}))).toString());
            }
            {
                this.numRows$7 = numRows$7;
                this.hasSparse$1 = hasSparse$1;
                this.numCols$7 = numCols$7;
            }
        });
        if (hasSparse.elem) {
            IntRef startCol = IntRef.create((int)0);
            Tuple3[] entries = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])matrices).flatMap((Function1)new Serializable(startCol){
                public static final long serialVersionUID = 0L;
                public final IntRef startCol$1;

                public final CustomParallelizable<Tuple3<Object, Object, Object>, ParArray<Tuple3<Object, Object, Object>>> apply(Matrix mat) {
                    Matrix matrix;
                    block4: {
                        ArrayBuffer arrayBuffer;
                        block3: {
                            int nCols;
                            block2: {
                                nCols = mat.numCols();
                                matrix = mat;
                                if (!(matrix instanceof SparseMatrix)) break block2;
                                SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                                Tuple3[] data = new Tuple3[sparseMatrix.values().length];
                                IntRef cnt = IntRef.create((int)0);
                                sparseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, data, cnt){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.12 $outer;
                                    private final Tuple3[] data$1;
                                    private final IntRef cnt$1;

                                    public final void apply(int i, int j, double v) {
                                        this.data$1[this.cnt$1.elem] = new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(j + this.$outer.startCol$1.elem)), (Object)BoxesRunTime.boxToDouble((double)v));
                                        ++this.cnt$1.elem;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.data$1 = data$1;
                                        this.cnt$1 = cnt$1;
                                    }
                                });
                                this.startCol$1.elem += nCols;
                                arrayBuffer = Predef$.MODULE$.refArrayOps((Object[])data);
                                break block3;
                            }
                            if (!(matrix instanceof DenseMatrix)) break block4;
                            DenseMatrix denseMatrix = (DenseMatrix)matrix;
                            ArrayBuffer data = new ArrayBuffer();
                            denseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, data){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.12 $outer;
                                private final ArrayBuffer data$2;

                                public final void apply(int i, int j, double v) {
                                    if (v != 0.0) {
                                        this.data$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(j + this.$outer.startCol$1.elem)), (Object)BoxesRunTime.boxToDouble((double)v))}));
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.data$2 = data$2;
                                }
                            });
                            this.startCol$1.elem += nCols;
                            arrayBuffer = data;
                        }
                        return arrayBuffer;
                    }
                    throw new MatchError((Object)matrix);
                }
                {
                    this.startCol$1 = startCol$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            matrix = SparseMatrix$.MODULE$.fromCOO(numRows, numCols.elem, (Iterable<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])entries));
        } else {
            matrix = new DenseMatrix(numRows, numCols.elem, (double[])Predef$.MODULE$.refArrayOps((Object[])matrices).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<Object> apply(Matrix x$3) {
                    return Predef$.MODULE$.doubleArrayOps(x$3.toArray());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        }
        return matrix;
    }

    public Matrix vertcat(Matrix[] matrices) {
        Matrix matrix;
        if (Predef$.MODULE$.refArrayOps((Object[])matrices).isEmpty()) {
            return new DenseMatrix(0, 0, (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
        }
        if (matrices.length == 1) {
            return matrices[0];
        }
        int numCols = matrices[0].numCols();
        BooleanRef hasSparse = BooleanRef.create((boolean)false);
        IntRef numRows = IntRef.create((int)0);
        Predef$.MODULE$.refArrayOps((Object[])matrices).foreach((Function1)new Serializable(numCols, hasSparse, numRows){
            public static final long serialVersionUID = 0L;
            private final int numCols$8;
            private final BooleanRef hasSparse$2;
            private final IntRef numRows$8;

            public final void apply(Matrix mat) {
                block4: {
                    block3: {
                        Matrix matrix;
                        block2: {
                            Predef$.MODULE$.require(this.numCols$8 == mat.numCols(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "The number of rows of the matrices in this sequence, don't match!";
                                }
                            });
                            matrix = mat;
                            if (!(matrix instanceof SparseMatrix)) break block2;
                            this.hasSparse$2.elem = true;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(matrix instanceof DenseMatrix)) break block4;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.numRows$8.elem += mat.numRows();
                    return;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Unsupported matrix format. Expected ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparseMatrix or DenseMatrix. Instead got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mat.getClass()}))).toString());
            }
            {
                this.numCols$8 = numCols$8;
                this.hasSparse$2 = hasSparse$2;
                this.numRows$8 = numRows$8;
            }
        });
        if (hasSparse.elem) {
            IntRef startRow = IntRef.create((int)0);
            Tuple3[] entries = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])matrices).flatMap((Function1)new Serializable(startRow){
                public static final long serialVersionUID = 0L;
                public final IntRef startRow$2;

                public final CustomParallelizable<Tuple3<Object, Object, Object>, ParArray<Tuple3<Object, Object, Object>>> apply(Matrix mat) {
                    Matrix matrix;
                    block4: {
                        ArrayBuffer arrayBuffer;
                        block3: {
                            int nRows;
                            block2: {
                                nRows = mat.numRows();
                                matrix = mat;
                                if (!(matrix instanceof SparseMatrix)) break block2;
                                SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                                Tuple3[] data = new Tuple3[sparseMatrix.values().length];
                                IntRef cnt = IntRef.create((int)0);
                                sparseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, data, cnt){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.13 $outer;
                                    private final Tuple3[] data$3;
                                    private final IntRef cnt$2;

                                    public final void apply(int i, int j, double v) {
                                        this.data$3[this.cnt$2.elem] = new Tuple3((Object)BoxesRunTime.boxToInteger((int)(i + this.$outer.startRow$2.elem)), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)v));
                                        ++this.cnt$2.elem;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.data$3 = data$3;
                                        this.cnt$2 = cnt$2;
                                    }
                                });
                                this.startRow$2.elem += nRows;
                                arrayBuffer = Predef$.MODULE$.refArrayOps((Object[])data);
                                break block3;
                            }
                            if (!(matrix instanceof DenseMatrix)) break block4;
                            DenseMatrix denseMatrix = (DenseMatrix)matrix;
                            ArrayBuffer data = new ArrayBuffer();
                            denseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, data){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.13 $outer;
                                private final ArrayBuffer data$4;

                                public final void apply(int i, int j, double v) {
                                    if (v != 0.0) {
                                        this.data$4.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)(i + this.$outer.startRow$2.elem)), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)v))}));
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.data$4 = data$4;
                                }
                            });
                            this.startRow$2.elem += nRows;
                            arrayBuffer = data;
                        }
                        return arrayBuffer;
                    }
                    throw new MatchError((Object)matrix);
                }
                {
                    this.startRow$2 = startRow$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            matrix = SparseMatrix$.MODULE$.fromCOO(numRows.elem, numCols, (Iterable<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])entries));
        } else {
            double[] allValues = new double[numRows.elem * numCols];
            IntRef startRow = IntRef.create((int)0);
            Predef$.MODULE$.refArrayOps((Object[])matrices).foreach((Function1)new Serializable(numRows, allValues, startRow){
                public static final long serialVersionUID = 0L;
                public final IntRef numRows$8;
                public final double[] allValues$1;
                public final IntRef startRow$1;

                public final void apply(Matrix mat) {
                    boolean j = false;
                    int nRows = mat.numRows();
                    mat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.vertcat.2 $outer;

                        public final void apply(int i, int j, double v) {
                            int indStart = j * this.$outer.numRows$8.elem + this.$outer.startRow$1.elem;
                            this.$outer.allValues$1[indStart + i] = v;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.startRow$1.elem += nRows;
                }
                {
                    this.numRows$8 = numRows$8;
                    this.allValues$1 = allValues$1;
                    this.startRow$1 = startRow$1;
                }
            });
            matrix = new DenseMatrix(numRows.elem, numCols, allValues);
        }
        return matrix;
    }

    private Matrices$() {
        MODULE$ = this;
    }
}

