/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import org.apache.spark.ml.SparkMLFunSuite;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.BLASSuite$;
import org.apache.spark.ml.linalg.BLASSuite$$anonfun$1$;
import org.apache.spark.ml.linalg.BLASSuite$$anonfun$3$;
import org.apache.spark.ml.linalg.BLASSuite$$anonfun$4$;
import org.apache.spark.ml.linalg.BLASSuite$$anonfun$5$;
import org.apache.spark.ml.linalg.BLASSuite$$anonfun$6$;
import org.apache.spark.ml.linalg.BLASSuite$$anonfun$7$;
import org.apache.spark.ml.linalg.BLASSuite$$anonfun$8$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u001b\tI!\tT!T'VLG/\u001a\u0006\u0003\u0007\u0011\ta\u0001\\5oC2<'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0003\n\u0005E!!aD*qCJ\\W\n\u0014$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001")
public class BLASSuite
extends SparkMLFunSuite {
    public BLASSuite() {
        this.test("copy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector sx = Vectors$.MODULE$.sparse(4, new int[]{0, 2}, new double[]{1.0, -2.0});
                Vector dx = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -2.0, 0.0}));
                Vector sy = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 3}, new double[]{2.0, 1.0, 1.0});
                double[] dy = new double[]{2.0, 1.0, 0.0, 1.0};
                Vector dy1 = Vectors$.MODULE$.dense((double[])dy.clone());
                BLAS$.MODULE$.copy(sx, dy1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dy1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(dx).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dy1).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dx).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Vector dy2 = Vectors$.MODULE$.dense((double[])dy.clone());
                BLAS$.MODULE$.copy(dx, dy2);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dy2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(dx).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dy2).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dx).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, sx, sy){
                    public static final long serialVersionUID = 0L;
                    private final Vector sx$1;
                    private final Vector sy$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        BLAS$.MODULE$.copy(this.sx$1, this.sy$1);
                    }
                    {
                        this.sx$1 = sx$1;
                        this.sy$1 = sy$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, dx, sy){
                    public static final long serialVersionUID = 0L;
                    private final Vector dx$1;
                    private final Vector sy$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        BLAS$.MODULE$.copy(this.dx$1, this.sy$1);
                    }
                    {
                        this.dx$1 = dx$1;
                        this.sy$1 = sy$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.withClue("vector sizes must match", (Function0)new Serializable(this, sx){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final Vector sx$1;

                    public final Exception apply() {
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$5 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.copy(this.$outer.sx$1, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sx$1 = sx$1;
                    }
                });
            }

            public /* synthetic */ BLASSuite org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("scal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double a = 0.1;
                Vector sx = Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{1.0, -2.0});
                Vector dx = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -2.0}));
                BLAS$.MODULE$.scal(a, sx);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(sx).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{0.1, -0.2})).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(sx).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(Vectors.sparse(3, scala.Array.apply(0, 2), scala.Array.apply(0.1, -0.2))).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                BLAS$.MODULE$.scal(a, dx);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dx).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.2}))).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dx).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(Vectors.dense(0.1, 0.0, -0.2)).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("axpy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double alpha = 0.1;
                Vector sx = Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{1.0, -2.0});
                Vector dx = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -2.0}));
                double[] dy = new double[]{2.0, 1.0, 0.0};
                Vector expected = Vectors$.MODULE$.dense(2.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, -0.2}));
                Vector dy1 = Vectors$.MODULE$.dense((double[])dy.clone());
                BLAS$.MODULE$.axpy(alpha, sx, dy1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dy1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dy1).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Vector dy2 = Vectors$.MODULE$.dense((double[])dy.clone());
                BLAS$.MODULE$.axpy(alpha, dx, dy2);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dy2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dy2).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Vector sy = Vectors$.MODULE$.sparse(4, new int[]{0, 1}, new double[]{2.0, 1.0});
                this.$outer.intercept((Function0)new Serializable(this, alpha, sx, sy){
                    public static final long serialVersionUID = 0L;
                    private final double alpha$1;
                    private final Vector sx$2;
                    private final Vector sy$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        BLAS$.MODULE$.axpy(this.alpha$1, this.sx$2, this.sy$2);
                    }
                    {
                        this.alpha$1 = alpha$1;
                        this.sx$2 = sx$2;
                        this.sy$2 = sy$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, alpha, dx, sy){
                    public static final long serialVersionUID = 0L;
                    private final double alpha$1;
                    private final Vector dx$2;
                    private final Vector sy$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        BLAS$.MODULE$.axpy(this.alpha$1, this.dx$2, this.sy$2);
                    }
                    {
                        this.alpha$1 = alpha$1;
                        this.dx$2 = dx$2;
                        this.sy$2 = sy$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.withClue("vector sizes must match", (Function0)new Serializable(this, alpha, sx){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    public final double alpha$1;
                    public final Vector sx$2;

                    public final Exception apply() {
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$6 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.axpy(this.$outer.alpha$1, this.$outer.sx$2, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.alpha$1 = alpha$1;
                        this.sx$2 = sx$2;
                    }
                });
            }

            public /* synthetic */ BLASSuite org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("dot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector sx = Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{1.0, -2.0});
                Vector dx = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -2.0}));
                Vector sy = Vectors$.MODULE$.sparse(3, new int[]{0, 1}, new double[]{2.0, 1.0});
                Vector dy = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(sx, sy)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(2.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(sx, sy)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(2.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(sy, sx)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(2.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(sy, sx)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(2.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(sx, dy)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(2.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(sx, dy)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(2.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(dy, sx)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(2.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(dy, sx)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(2.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(dx, dy)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(2.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(dx, dy)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(2.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(dy, dx)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(2.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(dy, dx)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(2.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(sx, sx)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(5.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(sx, sx)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(5.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(dx, dx)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(5.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(dx, dx)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(5.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(sx, dx)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(5.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(sx, dx)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(5.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(dx, sx)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(5.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(dx, sx)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(5.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Vector sx1 = Vectors$.MODULE$.sparse(10, new int[]{0, 3, 5, 7, 8}, new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
                Vector sx2 = Vectors$.MODULE$.sparse(10, new int[]{1, 3, 6, 7, 9}, new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(sx1, sx2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(20.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(sx1, sx2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(20.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BLAS$.MODULE$.dot(sx2, sx1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(20.0).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.ml.linalg.BLAS.dot(sx2, sx1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(20.0).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                this.$outer.withClue("vector sizes must match", (Function0)new Serializable(this, sx){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    public final Vector sx$3;

                    public final Exception apply() {
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$7 $outer;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return BLAS$.MODULE$.dot(this.$outer.sx$3, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sx$3 = sx$3;
                    }
                });
            }

            public /* synthetic */ BLASSuite org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("spr", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double alpha = 0.1;
                DenseVector x = new DenseVector(new double[]{1.0, 2.0, 2.1, 4.0});
                DenseVector U = new DenseVector(new double[]{1.0, 2.0, 2.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0});
                DenseVector expected = new DenseVector(new double[]{1.1, 2.2, 2.4, 3.21, 3.42, 3.441, 4.4, 4.8, 4.84, 5.6});
                BLAS$.MODULE$.spr(alpha, (Vector)x, U);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)U).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(U).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-9))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DenseVector matrix33 = new DenseVector(new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
                this.$outer.withClue("Size of vector must match the rank of matrix", (Function0)new Serializable(this, alpha, x, matrix33){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    public final double alpha$2;
                    public final DenseVector x$1;
                    public final DenseVector matrix33$1;

                    public final Exception apply() {
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$8 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.spr(this.$outer.alpha$2, (Vector)this.$outer.x$1, this.$outer.matrix33$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.alpha$2 = alpha$2;
                        this.x$1 = x$1;
                        this.matrix33$1 = matrix33$1;
                    }
                });
                SparseVector sv = new SparseVector(4, new int[]{0, 3}, new double[]{1.0, 2.0});
                DenseVector U2 = new DenseVector(new double[]{1.0, 2.0, 2.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0});
                BLAS$.MODULE$.spr(0.1, (Vector)sv, U2);
                DenseVector expectedSparse = new DenseVector(new double[]{1.1, 2.0, 2.0, 3.0, 3.0, 3.0, 4.2, 4.0, 4.0, 4.4});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)U2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expectedSparse).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(U2).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedSparse).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ BLASSuite org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("syr", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix dA = new DenseMatrix(4, 4, new double[]{0.0, 1.2, 2.2, 3.1, 1.2, 3.2, 5.3, 4.6, 2.2, 5.3, 1.8, 3.0, 3.1, 4.6, 3.0, 0.8});
                DenseVector x = new DenseVector(new double[]{0.0, 2.7, 3.5, 2.1});
                double alpha = 0.15;
                DenseMatrix expected = new DenseMatrix(4, 4, new double[]{0.0, 1.2, 2.2, 3.1, 1.2, 4.2935, 6.7175, 5.4505, 2.2, 6.7175, 3.6375, 4.1025, 3.1, 5.4505, 4.1025, 1.4615});
                BLAS$.MODULE$.syr(alpha, (Vector)x, dA);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)dA).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(dA).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DenseMatrix dB = new DenseMatrix(3, 4, new double[]{0.0, 1.2, 2.2, 3.1, 1.2, 3.2, 5.3, 4.6, 2.2, 5.3, 1.8, 3.0});
                this.$outer.withClue("Matrix A must be a symmetric Matrix", (Function0)new Serializable(this, x, alpha, dB){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final DenseVector x$2;
                    public final double alpha$3;
                    public final DenseMatrix dB$1;

                    public final Exception apply() {
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$9 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.syr(this.$outer.alpha$3, (Vector)this.$outer.x$2, this.$outer.dB$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$2 = x$2;
                        this.alpha$3 = alpha$3;
                        this.dB$1 = dB$1;
                    }
                });
                DenseMatrix dC = new DenseMatrix(3, 3, new double[]{0.0, 1.2, 2.2, 1.2, 3.2, 5.3, 2.2, 5.3, 1.8});
                this.$outer.withClue("Size of vector must match the rank of matrix", (Function0)new Serializable(this, x, alpha, dC){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final DenseVector x$2;
                    public final double alpha$3;
                    public final DenseMatrix dC$1;

                    public final Exception apply() {
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$10 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.syr(this.$outer.alpha$3, (Vector)this.$outer.x$2, this.$outer.dC$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$2 = x$2;
                        this.alpha$3 = alpha$3;
                        this.dC$1 = dC$1;
                    }
                });
                DenseVector y = new DenseVector(new double[]{0.0, 2.7, 3.5, 2.1, 1.5});
                this.$outer.withClue("Size of vector must match the rank of matrix", (Function0)new Serializable(this, dA, alpha, y){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final DenseMatrix dA$1;
                    public final double alpha$3;
                    public final DenseVector y$1;

                    public final Exception apply() {
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$11 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.syr(this.$outer.alpha$3, (Vector)this.$outer.y$1, this.$outer.dA$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dA$1 = dA$1;
                        this.alpha$3 = alpha$3;
                        this.y$1 = y$1;
                    }
                });
                SparseVector xSparse = new SparseVector(4, new int[]{0, 2, 3}, new double[]{1.0, 3.0, 4.0});
                DenseMatrix dD = new DenseMatrix(4, 4, new double[]{0.0, 1.2, 2.2, 3.1, 1.2, 3.2, 5.3, 4.6, 2.2, 5.3, 1.8, 3.0, 3.1, 4.6, 3.0, 0.8});
                BLAS$.MODULE$.syr(0.1, (Vector)xSparse, dD);
                DenseMatrix expectedSparse = new DenseMatrix(4, 4, new double[]{0.1, 1.2, 2.5, 3.5, 1.2, 3.2, 5.3, 4.6, 2.5, 5.3, 2.7, 4.2, 3.5, 4.6, 4.2, 2.4});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)dD).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expectedSparse).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(dD).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expectedSparse).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ BLASSuite org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("gemm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix dA = new DenseMatrix(4, 3, new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 3.0});
                SparseMatrix sA = new SparseMatrix(4, 3, new int[]{0, 1, 3, 4}, new int[]{1, 0, 2, 3}, new double[]{1.0, 2.0, 1.0, 3.0});
                DenseMatrix B = new DenseMatrix(3, 2, new double[]{1.0, 0.0, 0.0, 0.0, 2.0, 1.0});
                DenseMatrix expected = new DenseMatrix(4, 2, new double[]{0.0, 1.0, 0.0, 0.0, 4.0, 0.0, 2.0, 3.0});
                DenseMatrix BTman = new DenseMatrix(2, 3, new double[]{1.0, 0.0, 0.0, 2.0, 0.0, 1.0});
                DenseMatrix BT = B.transpose();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)dA.multiply(B)).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(dA.multiply(B)).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)sA.multiply(B)).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(sA.multiply(B)).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                DenseMatrix C1 = new DenseMatrix(4, 2, new double[]{1.0, 0.0, 2.0, 1.0, 0.0, 0.0, 1.0, 0.0});
                DenseMatrix C2 = C1.copy();
                DenseMatrix C3 = C1.copy();
                DenseMatrix C4 = C1.copy();
                DenseMatrix C5 = C1.copy();
                DenseMatrix C6 = C1.copy();
                DenseMatrix C7 = C1.copy();
                DenseMatrix C8 = C1.copy();
                DenseMatrix C9 = C1.copy();
                DenseMatrix C10 = C1.copy();
                DenseMatrix C11 = C1.copy();
                DenseMatrix C12 = C1.copy();
                DenseMatrix C13 = C1.copy();
                DenseMatrix C14 = C1.copy();
                DenseMatrix C15 = C1.copy();
                DenseMatrix C16 = C1.copy();
                DenseMatrix C17 = C1.copy();
                DenseMatrix expected2 = new DenseMatrix(4, 2, new double[]{2.0, 1.0, 4.0, 2.0, 4.0, 0.0, 4.0, 3.0});
                DenseMatrix expected3 = new DenseMatrix(4, 2, new double[]{2.0, 2.0, 4.0, 2.0, 8.0, 0.0, 6.0, 6.0});
                DenseMatrix expected4 = new DenseMatrix(4, 2, new double[]{5.0, 0.0, 10.0, 5.0, 0.0, 0.0, 5.0, 0.0});
                DenseMatrix expected5 = C1.copy();
                BLAS$.MODULE$.gemm(1.0, (Matrix)dA, B, 2.0, C1);
                BLAS$.MODULE$.gemm(1.0, (Matrix)sA, B, 2.0, C2);
                BLAS$.MODULE$.gemm(2.0, (Matrix)dA, B, 2.0, C3);
                BLAS$.MODULE$.gemm(2.0, (Matrix)sA, B, 2.0, C4);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C1).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C1).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C2).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C2).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C3).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C3).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C4).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C4).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                BLAS$.MODULE$.gemm(1.0, (Matrix)dA, B, 0.0, C17);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C17).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C17).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                BLAS$.MODULE$.gemm(1.0, (Matrix)sA, B, 0.0, C17);
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C17).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C17).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                this.$outer.withClue("columns of A don't match the rows of B", (Function0)new Serializable(this, dA, B, C1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    public final DenseMatrix dA$2;
                    public final DenseMatrix B$1;
                    public final DenseMatrix C1$1;

                    public final Exception apply() {
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$7$$anonfun$apply$mcV$sp$12 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.gemm(1.0, (Matrix)this.$outer.dA$2.transpose(), this.$outer.B$1, 2.0, this.$outer.C1$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dA$2 = dA$2;
                        this.B$1 = B$1;
                        this.C1$1 = C1$1;
                    }
                });
                DenseMatrix dATman = new DenseMatrix(3, 4, new double[]{0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 3.0});
                SparseMatrix sATman = new SparseMatrix(3, 4, new int[]{0, 1, 2, 3, 4}, new int[]{1, 0, 1, 2}, new double[]{2.0, 1.0, 1.0, 3.0});
                DenseMatrix dATT = dATman.transpose();
                SparseMatrix sATT = sATman.transpose();
                DenseMatrix BTT = BTman.transpose();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)dATT.multiply(B)).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(dATT.multiply(B)).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)sATT.multiply(B)).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(sATT.multiply(B)).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)dATT.multiply(BTT)).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(dATT.multiply(BTT)).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)sATT.multiply(BTT)).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(sATT.multiply(BTT)).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                BLAS$.MODULE$.gemm(1.0, (Matrix)dATT, BTT, 2.0, C5);
                BLAS$.MODULE$.gemm(1.0, (Matrix)sATT, BTT, 2.0, C6);
                BLAS$.MODULE$.gemm(2.0, (Matrix)dATT, BTT, 2.0, C7);
                BLAS$.MODULE$.gemm(2.0, (Matrix)sATT, BTT, 2.0, C8);
                BLAS$.MODULE$.gemm(1.0, (Matrix)dA, BTT, 2.0, C9);
                BLAS$.MODULE$.gemm(1.0, (Matrix)sA, BTT, 2.0, C10);
                BLAS$.MODULE$.gemm(2.0, (Matrix)dA, BTT, 2.0, C11);
                BLAS$.MODULE$.gemm(2.0, (Matrix)sA, BTT, 2.0, C12);
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C5).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C5).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C6).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C6).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C7).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C7).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C8).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C8).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C9).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C9).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C10).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C10).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C11).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C11).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C12).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C12).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                BLAS$.MODULE$.gemm(0.0, (Matrix)dA, B, 5.0, C13);
                BLAS$.MODULE$.gemm(0.0, (Matrix)sA, B, 5.0, C14);
                BLAS$.MODULE$.gemm(0.0, (Matrix)dA, B, 1.0, C15);
                BLAS$.MODULE$.gemm(0.0, (Matrix)sA, B, 1.0, C16);
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C13).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected4).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C13).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected4).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C14).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected4).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C14).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected4).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"");
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C15).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected5).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C15).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected5).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"");
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)C16).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)expected5).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(C16).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(expected5).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"");
            }

            public /* synthetic */ BLASSuite org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("gemv", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix dA = new DenseMatrix(4, 3, new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 3.0});
                SparseMatrix sA = new SparseMatrix(4, 3, new int[]{0, 1, 3, 4}, new int[]{1, 0, 2, 3}, new double[]{1.0, 2.0, 1.0, 3.0});
                DenseMatrix dA2 = new DenseMatrix(4, 3, new double[]{0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 3.0}, true);
                SparseMatrix sA2 = new SparseMatrix(4, 3, new int[]{0, 1, 2, 3, 4}, new int[]{1, 0, 1, 2}, new double[]{2.0, 1.0, 1.0, 3.0}, true);
                DenseVector dx = new DenseVector(new double[]{1.0, 2.0, 3.0});
                SparseVector sx = dx.toSparse();
                DenseVector expected = new DenseVector(new double[]{4.0, 1.0, 2.0, 9.0});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)dA.multiply(dx)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dA.multiply(dx)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)sA.multiply(dx)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(sA.multiply(dx)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)dA.multiply((Vector)sx)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dA.multiply(sx)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)sA.multiply((Vector)sx)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(sA.multiply(sx)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                DenseVector y1 = new DenseVector(new double[]{1.0, 3.0, 1.0, 0.0});
                DenseVector y2 = y1.copy();
                DenseVector y3 = y1.copy();
                DenseVector y4 = y1.copy();
                DenseVector y5 = y1.copy();
                DenseVector y6 = y1.copy();
                DenseVector y7 = y1.copy();
                DenseVector y8 = y1.copy();
                DenseVector y9 = y1.copy();
                DenseVector y10 = y1.copy();
                DenseVector y11 = y1.copy();
                DenseVector y12 = y1.copy();
                DenseVector y13 = y1.copy();
                DenseVector y14 = y1.copy();
                DenseVector y15 = y1.copy();
                DenseVector y16 = y1.copy();
                DenseVector expected2 = new DenseVector(new double[]{6.0, 7.0, 4.0, 9.0});
                DenseVector expected3 = new DenseVector(new double[]{10.0, 8.0, 6.0, 18.0});
                BLAS$.MODULE$.gemv(1.0, (Matrix)dA, (Vector)dx, 2.0, y1);
                BLAS$.MODULE$.gemv(1.0, (Matrix)sA, (Vector)dx, 2.0, y2);
                BLAS$.MODULE$.gemv(1.0, (Matrix)dA, (Vector)sx, 2.0, y3);
                BLAS$.MODULE$.gemv(1.0, (Matrix)sA, (Vector)sx, 2.0, y4);
                BLAS$.MODULE$.gemv(1.0, (Matrix)dA2, (Vector)dx, 2.0, y5);
                BLAS$.MODULE$.gemv(1.0, (Matrix)sA2, (Vector)dx, 2.0, y6);
                BLAS$.MODULE$.gemv(1.0, (Matrix)dA2, (Vector)sx, 2.0, y7);
                BLAS$.MODULE$.gemv(1.0, (Matrix)sA2, (Vector)sx, 2.0, y8);
                BLAS$.MODULE$.gemv(2.0, (Matrix)dA, (Vector)dx, 2.0, y9);
                BLAS$.MODULE$.gemv(2.0, (Matrix)sA, (Vector)dx, 2.0, y10);
                BLAS$.MODULE$.gemv(2.0, (Matrix)dA, (Vector)sx, 2.0, y11);
                BLAS$.MODULE$.gemv(2.0, (Matrix)sA, (Vector)sx, 2.0, y12);
                BLAS$.MODULE$.gemv(2.0, (Matrix)dA2, (Vector)dx, 2.0, y13);
                BLAS$.MODULE$.gemv(2.0, (Matrix)sA2, (Vector)dx, 2.0, y14);
                BLAS$.MODULE$.gemv(2.0, (Matrix)dA2, (Vector)sx, 2.0, y15);
                BLAS$.MODULE$.gemv(2.0, (Matrix)sA2, (Vector)sx, 2.0, y16);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y1).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y2).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y3).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y3).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y4).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y4).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y5).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y5).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y6).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y6).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y7).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y7).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y8).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y8).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y9).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y9).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y10).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y10).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y11).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y11).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y12).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y12).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y13).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y13).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y14).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y14).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y15).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y15).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y16).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y16).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                this.$outer.withClue("columns of A don't match the rows of B", (Function0)new Serializable(this, dA, sA, dx, sx, y1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    public final DenseMatrix dA$3;
                    public final SparseMatrix sA$1;
                    public final DenseVector dx$3;
                    public final SparseVector sx$4;
                    public final DenseVector y1$1;

                    public final Exception apply() {
                        this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$13 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.gemv(1.0, (Matrix)this.$outer.dA$3.transpose(), (Vector)this.$outer.dx$3, 2.0, this.$outer.y1$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                        this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$13 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.gemv(1.0, (Matrix)this.$outer.sA$1.transpose(), (Vector)this.$outer.dx$3, 2.0, this.$outer.y1$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                        this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$13 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.gemv(1.0, (Matrix)this.$outer.dA$3.transpose(), (Vector)this.$outer.sx$4, 2.0, this.$outer.y1$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                        return (Exception)this.$outer.org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$13 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                BLAS$.MODULE$.gemv(1.0, (Matrix)this.$outer.sA$1.transpose(), (Vector)this.$outer.sx$4, 2.0, this.$outer.y1$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(Exception.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dA$3 = dA$3;
                        this.sA$1 = sA$1;
                        this.dx$3 = dx$3;
                        this.sx$4 = sx$4;
                        this.y1$1 = y1$1;
                    }
                });
                DenseVector y17 = new DenseVector(new double[]{0.0, 0.0});
                DenseVector y18 = y17.copy();
                SparseMatrix sA3 = new SparseMatrix(3, 2, new int[]{0, 2, 4}, new int[]{1, 2, 0, 1}, new double[]{2.0, 1.0, 1.0, 2.0}).transpose();
                SparseMatrix sA4 = new SparseMatrix(2, 3, new int[]{0, 1, 3, 4}, new int[]{1, 0, 1, 0}, new double[]{1.0, 2.0, 2.0, 1.0});
                SparseVector sx3 = new SparseVector(3, new int[]{1, 2}, new double[]{2.0, 1.0});
                DenseVector expected4 = new DenseVector(new double[]{5.0, 4.0});
                BLAS$.MODULE$.gemv(1.0, (Matrix)sA3, (Vector)sx3, 0.0, y17);
                BLAS$.MODULE$.gemv(1.0, (Matrix)sA4, (Vector)sx3, 0.0, y18);
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y17).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected4).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y17).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected4).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y18).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected4).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y18).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected4).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"");
                DenseMatrix dAT = new DenseMatrix(3, 4, new double[]{0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 3.0});
                SparseMatrix sAT = new SparseMatrix(3, 4, new int[]{0, 1, 2, 3, 4}, new int[]{1, 0, 1, 2}, new double[]{2.0, 1.0, 1.0, 3.0});
                DenseMatrix dATT = dAT.transpose();
                SparseMatrix sATT = sAT.transpose();
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)dATT.multiply(dx)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dATT.multiply(dx)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"");
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)sATT.multiply(dx)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(sATT.multiply(dx)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"");
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)dATT.multiply((Vector)sx)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(dATT.multiply(sx)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"");
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)sATT.multiply((Vector)sx)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(sATT.multiply(sx)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"");
            }

            public /* synthetic */ BLASSuite org$apache$spark$ml$linalg$BLASSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("spmv", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BLASSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector A = new DenseVector(new double[]{3.0, -2.0, -8.0, 2.0, 4.0, -3.0, -4.0, 7.0, -3.0, 0.0});
                DenseVector x = new DenseVector(new double[]{5.0, 2.0, -1.0, -9.0});
                int n = 4;
                DenseVector y1 = new DenseVector(new double[]{-3.0, 6.0, -8.0, -3.0});
                DenseVector y2 = y1.copy();
                DenseVector y3 = y1.copy();
                DenseVector y4 = y1.copy();
                DenseVector y5 = y1.copy();
                DenseVector y6 = y1.copy();
                DenseVector y7 = y1.copy();
                DenseVector expected1 = new DenseVector(new double[]{42.0, -87.0, 40.0, -6.0});
                DenseVector expected2 = new DenseVector(new double[]{19.5, -40.5, 16.0, -4.5});
                DenseVector expected3 = new DenseVector(new double[]{-25.5, 52.5, -32.0, -1.5});
                DenseVector expected4 = new DenseVector(new double[]{-3.0, 6.0, -8.0, -3.0});
                DenseVector expected5 = new DenseVector(new double[]{43.5, -90.0, 44.0, -4.5});
                DenseVector expected6 = new DenseVector(new double[]{46.5, -96.0, 52.0, -1.5});
                DenseVector expected7 = new DenseVector(new double[]{45.0, -93.0, 48.0, -3.0});
                BLAS$.MODULE$.dspmv(n, 1.0, A, x, 1.0, y1);
                BLAS$.MODULE$.dspmv(n, 0.5, A, x, 1.0, y2);
                BLAS$.MODULE$.dspmv(n, -0.5, A, x, 1.0, y3);
                BLAS$.MODULE$.dspmv(n, 0.0, A, x, 1.0, y4);
                BLAS$.MODULE$.dspmv(n, 1.0, A, x, 0.5, y5);
                BLAS$.MODULE$.dspmv(n, 1.0, A, x, -0.5, y6);
                BLAS$.MODULE$.dspmv(n, 1.0, A, x, 0.0, y7);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected1).absTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y1).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected1).absTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected2).absTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y2).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected2).absTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y3).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected3).absTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y3).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected3).absTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y4).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected4).absTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y4).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected4).absTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y5).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected5).absTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y5).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected5).absTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y6).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected6).absTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y6).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected6).absTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)y7).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected7).absTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y7).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected7).absTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

