/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.linalg.DenseVector;
import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import org.apache.spark.ml.SparkMLFunSuite;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001b\tY\"I]3fu\u00164Vm\u0019;pe\u000e{gN^3sg&|gnU;ji\u0016T!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005!\u0011BA\t\u0005\u0005=\u0019\u0006/\u0019:l\u001b23UO\\*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002A1A\u0005\u0002e\t1!\u0019:s+\u0005Q\u0002cA\u000e\u001fA5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\u0007\t>,(\r\\3\t\r\u0011\u0002\u0001\u0015!\u0003\u001b\u0003\u0011\t'O\u001d\u0011\t\u000f\u0019\u0002!\u0019!C\u0001O\u0005\ta.F\u0001)!\tY\u0012&\u0003\u0002+9\t\u0019\u0011J\u001c;\t\r1\u0002\u0001\u0015!\u0003)\u0003\tq\u0007\u0005C\u0004/\u0001\t\u0007I\u0011A\u0018\u0002\u000f%tG-[2fgV\t\u0001\u0007E\u0002\u001c=!BaA\r\u0001!\u0002\u0013\u0001\u0014\u0001C5oI&\u001cWm\u001d\u0011\t\u000fQ\u0002!\u0019!C\u00013\u00051a/\u00197vKNDaA\u000e\u0001!\u0002\u0013Q\u0012a\u0002<bYV,7\u000f\t")
public class BreezeVectorConversionSuite
extends SparkMLFunSuite {
    private final double[] arr = new double[]{0.1, 0.2, 0.3, 0.4};
    private final int n;
    private final int[] indices = new int[]{0, 3, 5, 10, 13};
    private final double[] values = new double[]{0.1, 0.5, 0.3, -0.8, -1.0};

    public double[] arr() {
        return this.arr;
    }

    public int n() {
        return this.n;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public BreezeVectorConversionSuite() {
        this.n = 20;
        this.test("dense to breeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector vec = Vectors$.MODULE$.dense(this.$outer.arr());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(vec.asBreeze());
                DenseVector.mcD.sp $org_scalatest_assert_macro_right = new DenseVector.mcD.sp(this.$outer.arr());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse to breeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector vec = Vectors$.MODULE$.sparse(this.$outer.n(), this.$outer.indices(), this.$outer.values());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(vec.asBreeze());
                SparseVector.mcD.sp $org_scalatest_assert_macro_right = new SparseVector.mcD.sp(this.$outer.indices(), this.$outer.values(), this.$outer.n(), (Zero)Zero.DoubleZero$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("dense breeze to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector.mcD.sp breeze = new DenseVector.mcD.sp(this.$outer.arr());
                DenseVector vec = (DenseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.arr().length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double[] $org_scalatest_assert_macro_left2 = vec.values();
                double[] $org_scalatest_assert_macro_right2 = this.$outer.arr();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should not copy data");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse breeze to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector.mcD.sp breeze = new SparseVector.mcD.sp(this.$outer.indices(), this.$outer.values(), this.$outer.n(), (Zero)Zero.DoubleZero$.MODULE$);
                SparseVector vec = (SparseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int[] $org_scalatest_assert_macro_left2 = vec.indices();
                int[] $org_scalatest_assert_macro_right2 = this.$outer.indices();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should not copy data");
                double[] $org_scalatest_assert_macro_left3 = vec.values();
                double[] $org_scalatest_assert_macro_right3 = this.$outer.values();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse breeze with partially-used arrays to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int activeSize = 3;
                SparseVector.mcD.sp breeze = new SparseVector.mcD.sp(this.$outer.indices(), this.$outer.values(), activeSize, this.$outer.n(), (Zero)Zero.DoubleZero$.MODULE$);
                SparseVector vec = (SparseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(vec.indices());
                int[] $org_scalatest_assert_macro_right2 = (int[])Predef$.MODULE$.intArrayOps(this.$outer.indices()).slice(0, activeSize);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(vec.values());
                double[] $org_scalatest_assert_macro_right3 = (double[])Predef$.MODULE$.doubleArrayOps(this.$outer.values()).slice(0, activeSize);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

