/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat.distribution;

import org.apache.spark.ml.SparkMLFunSuite;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e1A!\u0001\u0002\u0001\u001f\tIR*\u001e7uSZ\f'/[1uK\u001e\u000bWo]:jC:\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002\u0006\r\u0005!1\u000f^1u\u0015\t9\u0001\"\u0001\u0002nY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u00051\u0011BA\n\u0007\u0005=\u0019\u0006/\u0019:l\u001b23UO\\*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0001")
public class MultivariateGaussianSuite
extends SparkMLFunSuite {
    public MultivariateGaussianSuite() {
        this.test("univariate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultivariateGaussianSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector x1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                Vector x2 = Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                Vector mu = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                Matrix sigma1 = Matrices$.MODULE$.dense(1, 1, new double[]{1.0});
                MultivariateGaussian dist1 = new MultivariateGaussian(mu, sigma1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.39894).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.39894).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.12952).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.12952).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Matrix sigma2 = Matrices$.MODULE$.dense(1, 1, new double[]{4.0});
                MultivariateGaussian dist2 = new MultivariateGaussian(mu, sigma2);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.19947).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.19947).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.15057).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.15057).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multivariate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultivariateGaussianSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector x1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
                Vector x2 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
                Vector mu = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
                Matrix sigma1 = Matrices$.MODULE$.dense(2, 2, new double[]{1.0, 0.0, 0.0, 1.0});
                MultivariateGaussian dist1 = new MultivariateGaussian(mu, sigma1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.15915).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.15915).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.05855).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.05855).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Matrix sigma2 = Matrices$.MODULE$.dense(2, 2, new double[]{4.0, -1.0, -1.0, 2.0});
                MultivariateGaussian dist2 = new MultivariateGaussian(mu, sigma2);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.060155).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.060155).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.033971).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.033971).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multivariate degenerate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultivariateGaussianSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector x1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
                Vector x2 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
                Vector mu = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
                Matrix sigma = Matrices$.MODULE$.dense(2, 2, new double[]{1.0, 1.0, 1.0, 1.0});
                MultivariateGaussian dist = new MultivariateGaussian(mu, sigma);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.11254).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.11254).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.068259).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.068259).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-11302", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultivariateGaussianSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector x = Vectors$.MODULE$.dense(629.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{640.0, 1.7188, 618.19}));
                Vector mu = Vectors$.MODULE$.dense(1055.3910505836575, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1070.489299610895, 1.39020554474708, 1040.5907503867697}));
                Matrix sigma = Matrices$.MODULE$.dense(4, 4, new double[]{166769.00466698944, 169336.6705268059, 12.820670788921873, 164243.93314092053, 169336.6705268059, 172041.5670061245, 21.62590020524533, 166678.01075856484, 12.820670788921873, 21.62590020524533, 0.872524191943962, 4.283255814732373, 164243.93314092053, 166678.01075856484, 4.283255814732373, 161848.9196719207});
                MultivariateGaussian dist = new MultivariateGaussian(mu, sigma);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist.pdf(x)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(7.154782224045512E-5).absTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist.pdf(x)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(7.154782224045512E-5).absTol(1.0E-9))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

