/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.Vector;
import scala.Function3;
import scala.Serializable;
import scala.collection.Iterator;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public abstract class Matrix$class {
    public static boolean isColMajor(Matrix $this) {
        return !$this.isTransposed();
    }

    public static boolean isRowMajor(Matrix $this) {
        return $this.isTransposed();
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toArray(Matrix $this) {
        void var1_1;
        double[] newArray = new double[$this.numRows() * $this.numCols()];
        $this.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable($this, newArray){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Matrix $outer;
            private final double[] newArray$1;

            public final void apply(int i, int j, double v) {
                this.newArray$1[j * this.$outer.numRows() + i] = v;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newArray$1 = newArray$1;
            }
        });
        return var1_1;
    }

    public static Iterator rowIter(Matrix $this) {
        return $this.transpose().colIter();
    }

    /*
     * WARNING - void declaration
     */
    public static DenseMatrix multiply(Matrix $this, DenseMatrix y) {
        void var2_2;
        DenseMatrix C = DenseMatrix$.MODULE$.zeros($this.numRows(), y.numCols());
        BLAS$.MODULE$.gemm(1.0, $this, y, 0.0, C);
        return var2_2;
    }

    public static DenseVector multiply(Matrix $this, DenseVector y) {
        return $this.multiply((Vector)y);
    }

    /*
     * WARNING - void declaration
     */
    public static DenseVector multiply(Matrix $this, Vector y) {
        void var2_2;
        DenseVector output = new DenseVector(new double[$this.numRows()]);
        BLAS$.MODULE$.gemv(1.0, $this, y, 0.0, output);
        return var2_2;
    }

    public static String toString(Matrix $this) {
        return $this.asBreeze().toString();
    }

    public static String toString(Matrix $this, int maxLines, int maxLineWidth) {
        return $this.asBreeze().toString(maxLines, maxLineWidth);
    }

    public static SparseMatrix toSparseColMajor(Matrix $this) {
        return $this.toSparseMatrix(true);
    }

    public static SparseMatrix toSparseRowMajor(Matrix $this) {
        return $this.toSparseMatrix(false);
    }

    public static SparseMatrix toSparse(Matrix $this) {
        return $this.toSparseMatrix($this.isColMajor());
    }

    public static DenseMatrix toDense(Matrix $this) {
        return $this.toDenseMatrix($this.isColMajor());
    }

    public static DenseMatrix toDenseRowMajor(Matrix $this) {
        return $this.toDenseMatrix(false);
    }

    public static DenseMatrix toDenseColMajor(Matrix $this) {
        return $this.toDenseMatrix(true);
    }

    public static Matrix compressedColMajor(Matrix $this) {
        return $this.getDenseSizeInBytes() <= $this.getSparseSizeInBytes(true) ? $this.toDenseColMajor() : $this.toSparseColMajor();
    }

    public static Matrix compressedRowMajor(Matrix $this) {
        return $this.getDenseSizeInBytes() <= $this.getSparseSizeInBytes(false) ? $this.toDenseRowMajor() : $this.toSparseRowMajor();
    }

    public static Matrix compressed(Matrix $this) {
        long cscSize = $this.getSparseSizeInBytes(true);
        long csrSize = $this.getSparseSizeInBytes(false);
        return $this.getDenseSizeInBytes() <= package$.MODULE$.min(cscSize, csrSize) ? $this.toDense() : (cscSize <= csrSize ? $this.toSparseColMajor() : $this.toSparseRowMajor());
    }

    public static long getDenseSizeInBytes(Matrix $this) {
        return Matrices$.MODULE$.getDenseSize($this.numCols(), $this.numRows());
    }

    public static long getSparseSizeInBytes(Matrix $this, boolean colMajor) {
        int nnz = $this.numNonzeros();
        long numPtrs = colMajor ? (long)$this.numCols() + 1L : (long)$this.numRows() + 1L;
        return Matrices$.MODULE$.getSparseSize(nnz, numPtrs);
    }

    public static void $init$(Matrix $this) {
        $this.org$apache$spark$ml$linalg$Matrix$_setter_$isTransposed_$eq(false);
    }
}

